/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.MessageLength;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.TcpTransportMapping;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.util.CommonTimer;
import org.snmp4j.util.WorkerTask;

public class DefaultTcpTransportMapping
extends TcpTransportMapping {
    public static final int DEFAULT_MAX_BUSY_LOOPS = 100;
    private static final LogAdapter logger = LogFactory.getLogger(DefaultTcpTransportMapping.class);
    protected Map<Address, SocketEntry> sockets = new Hashtable<Address, SocketEntry>();
    protected WorkerTask server;
    protected ServerThread serverThread;
    protected CommonTimer socketCleaner;
    private long connectionTimeout = 60000L;
    private boolean serverEnabled = false;
    private static final int MIN_SNMP_HEADER_LENGTH = 6;
    protected MessageLengthDecoder messageLengthDecoder = new SnmpMesssageLengthDecoder();
    private int maxBusyLoops = 100;

    public DefaultTcpTransportMapping() throws IOException {
        super(new TcpAddress(InetAddress.getLocalHost(), 0));
    }

    public DefaultTcpTransportMapping(TcpAddress serverAddress) throws IOException {
        super(serverAddress);
        this.serverEnabled = true;
    }

    @Override
    public synchronized void listen() throws IOException {
        if (this.server != null) {
            throw new SocketException("Port already listening");
        }
        this.serverThread = new ServerThread();
        if (logger.isInfoEnabled()) {
            logger.info("TCP address " + this.getListenAddress() + " bound successfully");
        }
        this.server = SNMP4JSettings.getThreadFactory().createWorkerThread("DefaultTCPTransportMapping_" + this.getAddress(), this.serverThread, true);
        if (this.connectionTimeout > 0L) {
            this.socketCleaner = SNMP4JSettings.getTimerFactory().createTimer();
        }
        this.server.run();
    }

    public void setPriority(int newPriority) {
        WorkerTask st = this.server;
        if (st instanceof Thread) {
            ((Thread)((Object)st)).setPriority(newPriority);
        }
    }

    public int getPriority() {
        WorkerTask st = this.server;
        if (st instanceof Thread) {
            return ((Thread)((Object)st)).getPriority();
        }
        return 5;
    }

    public void setThreadName(String name) {
        WorkerTask st = this.server;
        if (st instanceof Thread) {
            ((Thread)((Object)st)).setName(name);
        }
    }

    public String getThreadName() {
        WorkerTask st = this.server;
        if (st != null) {
            return ((Thread)((Object)st)).getName();
        }
        return null;
    }

    @Override
    public void close() {
        WorkerTask st = this.server;
        if (st != null) {
            st.terminate();
            st.interrupt();
            try {
                st.join();
            }
            catch (InterruptedException ex) {
                logger.warn(ex);
            }
            this.server = null;
            for (SocketEntry entry : this.sockets.values()) {
                Socket s = entry.getSocket();
                if (s == null) continue;
                try {
                    SocketChannel sc = s.getChannel();
                    s.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Socket to " + entry.getPeerAddress() + " closed")));
                    }
                    if (sc == null) continue;
                    sc.close();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Serializable)((Object)("Socket channel to " + entry.getPeerAddress() + " closed")));
                }
                catch (IOException iox) {
                    logger.debug(iox);
                }
            }
            this.sockets.clear();
            if (this.socketCleaner != null) {
                this.socketCleaner.cancel();
            }
            this.socketCleaner = null;
        }
    }

    @Override
    public synchronized boolean close(TcpAddress remoteAddress) throws IOException {
        SocketEntry entry;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Closing socket for peer address " + remoteAddress)));
        }
        if ((entry = (SocketEntry)this.removeSocketEntry(remoteAddress)) != null) {
            Socket s;
            if (entry.getSocketTimeout() != null) {
                entry.getSocketTimeout().cancel();
            }
            if ((s = entry.getSocket()) != null) {
                SocketChannel sc = entry.getSocket().getChannel();
                entry.getSocket().close();
                if (logger.isInfoEnabled()) {
                    logger.info("Socket to " + entry.getPeerAddress() + " closed");
                }
                if (sc != null) {
                    sc.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Closed socket channel for peer address " + remoteAddress)));
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void sendMessage(TcpAddress address, byte[] message, TransportStateReference tmStateReference) throws IOException {
        if (this.server == null || this.serverThread == null) {
            if (this.isOpenSocketOnSending()) {
                this.listen();
            } else {
                this.handleDroppedMessageToSend(address, message, tmStateReference);
            }
        }
        if (this.serverThread != null) {
            if (this.suspendedAddresses.size() > 0 && this.suspendedAddresses.contains(address)) {
                this.handleDroppedMessageToSend(address, message, tmStateReference);
            } else {
                this.serverThread.sendMessage(address, message, tmStateReference);
            }
        }
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    @Override
    public MessageLengthDecoder getMessageLengthDecoder() {
        return this.messageLengthDecoder;
    }

    public void setServerEnabled(boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
    }

    @Override
    public void setMessageLengthDecoder(MessageLengthDecoder messageLengthDecoder) {
        if (messageLengthDecoder == null) {
            throw new NullPointerException();
        }
        this.messageLengthDecoder = messageLengthDecoder;
    }

    @Override
    public int getMaxInboundMessageSize() {
        return super.getMaxInboundMessageSize();
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    private synchronized void timeoutSocket(SocketEntry entry) {
        if (this.connectionTimeout > 0L) {
            SocketTimeout socketTimeout = new SocketTimeout(entry);
            entry.setSocketTimeout(socketTimeout);
            this.socketCleaner.schedule(socketTimeout, this.connectionTimeout);
        }
    }

    @Override
    public boolean isListening() {
        return this.server != null;
    }

    protected int getMaxBusyLoops() {
        return this.maxBusyLoops;
    }

    protected void setMaxBusyLoops(int maxBusyLoops) {
        this.maxBusyLoops = maxBusyLoops;
    }

    protected void setSocketOptions(ServerSocket serverSocket) {
    }

    @Override
    public TcpAddress getListenAddress() {
        int port = this.tcpAddress.getPort();
        ServerThread serverThreadCopy = this.serverThread;
        try {
            port = ((InetSocketAddress)serverThreadCopy.ssc.getLocalAddress()).getPort();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new TcpAddress(this.tcpAddress.getInetAddress(), port);
    }

    protected void addBufferToReadBuffer(SocketEntry entry, ByteBuffer byteBuffer) {
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Adding data " + byteBuffer + " to read buffer " + entry.getReadBuffer())));
        }
        int buflen = byteBuffer.position();
        if (entry.getReadBuffer() != null) {
            entry.getReadBuffer().put(byteBuffer.array(), 0, buflen);
        } else {
            byte[] message = new byte[byteBuffer.limit()];
            byteBuffer.flip();
            byteBuffer.get(message, 0, buflen);
            ByteBuffer newBuffer = ByteBuffer.wrap(message);
            newBuffer.position(buflen);
            entry.setReadBuffer(newBuffer);
        }
    }

    protected void socketClosedRemotely(SelectionKey sk, SocketChannel readChannel, TcpAddress incomingAddress) throws IOException {
        logger.debug((Serializable)((Object)"Socket closed remotely"));
        this.cancelNonServerSelectionKey(sk);
        readChannel.close();
        TransportStateEvent e = new TransportStateEvent(this, incomingAddress, 2, null);
        this.fireConnectionStateChanged(e);
        this.removeSocketEntry(incomingAddress);
    }

    @Override
    protected Object removeSocketEntry(TcpAddress incomingAddress) {
        return this.sockets.remove(incomingAddress);
    }

    protected class ServerThread
    implements WorkerTask {
        protected byte[] buf;
        private volatile boolean stop = false;
        private Throwable lastError = null;
        private ServerSocketChannel ssc;
        protected Selector selector;
        private LinkedList<SocketEntry> pending = new LinkedList();

        public ServerThread() throws IOException {
            this.buf = new byte[DefaultTcpTransportMapping.this.getMaxInboundMessageSize()];
            this.selector = Selector.open();
            if (DefaultTcpTransportMapping.this.serverEnabled) {
                this.ssc = ServerSocketChannel.open();
                try {
                    this.ssc.configureBlocking(false);
                    InetSocketAddress isa = new InetSocketAddress(DefaultTcpTransportMapping.this.tcpAddress.getInetAddress(), DefaultTcpTransportMapping.this.tcpAddress.getPort());
                    DefaultTcpTransportMapping.this.setSocketOptions(this.ssc.socket());
                    this.ssc.socket().bind(isa);
                    this.ssc.register(this.selector, 16);
                }
                catch (IOException iox) {
                    logger.warn((Serializable)((Object)("Socket bind failed for " + DefaultTcpTransportMapping.this.tcpAddress + ": " + iox.getMessage())));
                    try {
                        this.ssc.close();
                    }
                    catch (IOException ioxClose) {
                        logger.warn((Serializable)((Object)("Socket close failed after bind failure for " + DefaultTcpTransportMapping.this.tcpAddress + ": " + ioxClose.getMessage())));
                    }
                    throw iox;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPending() {
            LinkedList<SocketEntry> linkedList = this.pending;
            synchronized (linkedList) {
                for (int i = 0; i < this.pending.size(); ++i) {
                    TransportStateEvent e;
                    SocketEntry entry = this.pending.get(i);
                    try {
                        if (entry.getSocket().isConnected()) {
                            entry.addRegistration(this.selector, 4);
                            continue;
                        }
                        entry.addRegistration(this.selector, 8);
                        continue;
                    }
                    catch (CancelledKeyException ckex) {
                        logger.warn(ckex);
                        this.pending.remove(entry);
                        try {
                            entry.getSocket().getChannel().close();
                            e = new TransportStateEvent(DefaultTcpTransportMapping.this, entry.getPeerAddress(), 4, null, entry.message);
                            DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
                        }
                        catch (IOException ex) {
                            logger.error(ex);
                        }
                        continue;
                    }
                    catch (IOException iox) {
                        logger.error(iox);
                        this.pending.remove(entry);
                        try {
                            entry.getSocket().getChannel().close();
                            e = new TransportStateEvent(DefaultTcpTransportMapping.this, entry.getPeerAddress(), 4, iox, entry.message);
                            DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
                        }
                        catch (IOException ex) {
                            logger.error(ex);
                        }
                        this.lastError = iox;
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(iox);
                    }
                }
            }
        }

        protected void connectSocketToSendMessage(Address address, byte[] message, Socket s, SocketEntry entry, Map<Address, SocketEntry> sockets) {
            SocketEntry currentSocketEntry = sockets.putIfAbsent(address, entry);
            if (currentSocketEntry != null && currentSocketEntry.getSocket().isConnected()) {
                entry = currentSocketEntry;
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Concurrent connection attempt detected, canceling this one to " + address)));
                }
                entry.addMessage(message);
                try {
                    s.close();
                }
                catch (IOException iox) {
                    logger.error("Failed to close recently opened socket for '" + address + "', with " + iox.getMessage(), iox);
                }
                if (currentSocketEntry.getSocket().isConnected()) {
                    this.queueNewMessage(entry);
                    return;
                }
            } else if (currentSocketEntry != null && !currentSocketEntry.getSocket().isConnected()) {
                entry.insertMessages(currentSocketEntry.message);
                sockets.put(address, entry);
                try {
                    currentSocketEntry.getSocket().close();
                }
                catch (IOException iox) {
                    logger.error("Failed to close socket for '" + address + "', with " + iox.getMessage(), iox);
                }
            }
            this.queueNewMessage(entry);
            logger.debug((Serializable)((Object)("Trying to connect to " + address)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueNewMessage(SocketEntry entry) {
            LinkedList<SocketEntry> linkedList = this.pending;
            synchronized (linkedList) {
                this.pending.add(entry);
            }
            this.selector.wakeup();
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(Address address, byte[] message, TransportStateReference tmStateReference) throws IOException {
            LinkedList<SocketEntry> linkedList;
            Socket s = null;
            SocketEntry entry = DefaultTcpTransportMapping.this.sockets.get(address);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Looking up connection for destination '" + address + "' returned: " + entry)));
                logger.debug((Serializable)((Object)DefaultTcpTransportMapping.this.sockets.toString()));
            }
            if (entry != null) {
                linkedList = entry;
                synchronized (linkedList) {
                    entry.used();
                    s = entry.getSocket();
                }
            }
            if (s == null || s.isClosed() || !s.isConnected()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Socket for address '" + address + "' is closed, opening it...")));
                }
                linkedList = this.pending;
                synchronized (linkedList) {
                    this.pending.remove(entry);
                }
                SocketChannel sc = null;
                try {
                    InetSocketAddress targetAddress = new InetSocketAddress(((TcpAddress)address).getInetAddress(), ((TcpAddress)address).getPort());
                    if (s == null || s.isClosed()) {
                        sc = SocketChannel.open();
                        sc.configureBlocking(false);
                        sc.connect(targetAddress);
                    } else {
                        sc = s.getChannel();
                        sc.configureBlocking(false);
                        if (!sc.isConnectionPending()) {
                            sc.connect(targetAddress);
                        }
                    }
                    s = sc.socket();
                    entry = new SocketEntry((TcpAddress)address, s);
                    entry.addMessage(message);
                    DefaultTcpTransportMapping.this.sockets.put(address, entry);
                    LinkedList<SocketEntry> linkedList2 = this.pending;
                    synchronized (linkedList2) {
                        this.pending.add(entry);
                    }
                    this.selector.wakeup();
                    logger.debug((Serializable)((Object)("Trying to connect to " + address)));
                }
                catch (IOException iox) {
                    logger.error(iox);
                    throw iox;
                }
            }
            entry.addMessage(message);
            linkedList = this.pending;
            synchronized (linkedList) {
                this.pending.add(entry);
            }
            logger.debug((Serializable)((Object)"Waking up selector for new message"));
            this.selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.stop) {
                    try {
                        if (this.selector.select() > 0) {
                            if (this.stop) break;
                            Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                            Iterator<SelectionKey> it = readyKeys.iterator();
                            while (it.hasNext()) {
                                try {
                                    SelectionKey sk = it.next();
                                    it.remove();
                                    SocketChannel readChannel = null;
                                    TcpAddress incomingAddress = null;
                                    if (sk.isAcceptable()) {
                                        logger.debug((Serializable)((Object)"Key is acceptable"));
                                        ServerSocketChannel nextReady = (ServerSocketChannel)sk.channel();
                                        Socket s = nextReady.accept().socket();
                                        readChannel = s.getChannel();
                                        readChannel.configureBlocking(false);
                                        incomingAddress = new TcpAddress(s.getInetAddress(), s.getPort());
                                        SocketEntry entry = new SocketEntry(incomingAddress, s);
                                        entry.addRegistration(this.selector, 1);
                                        DefaultTcpTransportMapping.this.sockets.put(incomingAddress, entry);
                                        DefaultTcpTransportMapping.this.timeoutSocket(entry);
                                        TransportStateEvent e = new TransportStateEvent(DefaultTcpTransportMapping.this, incomingAddress, 1, null);
                                        DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
                                        if (e.isCancelled()) {
                                            logger.warn((Serializable)((Object)"Incoming connection cancelled"));
                                            s.close();
                                            DefaultTcpTransportMapping.this.removeSocketEntry(incomingAddress);
                                            readChannel = null;
                                        }
                                    } else if (sk.isWritable()) {
                                        logger.debug((Serializable)((Object)"Key is writable"));
                                        incomingAddress = this.writeData(sk, incomingAddress);
                                    } else if (sk.isReadable()) {
                                        logger.debug((Serializable)((Object)"Key is readable"));
                                        readChannel = (SocketChannel)sk.channel();
                                        incomingAddress = new TcpAddress(readChannel.socket().getInetAddress(), readChannel.socket().getPort());
                                    } else if (sk.isConnectable()) {
                                        logger.debug((Serializable)((Object)"Key is connectable"));
                                        this.connectChannel(sk, incomingAddress);
                                    }
                                    if (readChannel == null) continue;
                                    logger.debug((Serializable)((Object)"Key is reading"));
                                    try {
                                        int busyLoops;
                                        SocketEntry entry;
                                        if (this.readMessage(sk, readChannel, incomingAddress) || (entry = (SocketEntry)sk.attachment()) == null || DefaultTcpTransportMapping.this.getMaxBusyLoops() <= 0 || (busyLoops = entry.nextBusyLoop()) <= DefaultTcpTransportMapping.this.getMaxBusyLoops()) continue;
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Serializable)((Object)("After " + busyLoops + " read key has been removed: " + entry)));
                                        }
                                        entry.removeRegistration(this.selector, 1);
                                        entry.resetBusyLoops();
                                    }
                                    catch (IOException iox) {
                                        DefaultTcpTransportMapping.this.socketClosedRemotely(sk, readChannel, incomingAddress);
                                    }
                                }
                                catch (CancelledKeyException ckex) {
                                    if (!logger.isDebugEnabled()) continue;
                                    logger.debug((Serializable)((Object)"Selection key cancelled, skipping it"));
                                }
                            }
                        }
                    }
                    catch (NullPointerException npex) {
                        npex.printStackTrace();
                        logger.warn((Serializable)((Object)"NullPointerException within select()?"));
                        this.stop = true;
                    }
                    this.processPending();
                }
                if (this.ssc != null) {
                    this.ssc.close();
                }
                if (this.selector != null) {
                    this.selector.close();
                }
            }
            catch (IOException iox) {
                logger.error(iox);
                this.lastError = iox;
            }
            if (!this.stop) {
                this.stop = true;
                DefaultTcpTransportMapping defaultTcpTransportMapping = DefaultTcpTransportMapping.this;
                synchronized (defaultTcpTransportMapping) {
                    DefaultTcpTransportMapping.this.server = null;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Worker task finished: " + this.getClass().getName())));
            }
        }

        private void connectChannel(SelectionKey sk, TcpAddress incomingAddress) {
            block6: {
                SocketEntry entry = (SocketEntry)sk.attachment();
                try {
                    SocketChannel sc = (SocketChannel)sk.channel();
                    if (!sc.isConnected()) {
                        if (sc.finishConnect()) {
                            sc.configureBlocking(false);
                            logger.debug((Serializable)((Object)("Connected to " + entry.getPeerAddress())));
                            DefaultTcpTransportMapping.this.timeoutSocket(entry);
                            entry.removeRegistration(this.selector, 8);
                            entry.addRegistration(this.selector, 4);
                        } else {
                            entry = null;
                        }
                    }
                    if (entry != null) {
                        TcpAddress addr = incomingAddress == null ? entry.getPeerAddress() : incomingAddress;
                        logger.debug((Serializable)((Object)("Fire connected event for " + addr)));
                        TransportStateEvent e = new TransportStateEvent(DefaultTcpTransportMapping.this, addr, 1, null);
                        DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
                    }
                }
                catch (IOException iox) {
                    logger.warn(iox);
                    DefaultTcpTransportMapping.this.cancelNonServerSelectionKey(sk);
                    this.closeChannel(sk.channel());
                    if (entry == null) break block6;
                    this.pending.remove(entry);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TcpAddress writeData(SelectionKey sk, TcpAddress incomingAddress) {
            SocketEntry entry = (SocketEntry)sk.attachment();
            try {
                SocketChannel sc = (SocketChannel)sk.channel();
                incomingAddress = new TcpAddress(sc.socket().getInetAddress(), sc.socket().getPort());
                if (entry != null && !entry.hasMessage()) {
                    LinkedList<SocketEntry> linkedList = this.pending;
                    synchronized (linkedList) {
                        this.pending.remove(entry);
                        entry.removeRegistration(this.selector, 4);
                    }
                }
                if (entry != null) {
                    this.writeMessage(entry, sc);
                }
            }
            catch (IOException iox) {
                logger.warn(iox);
                TransportStateEvent e = new TransportStateEvent(DefaultTcpTransportMapping.this, incomingAddress, 2, iox);
                DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
                this.closeChannel(sk.channel());
            }
            return incomingAddress;
        }

        private void closeChannel(SelectableChannel channel) {
            try {
                channel.close();
            }
            catch (IOException channelCloseException) {
                logger.warn(channelCloseException);
            }
        }

        protected boolean readMessage(SelectionKey sk, SocketChannel readChannel, TcpAddress incomingAddress) throws IOException {
            long bytesRead;
            SocketEntry entry = (SocketEntry)sk.attachment();
            if (entry == null) {
                entry = DefaultTcpTransportMapping.this.sockets.get(incomingAddress);
            }
            if (entry != null) {
                entry.used();
                ByteBuffer readBuffer = entry.getReadBuffer();
                if (readBuffer != null) {
                    int bytesRead2 = readChannel.read(readBuffer);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Read " + bytesRead2 + " bytes from " + incomingAddress)));
                    }
                    if (bytesRead2 >= 0 && (readBuffer.hasRemaining() || readBuffer.position() < DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength())) {
                        entry.addRegistration(this.selector, 1);
                    } else if (bytesRead2 < 0) {
                        DefaultTcpTransportMapping.this.socketClosedRemotely(sk, readChannel, incomingAddress);
                    } else {
                        this.readSnmpMessagePayload(readChannel, incomingAddress, entry, readBuffer);
                    }
                    if (bytesRead2 != 0) {
                        entry.resetBusyLoops();
                        return true;
                    }
                    return false;
                }
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf);
            byteBuffer.limit(DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength());
            if (!readChannel.isOpen()) {
                DefaultTcpTransportMapping.this.cancelNonServerSelectionKey(sk);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Read channel not open, no bytes read from " + incomingAddress)));
                }
                return false;
            }
            try {
                bytesRead = readChannel.read(byteBuffer);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Reading header " + bytesRead + " bytes from " + incomingAddress)));
                }
            }
            catch (ClosedChannelException ccex) {
                DefaultTcpTransportMapping.this.cancelNonServerSelectionKey(sk);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Read channel not open, no bytes read from " + incomingAddress)));
                }
                return false;
            }
            if (byteBuffer.position() >= DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength()) {
                this.readSnmpMessagePayload(readChannel, incomingAddress, entry, byteBuffer);
            } else if (bytesRead < 0L) {
                DefaultTcpTransportMapping.this.socketClosedRemotely(sk, readChannel, incomingAddress);
            } else if (entry != null && bytesRead > 0L) {
                DefaultTcpTransportMapping.this.addBufferToReadBuffer(entry, byteBuffer);
                entry.addRegistration(this.selector, 1);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("No socket entry found for incoming address " + incomingAddress + " for incomplete message with length " + bytesRead)));
            }
            if (entry != null && bytesRead != 0L) {
                entry.resetBusyLoops();
                return true;
            }
            return false;
        }

        protected void readSnmpMessagePayload(SocketChannel readChannel, TcpAddress incomingAddress, SocketEntry entry, ByteBuffer byteBuffer) throws IOException {
            MessageLength messageLength = DefaultTcpTransportMapping.this.messageLengthDecoder.getMessageLength(ByteBuffer.wrap(byteBuffer.array()));
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Message length is " + messageLength)));
            }
            if (messageLength.getMessageLength() > DefaultTcpTransportMapping.this.getMaxInboundMessageSize() || messageLength.getMessageLength() <= 0) {
                Socket s;
                logger.error((Serializable)((Object)("Received message length " + messageLength + " is greater than inboundBufferSize " + DefaultTcpTransportMapping.this.getMaxInboundMessageSize())));
                if (entry != null && (s = entry.getSocket()) != null) {
                    s.close();
                    logger.info("Socket to " + entry.getPeerAddress() + " closed due to an error");
                }
            } else {
                long bytesRead;
                int messageSize = messageLength.getMessageLength();
                if (byteBuffer.position() < messageSize) {
                    if (byteBuffer.capacity() < messageSize) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Extending message buffer size according to message length to " + messageSize)));
                        }
                        byte[] newBuffer = new byte[messageSize];
                        int len = byteBuffer.position();
                        byteBuffer.flip();
                        byteBuffer.get(newBuffer, 0, len);
                        byteBuffer = ByteBuffer.wrap(newBuffer);
                        byteBuffer.position(len);
                        if (entry != null) {
                            byteBuffer.limit(messageSize);
                            entry.setReadBuffer(byteBuffer);
                        }
                    } else {
                        byteBuffer.limit(messageSize);
                    }
                    readChannel.read(byteBuffer);
                }
                if ((bytesRead = (long)byteBuffer.position()) >= (long)messageSize) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Message completed with " + bytesRead + " bytes and " + byteBuffer.limit() + " buffer limit")));
                    }
                    if (entry != null) {
                        entry.setReadBuffer(null);
                    }
                    this.dispatchMessage(incomingAddress, byteBuffer, bytesRead, entry);
                } else if (entry != null && byteBuffer != entry.getReadBuffer()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Adding buffer content to read buffer of entry " + entry + ", buffer " + byteBuffer)));
                    }
                    DefaultTcpTransportMapping.this.addBufferToReadBuffer(entry, byteBuffer);
                }
                if (entry != null) {
                    entry.addRegistration(this.selector, 1);
                }
            }
        }

        private void dispatchMessage(TcpAddress incomingAddress, ByteBuffer byteBuffer, long bytesRead, Object sessionID) {
            ByteBuffer bis;
            byteBuffer.flip();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Received message from " + incomingAddress + " with length " + bytesRead + ": " + new OctetString(byteBuffer.array(), 0, (int)bytesRead).toHexString())));
            }
            if (DefaultTcpTransportMapping.this.isAsyncMsgProcessingSupported()) {
                byte[] bytes = new byte[(int)bytesRead];
                System.arraycopy(byteBuffer.array(), 0, bytes, 0, (int)bytesRead);
                bis = ByteBuffer.wrap(bytes);
            } else {
                bis = ByteBuffer.wrap(byteBuffer.array(), 0, (int)bytesRead);
            }
            TransportStateReference stateReference = new TransportStateReference(DefaultTcpTransportMapping.this, incomingAddress, null, SecurityLevel.undefined, SecurityLevel.undefined, false, sessionID);
            DefaultTcpTransportMapping.this.fireProcessMessage(incomingAddress, bis, stateReference);
        }

        private void writeMessage(SocketEntry entry, SocketChannel sc) throws IOException {
            byte[] message = entry.nextMessage();
            if (message != null) {
                ByteBuffer buffer = ByteBuffer.wrap(message);
                sc.write(buffer);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Sent message with length " + message.length + " to " + entry.getPeerAddress() + ": " + new OctetString(message).toHexString())));
                }
                entry.addRegistration(this.selector, 1);
            } else {
                entry.removeRegistration(this.selector, 4);
                if (entry.hasMessage() && !entry.isRegistered(4)) {
                    entry.addRegistration(this.selector, 4);
                    logger.debug((Serializable)((Object)"Waking up selector"));
                    this.selector.wakeup();
                }
            }
        }

        public void close() {
            this.stop = true;
            WorkerTask st = DefaultTcpTransportMapping.this.server;
            if (st != null) {
                st.terminate();
            }
        }

        @Override
        public void terminate() {
            this.stop = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Terminated worker task: " + this.getClass().getName())));
            }
        }

        @Override
        public void join() {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Joining worker task: " + this.getClass().getName())));
            }
        }

        @Override
        public void interrupt() {
            this.stop = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Interrupting worker task: " + this.getClass().getName())));
            }
            this.selector.wakeup();
        }
    }

    class SocketTimeout
    extends TimerTask {
        private SocketEntry entry;

        public SocketTimeout(SocketEntry entry) {
            this.entry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long now = System.nanoTime();
            SocketEntry entryCopy = this.entry;
            if (entryCopy == null) {
                return;
            }
            long idleMillis = (now - entryCopy.getLastUse()) / 1000000L;
            if (DefaultTcpTransportMapping.this.socketCleaner == null || idleMillis >= DefaultTcpTransportMapping.this.connectionTimeout) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Socket has not been used for " + idleMillis + " milliseconds, closing it")));
                }
                try {
                    SocketEntry socketEntry = entryCopy;
                    synchronized (socketEntry) {
                        if (idleMillis >= DefaultTcpTransportMapping.this.connectionTimeout) {
                            DefaultTcpTransportMapping.this.removeSocketEntry(entryCopy.getPeerAddress());
                            entryCopy.getSocket().close();
                            if (logger.isInfoEnabled()) {
                                logger.info("Socket to " + entryCopy.getPeerAddress() + " closed due to timeout");
                            }
                        } else {
                            this.rescheduleCleanup(idleMillis, entryCopy);
                        }
                    }
                }
                catch (IOException ex) {
                    logger.error(ex);
                }
            } else {
                this.rescheduleCleanup(idleMillis, entryCopy);
            }
        }

        private void rescheduleCleanup(long idleMillisAlreadyElapsed, SocketEntry entry) {
            long nextRun = DefaultTcpTransportMapping.this.connectionTimeout - idleMillisAlreadyElapsed;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Scheduling " + nextRun)));
            }
            SocketTimeout socketTimeout = new SocketTimeout(entry);
            entry.setSocketTimeout(socketTimeout);
            DefaultTcpTransportMapping.this.socketCleaner.schedule(socketTimeout, nextRun);
        }

        @Override
        public boolean cancel() {
            boolean result = super.cancel();
            this.entry = null;
            return result;
        }
    }

    public static class SnmpMesssageLengthDecoder
    implements MessageLengthDecoder {
        @Override
        public int getMinHeaderLength() {
            return 6;
        }

        @Override
        public MessageLength getMessageLength(ByteBuffer buf) throws IOException {
            BER.MutableByte type = new BER.MutableByte();
            BERInputStream is = new BERInputStream(buf);
            int ml = BER.decodeHeader(is, type, false);
            int hl = (int)is.getPosition();
            MessageLength messageLength = new MessageLength(hl, ml);
            return messageLength;
        }
    }

    class SocketEntry {
        private Socket socket;
        private TcpAddress peerAddress;
        private long lastUse;
        private LinkedList<byte[]> message = new LinkedList();
        private ByteBuffer readBuffer = null;
        private volatile int registrations = 0;
        private volatile int busyLoops = 0;
        private SocketTimeout socketTimeout;

        public SocketEntry(TcpAddress address, Socket socket) {
            this.peerAddress = address;
            this.socket = socket;
            this.lastUse = System.nanoTime();
        }

        public synchronized void addRegistration(Selector selector, int opKey) throws ClosedChannelException {
            if ((this.registrations & opKey) == 0) {
                this.registrations |= opKey;
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Adding operation " + opKey + " for: " + this.toString())));
                }
                this.socket.getChannel().register(selector, this.registrations, this);
            } else if (!this.socket.getChannel().isRegistered()) {
                this.registrations = opKey;
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Registering new operation " + opKey + " for: " + this.toString())));
                }
                this.socket.getChannel().register(selector, opKey, this);
            }
        }

        public synchronized void removeRegistration(Selector selector, int opKey) throws ClosedChannelException {
            if ((this.registrations & opKey) == opKey) {
                this.registrations &= ~opKey;
                this.socket.getChannel().register(selector, this.registrations, this);
            }
        }

        public synchronized boolean isRegistered(int opKey) {
            return (this.registrations & opKey) == opKey;
        }

        public long getLastUse() {
            return this.lastUse;
        }

        public void used() {
            this.lastUse = System.nanoTime();
        }

        public Socket getSocket() {
            return this.socket;
        }

        public TcpAddress getPeerAddress() {
            return this.peerAddress;
        }

        public synchronized void addMessage(byte[] message) {
            this.message.add(message);
        }

        public synchronized void insertMessages(List<byte[]> messages) {
            this.message.addAll(0, messages);
        }

        public synchronized byte[] nextMessage() {
            if (this.message.size() > 0) {
                return this.message.removeFirst();
            }
            return null;
        }

        public synchronized boolean hasMessage() {
            return !this.message.isEmpty();
        }

        public void setReadBuffer(ByteBuffer byteBuffer) {
            this.readBuffer = byteBuffer;
        }

        public ByteBuffer getReadBuffer() {
            return this.readBuffer;
        }

        public int nextBusyLoop() {
            return ++this.busyLoops;
        }

        public void resetBusyLoops() {
            this.busyLoops = 0;
        }

        public String toString() {
            return "SocketEntry[peerAddress=" + this.peerAddress + ",socket=" + this.socket + ",lastUse=" + new Date(this.lastUse / 1000000L) + ",readBufferPosition=" + (this.readBuffer == null ? -1 : this.readBuffer.position()) + ",socketTimeout=" + this.socketTimeout + "]";
        }

        public SocketTimeout getSocketTimeout() {
            return this.socketTimeout;
        }

        public void setSocketTimeout(SocketTimeout socketTimeout) {
            this.socketTimeout = socketTimeout;
        }
    }
}

