/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.coreservice.server.request;

import de.seetec.v5.coreservice.B.T;
import de.seetec.v5.coreservice.configuration.authorization.group.Group;
import de.seetec.v5.coreservice.configuration.authorization.user.User;
import de.seetec.v5.coreservice.configuration.events.loginfailed.LoginFailedEvent;
import de.seetec.v5.coreservice.server.G.B;
import de.seetec.v5.coreservice.server.G.C;
import de.seetec.v5.coreservice.server.request.AbstractReqHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.LicenseErrors;
import de.seetec.v5.shared.crypto.Crypto;
import de.seetec.v5.shared.interaction.DataObject;
import de.seetec.v5.shared.interaction.EntityDataObject;
import de.seetec.v5.shared.interaction.EventDataObject;
import de.seetec.v5.shared.interaction.KeyDataObject;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public final class IsSingleSignOnAuthorizedReqHandler
extends AbstractReqHandler {
    @Override
    public DataObject handleRequest(DataObject dataObject) {
        T t2 = null;
        try {
            t2 = (T)((Object)this.checkRequestObject(T.class, dataObject));
            this.A(t2);
            this.checkLicense();
            B b2 = C.A(t2.getString(), this.getCore().\u00fb()).A(t2.C(), t2.A());
            if (b2.A()) {
                return new KeyDataObject("", new byte[0], b2.D());
            }
            List<EntityDataObject> list = Arrays.asList(this.getCore().\u00ea().A(Arrays.asList(43L), true));
            List<Long> list2 = this.A(b2, list);
            List<EntityDataObject> list3 = Arrays.asList(this.getCore().\u00ea().A(Arrays.asList(41L), true));
            EntityDataObject entityDataObject = this.B(b2, list3);
            if (entityDataObject != null) {
                return this.A(entityDataObject, b2);
            }
            if (!list2.isEmpty()) {
                return this.C(b2, list2);
            }
            throw new SeeTecException(-33334, "Given active directory entity not assigned to \"Cayuga active directory user/group\".");
        }
        catch (SeeTecException seeTecException) {
            this.A(seeTecException, t2);
            this.P.warn("User NOT authorized.");
            return new DataObject(seeTecException.getErrorCode());
        }
        catch (Exception exception) {
            this.P.error("Unexpected error while SSO authorization.", (Throwable)exception);
            return new DataObject(-20000);
        }
    }

    private DataObject C(B b2, List<Long> list) throws SeeTecException {
        this.P.info("User authorized.");
        KeyDataObject keyDataObject = new KeyDataObject(Crypto.getKeyData().getEncryptionMethod(), Crypto.getKeyData().getKey(), b2.D());
        String string = b2.B();
        String string2 = this.getCore().\u00fb().A(string);
        keyDataObject.setToken(this.getCore().\u0109().A(string2, string, list));
        return keyDataObject;
    }

    private DataObject A(EntityDataObject entityDataObject, B b2) throws SeeTecException {
        try {
            this.getCore().\u00fb().A(entityDataObject);
        }
        catch (SeeTecException seeTecException) {
            this.P.warn("Updating entity of user " + entityDataObject.toStringShort() + " failed: " + seeTecException.getMessage());
        }
        this.P.info("User authorized.");
        KeyDataObject keyDataObject = new KeyDataObject(Crypto.getKeyData().getEncryptionMethod(), Crypto.getKeyData().getKey(), b2.D());
        keyDataObject.setToken(this.getCore().\u0109().A(entityDataObject.getID(), entityDataObject.getName()));
        return keyDataObject;
    }

    private void A(SeeTecException seeTecException, T t2) {
        if (seeTecException.getErrorCode() != -50002 && seeTecException.getErrorCode() != -50003 && seeTecException.getErrorCode() != -20002) {
            try {
                EventDataObject eventDataObject = new EventDataObject(EventType.FAILED_LOGIN_ATTEMPT, 1010L, Basic.cutOffRoot((String)Basic.marshalUTF8XML((Object)new LoginFailedEvent(t2.B().getInetAddress().getHostName()))).getBytes("UTF-8"));
                this.errorCode = this.getCore().\u0102().A(eventDataObject);
                if (this.errorCode != 0) {
                    this.P.info("Announcing FailedLoginAttempt event failed. errorCode: " + this.errorCode);
                }
            }
            catch (FileNotFoundException | UnsupportedEncodingException | JAXBException | SAXException throwable) {
                this.P.error("Unexpected error while creating login failed event " + throwable.getMessage());
            }
        }
    }

    List<Long> A(B b2, List<EntityDataObject> list) throws JAXBException, SAXException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (EntityDataObject entityDataObject : list) {
            if (!entityDataObject.getActive()) continue;
            try {
                Group group = (Group)Basic.unmarshalXML(Group.class, (Object)entityDataObject.getConfiguration());
                if (group.isUseActiveDirectorySupport() == null || !group.isUseActiveDirectorySupport().booleanValue() || group.getSecureId() == null || !b2.C().contains(group.getSecureId())) continue;
                arrayList.add(entityDataObject.getID());
            }
            catch (NullPointerException nullPointerException) {
                this.P.debug("Ignoring null group.");
            }
        }
        return arrayList;
    }

    EntityDataObject B(B b2, List<EntityDataObject> list) throws JAXBException, SAXException {
        for (EntityDataObject entityDataObject : list) {
            if (!entityDataObject.getActive()) continue;
            try {
                User user = (User)Basic.unmarshalXML(User.class, (Object)entityDataObject.getConfiguration());
                if (user.isUseActiveDirectorySupport() == null || !user.isUseActiveDirectorySupport().booleanValue() || user.getSecureId() == null || !b2.B().equals(user.getSecureId())) continue;
                return entityDataObject;
            }
            catch (NullPointerException nullPointerException) {
                this.P.debug("Ignoring null user.");
            }
        }
        return null;
    }

    protected void checkLicense() throws SeeTecException {
        if (this.getCore().\u0106() != null && this.getCore().\u0106().\u00a4() != null && this.getCore().\u0106().\u00a4().getLicenseInfo() != null && this.getCore().\u0106().\u00a4().getLicenseInfo().getFeatures() != null && this.getCore().\u0106().\u00a4().getLicenseInfo().getFeatures().isAD()) {
            return;
        }
        if (this.getCore().\u0106() != null && this.getCore().\u0106().\u00a4() == null) {
            return;
        }
        throw new SeeTecException(LicenseErrors.ERR_LICENSE_AD_NOT_ALLOWED.getErrorCode(), "Active Directory not licensed.");
    }

    private void A(T t2) throws SeeTecException {
        if (t2.C() == null || t2.getString() == null || t2.A() == null || t2.B() == null || t2.B().getInetAddress() == null) {
            throw new SeeTecException(-20002, "Needed parameter null");
        }
    }
}

