/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.coreservice.server;

import de.seetec.v5.coreservice.C.A;
import de.seetec.v5.coreservice.configuration.backup.Backup;
import de.seetec.v5.coreservice.configuration.backup.Frequency;
import de.seetec.v5.coreservice.server.FB;
import de.seetec.v5.coreservice.server.LA;
import de.seetec.v5.coreservice.server.UA;
import de.seetec.v5.coreservice.server.c;
import de.seetec.v5.coreservice.server.e;
import de.seetec.v5.coreservice.server.f;
import de.seetec.v5.coreservice.server.j;
import de.seetec.v5.coreservice.server.o;
import de.seetec.v5.coreservice.server.u;
import de.seetec.v5.coreservice.server.x;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.interaction.EntityDataObject;
import de.seetec.v5.shared.interaction.EventDataObject;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import de.seetec.v5.shared.util.SevenZipProxy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class _
implements Runnable,
A,
UA {
    private static final int \u011f = 14400000;
    private final ScheduledExecutorService \u011c = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("CyclicSyncExecutor"));
    private final Logger \u0121 = LogManager.getLogger((String)this.getClass().getName());
    private final c \u0119;
    private final u \u0118;
    private final LA \u011b;
    private final j \u011d;
    private final x \u0122;
    private final f \u0115;
    private volatile boolean \u0116 = false;
    private volatile boolean \u011e = false;
    private Backup \u0117 = null;
    private String \u0120 = null;
    private int \u011a = 0;

    public _(c c2, u u2, LA lA2, j j2, x x2) throws SeeTecException {
        this.\u0119 = c2;
        if (this.\u0119 == null || (this.\u0118 = u2) == null || (this.\u011b = lA2) == null || (this.\u011d = j2) == null || (this.\u0122 = x2) == null) {
            throw new SeeTecException(-20002, "Parameter to start BackupDaemon was null.");
        }
        if (u2.Q()) {
            try {
                this.o();
            }
            catch (SeeTecException seeTecException) {
                throw seeTecException;
            }
            catch (Throwable throwable) {
                throw new SeeTecException(-20000, "Error while reading out default backup location: " + throwable.getMessage());
            }
            try {
                this.j();
            }
            catch (SeeTecException seeTecException) {
                // empty catch block
            }
        }
        this.\u0115 = new f();
    }

    public void n() {
        if (this.\u0118.Q()) {
            this.\u011c.scheduleWithFixedDelay(this, TimeUnit.HOURS.toSeconds(1L), 1L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void run() {
        block9: {
            try {
                if (this.\u0116) {
                    this.\u0121.info("Backup functions will be delayed for a few seconds caused by reloading the backup configuration.");
                    return;
                }
                if (this.\u0117.getFrequency() == null) break block9;
                Calendar calendar = Calendar.getInstance();
                this.A(calendar.get(6));
                if (this.\u011e || this.\u0117.getFrequency() != Frequency.DAILY && calendar.get(7) != this.\u0117.getFrequency().value() + 1 || (long)this.\u0117.getTime() >= TimeHelper.getMillisecondsInDay()) break block9;
                try {
                    this.A(this.\u0117.getLocation(), o.D);
                    if (this.\u0117.isRollover()) {
                        this.\u0115.A((Calendar)calendar.clone(), this.\u0117.getLocation(), this.\u0117.getFrequency());
                    }
                }
                catch (SeeTecException seeTecException) {
                    this.A(this.\u0117.getLocation() + File.separatorChar, seeTecException.getErrorCode());
                    this.\u0121.warn("Creating backup failed. No clean-up of old backups will be done! Message: " + seeTecException.getMessage());
                }
                finally {
                    this.\u011e = true;
                    this.\u011a = calendar.get(6);
                }
            }
            catch (Throwable throwable) {
                this.\u0121.error("Error while running: ", throwable);
            }
        }
    }

    public void m() {
        this.\u011c.shutdown();
    }

    private void A(int n2) {
        if (this.\u011a != n2) {
            this.\u011e = false;
        }
    }

    private void A(String string, int n2) {
        try {
            this.\u0122.A(new EventDataObject(EventType.ENT_EVENTTYPE_CYCLIC_BACKUP_FAILED, Long.MIN_VALUE, null));
            this.\u0119.A(EventType.ENT_EVENTTYPE_CYCLIC_BACKUP_FAILED, n2, "Cyclic Backup failed.", "Error while doing a backup to [" + string + "].\r\nReturned errorCode: [" + n2 + "]");
        }
        catch (Exception exception) {
            this.\u0121.error("Error while announcing event.");
            this.\u0121.error((Object)exception, (Throwable)exception);
        }
    }

    private String K(String string) throws SeeTecException {
        String string2 = string;
        if (string2 == null) {
            this.\u0121.info("No backup location given. Trying to use default.");
            string2 = this.\u0120;
            if (string2 == null) {
                throw new SeeTecException(-20022, "Default backup location is null. Please set a backup destination.");
            }
        }
        this.\u0117.setLocation(string2);
        return string2;
    }

    private void j() throws SeeTecException {
        if (this.\u0118.P()) {
            throw new SeeTecException(-50203, "Functionality not available in this mode.");
        }
        this.A(true);
        EntityDataObject entityDataObject = this.\u011d.A(1050L, true);
        try {
            this.\u0117 = (Backup)Basic.unmarshalXML(Backup.class, (Object)entityDataObject.getConfiguration());
            this.k();
            this.l();
            if (this.\u0117.getLocation() != null && this.\u0117.getLocation().length() == 0) {
                this.\u0117.setLocation(null);
            }
        }
        catch (Exception exception) {
            this.\u0121.error("Error while reading configuration: " + exception.getMessage());
        }
        this.J(this.\u0117.getLocation());
        this.\u011e = false;
        this.A(false);
    }

    private void l() {
        if (this.\u0117.getTime() < 0 || this.\u0117.getTime() >= 86400000) {
            this.\u0121.warn("Value of 'time' has invalid value (" + this.\u0117.getTime() + "). Setting it to " + 14400000 + " (4 pm).");
            this.\u0117.setTime(14400000);
        }
    }

    private void k() {
        if (this.\u0117.getFrequency() != null && (this.\u0117.getFrequency().value() < 0 || this.\u0117.getFrequency().value() > 7)) {
            this.\u0121.warn("Value of 'frequency' has invalid value (" + (Object)((Object)this.\u0117.getFrequency()) + "). Setting it to: " + (Object)((Object)Frequency.DAILY));
            this.\u0117.setFrequency(Frequency.DAILY);
        }
    }

    private void A(boolean bl) {
        this.\u0116 = bl;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="It's a user-controlled filename configured in the client. But this here just checks the existency.")
    private void J(String string) {
        try {
            if (string != null && !new File(string).exists()) {
                this.\u0122.A(new EventDataObject(EventType.ENT_EVENTTYPE_BACKUP_FOLDER_UNUSABLE, 2L, Long.MIN_VALUE, null));
            }
        }
        catch (SecurityException securityException) {
            this.\u0122.A(new EventDataObject(EventType.ENT_EVENTTYPE_BACKUP_FOLDER_UNUSABLE, 2L, Long.MIN_VALUE, null));
        }
    }

    protected StringBuilder A(Calendar calendar, o o2) {
        StringBuilder stringBuilder = new StringBuilder();
        Calendar calendar2 = calendar;
        if (calendar2 == null) {
            calendar2 = Calendar.getInstance();
        }
        stringBuilder.append(File.separatorChar);
        stringBuilder.append(o2.D());
        stringBuilder.append(calendar2.get(1));
        stringBuilder.append(String.format("%02d", calendar2.get(2) + 1));
        stringBuilder.append(String.format("%02d", calendar2.get(5)));
        stringBuilder.append(".");
        stringBuilder.append(String.format("%02d", calendar2.get(11)));
        stringBuilder.append(String.format("%02d", calendar2.get(12)));
        return stringBuilder;
    }

    public void A(String string, o o2) throws SeeTecException, ZipException {
        if (this.\u0118.P()) {
            throw new SeeTecException(-50203, "Functionality not available in this mode.");
        }
        String string2 = this.K(string);
        this.J(string2);
        this.\u0121.info("Starting " + (Object)((Object)o2) + " backup.");
        try {
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.append((CharSequence)this.A(Calendar.getInstance(), o2));
            this.A(stringBuilder);
        }
        catch (SeeTecException | ZipException throwable) {
            this.\u0121.warn(throwable.getMessage());
            throw throwable;
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Folder is given from outside but we're only generating there a temporary file and delete exactly that one at the end.")
    private void A(StringBuilder stringBuilder) throws SeeTecException, ZipException {
        String string = "..\\..\\tools\\7z";
        FB fB = new FB(this.\u0118.S(), this.\u0118.R(), this.\u0118.H());
        fB.B(stringBuilder.toString());
        e.B(stringBuilder.toString());
        this.L(stringBuilder.toString());
        String string2 = stringBuilder.toString() + "." + o.A();
        String string3 = stringBuilder.toString() + "." + o.C();
        SevenZipProxy sevenZipProxy = new SevenZipProxy(Paths.get("..\\..\\tools\\7z", new String[0]), false);
        sevenZipProxy.encrypt(string2, string3, this.\u0117.getBackupPassword());
        this.L(string2);
        this.\u0121.info("Backup done to file: " + string3);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Folder is given from outside but we're only generating there a temporary file and delete exactly that one at the end.")
    private void L(String string) throws SeeTecException {
        try {
            if (!new File(string).delete()) {
                this.\u0121.error("Could not be deleted: " + string);
            }
        }
        catch (SecurityException securityException) {
            throw new SeeTecException(-20022, "Error while removing file: " + string);
        }
    }

    private void o() throws SeeTecException {
        this.\u0120 = this.M(this.\u011b.B() + "backup" + File.separatorChar);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Check for existence and if false, create it. Input is controlled by system variable in the one place where it's used.")
    protected String M(String string) {
        String string2 = null;
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                string2 = string;
            } else {
                try {
                    if (file.mkdir()) {
                        string2 = string;
                    } else {
                        this.\u0121.warn("Default backup location not existing. Creating the default backup location " + file + " not possible!");
                        this.\u0120 = null;
                    }
                }
                catch (SecurityException securityException) {
                    this.\u0121.warn("Default backup location not existing. Creating the default backup location " + file + " not possible!");
                    this.\u0120 = null;
                }
            }
        }
        return string2;
    }

    @Override
    public Map<String, String> A() {
        String string = "Backup frequency";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.\u011c.isShutdown()) {
            hashMap.put("BackupDaemon FINISHED", "NO FURTHER INFO AVAILABLE!");
        } else {
            if (this.\u0116) {
                hashMap.put("IN MAINTENANCE MODE", "NO FURTHER INFO AVAILABLE!");
            }
            hashMap.put("Backup already done today", this.\u011e ? "Yes" : "No");
            hashMap.put("Location of Backup", this.\u0117.getLocation() == null ? "n/a" : this.\u0117.getLocation());
            String string2 = TimeHelper.timeStringTillMidnight((long)this.\u0117.getTime());
            if (this.\u0117.getFrequency() == null) {
                hashMap.put("Backup frequency", "DEACTIVATED");
            } else if (this.\u0117.getFrequency() == Frequency.DAILY) {
                hashMap.put("Backup frequency", (Object)((Object)this.\u0117.getFrequency()) + " " + string2);
            } else {
                hashMap.put("Backup frequency", "Every " + (Object)((Object)this.\u0117.getFrequency()) + " " + string2);
            }
        }
        return hashMap;
    }

    @Override
    public void notify(EventDataObject eventDataObject) {
        if (eventDataObject.getSID() == 1050L) {
            try {
                this.j();
            }
            catch (SeeTecException seeTecException) {
                this.\u0121.error("Error while reinitializing Backupdaemon. Error: " + seeTecException.getErrorCode());
            }
        }
    }
}

