/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.coreservice.server;

import de.seetec.v5.coreservice.configuration.alarmclassifications.AlarmClassification;
import de.seetec.v5.coreservice.configuration.alarmclassifications.AlarmClassifications;
import de.seetec.v5.coreservice.configuration.alarmclassifications.Classifications;
import de.seetec.v5.coreservice.configuration.alarmscenario.Alarm;
import de.seetec.v5.coreservice.configuration.authorization.Authorization;
import de.seetec.v5.coreservice.configuration.authorization.group.Group;
import de.seetec.v5.coreservice.configuration.authorization.user.User;
import de.seetec.v5.coreservice.configuration.branchgroup.BranchGroupRelation;
import de.seetec.v5.coreservice.configuration.branchgroup.BranchGroupRelationBranchEntry;
import de.seetec.v5.coreservice.configuration.branchgroup.BranchGroupRelationGroupEntry;
import de.seetec.v5.coreservice.configuration.coreservice.file.Variant;
import de.seetec.v5.coreservice.configuration.sequences.ArrayOfBoolean;
import de.seetec.v5.coreservice.configuration.sequences.CalendarIds;
import de.seetec.v5.coreservice.configuration.sequences.TourDaysAndTime;
import de.seetec.v5.coreservice.configuration.sequences.TourEntity;
import de.seetec.v5.coreservice.configuration.sequences.TourEntry;
import de.seetec.v5.coreservice.configuration.sequences.TourTime;
import de.seetec.v5.coreservice.configuration.snmp.SNMPServerInfo;
import de.seetec.v5.coreservice.configuration.videowall.VideowallScreenEntity;
import de.seetec.v5.coreservice.configuration.videowall.module.VideowallScreenModuleEntity;
import de.seetec.v5.coreservice.server.J.A;
import de.seetec.v5.coreservice.server.J.B;
import de.seetec.v5.coreservice.server.J.C;
import de.seetec.v5.coreservice.server.KB;
import de.seetec.v5.coreservice.server.S;
import de.seetec.v5.coreservice.server.WA;
import de.seetec.v5.coreservice.server.aA;
import de.seetec.v5.coreservice.server.bA;
import de.seetec.v5.coreservice.server.c;
import de.seetec.v5.coreservice.server.gA;
import de.seetec.v5.coreservice.server.j;
import de.seetec.v5.coreservice.server.request.A.F;
import de.seetec.v5.coreservice.server.request.EntityExistingStatus;
import de.seetec.v5.coreservice.server.s;
import de.seetec.v5.coreservice.server.u;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.TreeTypes;
import de.seetec.v5.shared.configuration.eventing.Action;
import de.seetec.v5.shared.configuration.eventing.EmailListIDs;
import de.seetec.v5.shared.configuration.eventing.EventNotificationDetail;
import de.seetec.v5.shared.configuration.eventing.EventNotificationGroup;
import de.seetec.v5.shared.configuration.eventing.EventNotificationGroups;
import de.seetec.v5.shared.configuration.eventing.EventTypes;
import de.seetec.v5.shared.configuration.eventing.Eventing;
import de.seetec.v5.shared.configuration.eventing.NotificationLevel;
import de.seetec.v5.shared.configuration.output.high.DigitalOutputHigh;
import de.seetec.v5.shared.configuration.output.low.DigitalOutputLow;
import de.seetec.v5.shared.configuration.preset.PresetPositionEntity;
import de.seetec.v5.shared.configuration.smtp.SMTPServerInfo;
import de.seetec.v5.shared.configuration.timepattern.TimePattern;
import de.seetec.v5.shared.crypto.digest.MessageDigestGenerator;
import de.seetec.v5.shared.interaction.EntityDataObject;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class DBVersionMgr {
    public static final String FIRST_VERSION_WITH_DESCRIPTION = "6.15.0 RC13";
    private static final String FETCH_EVENTMANAGER_ENTITY = "select configuration from s_entity where ETYID = 4";
    private static final String UPDATE_EVENTMANAGER_ENTITY = "update s_entity set configuration=? where ETYID = 4";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private c core = null;
    private u coreCnfMgr = null;
    private S cayugaIDGenerator = null;
    private j internalEntityRepository = null;
    private WA entityEventUnmarshaller = null;
    private String version = null;

    public DBVersionMgr(c c2, u u2, Connection connection, S s2, s s3, j j2, bA bA2, WA wA2) throws SeeTecException {
        this.checkParameters(c2, u2, connection, s2, j2, bA2, wA2);
        try {
            this.logger.info("Doing DB updates...");
            String[] stringArray = DBVersionMgr.getUpdateMethodNames(this.getClass());
            Class[] classArray = new Class[]{Connection.class};
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (this.version == null) {
                    this.version = bA2.B();
                }
                this.checkIfContentIsTooOld();
                String string = stringArray[i2];
                String string2 = i2 == 0 ? "updateTo_5_0_0" : stringArray[i2 - 1];
                Method method = this.getClass().getDeclaredMethod(stringArray[i2], classArray);
                connection.setAutoCommit(false);
                String string3 = this.extractVersionNumber(string);
                try {
                    if (!this.version.equals(this.extractVersionNumber(string2))) continue;
                    if (s3 != null) {
                        s3.A(string3);
                    }
                    method.invoke((Object)this, connection);
                    this.logger.info("Update to " + string3 + ".");
                    bA2.A(string3);
                    this.version = string3;
                    connection.commit();
                    connection.setAutoCommit(true);
                    if (s3 == null) continue;
                    s3.B(string3);
                    continue;
                }
                catch (Exception exception) {
                    this.logCausingException(exception, stringArray[i2]);
                    connection.rollback();
                    connection.setAutoCommit(true);
                    throw new SeeTecException(-20000, "Update to " + this.extractVersionNumber(string) + " failed. Rolling back changes.");
                }
            }
        }
        catch (SeeTecException seeTecException) {
            throw seeTecException;
        }
        catch (Throwable throwable) {
            throw new SeeTecException(-20000, throwable.getMessage());
        }
    }

    private void logCausingException(Exception exception, String string) {
        try {
            throw exception.getCause();
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Error while executing " + string + ". errorCode: : " + seeTecException.getErrorCode() + ". Message: " + seeTecException.getMessage());
        }
        catch (Throwable throwable) {
            this.logger.error("Exception while executing " + string + ".", (Throwable)exception);
        }
    }

    protected static String[] getUpdateMethodNames(Class<?> clazz) {
        if (clazz == null) {
            return new String[0];
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Method method : methodArray) {
            if (!method.getName().startsWith("updateTo")) continue;
            arrayList.add(method.getName());
        }
        Object[] objectArray = new String[arrayList.size()];
        objectArray = (String[])arrayList.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void checkParameters(c c2, u u2, Connection connection, S s2, j j2, bA bA2, WA wA2) throws SeeTecException {
        this.core = c2;
        if (this.core == null || (this.coreCnfMgr = u2) == null || connection == null || (this.cayugaIDGenerator = s2) == null || (this.internalEntityRepository = j2) == null || bA2 == null || (this.entityEventUnmarshaller = wA2) == null) {
            throw new SeeTecException(-20002, "Parameter to start DBVersionMgr was null.");
        }
    }

    private void checkIfContentIsTooOld() throws SeeTecException {
        if (!KB.A(this.version.split(" ")[0], "5.4.7")) {
            throw new SeeTecException(-20000, Basic.generateIndentedMultiLineLog((String[])new String[]{"Before Updating to Cayuga you have to update before to SeeTec 5.4.8"}));
        }
    }

    protected String extractVersionNumber(String string) {
        try {
            String[] stringArray = string.split("_+");
            return stringArray[1] + "." + stringArray[2] + "." + stringArray[3] + (stringArray.length == 5 ? " " + stringArray[4] : "");
        }
        catch (Exception exception) {
            this.logger.error("An error occured while splitting method name. Return null.");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Eventing getEventManagerEntity(Connection connection) throws SeeTecException {
        if (connection == null) {
            throw new SeeTecException(-20002, "Given connection is null");
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(FETCH_EVENTMANAGER_ENTITY);){
            Throwable throwable;
            ResultSet resultSet;
            block27: {
                Eventing eventing;
                block28: {
                    resultSet = preparedStatement.executeQuery();
                    throwable = null;
                    if (!resultSet.next()) break block27;
                    eventing = (Eventing)Basic.unmarshalXML(Eventing.class, (Object)resultSet.getBytes(1));
                    if (resultSet == null) return eventing;
                    if (throwable == null) break block28;
                    try {
                        resultSet.close();
                        return eventing;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return eventing;
                    }
                }
                resultSet.close();
                return eventing;
            }
            try {
                try {
                    throw new SeeTecException(-20076, "Could not read event manager entity.");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (resultSet == null) throw throwable4;
                if (throwable == null) {
                    resultSet.close();
                    throw throwable4;
                }
                try {
                    resultSet.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SeeTecException(-20076, "Could not read event manager entity.");
        }
        catch (JAXBException | SAXException throwable) {
            throw new SeeTecException(-20076, "Could not deserialize event manager entity.");
        }
    }

    protected EmailListIDs createDefaultEmailListIDs() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(1053L);
        return new EmailListIDs(arrayList);
    }

    protected Action createDefaultAction() {
        return new Action(-1L, -1L);
    }

    protected EventNotificationDetail setDefaultEventNotificationDetail(EventType eventType) throws SeeTecException {
        return this.setNotificationDetail(3600000L, NotificationLevel.ERROR, eventType);
    }

    protected EventNotificationDetail setDisabledDefaultEventNotificationDetail(NotificationLevel notificationLevel, EventType eventType) throws SeeTecException {
        return this.setNotificationDetail(0L, notificationLevel, eventType);
    }

    private EventNotificationDetail setNotificationDetail(long l2, NotificationLevel notificationLevel, EventType eventType) throws SeeTecException {
        if (eventType == null) {
            throw new SeeTecException(-20002, "Eventtype to set is null.");
        }
        if (notificationLevel == null) {
            return null;
        }
        EventNotificationDetail eventNotificationDetail = new EventNotificationDetail();
        eventNotificationDetail.setEventType(eventType.getType());
        eventNotificationDetail.setDeadTime(l2);
        eventNotificationDetail.setEmailAccumulation(false);
        eventNotificationDetail.setSNMP(true);
        eventNotificationDetail.setNotificationLevel(notificationLevel);
        eventNotificationDetail.setAction(this.createDefaultAction());
        eventNotificationDetail.setEmailListIDs(this.createDefaultEmailListIDs());
        return eventNotificationDetail;
    }

    private void removeEventTypes(Connection connection, List<Long> list) throws SeeTecException {
        try {
            if (list != null) {
                Eventing eventing = this.getEventManagerEntity(connection);
                Iterator iterator = eventing.getEventNotification().getEventNotifications().getEventNotificationDetail().iterator();
                while (iterator.hasNext()) {
                    EventNotificationDetail eventNotificationDetail = (EventNotificationDetail)iterator.next();
                    if (!list.contains(eventNotificationDetail.getEventType())) continue;
                    iterator.remove();
                }
                this.writeEventManagerEntity(connection, eventing);
            }
        }
        catch (Exception exception) {
            throw new SeeTecException(-20076, "Error while updating eventing configuration: " + exception.getMessage());
        }
    }

    private void addEventTypes(Connection connection, EventNotificationDetail eventNotificationDetail) {
        try {
            if (eventNotificationDetail != null) {
                Eventing eventing = this.getEventManagerEntity(connection);
                eventing.getEventNotification().getEventNotifications().getEventNotificationDetail().add(eventNotificationDetail);
                this.writeEventManagerEntity(connection, eventing);
            }
        }
        catch (Exception exception) {
            this.logger.error("Error while updating eventing configuration: " + exception.getMessage());
        }
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING", "SQL_INJECTION_JDBC"})
    private void dropIndexIfExisting(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("select TABLENAME from indexes where INDEXNAME = ?");
        preparedStatement.setString(1, string.toUpperCase());
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            String string2 = resultSet.getString(1);
            this.logger.warn(String.format("Drop index %s.", string));
            preparedStatement = connection.prepareStatement(String.format("drop index %s on %s", string, string2));
            preparedStatement.execute();
        }
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING", "SQL_INJECTION_JDBC"})
    private void createIndexIfNotExisting(Connection connection, String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("select * from indexpages where indexname = ?");
        preparedStatement.setString(1, string2.toUpperCase());
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            this.logger.info("Creating index for " + string + ". THIS MAY TAKE A WHILE! DO NOT ABORT.");
            preparedStatement = connection.prepareStatement(String.format("create index %s on %s", string2, string3));
            preparedStatement.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEventManagerEntity(Connection connection, Eventing eventing) throws SeeTecException, SAXException, JAXBException, FileNotFoundException, SQLException {
        if (connection == null || eventing == null) {
            throw new SeeTecException(-20002, "Required argument is null");
        }
        String string = Basic.marshalXML((Object)eventing);
        try (PreparedStatement preparedStatement = connection.prepareStatement(UPDATE_EVENTMANAGER_ENTITY);){
            preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(string.getBytes()), string.getBytes().length);
            if (preparedStatement.executeUpdate() == 0) {
                throw new SeeTecException(-20076, "Can't write entity");
            }
            preparedStatement = connection.prepareStatement("update s_entity set syncID=seq_syncid.nextval where ETYID = 4");
            if (preparedStatement.executeUpdate() == 0) {
                throw new SeeTecException(-20076, "Can't write entity's syncID");
            }
        }
    }

    private void updatePortForDisplayAgent(EntityDataObject entityDataObject, int n2) throws JAXBException, SAXException, SeeTecException, FileNotFoundException {
        VideowallScreenEntity videowallScreenEntity = (VideowallScreenEntity)Basic.unmarshalXML(VideowallScreenEntity.class, (Object)entityDataObject.getConfiguration(), (boolean)false);
        if (videowallScreenEntity.getPort() == 0) {
            videowallScreenEntity.setPort(n2);
            this.storeEntity(entityDataObject, videowallScreenEntity);
        }
    }

    private void updatePortForDisplayAgentModule(EntityDataObject entityDataObject, int n2) throws JAXBException, SAXException, SeeTecException, FileNotFoundException {
        VideowallScreenModuleEntity videowallScreenModuleEntity = (VideowallScreenModuleEntity)Basic.unmarshalXML(VideowallScreenModuleEntity.class, (Object)entityDataObject.getConfiguration(), (boolean)false);
        if (videowallScreenModuleEntity.getPort() == 0L) {
            videowallScreenModuleEntity.setPort(n2);
            this.storeEntity(entityDataObject, videowallScreenModuleEntity);
        }
    }

    private void storeEntity(EntityDataObject entityDataObject, Object object) throws JAXBException, SAXException, SeeTecException, FileNotFoundException {
        entityDataObject.setConfiguration(Basic.marshalXML((Object)object).getBytes());
        if (this.internalEntityRepository.A(entityDataObject) != 0) {
            throw new SeeTecException(-20000, "Can't update " + object.getClass().getName() + ": " + entityDataObject.getName());
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_5_4_8_RC1(Connection connection) throws NullPointerException, SQLException {
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0_RC1(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(UPDATE_EVENTMANAGER_ENTITY);){
            Eventing eventing = this.getEventManagerEntity(connection);
            String string = Basic.marshalXML((Object)eventing);
            preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(string.getBytes()), string.getBytes().length);
            if (preparedStatement.executeUpdate() == 0) {
                throw new SeeTecException(-20076, "Can't write update.");
            }
        }
        catch (SeeTecException seeTecException) {
            throw seeTecException;
        }
        catch (Exception exception) {
            this.logger.error("Error while updating eventing configuration: " + exception.getMessage());
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0_RC2(Connection connection) throws NullPointerException, SQLException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "create sequence seq_idoffset INCREMENT BY 1 START WITH 1");
        de.seetec.v5.coreservice.server.F.C.A(connection, "grant all on seq_idoffset to EntMgr");
        de.seetec.v5.coreservice.server.F.C.A(connection, "drop sequence seq_eventticket");
        de.seetec.v5.coreservice.server.F.C.A(connection, "drop sequence seq_ticket");
        de.seetec.v5.coreservice.server.F.C.A(connection, "create sequence seq_ticket INCREMENT BY 1000 START WITH 1000000");
        de.seetec.v5.coreservice.server.F.C.A(connection, "grant all on seq_ticket to EntMgr");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0_RC3(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "create table s_password (ETYID fixed(38,0),pass varchar(100) UNICODE not null,pass2 varchar(100) UNICODE,syncID FIXED(38,0))");
        try (PreparedStatement preparedStatement = connection.prepareStatement("insert into s_password(ETYID,pass,pass2) select USRID,pass,pass2 from s_user");){
            if (preparedStatement.executeUpdate() == 0) {
                throw new SeeTecException(-20076, "Can't migrate users to new table.");
            }
        }
        de.seetec.v5.coreservice.server.F.C.A(connection, "alter table s_user drop pass");
        de.seetec.v5.coreservice.server.F.C.A(connection, "alter table s_user drop pass2");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0_RC4(Connection connection) throws NullPointerException, SQLException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "grant all on s_password to EntMgr");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0_RC5(Connection connection) throws NullPointerException, SQLException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "alter table s_password modify (pass VARCHAR(200) not null, pass2 VARCHAR(200))");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0_RC6(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        block41: {
            try (PreparedStatement preparedStatement = connection.prepareStatement("select value_desc from s_authmgr_properties where key_desc = 'IsLDAP'");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    Authorization authorization = new Authorization();
                    authorization.setLDAP(resultSet.getBoolean(1));
                    try (PreparedStatement preparedStatement2 = connection.prepareStatement("update s_entity set configuration=? where ETYID = 3");){
                        String string = Basic.marshalXML((Object)authorization);
                        preparedStatement2.setBinaryStream(1, (InputStream)new ByteArrayInputStream(string.getBytes()), string.getBytes().length);
                        if (preparedStatement2.executeUpdate() == 0) {
                            throw new SeeTecException(-20076, "Can't write update.");
                        }
                        de.seetec.v5.coreservice.server.F.C.A(connection, "drop table s_authmgr_properties");
                        break block41;
                    }
                    catch (SeeTecException seeTecException) {
                        throw seeTecException;
                    }
                    catch (Exception exception) {
                        throw new SeeTecException(-20076, "Error creating XML: " + exception);
                    }
                }
                throw new SeeTecException(-20076, "Can't write update.");
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0_RC7(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set name='CoreService' where ETYID = 2");
    }

    private void reorder(Connection connection, long l2, long l3, int n2) throws SQLException {
        this.reorder(connection, l2, l3, n2, true);
    }

    private void reorder(Connection connection, long l2, long l3, int n2, boolean bl) throws SQLException {
        this.reorder(connection, l2, l3, n2, bl, TreeTypes.LOGICALTREE);
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING", "SQL_INJECTION_JDBC"})
    private void reorder(Connection connection, long l2, long l3, int n2, boolean bl, TreeTypes treeTypes) throws SQLException {
        int n3 = n2 == -1 ? KB.A(KB.A(connection, l3, treeTypes)) : n2;
        PreparedStatement preparedStatement = connection.prepareStatement("update s_entity set " + treeTypes.getParentColumn() + "=" + l3 + "," + treeTypes.getOrderColumn() + "=" + n3 + " where etyid = " + l2);
        preparedStatement.executeUpdate();
        preparedStatement = bl ? connection.prepareStatement("select ETYID,nodeorder from v_administrativetree where parent = " + l2) : connection.prepareStatement("select ETYID,nodeorder from v_administrativetree where parent = " + l2 + " and (v_administrativetree.ettid < 210000 or v_administrativetree.ettid > 219901) ");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            this.reorder(connection, resultSet.getLong(1), l2, resultSet.getInt(2), bl, treeTypes);
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD", "SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void updateTo_6_0_0_RC8(Connection connection) throws NullPointerException, SQLException {
        long[][] lArrayArray;
        long l2;
        long l3 = 2200L;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        String string = "select ETYID from v_administrativetree deviceList where (ettid >= 200000 and ettid <= 209800) and (select count(*) from v_administrativetree where ettid >= 210000 and ettid <= 219901 and parent = deviceList.ETYID) = 1";
        String string2 = "select ETYID,name from v_administrativetree deviceList where ((ettid >= 200000 and ettid <= 209800) and (select count(*) from v_administrativetree where ettid >= 210000 and ettid <= 219901 and parent = deviceList.ETYID) > 1) or ETTID = 209900";
        String string3 = "select s_entity.ETYID,s_entity.name,s_entity.logicalparent,s_entity.logicalorder,v_administrativetree.parent,v_administrativetree.nodeorder from s_entity,v_administrativetree where s_entity.etyid = v_administrativetree.etyid and s_entity.ettid >= 210000 and s_entity.ettid <= 219901";
        de.seetec.v5.coreservice.server.F.C.A(connection, "alter table s_blob add deleted BOOLEAN DEFAULT FALSE, syncID FIXED(38,0)");
        de.seetec.v5.coreservice.server.F.C.A(connection, "alter table s_entity add physicalParent FIXED(38,0), physicalOrder FIXED(38,0), logicalParent FIXED(38,0), logicalOrder FIXED(38,0),deleted BOOLEAN DEFAULT FALSE, syncID FIXED(38,0)");
        de.seetec.v5.coreservice.server.F.C.A(connection, "update s_entity set (logicalParent,logicalorder) = (select parent,nodeorder from v_presentationtree where s_entity.etyid = v_presentationtree.etyid)");
        int n2 = KB.A(KB.A(connection, TreeTypes.LOGICALTREE.getRoot(), TreeTypes.LOGICALTREE));
        de.seetec.v5.coreservice.server.F.C.A(connection, "update s_entity set (physicalparent,physicalorder,logicalParent,logicalorder) = (" + TreeTypes.PHYSICALTREE.getRoot() + ",0," + TreeTypes.LOGICALTREE.getRoot() + "," + n2 + ") where etyid = " + 101L);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            arrayList.add(resultSet.getLong(1));
        }
        preparedStatement = connection.prepareStatement(string2);
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            arrayList2.add(resultSet.getLong(1));
        }
        preparedStatement = connection.prepareStatement(string3);
        resultSet = preparedStatement.executeQuery();
        arrayList3.addAll(arrayList);
        arrayList3.addAll(arrayList2);
        while (resultSet.next()) {
            l2 = resultSet.getLong(1);
            String string4 = resultSet.getString(2);
            long l4 = resultSet.getLong(3);
            int n3 = resultSet.getInt(4);
            Long l5 = resultSet.getLong(5);
            int n4 = resultSet.getInt(6);
            this.logger.info(String.format("Processing %s,'%s', Parent: %s, Order: %s, ParentInAdminTree: %s, OrderInAdminTree: %s", l2, string4, l4, n3, l5, n4));
            int n5 = -1;
            n5 = arrayList3.indexOf(l5);
            if (n5 != -1) {
                int n6 = 0;
                this.reorder(connection, (Long)arrayList3.get(n5), 101L, n6++, false);
                this.reorder(connection, l2, l4, n3);
                this.reorder(connection, (Long)arrayList3.get(n5), 101L, n3, true, TreeTypes.PHYSICALTREE);
            }
            preparedStatement = connection.prepareStatement("update s_entity set (physicalParent,physicalorder) = (" + l5 + "," + n4 + ") where ETYID = " + l2);
            preparedStatement.executeUpdate();
        }
        preparedStatement = connection.prepareStatement("select ETYID from s_entity where ETTID = 209900 and logicalorder is null");
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            l2 = resultSet.getLong(1);
            this.reorder(connection, l2, 101L, -1, false);
            this.reorder(connection, l2, 101L, -1, true, TreeTypes.PHYSICALTREE);
        }
        long[][] lArrayArray2 = lArrayArray = new long[][]{{102L, 3001L}, {30L, 3006L}, {31L, 3007L}, {103L, 3003L}, {109L, 3002L}, {114L, 3004L}, {105L, 3005L}, {108L, 3008L}, {110L, 3009L}};
        int n7 = lArrayArray2.length;
        for (int i2 = 0; i2 < n7; ++i2) {
            long[] lArray = lArrayArray2[i2];
            preparedStatement = connection.prepareStatement("update s_entity set ettid = " + lArray[1] + " where etyid = " + lArray[0]);
            preparedStatement.executeUpdate();
        }
        for (long[] lArray : lArrayArray2 = new long[][]{{231L, 1L}, {200081L, 1L}, {230L, 1L}, {232L, 1L}, {234L, 1L}, {2400L, 1L}, {2600L, 1L}, {270000L, 1L}, {270300L, 1L}, {270301L, 1L}, {270302L, 1L}, {270303L, 1L}, {270304L, 1L}, {270305L, 1L}, {l3, 1L}, {220100L, 1L}, {220101L, 1L}, {220102L, 1L}, {2202L, 1L}, {87L, 1L}, {233L, 0L}, {3001L, 0L}, {203L, 0L}, {202L, 0L}, {112L, 0L}, {3006L, 0L}, {3007L, 0L}, {3003L, 0L}, {205L, 0L}, {28L, 0L}, {3002L, 0L}, {3004L, 0L}, {3005L, 0L}, {3008L, 0L}, {3009L, 0L}}) {
            preparedStatement = connection.prepareStatement("select ETYID,name from v_administrativetree where ettid = " + lArray[0]);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l6 = resultSet.getLong(1);
                this.reorder(connection, l6, TreeTypes.LOGICALTREE.getRoot(), -1);
                if (lArray[1] == 1L) {
                    this.reorder(connection, l6, 101L, -1, true, TreeTypes.PHYSICALTREE);
                }
                this.logger.info(String.format("Reordering device %s, '%s' of type %s.", resultSet.getLong(1), resultSet.getString(2), lArray[0]));
            }
        }
        this.reorderSpecialEntities(connection);
        this.reorder(connection, 2L, TreeTypes.LOGICALTREE.getRoot(), -1);
        this.reorder(connection, 4L, 105L, -1);
        de.seetec.v5.coreservice.server.F.C.A(connection, "delete from s_entity where ETYID in (6,8,9,104,106,107,111,113,115)");
        de.seetec.v5.coreservice.server.F.C.A(connection, "drop table s_tree");
        de.seetec.v5.coreservice.server.F.C.A(connection, "update s_entity set physicalorder = 0 where ETYID = 1");
        de.seetec.v5.coreservice.server.F.C.A(connection, "update s_entity set configuration = null,name='Alarm',ETTID=3011 where ETYID = 5");
        de.seetec.v5.coreservice.server.F.C.A(connection, "update s_entity set ETTID=3010 where ETYID = 101");
        de.seetec.v5.coreservice.server.F.C.A(connection, "create sequence seq_syncid INCREMENT BY 1 START WITH 1");
        de.seetec.v5.coreservice.server.F.C.A(connection, "grant all on seq_syncid to EntMgr");
    }

    private void reorderSpecialEntities(Connection connection) throws SQLException {
        long[][] lArrayArray;
        for (long[] lArray : lArrayArray = new long[][]{{201L, TreeTypes.LOGICALTREE.getRoot()}, {51L, TreeTypes.LOGICALTREE.getRoot()}, {233L, 108L}}) {
            PreparedStatement preparedStatement = connection.prepareStatement("select ETYID,name from s_entity where ettid = " + lArray[0]);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                this.reorder(connection, resultSet.getLong(1), lArray[1], -1);
                this.logger.info("Reordering device of type " + lArray[0] + " with ID: " + resultSet.getString(2) + " to new parent: " + lArray[1]);
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void updateTo_6_0_0_RC9(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        de.seetec.v5.coreservice.server.F.C.C(connection, String.format("update s_entity set ETTID=%s where ETYID = %s", 3012L, TreeTypes.LOGICALTREE.getRoot()));
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void updateTo_6_0_0__RC10(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            de.seetec.v5.coreservice.server.F.C.C(connection, "insert into s_entity (ETYID,name,ETTID,active,MID," + TreeTypes.LOGICALTREE.getParentColumn() + "," + TreeTypes.LOGICALTREE.getOrderColumn() + ",syncID) values (1061,'EntityNumbers',47,TRUE,10053,105," + KB.A(KB.A(connection, 105L, TreeTypes.LOGICALTREE)) + ",seq_syncid.nextval)");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC11(Connection connection) throws NullPointerException, SQLException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "create table s_corelist (ETYID fixed(38,0),type varchar(30) UNICODE not null)");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC12(Connection connection) throws NullPointerException, SQLException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "drop sequence seq_idoffset");
        de.seetec.v5.coreservice.server.F.C.A(connection, "create sequence seq_idoffset INCREMENT BY 1 START WITH 2");
        de.seetec.v5.coreservice.server.F.C.A(connection, "grant all on seq_idoffset to EntMgr");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD", "SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void updateTo_6_0_0__RC13(Connection connection) throws NullPointerException, SQLException {
        if (this.coreCnfMgr.Q()) {
            try (PreparedStatement preparedStatement = connection.prepareStatement(String.format("update s_entity set ETTID=%s,syncID=seq_syncid.nextval where (ETTID = %s) and (ETYID <> %s)", 206L, 201L, 2L));){
                preparedStatement.executeUpdate();
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    private void updateTo_6_0_0__RC20(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        try (Statement statement = connection.createStatement();){
            int n2 = this.getLprVersion(connection);
            if (!de.seetec.v5.coreservice.server.F.C.B(connection, F.D.A())) {
                statement.execute("create table lpr_associatedcams(changeTime FIXED(38,0) not null,ETYID FIXED(38,0) constraint ETYID_chk check (ETYID >= 0),cam1 FIXED(38,0),cam2 FIXED(38,0),cam3 FIXED(38,0),layer1 FIXED(38,0),layer2 FIXED(38,0),layer3 FIXED(38,0))");
            }
            if (!de.seetec.v5.coreservice.server.F.C.B(connection, F.C.A())) {
                statement.execute("create table LPR_EVENT_DATA_00(ROW_ID  Fixed (38,0)  DEFAULT SERIAL (1),LP_TEXT  Varchar (50) UNICODE,MASTER_DATA_ID  Fixed (38,0),CAM_ID  Fixed (38,0),LANE_ID  Fixed (38,0),LANE_NAME  Varchar (50) UNICODE,GROUP_ID  Fixed (38,0),GROUP_NAME  Varchar (50) UNICODE,TRIGGER_ID  Fixed (38,0),COUNTRY  Varchar (50) UNICODE,COUNTRY_CODE  Integer,A_TIME  Fixed (38,0),FIRST_TIME  Fixed (38,0),CAM_NAME  Varchar (50) UNICODE,MODULE_NAME  Varchar (50) UNICODE,CONFIDENCE Integer)");
            } else if (n2 < 1) {
                statement.addBatch("ALTER TABLE LPR_EVENT_DATA_00 ADD(CAM_NAME VARCHAR(50) UNICODE)");
                statement.addBatch("ALTER TABLE LPR_EVENT_DATA_00 ADD(MODULE_NAME VARCHAR(50) UNICODE)");
                statement.addBatch("ALTER TABLE LPR_EVENT_DATA_00 ADD(CONFIDENCE Integer)");
                statement.executeBatch();
            }
            if (!de.seetec.v5.coreservice.server.F.C.B(connection, F.F.A())) {
                statement.execute("create table LPR_HEADER_DATA_00(ROW_ID FIXED(38,0) DEFAULT SERIAL (1), MY_KEY VARCHAR(50) UNICODE, MY_VALUE CHAR(255) UNICODE)");
            } else if (n2 < 1) {
                statement.addBatch("ALTER TABLE LPR_HEADER_DATA_00 DROP (MYID) CASCADE");
                statement.addBatch("ALTER TABLE LPR_HEADER_DATA_00 ADD(ROW_ID FIXED(38,0) DEFAULT SERIAL(1))");
                statement.addBatch("ALTER TABLE LPR_HEADER_DATA_00 ADD(MY_KEY VARCHAR(50) UNICODE)");
                statement.addBatch("ALTER TABLE LPR_HEADER_DATA_00 DROP (MYKEY) CASCADE");
                statement.addBatch("ALTER TABLE LPR_HEADER_DATA_00 ADD(MY_VALUE CHAR(255) UNICODE)");
                statement.addBatch("ALTER TABLE LPR_HEADER_DATA_00 DROP (MYVALUE) CASCADE");
                statement.executeBatch();
            }
            if (!de.seetec.v5.coreservice.server.F.C.B(connection, F.E.A())) {
                statement.execute("create table LPR_MASTER_DATA_00(ROW_ID  Fixed (38,0)  DEFAULT SERIAL (1),LP_TEXT  Varchar (50) UNICODE,GROUP_ID  Fixed (38,0),COUNTRY_CODE  Integer,COUNTRY  Varchar (50) UNICODE,ALWAYS_VALID  Boolean,VALID_FROM  Fixed (38,0),VALID_TO  Fixed (38,0),CREATED  Fixed (38,0),CREATED_BY  Fixed (38,0),LAST_MODIFIED  Fixed (38,0),LAST_MODIFIED_BY  Fixed (38,0),ENABLED  Boolean,HISTORY  Fixed (38,0),FIELD_0  Varchar (50) UNICODE,FIELD_1  Varchar (50) UNICODE,FIELD_2  Varchar (50) UNICODE,FIELD_3  Varchar (50) UNICODE,FIELD_4  Varchar (50) UNICODE,FIELD_5  Varchar (50) UNICODE,FIELD_6  Varchar (50) UNICODE,FIELD_7  Varchar (50) UNICODE,FIELD_8  Varchar (50) UNICODE,FIELD_9  Varchar (50) UNICODE,CREATED_BY_NAME  Varchar (50) UNICODE,LAST_MODIFIED_BY_NAME  Varchar (50) UNICODE,EMAIL_ACTION  Varchar (128) UNICODE,EMAIL_TEXT  Varchar (512) UNICODE)");
            } else if (n2 < 1) {
                statement.addBatch("ALTER TABLE LPR_MASTER_DATA_00 ADD(EMAIL_ACTION VARCHAR(128) UNICODE)");
                statement.addBatch("ALTER TABLE LPR_MASTER_DATA_00 ADD(EMAIL_TEXT VARCHAR(512) UNICODE)");
                statement.executeBatch();
            }
            if (!de.seetec.v5.coreservice.server.F.C.B(connection, "CCR_EVENT_DATA_00")) {
                statement.execute("create table CCR_EVENT_DATA_00(ROW_ID  Fixed (38,0)  DEFAULT SERIAL (1),CC_TEXT  Varchar (50) UNICODE,MASTER_DATA_ID  Fixed (38,0),CAM_ID  Fixed (38,0),LANE_ID  Fixed (38,0),LANE_NAME  Varchar (50) UNICODE,GROUP_ID  Fixed (38,0),GROUP_NAME  Varchar (50) UNICODE,TRIGGER_ID  Fixed (38,0),COUNTRY  Varchar (50) UNICODE,COUNTRY_CODE  Integer,A_TIME  Fixed (38,0),FIRST_TIME  Fixed (38,0),CAM_NAME  Varchar (50) UNICODE,MODULE_NAME  Varchar (50) UNICODE,CONFIDENCE Integer,CHECKSUM Integer,CC_ALTERNATIVE Varchar (50) UNICODE,CC_ALT_USER Varchar (50) UNICODE,CC_ALT_TIME Fixed(38,0))");
            }
            this.grantAccessToLprTables(connection);
        }
    }

    private int getLprVersion(Connection connection) throws SeeTecException, NumberFormatException, SQLException {
        try (Statement statement = connection.createStatement();){
            int n2 = -1;
            if (de.seetec.v5.coreservice.server.F.C.B(connection, "lpr_version")) {
                try (ResultSet resultSet = statement.executeQuery("select version from lpr_version");){
                    if (resultSet.next()) {
                        String string = resultSet.getString(1);
                        n2 = Integer.parseInt(string.substring(string.length() - 1));
                    }
                }
            }
            int n3 = n2;
            return n3;
        }
    }

    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE", "SQL_INJECTION_JDBC"})
    private void grantAccessToLprTables(Connection connection) throws SeeTecException, SQLException {
        String string = "grant all on %s to EntMgr";
        List<String> list = Arrays.asList(F.D.A(), F.C.A(), F.F.A(), F.E.A(), "CCR_EVENT_DATA_00");
        try (Statement statement = connection.createStatement();){
            for (String string2 : list) {
                try {
                    statement.execute(String.format(string, string2));
                }
                catch (SQLException sQLException) {
                    this.logger.error(sQLException.getMessage());
                }
            }
            if (de.seetec.v5.coreservice.server.F.C.B(connection, "lpr_version")) {
                statement.execute("drop table lpr_version");
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD", "SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void updateTo_6_0_0__RC21(Connection connection) throws NullPointerException, SQLException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        PreparedStatement preparedStatement = connection.prepareStatement("select ETYID from s_entity where ETTID = 2200");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            arrayList.add(resultSet.getLong(1));
        }
        for (Long l2 : arrayList) {
            preparedStatement = connection.prepareStatement("delete from s_entity where ETYID=" + l2);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("delete from s_entity where physicalparent=" + l2);
            int n2 = preparedStatement.executeUpdate();
            this.logger.info(String.format("Beckhoff device '%s' and its %s sub entities deleted.", l2, n2));
        }
        preparedStatement.close();
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC22(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        block40: {
            if (this.coreCnfMgr.Q()) {
                try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID,configuration from s_entity where ETTID = 9931");){
                    ResultSet resultSet = preparedStatement.executeQuery();
                    Throwable throwable = null;
                    while (true) {
                        try {
                            if (!resultSet.next()) break block40;
                            long l2 = resultSet.getLong(1);
                            PresetPositionEntity presetPositionEntity = null;
                            try {
                                PreparedStatement preparedStatement2 = connection.prepareStatement("update s_entity set configuration=? where ETYID = ?");
                                Throwable throwable2 = null;
                                try {
                                    byte[] byArray = resultSet.getBytes(2);
                                    if (byArray == null) continue;
                                    presetPositionEntity = (PresetPositionEntity)Basic.unmarshalXML(PresetPositionEntity.class, (Object)byArray, (boolean)false);
                                    presetPositionEntity.setIsUserDefined(false);
                                    presetPositionEntity.setUserID(1001L);
                                    byte[] byArray2 = Basic.marshalXMLToByteArray((Object)presetPositionEntity);
                                    preparedStatement2.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byArray2), byArray2.length);
                                    preparedStatement2.setLong(2, l2);
                                    if (preparedStatement2.executeUpdate() == 0) {
                                        throw new SeeTecException(-20076, "Can't write update.");
                                    }
                                    de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set syncID=seq_syncid.nextval where ETYID = " + l2);
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (preparedStatement2 == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            preparedStatement2.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    preparedStatement2.close();
                                }
                            }
                            catch (SeeTecException seeTecException) {
                                throw seeTecException;
                            }
                            catch (Exception exception) {
                                throw new SeeTecException(-20000, "Error while upgrading configuration of '" + l2 + ": " + exception.getMessage());
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            if (throwable != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                resultSet.close();
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD", "SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void updateTo_6_0_0__RC23(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
            PreparedStatement preparedStatement = connection.prepareStatement("select ETYID,logicalParent from s_entity where ETTID = 3009");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashMap.put(resultSet.getLong(1), resultSet.getLong(2));
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                this.logger.info("Processing extension: " + entry);
                ArrayList<Long> arrayList = new ArrayList<Long>();
                preparedStatement = connection.prepareStatement("select ETYID from s_entity where logicalParent = " + entry.getKey());
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getLong(1));
                }
                this.logger.info(String.format("%s children has been found under %s", arrayList.size(), entry.getKey()));
                this.logger.info(arrayList);
                if (arrayList.size() > 0) {
                    preparedStatement = connection.prepareStatement("select ETYID from s_entity where ETTID = 3008 and logicalParent = " + entry.getValue());
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new SeeTecException(-20000, "Error while finding new parent of extension " + entry.getKey());
                    }
                    long l2 = resultSet.getLong(1);
                    for (Long l3 : arrayList) {
                        int n2 = KB.A(KB.A(connection, l2, TreeTypes.LOGICALTREE));
                        de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set logicalParent = " + l2 + ", logicalOrder = " + n2 + ",syncID=seq_syncid.nextval where ETYID = " + l3);
                    }
                }
                de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set deleted=true,syncID=seq_syncid.nextval where ETYID = " + entry.getKey());
            }
            preparedStatement.close();
            this.logger.info(hashMap.size() + " extension folder(s) updated.");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC24(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set active=true,syncID=seq_syncid.nextval where ETYID = 112");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC25(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set MID=1,syncID=seq_syncid.nextval where ETYID = 0");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void updateTo_6_0_0__RC26(Connection connection) throws NullPointerException, SQLException {
        String string = "ALTER TABLE %s ADD SYNCID FIXED(38,0)";
        de.seetec.v5.coreservice.server.F.C.A(connection, String.format(string, "LPR_MASTER_DATA_00"));
        de.seetec.v5.coreservice.server.F.C.A(connection, String.format(string, "LPR_HEADER_DATA_00"));
        de.seetec.v5.coreservice.server.F.C.A(connection, String.format(string, "LPR_EVENT_DATA_00"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC27(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (!this.coreCnfMgr.Q()) return;
        try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID,ETTID,configuration from s_entity where (ETTID = 87) or (ETTID = 871)");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long l2 = resultSet.getLong(1);
                long l3 = resultSet.getLong(2);
                byte[] byArray = resultSet.getBytes(3);
                if (byArray != null) {
                    try {
                        Object object;
                        long l4 = -1L;
                        long l5 = 87L;
                        if (l3 == l5) {
                            object = (VideowallScreenEntity)Basic.unmarshalXML(VideowallScreenEntity.class, (Object)byArray, (boolean)false);
                            switch (((VideowallScreenEntity)object).getMyVideowallType()) {
                                case "Barco": {
                                    l4 = 881L;
                                    break;
                                }
                                case "Eyevis": {
                                    l4 = 882L;
                                    break;
                                }
                                default: {
                                    l4 = 883L;
                                    break;
                                }
                            }
                        } else {
                            object = (VideowallScreenModuleEntity)Basic.unmarshalXML(VideowallScreenModuleEntity.class, (Object)byArray, (boolean)false);
                            switch (((VideowallScreenModuleEntity)object).getMyVideowallType()) {
                                case "Barco": {
                                    l4 = 891L;
                                    break;
                                }
                                case "Eyevis": {
                                    l4 = 892L;
                                    break;
                                }
                                default: {
                                    l4 = 893L;
                                }
                            }
                        }
                        de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set ETTID=" + l4 + ",syncID=seq_syncid.nextval where ETYID = " + l2);
                        continue;
                    }
                    catch (SeeTecException seeTecException) {
                        throw seeTecException;
                    }
                    catch (Exception exception) {
                        throw new SeeTecException(-20000, "Error upgrading configuration " + l2 + ",Type " + l3 + ": " + exception.getMessage());
                    }
                }
                this.logger.info("Entity '" + l2 + "',Type '" + l3 + "' has no configuration so keeping it untouched.");
            }
            return;
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC28(Connection connection) throws NullPointerException, SQLException, SeeTecException, SAXException, JAXBException, FileNotFoundException {
        if (this.coreCnfMgr.Q()) {
            List<EventType> list = Arrays.asList(EventType.ENT_EVENTTYPE_CYCLIC_BACKUP_FAILED, EventType.ENT_EVENTTYPE_DBLOAD_WARNING, EventType.MDB_EVENTTYPE_ZONE_ALMOST_FULL, EventType.GENERAL_EVENTTYPE_SERVERTIME_CHANGED, EventType.CM_EVENTTYPE_VIDEO_LOSS, EventType.CM_EVENTTYPE_TAMPERING, EventType.CM_EVENTTYPE_AVEXPORT_JOB_OLD, EventType.CM_EVENTTYPE_AVEXPORT_JOB_OLDER);
            Eventing eventing = this.getEventManagerEntity(connection);
            EmailListIDs emailListIDs = null;
            List list2 = eventing.getEventNotification().getEventNotifications().getEventNotificationDetail();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                EventNotificationDetail eventNotificationDetail = (EventNotificationDetail)iterator.next();
                if (list.contains(EventType.valueOf((Long)eventNotificationDetail.getEventType()))) {
                    eventNotificationDetail.setNotificationLevel(NotificationLevel.WARNING);
                } else if (eventNotificationDetail.getEventType() == EventType.ENT_EVENTTYPE_LICENCE_CHANGE_SUCCESSFUL.getType()) {
                    eventNotificationDetail.setNotificationLevel(NotificationLevel.INFO);
                } else {
                    if (eventNotificationDetail.getEventType() == 908L || eventNotificationDetail.getEventType() == 192L || eventNotificationDetail.getEventType() == 193L) {
                        iterator.remove();
                        continue;
                    }
                    eventNotificationDetail.setNotificationLevel(NotificationLevel.ERROR);
                }
                if (eventNotificationDetail.getEventType() != EventType.MDB_EVENTTYPE_NO_MORE_ZONE_SPACE.getType()) continue;
                emailListIDs = eventNotificationDetail.getEmailListIDs();
            }
            list2.add(new EventNotificationDetail(EventType.MDB_EVENTTYPE_ZONE_ALMOST_FULL.getType(), 3600000L, emailListIDs, false, true, null, null, null, null, NotificationLevel.WARNING, this.createDefaultAction(), null));
            this.logger.info(String.format("Added %s. Same eMailLists as %s.", EventType.MDB_EVENTTYPE_ZONE_ALMOST_FULL.getType(), EventType.MDB_EVENTTYPE_NO_MORE_ZONE_SPACE.getType()));
            this.writeEventManagerEntity(connection, eventing);
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC29(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        String string = null;
        if (this.coreCnfMgr.Q()) {
            int n2 = this.core.C(this.coreCnfMgr.Q());
            if (n2 != 0) {
                throw new SeeTecException(n2, "Error while initializing cnfMgrDBPart: " + n2);
            }
            string = this.core.\u00e1().F();
        }
        try {
            new gA(this.internalEntityRepository, this.coreCnfMgr.Q(), string, connection, this.cayugaIDGenerator);
        }
        catch (SeeTecException seeTecException) {
            throw new SeeTecException(-20076, "Error while doing user update. error: " + seeTecException.getMessage());
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC30(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (!de.seetec.v5.coreservice.server.F.C.B(connection, "COUNTING_TEMPLATES")) {
            String string = "CREATE TABLE COUNTING_TEMPLATES (" + "NAME VARCHAR(255) UNICODE NOT NULL, " + "CHANNEL_ID FIXED(38,0) NOT NULL, " + "RULE_ID FIXED(38,0) NOT NULL, " + "PERIOD VARCHAR(50) UNICODE, " + "NUMBER FIXED(10,0), " + "TIMEINTERVALL VARCHAR(50) UNICODE, " + "RESTRICTIONSIGN VARCHAR(5) UNICODE, " + "RESTRICTIONNUMBER VARCHAR(50) UNICODE, " + "RESTRICTIONNUMBERBETWEEN VARCHAR(50) UNICODE, " + "AVERAGE BOOLEAN, " + "INTERVALL FIXED(10,0), " + "COMBSIGN VARCHAR(5) UNICODE " + ")";
            try (Statement statement = connection.createStatement();){
                statement.execute(string);
                statement.execute("grant all on COUNTING_TEMPLATES to EntMgr");
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC31(Connection connection) throws NullPointerException, SQLException {
        this.createIndexIfNotExisting(connection, "LPR Events", "lpr_event_x1", "LPR_EVENT_DATA_00(LANE_ID)");
        this.createIndexIfNotExisting(connection, "LPR Events", "lpr_event_x2", "LPR_EVENT_DATA_00(A_TIME)");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC32(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (!de.seetec.v5.coreservice.server.F.C.B(connection, "COUNTING_EVENT_DATA")) {
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE TABLE COUNTING_EVENT_DATA (ROW_ID FIXED(38,0) DEFAULT SERIAL(1), DELTA FIXED(38,0), START_TIME FIXED(38,0), END_TIME FIXED(38,0), RULE_ID FIXED(38,0), CHANNEL_ID FIXED(38,0))");
                statement.execute("grant all on COUNTING_EVENT_DATA to EntMgr");
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC33(Connection connection) throws NullPointerException, SQLException {
        this.internalEntityRepository.A(10L, 0);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC34(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (!de.seetec.v5.coreservice.server.F.C.B(connection, "COUNTING_COMMAND_DATA")) {
            Statement statement = connection.createStatement();
            statement.execute("CREATE TABLE COUNTING_COMMAND_DATA(ROW_ID FIXED(38,0) DEFAULT SERIAL(1), CMD_TIME FIXED(38,0), USER_ID FIXED(38,0), RULE_ID FIXED(38,0), COMMAND FIXED(38,0))");
            statement.execute("grant all on COUNTING_COMMAND_DATA to EntMgr");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC35(Connection connection) throws NullPointerException, SQLException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "grant all on s_corelist to EntMgr");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void updateTo_6_0_0__RC36(Connection connection) throws NullPointerException, SQLException {
        List<String> list = Arrays.asList("lpr_associatedcams", F.C.A(), F.F.A(), F.E.A(), "CCR_EVENT_DATA_00");
        for (String string : list) {
            de.seetec.v5.coreservice.server.F.C.A(connection, String.format("grant all on %s to EntMgr", string));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC37(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.deleteDiscontinuedEntities(Arrays.asList(200504L, 200505L, 200506L, 201104L, 201105L, 201106L, 201107L, 200608L, 200609L), "hardware");
        }
    }

    @SuppressFBWarnings(value={"FORMAT_STRING_MANIPULATION"}, justification="Only hardcoded values.")
    private void deleteDiscontinuedEntities(List<Long> list, String string) throws SeeTecException {
        try {
            EntityDataObject[] entityDataObjectArray = this.internalEntityRepository.A(list, false);
            this.outputDiscontinuedList(entityDataObjectArray, string);
            for (EntityDataObject entityDataObject : entityDataObjectArray) {
                try {
                    this.internalEntityRepository.B(entityDataObject.getID());
                }
                catch (SeeTecException seeTecException) {
                    this.logger.error(String.format("Error while deleting discontinued " + string + " %s,'%s'", entityDataObject.getID(), entityDataObject.getName()));
                }
            }
        }
        catch (Exception exception) {
            throw new SeeTecException(-20076, "Error while removing discontinued " + string + ": " + exception.getMessage());
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC38(Connection connection) throws NullPointerException, SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("alter table lpr_associatedcams add syncID FIXED(38,0)");
            statement.execute("grant all on lpr_associatedcams to EntMgr");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_0__RC39(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.deleteDiscontinuedEntities(Arrays.asList(270305L), "Counting Premium devices");
        }
    }

    private void outputDiscontinuedList(EntityDataObject[] entityDataObjectArray, String string) {
        if (entityDataObjectArray.length > 0) {
            this.logger.info(entityDataObjectArray.length + " discontinued " + string + " found. They will be deleted:");
            for (EntityDataObject entityDataObject : entityDataObjectArray) {
                this.logger.info("       " + entityDataObject.toStringShortest());
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD", "SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void updateTo_6_0_1_RC1(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            List<Long> list = Arrays.asList(231L, 200081L, 230L, 232L, 234L, 2400L, 2600L, 270000L, 270300L, 270301L, 270302L, 270303L, 270304L, 220100L, 220101L, 220102L, 2202L, 881L, 882L, 883L);
            String string = KB.A(list, null);
            try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID,name,ettid from s_entity where (deleted = false) and (logicalparent = " + TreeTypes.LOGICALTREE.getRoot() + ")" + string);
                 ResultSet resultSet = preparedStatement.executeQuery();
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    long l2 = resultSet.getLong(1);
                    if (statement.executeUpdate("update s_entity set logicalParent=101,syncID=seq_syncid.nextval where etyid = " + l2) == 0) {
                        throw new SeeTecException(-20076, "Can't update entity.");
                    }
                    this.logger.info(String.format("Reordering device %s, '%s' of type %s.", l2, resultSet.getString(2), resultSet.getLong(3)));
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_1_RC2(Connection connection) throws NullPointerException, SQLException, SeeTecException, SAXException, JAXBException, FileNotFoundException {
        block26: {
            if (this.coreCnfMgr.Q()) {
                try (PreparedStatement preparedStatement = connection.prepareStatement(FETCH_EVENTMANAGER_ENTITY);
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        aA aA2 = new aA(this.internalEntityRepository, this.coreCnfMgr.Q(), this.entityEventUnmarshaller);
                        aA2.A(resultSet.getBytes(1));
                        aA2.A(new EventNotificationDetail(811L, 0L, this.createDefaultEmailListIDs(), false, true, null, null, null, null, NotificationLevel.ERROR, this.createDefaultAction(), null));
                        aA2.A(new EventNotificationDetail(812L, 0L, this.createDefaultEmailListIDs(), false, true, null, null, null, null, NotificationLevel.ERROR, this.createDefaultAction(), null));
                        aA2.A(new EventNotificationDetail(813L, 0L, this.createDefaultEmailListIDs(), false, true, null, null, null, null, NotificationLevel.INFO, this.createDefaultAction(), null));
                        this.writeEventManagerEntity(connection, aA2.\u00c4());
                        break block26;
                    }
                    throw new SeeTecException(-20076, "Can't update entity.");
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD", "SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    private void updateTo_6_0_1_RC3(Connection connection) throws NullPointerException, SQLException, SAXException, JAXBException, FileNotFoundException {
        if (this.coreCnfMgr.Q()) {
            EntityDataObject[] entityDataObjectArray;
            PreparedStatement preparedStatement = connection.prepareStatement("update s_entity set configuration=? where ETYID = ?");
            for (EntityDataObject entityDataObject : entityDataObjectArray = this.internalEntityRepository.A(Arrays.asList(73L), true)) {
                TourEntity tourEntity = null;
                try {
                    tourEntity = (TourEntity)Basic.unmarshalXML(TourEntity.class, (Object)entityDataObject.getConfiguration(), (boolean)true);
                }
                catch (Exception exception) {
                    this.logger.error("Error while reading config for '" + entityDataObject.getID() + "', '" + entityDataObject.getName() + "'.");
                }
                if (null == tourEntity) continue;
                for (TourTime tourTime : tourEntity.getTourTimes()) {
                    for (TourEntry tourEntry : tourTime.getTourDaysAndTimeOrTourEntry()) {
                        TourDaysAndTime tourDaysAndTime;
                        ArrayOfBoolean arrayOfBoolean;
                        if (!(tourEntry instanceof TourDaysAndTime) || (arrayOfBoolean = (tourDaysAndTime = (TourDaysAndTime)tourEntry).getDays()).getBoolean().size() > 7) continue;
                        arrayOfBoolean.getBoolean().add(arrayOfBoolean.getBoolean().get(6));
                        tourDaysAndTime.setDays(arrayOfBoolean);
                    }
                }
                String string = Basic.marshalXML((Object)tourEntity);
                preparedStatement.clearParameters();
                preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(string.getBytes()), string.getBytes().length);
                preparedStatement.setLong(2, entityDataObject.getID());
                preparedStatement.executeUpdate();
                Statement object2 = connection.createStatement();
                object2.executeUpdate(String.format("update s_entity set syncid=seq_syncid.nextval where ETYID = %s", entityDataObject.getID()));
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_1_RC4(Connection connection) throws NullPointerException, SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("alter table COUNTING_EVENT_DATA add CONSOLIDATION_DISABLE BOOLEAN DEFAULT FALSE");
            statement.executeUpdate("grant all on COUNTING_EVENT_DATA to EntMgr");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_1__RC5(Connection connection) throws NullPointerException, SQLException {
        this.dropIndexIfExisting(connection, "lpr_master_x1");
        this.createIndexIfNotExisting(connection, "LPR Master Data", "IDX_LPR_MASTER_X1", "LPR_MASTER_DATA_00(LP_TEXT)");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_2_RC1(Connection connection) throws NullPointerException, SQLException, SeeTecException, SAXException, JAXBException, FileNotFoundException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, new EventNotificationDetail(EventType.ENT_EVENTTYPE_SUB_UNREACHABLE.getType(), 0L, this.createDefaultEmailListIDs(), false, true, null, null, null, null, NotificationLevel.WARNING, this.createDefaultAction(), null));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_2_RC2(Connection connection) throws NullPointerException, SQLException {
        this.createIndexIfNotExisting(connection, "LPR Master Data", "lpr_master_x2", "LPR_MASTER_DATA_00(HISTORY)");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_0_3_RC1(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID from s_entity where ETYID = 1062");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) {
                    int n2 = KB.A(KB.A(connection, TreeTypes.LOGICALTREE.getRoot(), TreeTypes.LOGICALTREE));
                    de.seetec.v5.coreservice.server.F.C.C(connection, "insert into s_entity (ETYID,name,ETTID,active,MID,logicalparent,logicalorder,syncID) values (1062,'AlarmWatchDog',811,TRUE,10002,105," + n2 + ",seq_syncid.nextval)");
                    de.seetec.v5.coreservice.server.F.C.C(connection, "insert into s_entity (ETYID,name,ETTID,active,MID,logicalparent,logicalorder,syncID) values (1063,'AlarmWatchdogAction',9972,TRUE,10003,1062,0,seq_syncid.nextval)");
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_4_0_RC1(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID from s_entity where ETYID = 1064");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) {
                    de.seetec.v5.coreservice.server.F.C.C(connection, "insert into s_entity (ETYID,name,ETTID,active,MID,logicalparent,logicalorder,syncID) values (1064,'SNMPAction',9973,TRUE,10003,1055,0,seq_syncid.nextval)");
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_4_0_RC2(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            int n2 = KB.A(KB.A(connection, 105L, TreeTypes.LOGICALTREE));
            de.seetec.v5.coreservice.server.F.C.C(connection, "insert into s_entity (ETYID,name,ETTID,active,MID,logicalparent,logicalorder,syncID) values (1065,'BranchGroupRelation',48,TRUE,10002,105," + n2 + ",seq_syncid.nextval)");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_4_0_RC3(Connection connection) throws NullPointerException, SQLException, SeeTecException, SAXException, JAXBException, FileNotFoundException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, new EventNotificationDetail(EventType.MDB_EVENTTYPE_LAST_FULL_FRAME_IS_TOO_OLD.getType(), 3600000L, this.createDefaultEmailListIDs(), false, true, null, null, null, null, NotificationLevel.WARNING, this.createDefaultAction(), null));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_4_0_RC4(Connection connection) throws NullPointerException, SQLException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "ALTER TABLE LPR_MASTER_DATA_00 ADD TPID FIXED(38,0)");
        de.seetec.v5.coreservice.server.F.C.A(connection, "ALTER TABLE LPR_MASTER_DATA_00 ADD FCOLOR Integer");
        de.seetec.v5.coreservice.server.F.C.A(connection, "ALTER TABLE LPR_MASTER_DATA_00 ADD BCOLOR Integer");
        de.seetec.v5.coreservice.server.F.C.A(connection, "ALTER TABLE LPR_EVENT_DATA_00 ADD FCOLOR Integer");
        de.seetec.v5.coreservice.server.F.C.A(connection, "ALTER TABLE LPR_EVENT_DATA_00 ADD BCOLOR Integer");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_5_0_RC1(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.removeEventTypes(connection, new ArrayList<Long>(Arrays.asList(190L, 191L)));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_5_0_RC2(Connection connection) throws NullPointerException, SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select * from indexes where indexname = 'S_ENTITY_X'");
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                de.seetec.v5.coreservice.server.F.C.A(connection, "drop index s_entity_x on s_entity");
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_5_0_RC3(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            int n2 = KB.A(KB.A(connection, 105L, TreeTypes.LOGICALTREE));
            de.seetec.v5.coreservice.server.F.C.C(connection, "insert into s_entity (ETYID,name,ETTID,active,MID,logicalparent,logicalorder,syncID) values (1066,'ReportTemplates',49,TRUE,10002,105," + n2 + ",seq_syncid.nextval)");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_5_0_RC4(Connection connection) throws NullPointerException, SQLException, SeeTecException, Exception {
        if (this.coreCnfMgr.Q()) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID,name from s_entity where ETTID = 234");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                DigitalOutputHigh digitalOutputHigh = new DigitalOutputHigh();
                digitalOutputHigh.setHoldTime(0L);
                DigitalOutputLow digitalOutputLow = new DigitalOutputLow();
                digitalOutputLow.setHoldTime(0L);
                while (resultSet.next()) {
                    long l2 = resultSet.getLong(1);
                    this.logger.info(String.format("Updating SPC '%s' (%s).", resultSet.getString(2), KB.A(l2)));
                    int n2 = KB.A(KB.A(connection, l2, TreeTypes.PHYSICALTREE));
                    int n3 = KB.A(KB.A(connection, l2, TreeTypes.LOGICALTREE));
                    for (int i2 = 1; i2 < 9; ++i2) {
                        digitalOutputHigh.setOutputNumber(i2);
                        this.insertEntity(connection, "CLOSE: output" + i2, 9911L, Boolean.FALSE, 46L, l2, n2++, l2, n3++, Basic.marshalXMLToByteArray((Object)digitalOutputHigh));
                        digitalOutputLow.setOutputNumber(i2);
                        this.insertEntity(connection, "OPEN: output" + i2, 9912L, Boolean.FALSE, 47L, l2, n2++, l2, n3++, Basic.marshalXML((Object)digitalOutputLow).getBytes());
                    }
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_5_0_RC5(Connection connection) throws NullPointerException, SQLException, SeeTecException, Exception {
        if (this.coreCnfMgr.Q()) {
            this.updateRules(connection);
            this.updateArea(connection);
        }
    }

    private void updateRules(Connection connection) throws SeeTecException, SQLException, InterruptedException, SAXException, JAXBException, FileNotFoundException {
        byte[] byArray = Basic.marshalXMLToByteArray((Object)new de.seetec.v5.coreservice.configuration.action.emptyaction.Action("6.5.0"));
        try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID,name,active from s_entity where ETTID = 9885");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                if (!this.isUpdateNeeded(connection, resultSet.getLong(1))) continue;
                this.insertEntity(connection, "ActionSPCZoneInhibit", 9986L, resultSet.getBoolean(3), 3003L, resultSet.getLong(1), 0, resultSet.getLong(1), 0, byArray);
                this.insertEntity(connection, "ActionSPCZoneDeInhibit", 9987L, resultSet.getBoolean(3), 3003L, resultSet.getLong(1), 1, resultSet.getLong(1), 1, byArray);
                this.insertEntity(connection, "ActionSPCZoneIsolate", 9988L, resultSet.getBoolean(3), 3003L, resultSet.getLong(1), 2, resultSet.getLong(1), 2, byArray);
                this.insertEntity(connection, "ActionSPCZoneDeIsolate", 9989L, resultSet.getBoolean(3), 3003L, resultSet.getLong(1), 3, resultSet.getLong(1), 3, byArray);
                this.logger.info(String.format("SPC Rule '%s' (%s) updated.", resultSet.getString(2), KB.A(resultSet.getLong(1))));
            }
        }
    }

    private void updateArea(Connection connection) throws SeeTecException, SQLException, InterruptedException, SAXException, JAXBException, FileNotFoundException {
        byte[] byArray = Basic.marshalXMLToByteArray((Object)new de.seetec.v5.coreservice.configuration.action.emptyaction.Action("6.5.0"));
        try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID,name,active from s_entity where ETTID = 9815");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                if (!this.isUpdateNeeded(connection, resultSet.getLong(1))) continue;
                this.insertEntity(connection, "ActionSPCAreaArm", 9983L, resultSet.getBoolean(3), 3003L, resultSet.getLong(1), 0, resultSet.getLong(1), 0, byArray);
                this.insertEntity(connection, "ActionSPCAreaForceArm", 9984L, resultSet.getBoolean(3), 3003L, resultSet.getLong(1), 1, resultSet.getLong(1), 1, byArray);
                this.insertEntity(connection, "ActionSPCAreaDisArm", 9985L, resultSet.getBoolean(3), 3003L, resultSet.getLong(1), 2, resultSet.getLong(1), 2, byArray);
                this.logger.info(String.format("SPC Area '%s' (%s) updated.", resultSet.getString(2), KB.A(resultSet.getLong(1))));
            }
        }
    }

    private void insertEntity(Connection connection, String string, long l2, boolean bl, long l3, long l4, int n2, long l5, int n3, byte[] byArray) throws SQLException, SeeTecException, InterruptedException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("insert into s_entity (ETYID,name,ETTID,active,MID,physicalparent,physicalorder,logicalparent,logicalorder,configuration,syncID) values (?,?,?,?,?,?,?,?,?,?,seq_syncid.nextval)");){
            preparedStatement.setLong(1, this.cayugaIDGenerator.A());
            preparedStatement.setString(2, string);
            preparedStatement.setLong(3, l2);
            preparedStatement.setBoolean(4, bl);
            preparedStatement.setLong(5, l3);
            preparedStatement.setLong(6, l4);
            preparedStatement.setLong(7, n2);
            preparedStatement.setLong(8, l5);
            preparedStatement.setLong(9, n3);
            preparedStatement.setBinaryStream(10, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
            if (preparedStatement.executeUpdate() == 0) {
                throw new SeeTecException(-20076, "Can't update entity.");
            }
        }
    }

    private boolean isUpdateNeeded(Connection connection, long l2) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select count(ETYID) from s_entity where logicalParent = " + l2);){
            ResultSet resultSet = preparedStatement.executeQuery();
            boolean bl = !resultSet.next() || resultSet.getLong(1) == 0L;
            return bl;
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_5_0_RC6(Connection connection) throws NullPointerException, SQLException, SeeTecException, Exception {
        if (this.coreCnfMgr.Q()) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID,name from s_entity where deleted = false and ETTID = 234");
                 ResultSet resultSet = preparedStatement.executeQuery();
                 PreparedStatement preparedStatement2 = connection.prepareStatement("insert into s_entity (ETYID,name,ETTID,active,MID,physicalparent,physicalorder,logicalparent,logicalorder,configuration,syncID) values (?,'ActionSPCResetAllAlarms',9982,true,3003,?,?,?,?,?,seq_syncid.nextval)");){
                byte[] byArray = Basic.marshalXMLToByteArray((Object)new de.seetec.v5.coreservice.configuration.action.emptyaction.Action("6.5.0"));
                while (resultSet.next()) {
                    long l2 = resultSet.getLong(1);
                    if (!connection.createStatement().executeQuery("select count(*) from s_entity where ETTID = 9982 AND logicalparent = " + l2 + "  having (count(*) = 0)").next()) continue;
                    this.logger.info(String.format("Updating SPC '%s' (%s).", resultSet.getString(2), KB.A(l2)));
                    int n2 = KB.A(KB.A(connection, l2, TreeTypes.PHYSICALTREE));
                    int n3 = KB.A(KB.A(connection, l2, TreeTypes.LOGICALTREE));
                    preparedStatement2.setLong(1, this.cayugaIDGenerator.A());
                    preparedStatement2.setLong(2, l2);
                    preparedStatement2.setLong(3, n2);
                    preparedStatement2.setLong(4, l2);
                    preparedStatement2.setLong(5, n3);
                    preparedStatement2.setBinaryStream(6, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                    if (preparedStatement2.executeUpdate() != 0) continue;
                    throw new SeeTecException(-20076, "Can't update entity.");
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_6_0_RC1(Connection connection) throws NullPointerException, SQLException {
        this.createIndexIfNotExisting(connection, "syncID", "s_entity_x2", "s_entity(syncid)");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_6_0_RC2(Connection connection) throws NullPointerException, SQLException, SeeTecException, SAXException, JAXBException, FileNotFoundException {
        if (this.coreCnfMgr.Q()) {
            Eventing eventing = this.getEventManagerEntity(connection);
            if (eventing.getNotificationPrefix() == null) {
                eventing.setNotificationPrefix("[SeeTec Cayuga]");
            }
            this.writeEventManagerEntity(connection, eventing);
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_6_0_RC3(Connection connection) throws NullPointerException, SQLException, SeeTecException, NoSuchAlgorithmException {
        if (this.coreCnfMgr.Q() && this.coreCnfMgr.M() != null && this.coreCnfMgr.M() == Variant.ONSSI) {
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("select name from s_entity where ETYID = 1001");){
                Object object;
                if (resultSet.next() && resultSet.getString(1).equalsIgnoreCase("administrator")) {
                    int n2;
                    if (statement.executeUpdate("update s_entity set name = 'admin',syncID=seq_syncid.nextval where ETYID = 1001") == 1) {
                        this.logger.info("Administrator account adapted.");
                    }
                    if ((n2 = this.core.C(this.coreCnfMgr.Q())) != 0) {
                        throw new SeeTecException(n2, "Error while initializing cnfMgrDBPart: " + n2);
                    }
                    object = this.core.\u00e1().F() + "admin";
                    object = MessageDigestGenerator.getSHA512Digest((String)object);
                    try (PreparedStatement preparedStatement = connection.prepareStatement("update s_password set Pass=?,Pass2=null,syncID=seq_syncid.nextval where ETYID=1001");){
                        preparedStatement.setString(1, (String)object);
                        if (preparedStatement.executeUpdate() == 1) {
                            this.logger.info("Administrator account's password adapted.");
                        }
                    }
                }
                try {
                    object = this.getEventManagerEntity(connection);
                    if (object.getNotificationPrefix() != null && object.getNotificationPrefix().equals("[SeeTec Cayuga]")) {
                        object.setNotificationPrefix("[Ocularis Recorder]");
                    }
                    this.writeEventManagerEntity(connection, (Eventing)object);
                }
                catch (Exception exception) {
                    throw new SeeTecException(-20076, "Error while updating eventing configuration: " + exception.getMessage());
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_6_0_RC4(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        block42: {
            if (this.coreCnfMgr.Q() && this.coreCnfMgr.M() != null && this.coreCnfMgr.M() == Variant.ONSSI) {
                try (PreparedStatement preparedStatement = connection.prepareStatement("select configuration from s_entity where ETYID = 1052");
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        try (PreparedStatement preparedStatement2 = connection.prepareStatement("update s_entity set configuration=? where ETYID = 1052");){
                            SMTPServerInfo sMTPServerInfo = (SMTPServerInfo)Basic.unmarshalXML(SMTPServerInfo.class, (Object)resultSet.getBytes(1));
                            sMTPServerInfo.setSender("");
                            String string = Basic.marshalXML((Object)sMTPServerInfo);
                            preparedStatement2.setBinaryStream(1, (InputStream)new ByteArrayInputStream(string.getBytes()), string.getBytes().length);
                            if (preparedStatement2.executeUpdate() == 0) {
                                throw new SeeTecException(-20076, "Error while updating eventing configuration.");
                            }
                            de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set syncID=seq_syncid.nextval where ETYID = 1052");
                            break block42;
                        }
                        catch (SeeTecException seeTecException) {
                            throw seeTecException;
                        }
                        catch (Exception exception) {
                            throw new SeeTecException(-20076, "Error while updating eventing configuration: " + exception.getMessage());
                        }
                    }
                    throw new SeeTecException(-20076, "Entity not existing.");
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_7_0_RC1(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            int n2 = KB.A(KB.A(connection, 105L, TreeTypes.LOGICALTREE));
            de.seetec.v5.coreservice.server.F.C.C(connection, "insert into s_entity (ETYID,name,ETTID,active,MID,logicalparent,logicalorder,syncID) values (1067,'CustomMedia',61,TRUE,10058,105," + n2 + ",seq_syncid.nextval)");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_7_0_RC2(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.removeEventTypes(connection, new ArrayList<Long>(Arrays.asList(801L, 804L)));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_7_0_RC3(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q() && this.coreCnfMgr.M() != null && this.coreCnfMgr.M() == Variant.ONSSI) {
            de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set name = (select name from s_entity where ETYID = 1001),syncid = seq_syncid.nextval where etyid = 1000");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_7_0_RC4(Connection connection) throws NullPointerException, SQLException, SeeTecException, SAXException, JAXBException, FileNotFoundException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, this.setDefaultEventNotificationDetail(EventType.ENT_EVENTTYPE_CANNOT_WRITE_SUMMARY_FILE));
            this.addEventTypes(connection, this.setDefaultEventNotificationDetail(EventType.ENT_EVENTTYPE_CANNOT_WRITE_ALARM_FILE));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_7_0_RC5(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, this.setDefaultEventNotificationDetail(EventType.GENERAL_EVENTTYPE_VCA_VIDEO_LOST));
            this.addEventTypes(connection, this.setNotificationDetail(3600000L, NotificationLevel.INFO, EventType.GENERAL_EVENTTYPE_VCA_VIDEO_GAIN));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_8_0_RC1(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.removeEventTypes(connection, new ArrayList<Long>(Arrays.asList(909L)));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_9_0_RC1(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, this.setDefaultEventNotificationDetail(EventType.GENERAL_EVENTTYPE_VA_3RDParty_COMMUNICATION_LOST));
            this.addEventTypes(connection, this.setNotificationDetail(3600000L, NotificationLevel.INFO, EventType.GENERAL_EVENTTYPE_VA_3RDParty_COMMUNICATION_GAIN));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6_9_0_RC2(Connection connection) throws NullPointerException, SQLException {
        this.createIndexIfNotExisting(connection, "entity", "s_entity_x3", "s_entity(physicalparent)");
        this.createIndexIfNotExisting(connection, "entity", "s_entity_x4", "s_entity(logicalparent)");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__11_0_RC1(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.INFO, EventType.GENERAL_EVENTTYPE_RE_START));
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.WARNING, EventType.GENERAL_EVENTTYPE_RE_STOP));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__12_0_RC1(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.WARNING, EventType.MDB_EVENTTYPE_STATISTICS_LIMITED_STATUS));
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.ERROR, EventType.MDB_EVENTTYPE_STATISTICS_ERROR_STATUS));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__13_0_RC1(Connection connection) throws NullPointerException, SQLException, SeeTecException, Exception {
        if (this.coreCnfMgr.Q()) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID from s_entity where deleted = false and ETTID = 105");
                 ResultSet resultSet = preparedStatement.executeQuery();
                 PreparedStatement preparedStatement2 = connection.prepareStatement("insert into s_entity (ETYID,name,ETTID,active,MID,physicalparent,physicalorder,logicalparent,logicalorder,configuration,syncID) values (?, 'Video Data Export',9992,true,13001,?,-1,?,-1,?,seq_syncid.nextval)");){
                byte[] byArray = Basic.marshalXMLToByteArray((Object)new de.seetec.v5.coreservice.configuration.action.emptyaction.Action("6.13.0"));
                while (resultSet.next()) {
                    long l2 = resultSet.getLong(1);
                    preparedStatement2.setLong(1, this.cayugaIDGenerator.A());
                    preparedStatement2.setLong(2, l2);
                    preparedStatement2.setLong(3, l2);
                    preparedStatement2.setBinaryStream(4, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                    if (preparedStatement2.executeUpdate() != 0) continue;
                    throw new SeeTecException(-20076, "Can't update entity.");
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__13_0_RC2(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.INFO, EventType.MDB_EVENTTYPE_BACKUP_STARTED));
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.INFO, EventType.MDB_EVENTTYPE_BACKUP_COMPLETED));
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.WARNING, EventType.MDB_EVENTTYPE_BACKUP_INTERRUPTED));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__14_0_RC1(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.removeEventTypes(connection, new ArrayList<Long>(Arrays.asList(907L)));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__14_0_RC2(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        if (this.coreCnfMgr.Q()) {
            byte[] byArray = this.getBranchGroupRelationFromDatabase(connection);
            if (byArray != null && byArray.length > 0) {
                long l2;
                A a2 = new A();
                BranchGroupRelation branchGroupRelation = a2.A(byArray);
                C c2 = new C(branchGroupRelation, this.cayugaIDGenerator);
                a2.B(branchGroupRelation, c2.A());
                for (BranchGroupRelationGroupEntry map2 : branchGroupRelation.getGroupEntries().getBranchGroupRelationGroupEntry()) {
                    l2 = this.adaptLogicalToPhysicalParent(map2.getParentGroupID());
                    this.insertBranchgroupIntoDatabase(connection, map2.getGroupID(), map2.getName(), map2.getParentGroupID(), l2, map2.getIndex());
                }
                for (BranchGroupRelationBranchEntry branchGroupRelationBranchEntry : branchGroupRelation.getBranchEntries().getBranchGroupRelationBranchEntry()) {
                    l2 = this.adaptLogicalToPhysicalParent(branchGroupRelationBranchEntry.getGroupID());
                    this.updateBranchInDatabase(connection, branchGroupRelationBranchEntry.getBranchID(), branchGroupRelationBranchEntry.getGroupID(), l2, branchGroupRelationBranchEntry.getIndex());
                }
                B b2 = new B();
                Map<Long, User> map = this.getConfigurationsForAllEntitiesOfType(connection, User.class, 41L);
                for (Map.Entry<Long, User> entry : map.entrySet()) {
                    if (!b2.A(entry.getValue().getRights(), c2)) continue;
                    this.updateConfiguration(connection, (Long)entry.getKey(), entry.getValue());
                }
                Map<Long, Group> map2 = this.getConfigurationsForAllEntitiesOfType(connection, Group.class, 43L);
                for (Map.Entry entry : map2.entrySet()) {
                    if (!b2.A(((Group)entry.getValue()).getRights(), c2)) continue;
                    this.updateConfiguration(connection, (Long)entry.getKey(), entry.getValue());
                }
            }
            this.setBranchGroupRelationToDeleted(connection);
        }
    }

    private byte[] getBranchGroupRelationFromDatabase(Connection connection) throws SQLException, SeeTecException {
        Throwable throwable = null;
        try (PreparedStatement preparedStatement = connection.prepareStatement("select configuration from s_entity where ETYID = 1065");){
            Throwable throwable2;
            ResultSet resultSet;
            block25: {
                byte[] byArray;
                block26: {
                    block27: {
                        resultSet = preparedStatement.executeQuery();
                        throwable2 = null;
                        if (!resultSet.next()) break block25;
                        Blob blob = resultSet.getBlob(1);
                        byte[] byArray2 = byArray = blob == null ? null : blob.getBytes(1L, (int)blob.length());
                        if (resultSet == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    resultSet.close();
                }
                return byArray;
            }
            try {
                try {
                    try {
                        throw new SeeTecException(-20061, "No BranchGroupRelation found in database.");
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (resultSet != null) {
                        if (throwable2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    protected <T> Map<Long, T> getConfigurationsForAllEntitiesOfType(Connection connection, Class<T> clazz, Long l2) throws SQLException, SAXException, JAXBException {
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        String string = "select ETYID, CONFIGURATION from S_ENTITY WHERE ETTID=? AND DELETED=false";
        try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setLong(1, l2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l3 = resultSet.getLong(1);
                Blob blob = resultSet.getBlob(2);
                byte[] byArray = blob.getBytes(1L, (int)blob.length());
                hashMap.put(l3, Basic.unmarshalXML(clazz, (Object)byArray));
            }
        }
        return hashMap;
    }

    private void setBranchGroupRelationToDeleted(Connection connection) throws SQLException, SeeTecException, NullPointerException {
        de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set deleted = TRUE where ETYID = 1065");
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING", "SQL_INJECTION_JDBC"})
    private void insertBranchgroupIntoDatabase(Connection connection, long l2, String string, long l3, long l4, long l5) throws NullPointerException, SQLException, SeeTecException {
        String string2 = "<?xml version=\"1.0\"?>\r\n<HeavyweightEntity xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n<Version>6.14.0</Version>\r\n</HeavyweightEntity>";
        int n2 = Integer.MIN_VALUE;
        String string3 = "insert into s_entity (ETYID,name,ETTID,active,MID,logicalparent,logicalorder,physicalparent,physicalorder,configuration) values (?,?,?,TRUE,12,?,?,?,?,?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement(string3);){
            preparedStatement.setLong(1, l2);
            preparedStatement.setString(2, string);
            preparedStatement.setLong(3, 3013L);
            preparedStatement.setLong(4, l3);
            preparedStatement.setLong(5, l5);
            preparedStatement.setLong(6, l4);
            preparedStatement.setLong(7, l5);
            preparedStatement.setBinaryStream(8, (InputStream)new ByteArrayInputStream("<?xml version=\"1.0\"?>\r\n<HeavyweightEntity xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n<Version>6.14.0</Version>\r\n</HeavyweightEntity>".getBytes()), n2);
            preparedStatement.execute();
        }
    }

    private void updateBranchInDatabase(Connection connection, long l2, long l3, long l4, long l5) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("update s_entity set logicalparent = ?, physicalparent = ?, logicalorder = ?, physicalorder = ? where ETYID = ?");){
            preparedStatement.setLong(1, l3);
            preparedStatement.setLong(2, l4);
            preparedStatement.setLong(3, l5);
            preparedStatement.setLong(4, l5);
            preparedStatement.setLong(5, l2);
            preparedStatement.execute();
        }
    }

    private <T> void updateConfiguration(Connection connection, long l2, T t2) throws SQLException, JAXBException, SAXException, FileNotFoundException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("update s_entity set configuration = ? where ETYID = ?");){
            preparedStatement.setBytes(1, Basic.marshalXMLToByteArray(t2));
            preparedStatement.setLong(2, l2);
            preparedStatement.execute();
        }
    }

    protected long adaptLogicalToPhysicalParent(long l2) {
        return l2 == 0L ? 1L : l2;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__14_0_RC3(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "drop table CCR_EVENT_DATA_00");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__14_0_RC4(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "drop table diag");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__14_0_RC5(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "drop user entmgr");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__14_0_RC6(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set deleted=true,syncID=seq_syncid.nextval where ETTID in (791,9971)");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__14_0_RC7(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.INFO, EventType.CM_EVENTTYPE_EDGESTORAGE_IMPORT_SUCCESSFUL));
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.WARNING, EventType.CM_EVENTTYPE_EDGESTORAGE_IMPORT_INTERRUPTED));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__15_0_RC1(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.removeEventTypes(connection, new ArrayList<Long>(Arrays.asList(150L)));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__15_0_RC2(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.removeEventTypes(connection, new ArrayList<Long>(Arrays.asList(802L)));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__15_0_RC3(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.removeEventTypes(connection, new ArrayList<Long>(Arrays.asList(807L)));
        }
    }

    private EventNotificationGroup createEventNotificationGroup(EventTypes eventTypes, String string, int n2) {
        EventNotificationGroup eventNotificationGroup = new EventNotificationGroup();
        eventNotificationGroup.setEventTypes(eventTypes);
        eventNotificationGroup.setName(string);
        eventNotificationGroup.setEventGroupType(n2);
        return eventNotificationGroup;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__15_0_RC4(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            Eventing eventing = this.getEventManagerEntity(connection);
            eventing.getEventNotification().setEventNotificationGroups(new EventNotificationGroups());
            EventNotificationGroup eventNotificationGroup = this.createEventNotificationGroup(new EventTypes(Arrays.asList(EventType.ENT_EVENTTYPE_LICENCE_CHANGE_UNSUCCESSFUL.getType(), EventType.ENT_EVENTTYPE_LICENCE_CHANGE_SUCCESSFUL.getType())), "License Changes", 1000);
            eventing.getEventNotification().getEventNotificationGroups().getEventNotificationGroup().add(eventNotificationGroup);
            eventNotificationGroup = this.createEventNotificationGroup(new EventTypes(Arrays.asList(EventType.MDB_EVENTTYPE_BACKUP_STARTED.getType(), EventType.MDB_EVENTTYPE_BACKUP_INTERRUPTED.getType(), EventType.MDB_EVENTTYPE_BACKUP_COMPLETED.getType())), "Automated Video Backup", 1001);
            eventing.getEventNotification().getEventNotificationGroups().getEventNotificationGroup().add(eventNotificationGroup);
            eventNotificationGroup = this.createEventNotificationGroup(new EventTypes(Arrays.asList(EventType.ENT_EVENTTYPE_SUB_UNREACHABLE.getType(), EventType.ENT_EVENTTYPE_SUB_REACHABLE_AGAIN.getType())), "Core Sub Connection", 1002);
            eventing.getEventNotification().getEventNotificationGroups().getEventNotificationGroup().add(eventNotificationGroup);
            eventNotificationGroup = this.createEventNotificationGroup(new EventTypes(Arrays.asList(EventType.GENERAL_EVENTTYPE_VCA_BAD_SIGNAL.getType(), EventType.GENERAL_EVENTTYPE_VCA_VIEW_UNKNOWN.getType(), EventType.GENERAL_EVENTTYPE_VCA_VIEW_RESTORED.getType())), "Analytics Channel Video", 1003);
            eventing.getEventNotification().getEventNotificationGroups().getEventNotificationGroup().add(eventNotificationGroup);
            eventNotificationGroup = this.createEventNotificationGroup(new EventTypes(Arrays.asList(EventType.GENERAL_EVENTTYPE_VCA_VIDEO_LOST.getType(), EventType.GENERAL_EVENTTYPE_VCA_VIDEO_GAIN.getType())), "Versatile Application Video", 1004);
            eventing.getEventNotification().getEventNotificationGroups().getEventNotificationGroup().add(eventNotificationGroup);
            eventNotificationGroup = this.createEventNotificationGroup(new EventTypes(Arrays.asList(EventType.GENERAL_EVENTTYPE_VA_3RDParty_COMMUNICATION_LOST.getType(), EventType.GENERAL_EVENTTYPE_VA_3RDParty_COMMUNICATION_GAIN.getType())), "Third Party Communication", 1005);
            eventing.getEventNotification().getEventNotificationGroups().getEventNotificationGroup().add(eventNotificationGroup);
            eventNotificationGroup = this.createEventNotificationGroup(new EventTypes(Arrays.asList(EventType.CM_EVENTTYPE_EDGESTORAGE_IMPORT_INTERRUPTED.getType(), EventType.CM_EVENTTYPE_EDGESTORAGE_IMPORT_SUCCESSFUL.getType())), "Edge Storage Import", 1006);
            eventing.getEventNotification().getEventNotificationGroups().getEventNotificationGroup().add(eventNotificationGroup);
            this.writeEventManagerEntity(connection, eventing);
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__15_0_RC5(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            Eventing eventing = this.getEventManagerEntity(connection);
            EventNotificationGroup eventNotificationGroup = this.createEventNotificationGroup(new EventTypes(Arrays.asList(EventType.MDB_EVENTTYPE_ZONE_ALMOST_FULL.getType(), EventType.MDB_EVENTTYPE_NO_MORE_ZONE_SPACE.getType())), "Zone fill level", 1007);
            eventing.getEventNotification().getEventNotificationGroups().getEventNotificationGroup().add(eventNotificationGroup);
            eventNotificationGroup = this.createEventNotificationGroup(new EventTypes(Arrays.asList(EventType.ENT_EVENTTYPE_DBLOAD_WARNING.getType(), EventType.ENT_EVENTTYPE_DBLOAD_EMERGENCY_SHUTDOWN.getType())), "Configuration and event database fill level", 1008);
            eventing.getEventNotification().getEventNotificationGroups().getEventNotificationGroup().add(eventNotificationGroup);
            this.writeEventManagerEntity(connection, eventing);
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__15_0_RC6(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.removeEventTypes(connection, new ArrayList<Long>(Arrays.asList(805L)));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__15_0_RC7(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            int n2 = KB.A(KB.A(connection, 105L, TreeTypes.LOGICALTREE));
            de.seetec.v5.coreservice.server.F.C.C(connection, "insert into s_entity (ETYID,name,ETTID,active,MID,logicalparent,logicalorder,syncID) values (1068,'SecuritySettings',62,TRUE,10070,105," + n2 + ",seq_syncid.nextval)");
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__15_0_RC8(Connection connection) throws NullPointerException, SQLException, SeeTecException {
        block42: {
            if (this.coreCnfMgr.Q()) {
                try (PreparedStatement preparedStatement = connection.prepareStatement("select configuration from s_entity where ETYID = 1055");
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        try (PreparedStatement preparedStatement2 = connection.prepareStatement("update s_entity set configuration=? where ETYID = 1055");){
                            SNMPServerInfo sNMPServerInfo = (SNMPServerInfo)Basic.unmarshalXML(SNMPServerInfo.class, (Object)resultSet.getBytes(1));
                            sNMPServerInfo.setEnterpriseOID("1.3.6.1.4.1.23151");
                            sNMPServerInfo.setApplicationTrapOID(null);
                            String string = Basic.marshalXML((Object)sNMPServerInfo);
                            preparedStatement2.setBinaryStream(1, (InputStream)new ByteArrayInputStream(string.getBytes()), string.getBytes().length);
                            if (preparedStatement2.executeUpdate() == 0) {
                                throw new SeeTecException(-20076, "Error while updating configuration.");
                            }
                            de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set syncID=seq_syncid.nextval where ETYID = 1055");
                            break block42;
                        }
                        catch (SeeTecException seeTecException) {
                            throw seeTecException;
                        }
                        catch (Exception exception) {
                            throw new SeeTecException(-20076, "Error while updating configuration: " + exception.getMessage());
                        }
                    }
                    throw new SeeTecException(-20076, "Entity not existing.");
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6__15_0_RC9(Connection connection) throws NullPointerException, SQLException, FileNotFoundException, JAXBException, SAXException, SeeTecException {
        if (this.coreCnfMgr.Q()) {
            this.removeEventTypes(connection, new ArrayList<Long>(Arrays.asList(903L)));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___15_0_RC10(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.INFO, EventType.ENT_EVENTTYPE_SUB_REACHABLE_AGAIN));
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___15_0_RC11(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.INFO, EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM_SOLVED));
            Eventing eventing = this.getEventManagerEntity(connection);
            EventNotificationGroup eventNotificationGroup = this.createEventNotificationGroup(new EventTypes(Arrays.asList(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM.getType(), EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM_SOLVED.getType())), "Device connectivity", 1009);
            eventing.getEventNotification().getEventNotificationGroups().getEventNotificationGroup().add(eventNotificationGroup);
            this.writeEventManagerEntity(connection, eventing);
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___15_0_RC12(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        if (this.coreCnfMgr.Q()) {
            String string = "<?xml version=\"1.0\"?>\r\n<AdvancedMapElementList xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n<Version>6.15.0</Version>\r\n</AdvancedMapElementList>";
            int n2 = Integer.MIN_VALUE;
            String string2 = "insert into s_entity (ETYID,name,ETTID,active,MID,logicalparent,logicalorder,physicalparent,physicalorder,configuration) values (1069,?,?,TRUE,28,?,-1,-1,-1,?)";
            try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                preparedStatement.setString(1, "AdvancedMapElementList");
                preparedStatement.setLong(2, 82L);
                preparedStatement.setLong(3, 105L);
                preparedStatement.setBinaryStream(4, (InputStream)new ByteArrayInputStream("<?xml version=\"1.0\"?>\r\n<AdvancedMapElementList xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n<Version>6.15.0</Version>\r\n</AdvancedMapElementList>".getBytes()), n2);
                preparedStatement.execute();
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___15_0_RC13(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "alter table s_entity add description varchar(1000)");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___15_0_RC14(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, UnsupportedEncodingException {
        if (this.coreCnfMgr.Q()) {
            long l2 = System.currentTimeMillis();
            try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID,ETTID,configuration from s_entity where ETTID in (70,41,43) and deleted = false");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                int n2 = 0;
                int n3 = 0;
                while (resultSet.next()) {
                    String string;
                    Object object;
                    ++n3;
                    if (resultSet.getLong(2) == 70L) {
                        object = (Alarm)Basic.unmarshalXML(Alarm.class, (Object)new String(resultSet.getBytes(3), "UTF-8"));
                        string = ((Alarm)object).getDescription();
                        if (string == null) continue;
                        ((Alarm)object).setDescription(null);
                        this.updateConfigurationAndDescription(connection, resultSet.getLong(1), Basic.marshalXML((Object)object), string);
                        ++n2;
                        continue;
                    }
                    if (resultSet.getLong(2) == 41L) {
                        object = (User)Basic.unmarshalXML(User.class, (Object)new String(resultSet.getBytes(3), "UTF-8"));
                        string = ((User)object).getDescription();
                        if (string == null) continue;
                        ((User)object).setDescription(null);
                        this.updateConfigurationAndDescription(connection, resultSet.getLong(1), Basic.marshalXML((Object)object), string);
                        ++n2;
                        continue;
                    }
                    if (resultSet.getLong(2) != 43L || (string = ((Group)(object = (Group)Basic.unmarshalXML(Group.class, (Object)new String(resultSet.getBytes(3), "UTF-8")))).getDescription()) == null) continue;
                    ((Group)object).setDescription(null);
                    this.updateConfigurationAndDescription(connection, resultSet.getLong(1), Basic.marshalXML((Object)object), string);
                    ++n2;
                }
                this.logger.info("Migrated " + n2 + " descriptions from " + n3 + " entities in [ms]: " + (System.currentTimeMillis() - l2));
            }
        }
    }

    private void updateConfigurationAndDescription(Connection connection, long l2, String string, String string2) throws SeeTecException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("update s_entity set configuration=?,description=? where ETYID = ?");){
            preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(string.getBytes()), string.getBytes().length);
            preparedStatement.setString(2, string2);
            preparedStatement.setLong(3, l2);
            if (preparedStatement.executeUpdate() == 0) {
                throw new SeeTecException(-20076, "Error while updating configuration.");
            }
            de.seetec.v5.coreservice.server.F.C.C(connection, "update s_entity set syncID=seq_syncid.nextval where ETYID = " + l2);
        }
        catch (SeeTecException seeTecException) {
            throw seeTecException;
        }
        catch (Exception exception) {
            throw new SeeTecException(-20076, "Error while updating configuration: " + exception.getMessage());
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___15_0_RC15(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        if (this.coreCnfMgr.Q()) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("select ETYID,name from s_entity where ETTID in (3012) and deleted = false");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    EntityDataObject entityDataObject = new EntityDataObject(this.cayugaIDGenerator.A(), resultSet.getString(2) + "_companycalendars", 3014L, 1051L, true, null, null, null, Long.MIN_VALUE, Long.MIN_VALUE, resultSet.getLong(1), -1L);
                    if (this.internalEntityRepository.A(entityDataObject) != 0) {
                        throw new SeeTecException(-20000, "Can't add new folder.");
                    }
                    if (entityDataObject.getLogicalParent() != TreeTypes.LOGICALTREE.getRoot()) continue;
                    EntityDataObject entityDataObject2 = this.internalEntityRepository.A(1051L, false);
                    entityDataObject2.setLogicalParent(entityDataObject.getID());
                    this.internalEntityRepository.A(entityDataObject2);
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___15_0_RC16(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        if (this.coreCnfMgr.Q()) {
            for (EntityDataObject entityDataObject : this.internalEntityRepository.A(Arrays.asList(60L), true)) {
                TimePattern timePattern = (TimePattern)Basic.unmarshalXML(TimePattern.class, (Object)entityDataObject.getConfiguration(), (boolean)false);
                de.seetec.v5.shared.configuration.timepattern.CalendarIds calendarIds = new de.seetec.v5.shared.configuration.timepattern.CalendarIds();
                calendarIds.getLong().add(1051L);
                timePattern.setCalendarIds(calendarIds);
                entityDataObject.setConfiguration(Basic.marshalXML((Object)timePattern).getBytes());
                if (this.internalEntityRepository.A(entityDataObject) == 0) continue;
                throw new SeeTecException(-20000, "Can't update timepattern: " + entityDataObject.getName());
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___15_0_RC17(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        if (this.coreCnfMgr.Q()) {
            CalendarIds calendarIds = new CalendarIds();
            calendarIds.getLong().add(1051L);
            for (EntityDataObject entityDataObject : this.internalEntityRepository.A(Arrays.asList(73L), true)) {
                TourEntity tourEntity = (TourEntity)Basic.unmarshalXML(TourEntity.class, (Object)entityDataObject.getConfiguration(), (boolean)false);
                tourEntity.getTourTimes().stream().forEach(tourTime -> tourTime.getTourDaysAndTimeOrTourEntry().stream().filter(tourEntry -> tourEntry instanceof TourDaysAndTime).forEach(tourEntry -> ((TourDaysAndTime)tourEntry).setCalendarIds(calendarIds)));
                entityDataObject.setConfiguration(Basic.marshalXML((Object)tourEntity).getBytes());
                if (this.internalEntityRepository.A(entityDataObject) == 0) continue;
                throw new SeeTecException(-20000, "Can't update timepattern: " + entityDataObject.getName());
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___16_0_RC1(Connection connection) throws JAXBException, SAXException, SeeTecException, FileNotFoundException {
        if (this.coreCnfMgr.Q()) {
            int n2 = 44000;
            for (EntityDataObject entityDataObject : this.internalEntityRepository.A(Arrays.asList(883L), true)) {
                this.updatePortForDisplayAgent(entityDataObject, 44000);
            }
            for (EntityDataObject entityDataObject : this.internalEntityRepository.A(Arrays.asList(893L), true)) {
                this.updatePortForDisplayAgentModule(entityDataObject, 44000);
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___16_0_RC2(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        if (this.coreCnfMgr.Q()) {
            for (EntityDataObject entityDataObject : this.internalEntityRepository.A(Arrays.asList(270300L, 270302L, 270303L, 270304L), false)) {
                this.internalEntityRepository.B(entityDataObject.getID());
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___16_0_RC3(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        if (this.coreCnfMgr.Q()) {
            for (EntityDataObject entityDataObject : this.internalEntityRepository.A(Arrays.asList(107L), false)) {
                this.internalEntityRepository.B(entityDataObject.getID());
            }
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___17_0_RC1(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "drop table COUNTING_EVENT_DATA");
        de.seetec.v5.coreservice.server.F.C.A(connection, "drop table COUNTING_COMMAND_DATA");
        de.seetec.v5.coreservice.server.F.C.A(connection, "drop table COUNTING_TEMPLATES");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___17_0_RC2(Connection connection) throws NullPointerException, SQLException, JAXBException, SAXException, SeeTecException, FileNotFoundException, InterruptedException {
        de.seetec.v5.coreservice.server.F.C.A(connection, "alter table s_entity modify (description VARCHAR(1000) UNICODE)");
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___17_0_RC3(Connection connection) throws SeeTecException, SAXException, JAXBException, FileNotFoundException {
        EntityExistingStatus entityExistingStatus;
        if (this.coreCnfMgr.Q() && (entityExistingStatus = this.core.\u00ea().A(116L)) == EntityExistingStatus.NONEXISTING) {
            EntityDataObject entityDataObject = new EntityDataObject(116L, "AlarmClassifications", 26L);
            entityDataObject.setMediaID(14001L);
            entityDataObject.setLogicalParent(105L);
            entityDataObject.setLogicalOrder(-1L);
            entityDataObject.setConfiguration(Basic.marshalXMLToByteArray((Object)this.createDefaultClassifications()));
            if (this.internalEntityRepository.A(entityDataObject) != 0) {
                throw new SeeTecException(-20000, "Can't create singelton Entity for AlarmClassifications.");
            }
        }
    }

    private AlarmClassifications createDefaultClassifications() {
        AlarmClassifications alarmClassifications = new AlarmClassifications();
        long l2 = 1L;
        Classifications classifications = new Classifications();
        classifications.getAlarmClassification().add(this.createAlarmClassification(l2++, "False"));
        classifications.getAlarmClassification().add(this.createAlarmClassification(l2++, "Nuisance"));
        classifications.getAlarmClassification().add(this.createAlarmClassification(l2++, "Technical Malfunction"));
        classifications.getAlarmClassification().add(this.createAlarmClassification(l2++, "Incident"));
        alarmClassifications.setClassifications(classifications);
        alarmClassifications.setNextID(l2);
        return alarmClassifications;
    }

    private AlarmClassification createAlarmClassification(long l2, String string) {
        AlarmClassification alarmClassification = new AlarmClassification();
        alarmClassification.setID(l2);
        alarmClassification.setName(string);
        return alarmClassification;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_6___18_0_RC1(Connection connection) throws SeeTecException, SAXException, JAXBException, FileNotFoundException, SQLException {
        if (this.coreCnfMgr.Q()) {
            this.addEventTypes(connection, this.setDisabledDefaultEventNotificationDetail(NotificationLevel.WARNING, EventType.USER_DEACTIVATED_AFTER_FAILED_LOGIN_ATTEMPT));
            Eventing eventing = this.getEventManagerEntity(connection);
            EventNotificationGroup eventNotificationGroup = this.createEventNotificationGroup(new EventTypes(Arrays.asList(EventType.USER_DEACTIVATED_AFTER_FAILED_LOGIN_ATTEMPT.getType())), "Failed login attempts", 1010);
            eventing.getEventNotification().getEventNotificationGroups().getEventNotificationGroup().add(eventNotificationGroup);
            this.writeEventManagerEntity(connection, eventing);
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_7_1_0_RC1(Connection connection) throws SeeTecException, SAXException, JAXBException, FileNotFoundException, SQLException {
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_7_1_0_RC2(Connection connection) throws NullPointerException, SeeTecException, SAXException, JAXBException, FileNotFoundException, SQLException {
        Eventing eventing;
        if (this.coreCnfMgr.Q() && this.updateEventManagerEntityNotificationPrefix(eventing = this.getEventManagerEntity(connection))) {
            this.writeEventManagerEntity(connection, eventing);
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_7_1_0_RC3(Connection connection) throws NullPointerException, SeeTecException, SAXException, JAXBException, FileNotFoundException {
        if (this.coreCnfMgr.Q()) {
            EntityDataObject entityDataObject = this.internalEntityRepository.A(1052L, true);
            if (entityDataObject != null) {
                SMTPServerInfo sMTPServerInfo = (SMTPServerInfo)Basic.unmarshalXML(SMTPServerInfo.class, (Object)entityDataObject.getConfiguration());
                if (this.updateSmtpServerInfoEntitySender(sMTPServerInfo)) {
                    entityDataObject.setConfiguration(Basic.marshalXMLToByteArray((Object)sMTPServerInfo));
                    this.internalEntityRepository.A(entityDataObject);
                }
            } else {
                this.logger.warn("updateTo_7_1_0_RC3: SMTPServerInfo does not exist, returning");
            }
        }
    }

    protected boolean updateEventManagerEntityNotificationPrefix(Eventing eventing) {
        if (eventing.getNotificationPrefix() != null && eventing.getNotificationPrefix().equals("[SeeTec Cayuga]")) {
            eventing.setNotificationPrefix("[Qognify VMS]");
            return true;
        }
        return false;
    }

    protected boolean updateSmtpServerInfoEntitySender(SMTPServerInfo sMTPServerInfo) {
        if (sMTPServerInfo.getSender() != null && sMTPServerInfo.getSender().equals("systeminfo@seetec.de")) {
            sMTPServerInfo.setSender("systeminfo@qognify.com");
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by reflection!")
    private void updateTo_7_1_0_RC4(Connection connection) throws NullPointerException, SeeTecException, SAXException, JAXBException, FileNotFoundException {
        if (this.coreCnfMgr.Q()) {
            for (EntityDataObject entityDataObject : this.internalEntityRepository.A(Arrays.asList(201892L, 201892L, 201893L, 201894L, 201895L, 201896L, 201897L, 201898L, 201899L), false)) {
                this.internalEntityRepository.B(entityDataObject.getID());
            }
        }
    }
}

