/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.coreservice.connector;

import de.seetec.v5.coreservice.B.N;
import de.seetec.v5.coreservice.connector.B;
import de.seetec.v5.coreservice.connector.CoreConnectorImpl;
import de.seetec.v5.coreservice.connector.E;
import de.seetec.v5.coreservice.connector.G;
import de.seetec.v5.coreservice.server.JA;
import de.seetec.v5.shared.interaction.EntityDataObject;
import de.seetec.v5.shared.interaction.KeyDataObject;
import de.seetec.v5.shared.interaction.ValueDataObject;
import de.seetec.v5.shared.networking.srpc.DefaultRequestHandlerFactoryImpl;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerFactoryIntf;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerIntf;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.Socket;

public class SSLSRPCConnector
extends G
implements B {
    protected CoreConnectorImpl K;

    @Override
    public void init(Socket socket, JA jA2) {
        this.K = new CoreConnectorImpl(jA2);
        super.A(socket, jA2, (SrpcRequestHandlerFactoryIntf)new DefaultRequestHandlerFactoryImpl((SrpcRequestHandlerIntf)this));
    }

    @Override
    protected void A(SrpcMessage srpcMessage) {
        GObject gObject = srpcMessage.getPayload();
        try {
            switch (Methods.valueOf((int)srpcMessage.getHash())) {
                case PING: {
                    this.K.ping(srpcMessage.getId());
                    break;
                }
                case ENT_FUNCTION_GET_SALT: {
                    this.K.getSalt(srpcMessage.getId());
                    break;
                }
                case SSL_FUNCTION_GET_ENCRYPTION_KEY: {
                    this.A(srpcMessage, 2);
                    String string = null;
                    if (gObject.getChildren().size() > 2) {
                        string = gObject.getChildAt(2).tryGetAsString();
                    }
                    this.K.getEncryptionKey(gObject.getChildAt(0).tryGetAsString(), gObject.getChildAt(1).getAsString(), string, srpcMessage.getId());
                    break;
                }
                case IS_SINGLE_SIGN_ON_AUTHORIZED: {
                    this.A(srpcMessage, 3);
                    this.K.isSingleSignOnAuthorized(gObject.getChildAt(0).getAsString(), gObject.getChildAt(1).getAsString(), gObject.getChildAt(2).getAsArrayOfByte(), srpcMessage.getId());
                    break;
                }
                default: {
                    this.onError(srpcMessage, -50001);
                    break;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.F.error((Object)nullPointerException, (Throwable)nullPointerException);
            this.onError(srpcMessage, -20003);
        }
        catch (SeeTecException seeTecException) {
            this.F.error((Object)seeTecException, (Throwable)seeTecException);
            this.onError(srpcMessage, seeTecException.getErrorCode());
        }
        catch (Exception exception) {
            this.F.error((Object)exception, (Throwable)exception);
            this.onError(srpcMessage, -20204);
        }
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Our middle ware can't check type safety so we ignore this hint here explicitly.")
    protected SrpcMessage A(N n2) {
        SrpcMessage srpcMessage = null;
        E e2 = this.A(n2.G());
        if (null == e2) {
            return null;
        }
        int n3 = n2.A().getErrorCode();
        if (n3 != 0) {
            SrpcMessage srpcMessage2 = SrpcMessage.createResponse((SrpcMessage)e2.C(), null);
            srpcMessage2.setError(n3);
            return srpcMessage2;
        }
        switch (Methods.valueOf((int)e2.C().getHash())) {
            case PING: {
                EntityDataObject entityDataObject = (EntityDataObject)n2.A();
                srpcMessage = this.K.onPing(entityDataObject.getID(), entityDataObject.getName(), entityDataObject.getType(), entityDataObject.getServerTime(), entityDataObject.getExtent(), e2);
                break;
            }
            case ENT_FUNCTION_GET_SALT: {
                srpcMessage = this.K.onGetSalt(n3, (String)((ValueDataObject)n2.A()).getValue(), e2);
                break;
            }
            case SSL_FUNCTION_GET_ENCRYPTION_KEY: {
                KeyDataObject keyDataObject = (KeyDataObject)n2.A();
                srpcMessage = this.K.onGetEncryptionKey(keyDataObject.getEncryptionMethod(), keyDataObject.getKey(), keyDataObject.getToken(), e2);
                break;
            }
            case IS_SINGLE_SIGN_ON_AUTHORIZED: {
                KeyDataObject keyDataObject = (KeyDataObject)n2.A();
                srpcMessage = this.K.onIsSingleSignOnAuthorized(keyDataObject.getEncryptionMethod(), keyDataObject.getKey(), keyDataObject.getSingleSignOnToken(), keyDataObject.getToken(), e2);
                break;
            }
            default: {
                this.onError(e2.C(), -50001);
            }
        }
        if (srpcMessage != null) {
            srpcMessage.setEncryption((byte)0);
        }
        return srpcMessage;
    }

    @Override
    public void onError(SrpcMessage srpcMessage, int n2) {
        if (null != srpcMessage) {
            this.F.warn(String.format("Error in message [%s] : %s", srpcMessage.getId(), n2));
            SrpcMessage srpcMessage2 = SrpcMessage.createResponse((SrpcMessage)srpcMessage, null);
            srpcMessage2.setError(n2);
            this.C(srpcMessage2);
        }
    }
}

