/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.ShutdownCallback;
import de.seetec.v5.shared.networking.srpc.SrpcClientIntf;
import de.seetec.v5.shared.networking.srpc.SrpcContext;
import de.seetec.v5.shared.networking.srpc.SrpcContextImpl;
import de.seetec.v5.shared.networking.srpc.SrpcFuture;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerFactoryIntf;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerIntf;
import de.seetec.v5.shared.networking.srpc.SrpcStatistics;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpcTcp
implements SrpcClientIntf {
    private static final List<Methods> DEBUG_METHS = Collections.emptyList();
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    private static final ExecutorService COMMONTHREADPOOL = Executors.newCachedThreadPool(new NamedThreadFactory("SrpcTcp"));
    private static WriterWatchdog WRITER_WATCHDOG = WriterWatchdog.getInstance();
    private static AtomicLong INSTANCE_COUNTER = new AtomicLong(0L);
    private static AtomicLong DEBUG_ID_SOURCE = new AtomicLong(0L);
    private final long DEBUG_ID = DEBUG_ID_SOURCE.incrementAndGet();
    private static Logger logger = LogManager.getLogger(SrpcTcp.class);
    private static final long TIMEOUT = 1L;
    private static final int MAX_SO_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final long CONNECTION_IDLE_TIMEOUT_NANOS = TimeUnit.HOURS.toNanos(1L);
    private static final long SEND_CUMULATION_TIME_MILLIES = 50L;
    private volatile AtomicLong lastActive = new AtomicLong(System.nanoTime());
    private List<ShutdownCallback> shutdownListeners = new ArrayList<ShutdownCallback>();
    private byte[] version = new byte[]{3, 0, 0};
    private Socket mySocket;
    private final BlockingQueue<SrpcContext> sendQ;
    private final Map<UUID, SrpcContext> pending;
    private final SrpcRequestHandlerFactoryIntf reqHandlerFactory;
    private volatile long ENTITY = 0L;
    private MyReader reader;
    private MyWriter writer;
    private AtomicBoolean isInShutdown = new AtomicBoolean(false);
    private AtomicBoolean isInStartup = new AtomicBoolean(true);
    private RequestHandlerCallback requestCallback = new RequestHandlerCallback(){

        @Override
        public void onRequestHandled(SrpcMessage request, SrpcMessage result) {
            SrpcTcp.this.sendQ.offer(SrpcContextImpl.get(result, Long.MAX_VALUE));
        }
    };
    private volatile AtomicBoolean closedByPeerCalled = new AtomicBoolean(false);
    private AtomicLong lastZombieKillerRun = new AtomicLong(System.nanoTime());
    private AtomicBoolean zombieKillerActive = new AtomicBoolean(false);

    public static long ActiveConnections() {
        return INSTANCE_COUNTER.get();
    }

    public void registerShutdownListener(ShutdownCallback l) {
        this.shutdownListeners.add(l);
    }

    SrpcTcp(Socket aSocket, SrpcRequestHandlerFactoryIntf aFactory, boolean isOutgoing, Long aEntity) {
        INSTANCE_COUNTER.incrementAndGet();
        if (null == aSocket) {
            throw new IllegalArgumentException("Argument 'Socket' must not be null!");
        }
        if (null == aFactory) {
            throw new IllegalArgumentException("Argument 'Factory' must not be null!");
        }
        if (null != aEntity) {
            this.ENTITY = aEntity;
        }
        this.reqHandlerFactory = aFactory;
        this.mySocket = aSocket;
        try {
            int oldSoTimeout = this.mySocket.getSoTimeout();
            if (oldSoTimeout > MAX_SO_TIMEOUT || oldSoTimeout <= 0) {
                this.mySocket.setSoTimeout(MAX_SO_TIMEOUT);
            }
            this.mySocket.setSendBufferSize(262144);
            this.mySocket.setReceiveBufferSize(262144);
            if (this.mySocket.getInetAddress().isLoopbackAddress()) {
                this.mySocket.setTcpNoDelay(true);
            }
            if (logger.isDebugEnabled()) {
                logger.info("New SRPC connection via " + this.mySocket + ". TcpNoDelay=[" + this.mySocket.getTcpNoDelay() + "], ReceiveBufferSize=[" + (this.mySocket.getReceiveBufferSize() >> 10) + " KB], SendBufferSize=[" + (this.mySocket.getSendBufferSize() >> 10) + " KB]");
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        try {
            if (isOutgoing) {
                this.setupAndCheckConnection(this.mySocket);
            }
        }
        catch (IOException ex) {
            logger.fatal("Socket failed on setup: " + ex.getMessage());
        }
        this.sendQ = new LinkedBlockingQueue<SrpcContext>();
        this.pending = new ConcurrentHashMap<UUID, SrpcContext>();
        this.reader = new MyReader();
        COMMONTHREADPOOL.execute(this.reader);
        this.writer = new MyWriter();
        COMMONTHREADPOOL.execute(this.writer);
        this.isInStartup.set(false);
    }

    private boolean setupAndCheckConnection(Socket aSocket) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(64);
        bb.put(SSLConstantsIntf.SSL_SRPC_TCP_HEADER);
        bb.putLong(this.ENTITY);
        byte[] srpcHeader = bb.array();
        aSocket.getOutputStream().write(srpcHeader);
        return true;
    }

    @Override
    public void shutdown() {
        if (this.isInShutdown.compareAndSet(false, true)) {
            COMMONTHREADPOOL.submit(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName(String.format("SRPC [%s] SHUTDOWN EXECUTOR [%s]", SrpcTcp.this.DEBUG_ID, SDF.format(System.currentTimeMillis())));
                    if (SrpcTcp.this.writer != null) {
                        try {
                            SrpcTcp.this.writer.interruptWritingIfItTookAlreadyLongerThan(5L, TimeUnit.MINUTES);
                            SrpcTcp.this.writer.shutdown();
                        }
                        catch (Throwable t) {
                            logger.error("Problem while shutting down writer: ", t);
                        }
                        SrpcTcp.this.writer = null;
                    }
                    if (SrpcTcp.this.reader != null && !Thread.currentThread().isInterrupted()) {
                        try {
                            SrpcTcp.this.reader.shutdown();
                        }
                        catch (Throwable t) {
                            logger.error("Problem while shutting down reader: ", t);
                        }
                        SrpcTcp.this.reader = null;
                    }
                    try {
                        if (null != SrpcTcp.this.mySocket) {
                            SrpcTcp.this.mySocket.close();
                        }
                    }
                    catch (Throwable t) {
                        logger.warn("Closing socket:", t);
                    }
                    INSTANCE_COUNTER.decrementAndGet();
                    Thread.currentThread().setName(String.format("Idle pool Thread. [%s]", SDF.format(System.currentTimeMillis())));
                }
            });
            this.invokeShutdownCallbacks();
        }
    }

    private void invokeShutdownCallbacks() {
        ExecutorService shutdownPool = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private volatile int cnt = 0;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "SrpcTcpShutdownCallbackRunner-" + this.cnt++);
            }
        });
        if (!this.shutdownListeners.isEmpty()) {
            for (ShutdownCallback sci : this.shutdownListeners) {
                try {
                    shutdownPool.execute(new ShutdownCallbackRunnable(sci));
                }
                catch (IllegalArgumentException iae) {
                    logger.warn((Object)iae);
                }
            }
            try {
                shutdownPool.shutdown();
                if (!shutdownPool.awaitTermination(1L, TimeUnit.MINUTES)) {
                    logger.warn(String.format("%s -  SrpcTcpShutdownCallbacks did not finish in time!", this.DEBUG_ID));
                }
            }
            catch (InterruptedException ex) {
                logger.debug((Object)ex, (Throwable)ex);
            }
        }
    }

    private boolean isStartup() {
        return this.isInStartup.get();
    }

    @Override
    public boolean isShutdown() {
        return this.isInShutdown.get();
    }

    @Override
    public boolean isReady() {
        boolean bReady = true;
        bReady = bReady && !this.isShutdown();
        bReady = bReady && !this.isStartup();
        bReady = bReady && null != this.mySocket && !this.mySocket.isClosed();
        return bReady;
    }

    @Override
    public SrpcFuture sendAsync(SrpcMessage msg) {
        return this.sendAsync(msg, Long.MAX_VALUE);
    }

    private SrpcFuture sendAsync(SrpcMessage msg, long timeout) {
        SrpcContext context = SrpcContextImpl.get(msg, timeout);
        if (this.isShutdown()) {
            SrpcFuture exFuture = context.getFuture();
            exFuture.except(new SeeTecException(-20219, "SRPC connection has been closed."));
            return exFuture;
        }
        if (null == msg) {
            throw new IllegalArgumentException("Cannot send null");
        }
        if (!this.sendQ.offer(context)) {
            logger.error("[" + this.mySocket.getLocalPort() + "] Could not enqueue request. [" + msg.getMethodName() + "] " + msg.getId());
        }
        return context.getFuture();
    }

    @Override
    public SrpcMessage send(SrpcMessage msg) throws InterruptedException, ExecutionException {
        SrpcFuture stf = this.sendAsync(msg);
        if (null != stf) {
            return stf.get();
        }
        logger.fatal("Got no Future!");
        throw new ExecutionException(new SeeTecException(-1, "Future was NULL!"));
    }

    @Override
    public SrpcMessage send(SrpcMessage msg, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        SrpcFuture stf = this.sendAsync(msg, timeout);
        if (null != stf) {
            return stf.get(timeout, TimeUnit.MILLISECONDS);
        }
        logger.fatal("Got no Future!");
        throw new ExecutionException(new SeeTecException(-1, "Future was NULL!"));
    }

    @Override
    public void sendFireAndForget(SrpcMessage msg) {
        if (this.isShutdown()) {
            throw new RuntimeException(new SeeTecException(-20219, "Already shutting down."));
        }
        msg.setFireAndForget(true);
        try {
            this.sendAsync(msg);
        }
        catch (Exception ex) {
            logger.warn(String.format("Error while sending Fire and Forget message [%s] id [%s]: %s", msg.getMethodName(), msg.getId(), ex.getMessage()));
        }
    }

    private SrpcContext popPendingContext(UUID id) {
        return this.pending.remove(id);
    }

    private void putPendingContext(SrpcContext ctx) {
        if (ctx.getTimeout() > System.nanoTime() + TimeUnit.HOURS.toNanos(1L)) {
            logger.warn(String.format("Very long timeout: [%s]ms for [%s]", TimeUnit.NANOSECONDS.toMillis(ctx.getTimeout() - System.nanoTime()), ctx.getMessage().getMethodName()));
        }
        this.pending.put(ctx.getMessage().getId(), ctx);
    }

    private void purgeAllPending(String reason) {
        ConcurrentModificationException cme = null;
        do {
            try {
                Iterator<Map.Entry<UUID, SrpcContext>> itr = this.pending.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry<UUID, SrpcContext> entry = itr.next();
                    itr.remove();
                    entry.getValue().getFuture().except(new RuntimeException(reason));
                }
            }
            catch (ConcurrentModificationException ex) {
                cme = ex;
            }
        } while (cme != null);
    }

    private void closedByPeer() {
        if (this.closedByPeerCalled.compareAndSet(false, true)) {
            try {
                if (this.mySocket == null || this.mySocket.isClosed()) {
                    this.purgeAllPending("Connection closed.");
                    this.pending.clear();
                    this.sendQ.clear();
                }
            }
            catch (NullPointerException npe) {
                this.purgeAllPending("Connection closed.");
                this.pending.clear();
                this.sendQ.clear();
            }
            this.shutdown();
        }
    }

    public String toString() {
        return String.format("%s [%s]", super.toString(), this.mySocket);
    }

    @Override
    public byte[] getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(byte[] version) {
        this.version = version;
    }

    private static class WriterWatchdog
    implements Runnable {
        private static final long SLEEP_TIME = 5000L;
        private final Map<MyWriter, Long> list = Collections.synchronizedMap(new WeakHashMap());
        private WeakReference<Thread> myThread;

        public static WriterWatchdog getInstance() {
            WriterWatchdog instance = new WriterWatchdog();
            Thread t = new Thread((Runnable)instance, "Srpc WriterWatchdog");
            t.setDaemon(true);
            t.start();
            instance.myThread = new WeakReference<Thread>(t);
            return instance;
        }

        private WriterWatchdog() {
        }

        public void register(MyWriter writer, long timeout, TimeUnit unit) {
            if (null == writer) {
                return;
            }
            if (timeout < 0L) {
                this.list.remove(writer);
            } else {
                this.list.put(writer, unit.toMillis(timeout));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.myThread != null && this.myThread.get() != null && !((Thread)this.myThread.get()).isInterrupted()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    break;
                }
                try {
                    Map<MyWriter, Long> ex = this.list;
                    synchronized (ex) {
                        Iterator<Map.Entry<MyWriter, Long>> itr = this.list.entrySet().iterator();
                        while (itr.hasNext()) {
                            Map.Entry<MyWriter, Long> item = itr.next();
                            if (item.getKey().interruptWritingIfItTookAlreadyLongerThan(item.getValue(), TimeUnit.MILLISECONDS)) continue;
                            itr.remove();
                        }
                    }
                }
                catch (Throwable t) {
                    logger.debug("Exception in WriterWatchdog ", t);
                }
            }
        }
    }

    private class ZombieKiller
    implements Runnable {
        private ZombieKiller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.currentThread().setName("ZombieKiller " + SrpcTcp.this.DEBUG_ID + ": " + SrpcTcp.this.mySocket);
                if (!SrpcTcp.this.zombieKillerActive.compareAndSet(false, true)) {
                    return;
                }
                long runCheck = System.nanoTime() - SrpcTcp.this.lastZombieKillerRun.get();
                if (runCheck < TimeUnit.MINUTES.toNanos(1L)) {
                    return;
                }
                SrpcTcp.this.lastZombieKillerRun.set(System.nanoTime());
                if (null == SrpcTcp.this.pending || SrpcTcp.this.pending.isEmpty()) {
                    return;
                }
                long ref = System.nanoTime();
                try {
                    Iterator itr = SrpcTcp.this.pending.entrySet().iterator();
                    long veryLongTimeout = ref + TimeUnit.HOURS.toNanos(1L);
                    while (itr.hasNext()) {
                        long timeout;
                        Map.Entry entry = itr.next();
                        long l = timeout = entry.getValue() == null ? 0L : ((SrpcContext)entry.getValue()).getTimeout();
                        if (timeout > veryLongTimeout && SrpcTcp.this.isShutdown()) {
                            itr.remove();
                            ((SrpcContext)entry.getValue()).getFuture().except(new TimeoutException("Shutting down."));
                            logger.info(String.format("ZombieKiller %s : Removed %s: very long timeout and in shutdown.", SrpcTcp.this.DEBUG_ID, ((SrpcContext)entry.getValue()).getMessage().getMethodName()));
                            continue;
                        }
                        if (null == entry.getValue() || timeout < ref) {
                            itr.remove();
                            ((SrpcContext)entry.getValue()).getFuture().except(new TimeoutException("No response in time."));
                            logger.info(String.format("ZombieKiller %s : Removed [%s] (%s): timeout.", SrpcTcp.this.DEBUG_ID, ((SrpcContext)entry.getValue()).getMessage().getMethodName(), ((SrpcContext)entry.getValue()).getMessage().getId()));
                        }
                        if (!SrpcTcp.this.isShutdown() && !Thread.currentThread().isInterrupted()) continue;
                        break;
                    }
                }
                catch (ConcurrentModificationException cme) {
                    logger.error((Object)cme, (Throwable)cme);
                }
                if (null == SrpcTcp.this.mySocket || SrpcTcp.this.mySocket.isClosed()) {
                    SrpcTcp.this.closedByPeer();
                }
            }
            catch (Throwable t) {
                logger.error("While killing srpc context zombies: ", t);
            }
            finally {
                Thread.currentThread().setName("ENDED " + Thread.currentThread().getName());
                SrpcTcp.this.zombieKillerActive.set(false);
            }
        }
    }

    private class MyWriter
    implements Runnable {
        private volatile AtomicBoolean runFlag = new AtomicBoolean(true);
        private Thread myThread = null;
        private OutputStream os = null;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private StringBuilder msgs = new StringBuilder();
        private long lastSendNanos = Long.MIN_VALUE;
        private final long overrideBufferingTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(50L);
        private final int bufferThreshold = 1500;
        private volatile CountDownLatch finalCountdown = new CountDownLatch(1);
        private volatile CountDownLatch startUp = new CountDownLatch(1);
        private long tsStarted = System.nanoTime();
        private static final int socketExPenaltyStartVal = 1;
        private final AtomicInteger socketExPenalty = new AtomicInteger(1);
        private final AtomicLong lastWriteStart = new AtomicLong(-1L);

        private MyWriter() {
        }

        private void reset() {
            SrpcTcp.this.pending.clear();
            SrpcTcp.this.sendQ.clear();
            this.buffer.reset();
        }

        private boolean keepThreadAlive() {
            try {
                if (SrpcTcp.this.mySocket == null || SrpcTcp.this.mySocket.isClosed()) {
                    return false;
                }
            }
            catch (NullPointerException npe) {
                return false;
            }
            return this.runFlag.get() || !SrpcTcp.this.pending.isEmpty() || !SrpcTcp.this.sendQ.isEmpty() || this.buffer.size() != 0;
        }

        public void shutdown() {
            if (!this.runFlag.compareAndSet(true, false)) {
                return;
            }
            try {
                this.startUp.await();
                if (null != this.myThread && !this.finalCountdown.await(45L, TimeUnit.SECONDS)) {
                    logger.warn("==== Waited for Writer " + SrpcTcp.this.DEBUG_ID + " to shutdown: TIMEOUT! (after) 45 " + TimeUnit.SECONDS.toString() + " " + SrpcTcp.this.mySocket);
                    this.myThread.interrupt();
                }
            }
            catch (InterruptedException ie) {
                logger.error((Object)ie, (Throwable)ie);
            }
            finally {
                this.myThread = null;
            }
        }

        @Override
        public void run() {
            this.myThread = Thread.currentThread();
            this.myThread.setName("WRITER " + SrpcTcp.this.DEBUG_ID + " : " + SrpcTcp.this.mySocket);
            this.startUp.countDown();
            this.tsStarted = System.nanoTime();
            int keepAliveRuns = 0;
            block17: while (!Thread.currentThread().isInterrupted() && this.keepThreadAlive()) {
                SrpcContext ctx;
                if (SrpcTcp.this.isShutdown() && ++keepAliveRuns % 50 == 0) {
                    new ZombieKiller().run();
                    if (this.myThread != null) {
                        this.myThread.setName("WRITER " + SrpcTcp.this.DEBUG_ID + " : " + SrpcTcp.this.mySocket);
                    }
                }
                try {
                    ctx = (SrpcContext)SrpcTcp.this.sendQ.poll(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                if (null != ctx) {
                    SrpcTcp.this.lastActive.set(System.nanoTime());
                    switch (ctx.getMessage().getType()) {
                        case 0: {
                            try {
                                this.processRequest(ctx);
                            }
                            catch (SocketException sox) {
                                if (!SrpcTcp.this.isInShutdown.get()) {
                                    logger.warn("[REQ  ] Unexpected SocketException! " + sox.getMessage());
                                }
                                this.reset();
                            }
                            catch (IOException ioe) {
                                if (!SrpcTcp.this.isInShutdown.get()) {
                                    logger.warn("Unexpected IO Exception! " + ioe.getMessage());
                                    SrpcTcp.this.closedByPeer();
                                }
                                this.reset();
                            }
                            catch (Exception e) {
                                if (!SrpcTcp.this.isInShutdown.get()) {
                                    logger.warn("Unexpected Exception! " + e.getMessage());
                                }
                                this.reset();
                            }
                            continue block17;
                        }
                        case 1: {
                            try {
                                if (null != ctx.getMessage() && DEBUG_METHS.contains((Object)Methods.valueOf(ctx.getMessage().getHash()))) {
                                    logger.info(String.format("[SRPC DEBUG] SRPC [%s] [send] Resp[%s] [%s] [err %s] [enc %s] [zip %s] [payload %s] %s", SrpcTcp.this.DEBUG_ID, ctx.getMessage().getId(), ctx.getMessage().getMethodName(), ctx.getMessage().getError(), ctx.getMessage().getEncryption() != 0, ctx.getMessage().getCompression() != 0, ctx.getMessage().getPayload() == null ? "null" : ctx.getMessage().getPayload().toExtendedString(), SrpcTcp.this.mySocket));
                                }
                                this.tcpSend(ctx.getMessage());
                            }
                            catch (SocketException sox) {
                                if (!SrpcTcp.this.isInShutdown.get()) {
                                    logger.warn("[RSP  ] Unexpected SocketException! " + sox.getMessage());
                                }
                                this.reset();
                            }
                            catch (IOException ioe) {
                                if (!SrpcTcp.this.isInShutdown.get()) {
                                    logger.warn("Unexpected IO Exception! " + ioe.getMessage());
                                    SrpcTcp.this.closedByPeer();
                                }
                                this.reset();
                            }
                            continue block17;
                        }
                    }
                    try {
                        this.tcpSend(ctx.getMessage());
                    }
                    catch (IOException ioe) {
                        if (!SrpcTcp.this.isInShutdown.get()) {
                            logger.warn("Unexpected IO Exception! " + ioe.getMessage());
                        }
                        this.reset();
                    }
                    continue;
                }
                try {
                    this.flush();
                }
                catch (IOException e) {
                    if (!SrpcTcp.this.isInShutdown.get()) {
                        SrpcTcp.this.closedByPeer();
                    }
                    this.reset();
                    break;
                }
            }
            this.finalCountdown.countDown();
            Thread.currentThread().setName("DEAD " + Thread.currentThread().getName());
        }

        private void processRequest(SrpcContext ctx) throws Exception {
            try {
                if (ctx.getMessage().isFireAndForget()) {
                    ctx.getFuture().done(SrpcMessage.nullResponse(ctx.getMessage()));
                } else {
                    SrpcTcp.this.putPendingContext(ctx);
                }
                if (null != ctx.getMessage() && DEBUG_METHS.contains((Object)Methods.valueOf(ctx.getMessage().getHash()))) {
                    logger.info(String.format("[SRPC DEBUG] SRPC [%s] [send] Requ[%s] [%s] size[%s] [enc %s] [zip %s] %s", SrpcTcp.this.DEBUG_ID, ctx.getMessage().getId(), ctx.getMessage().getMethodName(), ctx.getMessage().getPayload() == null ? "0" : Integer.valueOf(ctx.getMessage().getPayload().size()), ctx.getMessage().getEncryption() != 0, ctx.getMessage().getCompression() != 0, SrpcTcp.this.mySocket));
                }
                this.tcpSend(ctx.getMessage());
            }
            catch (IOException ex) {
                ctx.getFuture().except(new SeeTecException(-20219, "Connection closed."));
                throw ex;
            }
            catch (Exception ex) {
                ctx.getFuture().except(ex);
                throw ex;
            }
        }

        private void tcpSend(SrpcMessage msg) throws IOException {
            block13: {
                try {
                    if (null == this.os) {
                        this.os = new BufferedOutputStream(SrpcTcp.this.mySocket.getOutputStream());
                    }
                    if (null != msg) {
                        long serializationStart = System.nanoTime();
                        byte[] serialized = msg.serialize();
                        if (DEBUG_METHS.contains((Object)Methods.valueOf(msg.getHash()))) {
                            logger.info(String.format("[SRPC DEBUG] SRPC [%s] MSG [%s] serialized in [%s ms] (MsgID [%s])", SrpcTcp.this.DEBUG_ID, msg.getMethodName(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - serializationStart), msg.getId()));
                        }
                        this.buffer.write(serialized);
                        this.msgs.append(msg.getId()).append(", ");
                        if (SrpcStatistics.isActivated()) {
                            try {
                                SrpcStatistics.addOutgoingMessage(SrpcTcp.this.mySocket.getInetAddress().getHostAddress(), msg.getMethodName(), serialized.length);
                            }
                            catch (Throwable t) {
                                logger.warn("While adding statistical info: ", t);
                            }
                        }
                    }
                    if (null == msg || this.buffer.size() > 1500 || this.lastSendNanos + this.overrideBufferingTimeoutNanos - System.nanoTime() < 0L || SrpcTcp.this.sendQ.isEmpty() || SrpcTcp.this.isInShutdown.get()) {
                        if (this.buffer.size() > 0) {
                            byte[] bytesToSend = this.buffer.toByteArray();
                            WRITER_WATCHDOG.register(this, 600L, TimeUnit.SECONDS);
                            this.lastWriteStart.set(System.nanoTime());
                            this.os.write(bytesToSend, 0, bytesToSend.length);
                            long writeDurationInNanos = System.nanoTime() - this.lastWriteStart.getAndSet(-1L);
                            if (writeDurationInNanos > TimeUnit.MILLISECONDS.toNanos(4999L)) {
                                logger.warn(String.format("TCP Write operation needed [%s ms] for [%s bytes]!", TimeUnit.NANOSECONDS.toMillis(writeDurationInNanos), bytesToSend.length));
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug(String.format("%s sent [%s] bytes of msg [%s] to [%s] in [%s ms].", SrpcTcp.this.DEBUG_ID, this.buffer.size(), this.msgs.toString(), SrpcTcp.this.mySocket, TimeUnit.NANOSECONDS.toMillis(writeDurationInNanos)));
                            }
                            if (this.buffer.size() > 1024 && writeDurationInNanos > TimeUnit.SECONDS.toNanos(4L)) {
                                logger.warn(String.format("%s sent [%s] bytes of msg [%s] to [%s] in [%s ms].", SrpcTcp.this.DEBUG_ID, this.buffer.size(), this.msgs.toString(), SrpcTcp.this.mySocket, TimeUnit.NANOSECONDS.toMillis(writeDurationInNanos)));
                            }
                        }
                        this.os.flush();
                        this.buffer.reset();
                        this.lastSendNanos = System.nanoTime();
                        this.myThread.setName("WRITER " + SrpcTcp.this.DEBUG_ID + " : " + SrpcTcp.this.mySocket + " last send @[" + SDF.format(System.currentTimeMillis()) + "], uptime [" + this.getUptime() + "ms], isShutdown[" + SrpcTcp.this.isShutdown() + "]");
                        this.msgs = new StringBuilder();
                        this.socketExPenalty.set(1);
                    }
                }
                catch (SocketException ex) {
                    if (this.socketExPenalty.decrementAndGet() > 0 && !SrpcTcp.this.mySocket.isClosed()) break block13;
                    throw ex;
                }
            }
        }

        private void flush() throws IOException {
            this.tcpSend(null);
        }

        private boolean interruptWritingIfItTookAlreadyLongerThan(long timeout, TimeUnit unit) {
            if (this.lastWriteStart.get() < 0L) {
                return false;
            }
            long deadlineNs = System.nanoTime() - unit.toNanos(timeout);
            if (this.lastWriteStart.get() - deadlineNs < 0L && null != this.myThread && null != SrpcTcp.this.mySocket) {
                logger.warn(Basic.generateIndentedMultiLineLog(new String[]{"Writer blocking longer than " + timeout + " " + unit.toString() + " for " + SrpcTcp.this.mySocket}));
                try {
                    SrpcTcp.this.mySocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return true;
        }

        private long getUptime() {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.tsStarted);
        }
    }

    private class MyReader
    implements Runnable {
        private volatile AtomicBoolean runFlag = new AtomicBoolean(true);
        private volatile Thread myThread = null;
        private volatile boolean bCloseForInactivity = true;

        private MyReader() {
        }

        public void shutdown() {
            if (this.runFlag.compareAndSet(true, false)) {
                this.myThread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.myThread = Thread.currentThread();
                this.myThread.setName("READER " + SrpcTcp.this.DEBUG_ID + " : " + SrpcTcp.this.mySocket);
                InputStream is = null;
                SrpcMessage msg = null;
                while (!Thread.currentThread().isInterrupted() && this.runFlag.get()) {
                    block29: {
                        if (null == is) {
                            if (null == SrpcTcp.this.mySocket) {
                                logger.warn("Socket was null, when trying to get IO.");
                                SrpcTcp.this.closedByPeer();
                                continue;
                            }
                            try {
                                is = SrpcTcp.this.mySocket.getInputStream();
                            }
                            catch (IOException ioe) {
                                if (SrpcTcp.this.isInShutdown.get()) break block29;
                                SrpcTcp.this.closedByPeer();
                            }
                        }
                    }
                    try {
                        msg = this.readMessage(is);
                    }
                    catch (InterruptedException e) {
                        if (!SrpcTcp.this.isInShutdown.get()) {
                            logger.error((Object)e, (Throwable)e);
                        }
                        Thread.currentThread().interrupt();
                    }
                    catch (IOException ioe) {
                        SrpcTcp.this.closedByPeer();
                    }
                    if (null != msg) {
                        SrpcTcp.this.lastActive.set(System.nanoTime());
                        switch (msg.getType()) {
                            case 1: {
                                UUID id;
                                SrpcContext context;
                                if (DEBUG_METHS.contains((Object)Methods.valueOf(msg.getHash()))) {
                                    logger.info(String.format("[SRPC DEBUG] [recv] Resp[%s] [%s] [err %s] [enc %s] [zip %s] [token %s] [payload %s] %s", msg.getId(), msg.getMethodName(), msg.getError(), msg.getEncryption() != 0, msg.getCompression() != 0, msg.getToken() == null ? "no token" : msg.getToken(), msg.getPayload() == null ? "null" : msg.getPayload().toExtendedString(), SrpcTcp.this.mySocket));
                                }
                                if (null == (context = SrpcTcp.this.popPendingContext(id = msg.getId()))) break;
                                context.getFuture().done(msg);
                                break;
                            }
                            case 0: {
                                if (DEBUG_METHS.contains((Object)Methods.valueOf(msg.getHash()))) {
                                    logger.info(String.format("[recv] Requ[%s] [%s] [enc %s] [zip %s] [token %s] %s", msg.getId(), msg.getMethodName(), msg.getEncryption() != 0, msg.getCompression() != 0, msg.getToken() == null ? "no token" : msg.getToken(), SrpcTcp.this.mySocket));
                                }
                                try {
                                    SrpcRequestHandlerIntf handler = SrpcTcp.this.reqHandlerFactory.getRequestHandler(msg);
                                    handler.handleRequest(msg, SrpcTcp.this.requestCallback);
                                }
                                catch (NullPointerException ex) {
                                    logger.fatal((Object)ex, (Throwable)ex);
                                }
                                break;
                            }
                            default: {
                                logger.warn(String.format("[recv] ????(0x%x) [%s] [%s] [enc %s] [zip %s] %s", msg.getType(), msg.getId(), msg.getMethodName(), msg.getEncryption() != 0, msg.getCompression() != 0, SrpcTcp.this.mySocket));
                            }
                        }
                        msg = null;
                        continue;
                    }
                    if (System.nanoTime() - SrpcTcp.this.lastActive.get() > CONNECTION_IDLE_TIMEOUT_NANOS && this.bCloseForInactivity) {
                        this.bCloseForInactivity = false;
                        SrpcTcp.this.closedByPeer();
                        continue;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {}
                }
            }
            catch (NullPointerException ex) {
                SocketAddress remoteSocket = SrpcTcp.this.mySocket != null ? SrpcTcp.this.mySocket.getRemoteSocketAddress() : null;
                String remoteSocketDescriptor = remoteSocket != null ? remoteSocket.toString() : "<not connected>";
                logger.error("Pointer to NULL caused by " + remoteSocketDescriptor + ": ", (Throwable)ex);
                SrpcTcp.this.closedByPeer();
            }
            catch (Exception ex) {
                if (!SrpcTcp.this.isInShutdown.get()) {
                    logger.info("Connection has been closed." + SrpcTcp.this.mySocket);
                    SrpcTcp.this.closedByPeer();
                }
            }
            finally {
                Thread.currentThread().setName("DEAD " + Thread.currentThread().getName());
            }
        }

        private SrpcMessage readMessage(InputStream input) throws InterruptedException, IOException {
            SrpcMessage msg = null;
            AtomicLong bytesConsumed = new AtomicLong(0L);
            try {
                msg = SrpcMessage.deserialize(input, bytesConsumed);
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (SocketException ex) {
                throw ex;
            }
            if (SrpcStatistics.isActivated() && null != msg) {
                try {
                    SrpcStatistics.addIncomingMessage(SrpcTcp.this.mySocket.getInetAddress().getHostAddress(), msg.getMethodName(), bytesConsumed.get());
                }
                catch (Throwable t) {
                    logger.warn("While adding statistical info: ", t);
                }
            }
            return msg;
        }
    }

    private static class ShutdownCallbackRunnable
    implements Runnable {
        private final ShutdownCallback callback;

        ShutdownCallbackRunnable(ShutdownCallback aCallback) {
            if (null == aCallback) {
                throw new IllegalArgumentException("Callback is null!");
            }
            this.callback = aCallback;
        }

        @Override
        public void run() {
            if (null == this.callback) {
                logger.warn("Callback was null!");
                return;
            }
            try {
                this.callback.onShutdown();
            }
            catch (Throwable t) {
                logger.error("While reporting shutdown of srpc: ", t);
            }
            Thread.currentThread().setName("Finished Callbackrunner " + SDF.format(System.currentTimeMillis()));
        }
    }
}

