/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;

public final class SrpcFuture
implements Future<SrpcMessage> {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private volatile SrpcMessage result = null;
    private volatile boolean cancelled = false;
    private volatile Exception exception = null;

    SrpcFuture() {
    }

    protected void done(SrpcMessage result) {
        if (null == result) {
            LogManager.getLogger(SrpcFuture.class).warn(String.format("ResultMessage is null! Exception is [%s]", this.exception));
        }
        this.result = result;
        this.countDownLatch.countDown();
    }

    protected void except(Exception t) {
        this.exception = t;
        this.countDownLatch.countDown();
    }

    @Override
    public SrpcMessage get() throws InterruptedException, ExecutionException {
        this.countDownLatch.await();
        if (null != this.exception) {
            if (this.exception instanceof InterruptedException) {
                throw (InterruptedException)this.exception;
            }
            if (this.exception instanceof ExecutionException) {
                throw (ExecutionException)this.exception;
            }
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Override
    public SrpcMessage get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean notimeout = this.countDownLatch.await(timeout, unit);
        if (null != this.exception) {
            if (this.exception instanceof InterruptedException) {
                throw (InterruptedException)this.exception;
            }
            if (this.exception instanceof ExecutionException) {
                throw (ExecutionException)this.exception;
            }
            if (this.exception instanceof TimeoutException) {
                throw (TimeoutException)this.exception;
            }
            throw new ExecutionException(this.exception);
        }
        if (!notimeout) {
            throw new TimeoutException("No response in custom timeout.");
        }
        return this.result;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.cancelled = true;
        this.countDownLatch.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.countDownLatch.getCount() == 0L;
    }
}

