/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

import de.seetec.v5.shared.networking.srpc.SrpcDataType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GObject {
    private static final Logger LOGGER = LogManager.getLogger(GObject.class);
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String ADD_CHILD_NOT_TYPE_LIST = "Tried to add a child to a GObject that is not of type LIST!";
    private static final String ACCESS_CHILD_NOT_TYPE_LIST = "Tried to access a child on a GObject that is not of type LIST!";
    private static final byte[] TRUE = new byte[]{1};
    private static final byte[] FALSE = new byte[]{0};
    private byte type;
    private int sizeOfValue;
    private byte[] value;
    private List<GObject> children = null;

    private void ensureChildList() {
        if (null == this.children && this.isType(SrpcDataType.LIST)) {
            this.children = new ArrayList<GObject>();
            if (null != this.value) {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.value);
                try {
                    GObject child;
                    while ((child = GObject.fromBytes(bais)) != null) {
                        this.children.add(child);
                    }
                }
                catch (IOException ioe) {
                    LOGGER.error((Object)ioe, (Throwable)ioe);
                    throw new RuntimeException("Could not do it!");
                }
                finally {
                    this.value = null;
                }
            }
        }
    }

    public static GObject fromBytes(InputStream stream) throws IOException {
        GObject resultObject;
        int firstByte = stream.read();
        if (firstByte < 0) {
            return null;
        }
        int size = 0;
        byte theType = (byte)(firstByte & 0xFF);
        if ((theType & 0x80) == 128) {
            resultObject = new GObject(theType, null);
        } else if ((theType & 0x40) == 64) {
            int really;
            byte[] sizeBytes = new byte[4];
            stream.read(sizeBytes);
            size = ByteBuffer.wrap(sizeBytes).getInt();
            byte[] value = new byte[size];
            if (size > 0 && (really = stream.read(value)) != size) {
                LOGGER.warn(String.format("Size should be [%s] but read only [%s]", size, really));
            }
            resultObject = new GObject(theType, value);
        } else {
            switch (SrpcDataType.isType(theType)) {
                case INT4: {
                    size = 4;
                    break;
                }
                case INT8: {
                    size = 8;
                    break;
                }
                case BOOLEAN: {
                    size = 1;
                    break;
                }
                case BYTE: {
                    size = 1;
                }
            }
            byte[] value = new byte[size];
            stream.read(value);
            resultObject = new GObject(theType, value);
        }
        return resultObject;
    }

    public static GObject create(String value) {
        if (null == value) {
            return GObject.createNull(SrpcDataType.STRING);
        }
        return new GObject(SrpcDataType.STRING, value.getBytes(UTF8_CHARSET));
    }

    public static GObject create(long value) {
        return new GObject(SrpcDataType.INT8, ByteBuffer.allocate(8).putLong(value).array());
    }

    public static GObject create(int value) {
        return new GObject(SrpcDataType.INT4, ByteBuffer.allocate(4).putInt(value).array());
    }

    public static GObject create(boolean value) {
        return new GObject(SrpcDataType.BOOLEAN, value ? TRUE : FALSE);
    }

    public static GObject create(byte value) {
        return new GObject(SrpcDataType.BYTE, new byte[]{value});
    }

    public static GObject create(long[] value) {
        if (null == value) {
            return GObject.createNull(SrpcDataType.INT8_ARRAY);
        }
        ByteBuffer buffer = ByteBuffer.allocate(value.length * 8);
        for (long v : value) {
            buffer.putLong(v);
        }
        return new GObject(SrpcDataType.INT8_ARRAY, buffer.array());
    }

    public static GObject create(int[] value) {
        if (null == value) {
            return GObject.createNull(SrpcDataType.INT4_ARRAY);
        }
        ByteBuffer buffer = ByteBuffer.allocate(value.length * 4);
        for (int v : value) {
            buffer.putInt(v);
        }
        return new GObject(SrpcDataType.INT4_ARRAY, buffer.array());
    }

    public static GObject create(boolean[] value) {
        if (null == value) {
            return GObject.createNull(SrpcDataType.BOOLEAN_ARRAY);
        }
        ByteBuffer buffer = ByteBuffer.allocate(value.length);
        for (boolean v : value) {
            buffer.put(v ? TRUE : FALSE);
        }
        return new GObject(SrpcDataType.BOOLEAN_ARRAY, buffer.array());
    }

    public static GObject create(byte[] value) {
        if (null == value) {
            return GObject.createNull(SrpcDataType.BYTE_ARRAY);
        }
        return new GObject(SrpcDataType.BYTE_ARRAY, value);
    }

    public static GObject createList() {
        return new GObject(SrpcDataType.LIST, new byte[0]);
    }

    public static GObject createNull(SrpcDataType type) {
        return new GObject(type, null);
    }

    private GObject(byte type, byte[] value) {
        this(SrpcDataType.isType(type), value);
    }

    protected GObject(SrpcDataType type, byte[] value) {
        this.type = type.getType();
        this.setNullFlag(value);
        this.sizeOfValue = null != value ? value.length : 0;
        this.value = value;
        try {
            if (type == SrpcDataType.LIST) {
                this.ensureChildList();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void setNullFlag(byte[] value1) {
        if (null == value1) {
            this.type = (byte)(this.type | 0x80);
        }
    }

    public boolean isNull() {
        return (this.type & 0x80) == 128;
    }

    public byte getType() {
        return (byte)(this.type & 0x7F);
    }

    public int size() {
        if (this.isNull()) {
            return 1;
        }
        if (this.isArray()) {
            return 5 + this.valueSize();
        }
        try {
            switch (SrpcDataType.isType(this.type)) {
                case INT8: {
                    return 9;
                }
                case INT4: {
                    return 5;
                }
                case BOOLEAN: {
                    return 2;
                }
                case BYTE: {
                    return 2;
                }
            }
            return -1;
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    protected int valueSize() {
        if (this.isType(SrpcDataType.LIST)) {
            this.ensureChildList();
            int size = 0;
            if (!this.children.isEmpty()) {
                size = this.children.stream().map(child -> child.size()).reduce(size, Integer::sum);
            }
            this.sizeOfValue = size;
        }
        return this.sizeOfValue;
    }

    protected boolean isArray() {
        return (this.type & 0x40) == 64;
    }

    public boolean isType(SrpcDataType givenType) {
        return givenType.getType() == this.getType();
    }

    public void addChild(Long childVal) {
        this.addChild(null == childVal ? GObject.createNull(SrpcDataType.INT8) : GObject.create(childVal));
    }

    public void addChild(Integer childVal) {
        this.addChild(null == childVal ? GObject.createNull(SrpcDataType.INT4) : GObject.create(childVal));
    }

    public void addChild(Boolean childVal) {
        this.addChild(null == childVal ? GObject.createNull(SrpcDataType.BOOLEAN) : GObject.create(childVal));
    }

    public void addChild(Byte childVal) {
        this.addChild(null == childVal ? GObject.createNull(SrpcDataType.BYTE) : GObject.create(childVal));
    }

    public void addChild(long[] childVal) {
        this.addChild(GObject.create(childVal));
    }

    public void addChild(byte[] childVal) {
        this.addChild(GObject.create(childVal));
    }

    public void addChild(String childVal) {
        this.addChild(GObject.create(childVal));
    }

    public void addChild(GObject child) {
        if (!this.isType(SrpcDataType.LIST)) {
            throw new IllegalStateException(ADD_CHILD_NOT_TYPE_LIST);
        }
        this.ensureChildList();
        this.children.add(child);
    }

    public GObject getChildAt(int index) {
        if (!this.isType(SrpcDataType.LIST)) {
            throw new IllegalStateException(ACCESS_CHILD_NOT_TYPE_LIST);
        }
        this.ensureChildList();
        return this.children.get(index);
    }

    public List<GObject> getChildren() {
        return this.children;
    }

    public long getAsLong() {
        this.checkIfNull();
        if (!this.isType(SrpcDataType.INT8) && !this.isType(SrpcDataType.INT4)) {
            throw new RuntimeException(String.format("Type mismatch! was %s, expected %s ", new Object[]{this.type, SrpcDataType.INT8}));
        }
        if (this.isType(SrpcDataType.INT4)) {
            return ByteBuffer.wrap(this.value).getInt();
        }
        return ByteBuffer.wrap(this.value).getLong();
    }

    public Long tryGetAsLong() {
        try {
            return this.getAsLong();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public Long[] getAsArrayOfBoxedLong() {
        if (!this.isType(SrpcDataType.INT8_ARRAY)) {
            throw new RuntimeException("Type mismatch!");
        }
        if (this.isNull() || this.value == null) {
            throw new NullPointerException("Value is null!");
        }
        Long[] result = new Long[this.sizeOfValue / 8];
        ByteBuffer buffer = ByteBuffer.wrap(this.value);
        for (int i = 0; i < result.length; ++i) {
            result[i] = buffer.getLong(i * 8);
        }
        return result;
    }

    public long[] getAsArrayOfLong() {
        if (!this.isType(SrpcDataType.INT8_ARRAY)) {
            throw new RuntimeException("Type mismatch!");
        }
        if (this.isNull() || this.value == null) {
            throw new NullPointerException("Value is null!");
        }
        long[] result = new long[this.sizeOfValue / 8];
        ByteBuffer buffer = ByteBuffer.wrap(this.value);
        for (int i = 0; i < result.length; ++i) {
            result[i] = buffer.getLong(i * 8);
        }
        return result;
    }

    public long[] tryGetAsArrayOfLong() {
        try {
            return this.getAsArrayOfLong();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public Long[] tryGetAsArrayOfBoxedLong() {
        try {
            return this.getAsArrayOfBoxedLong();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public int getAsInt() {
        if (!this.isType(SrpcDataType.INT8) && !this.isType(SrpcDataType.INT4)) {
            throw new RuntimeException("Type mismatch!");
        }
        this.checkIfNull();
        if (this.isType(SrpcDataType.INT8)) {
            return (int)ByteBuffer.wrap(this.value).getLong();
        }
        return ByteBuffer.wrap(this.value).getInt();
    }

    public Integer tryGetAsInt() {
        try {
            return this.getAsInt();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public int[] getAsArrayOfInt() {
        if (!this.isType(SrpcDataType.INT4_ARRAY)) {
            throw new RuntimeException("Type mismatch!");
        }
        this.checkIfNull();
        int[] result = new int[this.sizeOfValue / 4];
        ByteBuffer buffer = ByteBuffer.wrap(this.value);
        for (int i = 0; i < result.length; ++i) {
            result[i] = buffer.getInt(i * 4);
        }
        return result;
    }

    public int[] tryGetAsArrayOfInt() {
        try {
            return this.getAsArrayOfInt();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public byte getAsByte() {
        if (!this.isType(SrpcDataType.BYTE)) {
            throw new RuntimeException("Type mismatch!");
        }
        this.checkIfNull();
        if (null == this.value || this.value.length <= 0) {
            throw new RuntimeException("IndexOutOfBounds!");
        }
        return this.value[0];
    }

    public Byte tryGetAsByte() {
        try {
            return this.getAsByte();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public byte[] getAsArrayOfByte() {
        if (!this.isType(SrpcDataType.BYTE_ARRAY)) {
            throw new RuntimeException("Type mismatch!");
        }
        this.checkIfNull();
        return this.value;
    }

    public byte[] tryGetAsArrayOfByte() {
        try {
            return this.getAsArrayOfByte();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public boolean getAsBoolean() {
        if (!this.isType(SrpcDataType.BOOLEAN)) {
            throw new RuntimeException("Type mismatch!");
        }
        this.checkIfNull();
        if (null == this.value || this.value.length <= 0) {
            throw new RuntimeException("IndexOutOfBounds!");
        }
        return ByteBuffer.wrap(this.value).get() > 0;
    }

    public Boolean tryGetAsBoolean() {
        try {
            return this.getAsBoolean();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public boolean[] getAsArrayOfBoolean() {
        if (!this.isType(SrpcDataType.BOOLEAN_ARRAY)) {
            throw new RuntimeException("Type mismatch!");
        }
        this.checkIfNull();
        boolean[] result = new boolean[this.sizeOfValue];
        ByteBuffer buffer = ByteBuffer.wrap(this.value);
        for (int i = 0; i < result.length; ++i) {
            result[i] = buffer.get(i) > 0;
        }
        return result;
    }

    public boolean[] tryGetAsArrayOfBoolean() {
        try {
            return this.getAsArrayOfBoolean();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public String getAsString() {
        this.checkIfNull();
        if (!this.isType(SrpcDataType.STRING)) {
            throw new RuntimeException(String.format("Type mismatch! was %s, expected %s ", new Object[]{this.type, SrpcDataType.STRING}));
        }
        return new String(this.value, UTF8_CHARSET);
    }

    private void checkIfNull() throws NullPointerException {
        if (this.isNull()) {
            throw new NullPointerException("Value is null!");
        }
    }

    public String tryGetAsString() {
        try {
            return this.getAsString();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public void serialize(OutputStream stream) throws IOException {
        stream.write(this.type);
        if (!this.isNull()) {
            if (this.isType(SrpcDataType.LIST)) {
                stream.write(ByteBuffer.allocate(4).putInt(this.valueSize()).array());
                if (!this.children.isEmpty()) {
                    for (GObject child : this.children) {
                        child.serialize(stream);
                    }
                }
            } else {
                if (this.isArray()) {
                    stream.write(ByteBuffer.allocate(4).putInt(this.valueSize()).array());
                }
                stream.write(this.value);
            }
        }
    }

    public static List<Long> asList(final long[] value) {
        if (null == value) {
            return null;
        }
        return Collections.unmodifiableList(new AbstractList<Long>(){

            @Override
            public Long get(int index) {
                return value[index];
            }

            @Override
            public Long set(int index, Long val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return value.length;
            }
        });
    }

    public static List<Long> asModifyableList(long[] l) {
        if (null == l) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (long el : l) {
            list.add(el);
        }
        return list;
    }

    public static long[] fromListLong(List<Long> l) {
        if (null == l) {
            return new long[0];
        }
        long[] arr = new long[l.size()];
        int index = 0;
        for (Long value : l) {
            arr[index] = value;
            ++index;
        }
        return arr;
    }

    public void printGObjectTree(PrintStream ps) {
        ps.println();
        this.printGObjectTree(ps, "");
    }

    protected final void printGObjectTree(PrintStream ps, String offset) {
        ps.format("%s%s", offset, this.toExtendedString());
        ps.println();
        if (this.isType(SrpcDataType.LIST)) {
            String childOffset = offset + "  ";
            this.getChildren().stream().forEach(child -> child.printGObjectTree(ps, childOffset));
        }
    }

    private String getArrayString() {
        try {
            switch (SrpcDataType.isType(this.type)) {
                case STRING: {
                    return String.format("%s", this.tryGetAsString());
                }
                case BOOLEAN: {
                    return String.format("%s", this.tryGetAsBoolean());
                }
                case BOOLEAN_ARRAY: {
                    return Arrays.toString(this.tryGetAsArrayOfBoolean());
                }
                case BYTE: {
                    return String.format("%s", this.tryGetAsByte());
                }
                case BYTE_ARRAY: {
                    return Arrays.toString(this.tryGetAsArrayOfByte());
                }
                case INT4: {
                    return String.format("%s", this.tryGetAsInt());
                }
                case INT4_ARRAY: {
                    return Arrays.toString(this.tryGetAsArrayOfInt());
                }
                case INT8: {
                    return String.format("%s", this.tryGetAsLong());
                }
                case INT8_ARRAY: {
                    return Arrays.toString(this.tryGetAsArrayOfLong());
                }
                case LIST: {
                    return String.format("List<GObject>(elms %s)", this.getChildren().size());
                }
            }
            return "";
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    public String toExtendedString() {
        return String.format("GObj%s<Type (0x%02X) %s> Value [%s] , Nullflag [%s], Size [%s]", Integer.toHexString(this.hashCode()), this.type & 0xFF, SrpcDataType.isType(this.type).name(), this.getArrayString(), this.isNull(), this.size());
    }

    public String toString() {
        return String.format("GObj%s<(0x%02X) %s> [%s]", Integer.toHexString(this.hashCode()), this.type & 0xFF, SrpcDataType.isType(this.type).name(), this.getArrayString());
    }
}

