/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net.srpc.re;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.srpc.RequestWrapper;
import de.seetec.v5.shared.networking.srpc.GObject;
import java.util.Date;
import java.util.List;

public class ReqReadFrame
extends RequestWrapper {
    String methodName = "";
    Integer mediatype = null;
    Integer track = null;
    Long timestamp = null;
    private Integer transactionId = null;

    public ReqReadFrame(String methodName, Integer mediatype, Integer track, Long timestamp, Integer transactionId) {
        this.methodName = methodName;
        this.mediatype = mediatype;
        this.track = track;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
    }

    protected static RequestWrapper parseGObject(String methodName, GObject goRequest) {
        Integer transactionId;
        Long timestamp;
        Integer mediatype = null;
        Integer track = null;
        List<GObject> lParameter = goRequest.getChildren();
        if (lParameter != null && lParameter.size() > 2) {
            mediatype = goRequest.getChildAt(0).tryGetAsInt();
            track = goRequest.getChildAt(1).tryGetAsInt();
            timestamp = goRequest.getChildAt(2).getAsLong();
            transactionId = goRequest.getChildAt(3).tryGetAsInt();
        } else {
            timestamp = goRequest.getChildAt(0).tryGetAsLong();
            transactionId = goRequest.getChildAt(1).tryGetAsInt();
        }
        return new ReqReadFrame(methodName, mediatype, track, timestamp, transactionId);
    }

    @Override
    public GObject createGObject() {
        GObject goResponse = GObject.createList();
        goResponse.addChild(this.mediatype);
        goResponse.addChild(this.track);
        goResponse.addChild(this.timestamp);
        goResponse.addChild(this.transactionId);
        return goResponse;
    }

    public Integer getMediatype() {
        return this.mediatype;
    }

    public Integer getTrack() {
        return this.track;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Integer getTransactionId() {
        return this.transactionId;
    }

    public String toString() {
        String sTrack = "undefined";
        String sMediatype = "undefined";
        String sTimestamp = "undefined";
        String sTransactionId = "undefined";
        if (this.mediatype != null) {
            sMediatype = "" + this.mediatype;
        }
        if (this.track != null) {
            sTrack = "" + this.track;
        }
        if (this.timestamp != null) {
            sTimestamp = Basic.longToFormattedString(this.timestamp) + "]/[" + new Date(this.timestamp);
        }
        if (this.transactionId != null) {
            sTransactionId = "" + this.transactionId;
        }
        return "[" + this.methodName + ", Mediatype=[" + sMediatype + "], Track=[" + sTrack + "], Timestamp=[" + sTimestamp + "], TransactionId=[" + sTransactionId + "]]";
    }
}

