/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net.srpc;

import de.seetec.v5.shared.net.srpc.RequestWrapper;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcDataType;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReqNotify
extends RequestWrapper {
    static final Logger LOGGER = LogManager.getLogger((String)"de.seetec.v5.shared.net.srpc.ReqNotify");
    protected Long eventID = null;
    protected Long eventType = null;
    protected Long sourceID = null;
    protected Long causeID = null;
    protected Long time = null;
    protected final byte[] data;

    public ReqNotify(Long nEventID, Long eventType, Long sourceID, Long causeID, Long time, byte[] data) {
        this.eventID = nEventID;
        this.eventType = eventType;
        this.sourceID = sourceID;
        this.causeID = causeID;
        this.time = time;
        this.data = data;
    }

    public static RequestWrapper parseGObject(GObject goRequest) {
        Long eventID = null;
        Long eventType = null;
        Long sourceID = null;
        Long causeID = null;
        Long time = null;
        byte[] data = null;
        if (goRequest.isType(SrpcDataType.LIST)) {
            eventID = goRequest.getChildAt(0).getAsLong();
            eventType = goRequest.getChildAt(1).getAsLong();
            sourceID = goRequest.getChildAt(2).getAsLong();
            causeID = goRequest.getChildAt(3).getAsLong();
            time = goRequest.getChildAt(4).getAsLong();
            data = goRequest.getChildAt(5).getAsArrayOfByte();
        } else if (!goRequest.isNull()) {
            byte[] bArray = goRequest.getAsArrayOfByte();
            ByteBuffer bb = ByteBuffer.wrap(bArray).asReadOnlyBuffer();
            eventID = bb.getLong();
            eventType = bb.getLong();
            sourceID = bb.getLong();
            causeID = bb.getLong();
            time = bb.getLong();
            if (bb.remaining() > 0) {
                data = new byte[bb.remaining()];
                bb.get(data, 0, bb.remaining());
            }
        } else {
            LOGGER.warn(String.format("Could not parse Request Notify: [%s]!", goRequest.toString()));
        }
        return new ReqNotify(eventID, eventType, sourceID, causeID, time, data);
    }

    @Override
    public GObject createGObject() {
        int len = 40 + (null == this.data ? 0 : this.data.length);
        ByteBuffer buffer = ByteBuffer.allocate(len);
        this.eventID = this.eventID == null ? Long.MIN_VALUE : this.eventID;
        buffer.putLong(this.eventID);
        this.eventType = this.eventType == null ? Long.MIN_VALUE : this.eventType;
        buffer.putLong(this.eventType);
        this.sourceID = this.sourceID == null ? Long.MIN_VALUE : this.sourceID;
        buffer.putLong(this.sourceID);
        this.causeID = this.causeID == null ? Long.MIN_VALUE : this.causeID;
        buffer.putLong(this.causeID);
        this.time = this.time == null ? Long.MIN_VALUE : this.time;
        buffer.putLong(this.time);
        if (this.data != null) {
            buffer.put(this.data);
        }
        GObject params = GObject.create(buffer.array());
        return params;
    }

    public Long getEventID() {
        return this.eventID;
    }

    public Long getEventType() {
        return this.eventType;
    }

    public Long getSourceID() {
        return this.sourceID;
    }

    public Long getCauseID() {
        return this.causeID;
    }

    public Long getDuration() {
        return this.time;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return String.format("[%s , EventID=[%,d], EventType=[%,d], SourceID=[%,d], CauseID=[%,d], Time=[%,d], ]", Methods.NOTIFY.methodName(), this.eventID, this.eventType, this.sourceID, this.causeID, this.time);
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Objects.hashCode(this.eventID);
        hash = 41 * hash + Objects.hashCode(this.eventType);
        hash = 41 * hash + Objects.hashCode(this.sourceID);
        hash = 41 * hash + Objects.hashCode(this.causeID);
        hash = 41 * hash + Objects.hashCode(this.time);
        hash = 41 * hash + Arrays.hashCode(this.data);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReqNotify other = (ReqNotify)obj;
        return Objects.equals(this.eventID, other.eventID) && Objects.equals(this.eventType, other.eventType) && Objects.equals(this.sourceID, other.sourceID) && Objects.equals(this.time, other.time) && Arrays.equals(this.data, other.data);
    }
}

