/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net.mail;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SmtpEncryptionMethod;
import de.seetec.v5.shared.net.mail.MailTransferAgent;
import de.seetec.v5.shared.net.mail.SmtpAuthenticator;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailTransferAgentImpl
implements MailTransferAgent {
    private final Logger logger;
    private String sMailHost = null;
    private int smtpPort = 25;
    private SmtpEncryptionMethod encryptionMethod = SmtpEncryptionMethod.UNENCRYPTED;
    private String sMailFrom = null;
    private String[] sMailRecipients = null;
    private String sUser = null;
    private String sPass = null;

    public MailTransferAgentImpl() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    @Override
    public void init(String sMailHost, int port, SmtpEncryptionMethod encryptionMethod, String sUser, String sPass, String sMailFrom, String[] sMailRecipients) throws SeeTecException {
        this.sMailHost = sMailHost;
        if (this.sMailHost == null) {
            throw new SeeTecException(-20002, "Smtp host is null.");
        }
        this.smtpPort = port;
        this.encryptionMethod = encryptionMethod;
        this.sUser = sUser;
        this.sPass = sPass;
        this.sMailFrom = sMailFrom;
        if (this.sMailFrom == null) {
            throw new SeeTecException(-20002, "Smtp sender is null.");
        }
        this.sMailRecipients = sMailRecipients;
        if (sMailRecipients == null) {
            throw new SeeTecException(-20002, "Smtp recipients are null.");
        }
    }

    @Override
    public int sendMail(String sSubject, String sMessage, List<MimeBodyPart> attachments) {
        try {
            Properties mailProperties = this.createMailProperties();
            mailProperties = this.setMailAuthProperties(mailProperties);
            mailProperties = this.setMailEncryptionProperties(mailProperties);
            Session session = this.isAuthSet() ? Session.getInstance((Properties)mailProperties, (Authenticator)new SmtpAuthenticator(this.sUser, this.sPass)) : Session.getInstance((Properties)mailProperties);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)this.createBody(sMessage));
            if (attachments != null) {
                int counter = 0;
                for (MimeBodyPart messageBodyPart : attachments) {
                    messageBodyPart.setHeader("Content-ID", "<image" + counter++ + ">");
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
            }
            this.sendMailToAllRecipients(session, sSubject, (Multipart)multipart);
        }
        catch (SendFailedException uhe) {
            Exception e = uhe.getNextException();
            if (e != null) {
                if (e.getClass().getName().equals("javax.mail.MessagingException")) {
                    if (((MessagingException)((Object)e)).getNextException() != null && ((MessagingException)((Object)e)).getNextException().getClass().getName().equals("java.net.UnknownHostException")) {
                        this.logger.error((Object)e, (Throwable)e);
                        return -20052;
                    }
                } else if (e.getClass().getName().equals("javax.mail.AuthenticationFailedException")) {
                    this.logger.error((Object)e, (Throwable)e);
                    return -20053;
                }
            }
            this.logger.error((Object)e, (Throwable)e);
            return -20050;
        }
        catch (MessagingException ve) {
            Exception e = ve.getNextException();
            if (e != null && e.getClass().getName().equals("javax.net.ssl.SSLHandshakeException") && e.getMessage().contains("PKIX path building failed")) {
                this.logger.info(Basic.generateIndentedMultiLineLog("The provider's SSL/TLS certificate is unknown and must be imported!"));
            } else {
                this.logger.error((Object)ve, (Throwable)ve);
            }
            return -20050;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return -20050;
        }
        return 0;
    }

    private Properties setMailAuthProperties(Properties mailProperties) {
        if (this.isAuthSet()) {
            mailProperties.put("mail.smtp.auth", "true");
            if (this.encryptionMethod == SmtpEncryptionMethod.SSL) {
                mailProperties.put("mail.smtp.user", this.sUser);
            }
        }
        return mailProperties;
    }

    private boolean isAuthSet() {
        return this.sUser != null && this.sPass != null;
    }

    private Properties setMailEncryptionProperties(Properties mailProperties) {
        if (this.encryptionMethod == SmtpEncryptionMethod.SSL) {
            mailProperties.setProperty("mail.smtp.ssl.trust", "*");
            mailProperties.put("mail.smtp.socketFactory.port", (Object)this.smtpPort);
            mailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            mailProperties.put("mail.smtp.socketFactory.fallback", "false");
        } else if (this.encryptionMethod == SmtpEncryptionMethod.TLS) {
            mailProperties.put("mail.smtp.ssl.trust", "*");
            mailProperties.put("mail.smtp.starttls.enable", "true");
        }
        return mailProperties;
    }

    private Properties createMailProperties() {
        Properties mailProperties = new Properties();
        mailProperties.put("mail.smtp.host", this.sMailHost);
        mailProperties.put("mail.smtp.port", (Object)this.smtpPort);
        return mailProperties;
    }

    private MimeBodyPart createBody(String sMessage) throws MessagingException {
        MimeBodyPart body = new MimeBodyPart();
        if (sMessage.toLowerCase().contains("<html>")) {
            body.setContent((Object)sMessage, "text/html");
        } else {
            body.setText(sMessage, "UTF-8");
        }
        return body;
    }

    private void sendMailToAllRecipients(Session session, String sSubject, Multipart multipart) throws MessagingException {
        for (String sMailRecipient : this.sMailRecipients) {
            MimeMessage msg = new MimeMessage(session);
            msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(sMailRecipient));
            msg.setSubject(sSubject);
            msg.setContent(multipart);
            msg.setFrom((Address)new InternetAddress(this.sMailFrom));
            try (Transport transport = session.getTransport("smtp");){
                transport.connect(this.sMailHost, this.smtpPort, this.sUser, this.sPass);
                transport.sendMessage((Message)msg, msg.getAllRecipients());
            }
        }
    }
}

