/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net;

public enum RTSPStatusCode {
    RTSP_CONTINUE(100),
    RTSP_OK(200),
    RTSP_CREATED(201),
    RTSP_LOW_ON_STORAGE_SPACE(250),
    RTSP_MULTIPLE_CHOICES(300),
    RTSP_MOVED_PERMANENTLY(301),
    RTSP_MOVED_TEMPORARILY(302),
    RTSP_SEE_OTHER(303),
    RTSP_NOT_MODIFIED(304),
    RTSP_USE_PROXY(305),
    RTSP_BAD_REQUEST(400),
    RTSP_UNAUTHORIZED(401),
    RTSP_PAYMENT_REQUIRED(402),
    RTSP_FORBIDDEN(403),
    RTSP_NOT_FOUND(404),
    RTSP_METHOD_NOT_ALLOWED(405),
    RTSP_NOT_ACCEPTABLE(406),
    RTSP_PROXY_AUTHENTICATION_REQUIRED(407),
    RTSP_REQUEST_TIME_OUT(408),
    RTSP_GONE(410),
    RTSP_LENGTH_REQUIRED(411),
    RTSP_PRECONDITION_FAILED(412),
    RTSP_REQUEST_ENTITY_TOO_LARGE(413),
    RTSP_REQUEST_URI_TOO_LARGE(414),
    RTSP_UNSUPPORTED_MEDIA_TYPE(415),
    RTSP_PARAMETER_NOT_UNDERSTOOD(451),
    RTSP_CONFERENCE_NOT_FOUND(452),
    RTSP_NOT_ENOUGH_BANDWIDTH(453),
    RTSP_SESSION_NOT_FOUND(454),
    RTSP_METHOD_NOT_VALID_IN_THIS_STATE(455),
    RTSP_HEADER_FIELD_NOT_VALID_FOR_RESOURCE(456),
    RTSP_INVALID_RANGE(457),
    RTSP_PARAMETER_IS_READ_ONLY(458),
    RTSP_AGGREGATE_OPERATION_NOT_ALLOWED(459),
    RTSP_ONLY_AGGREGATE_OPERATION_ALLOWED(460),
    RTSP_UNSUPPORTED_TRANSPORT(461),
    RTSP_DESTINATION_UNREACHABLE(462),
    RTSP_INTERNAL_SERVER_ERROR(500),
    RTSP_NOT_IMPLEMENTED(501),
    RTSP_BAD_GATEWAY(502),
    RTSP_SERVICE_UNAVAILABLE(503),
    RTSP_GATEWAY_TIME_OUT(504),
    RTSP_RTSP_VERSION_NOT_SUPPORTED(505),
    RTSP_OPTION_NOT_SUPPORTED(551);

    private int statusCode;

    private RTSPStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static RTSPStatusCode valueOf(int givenStatusCode) {
        RTSPStatusCode statusCode = null;
        for (RTSPStatusCode t : RTSPStatusCode.values()) {
            if (givenStatusCode != t.statusCode) continue;
            statusCode = t;
            break;
        }
        return statusCode;
    }

    public String toString() {
        return "RTSP Statuscode: " + this.getStatusCode() + ", Name: " + this.name();
    }
}

