/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HTTPHeader {
    private static final String COOKIE = "set-cookie";
    private static final String CONTENTLENGTH = "contentlength";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private int statusCode;
    private int contentLength;
    private String cookie;
    private byte[] headerData;
    private String realm;
    private String nonce;
    private String qop;

    HTTPHeader(byte[] data) {
        this.headerData = data;
        String[] lines = new String(data).split("\r\n");
        if (lines.length > 0) {
            String[] splittedFirstLine = lines[0].split(" ");
            if (splittedFirstLine.length > 1) {
                try {
                    this.statusCode = Integer.parseInt(splittedFirstLine[1]);
                }
                catch (NumberFormatException ex) {
                    this.logger.error("Could not read statuscode from response");
                }
            }
            for (int i = 1; i < lines.length; ++i) {
                String[] authParts;
                String line = lines[i];
                if (line.toLowerCase().replace("-", "").replace(" ", "").contains(CONTENTLENGTH)) {
                    String[] nameValue = line.split(":");
                    if (nameValue.length != 2) continue;
                    this.contentLength = Integer.parseInt(nameValue[1].trim());
                    continue;
                }
                if (line.toLowerCase().contains(COOKIE)) {
                    String[] firstCookieLine = line.split(":");
                    if (firstCookieLine.length == 2) {
                        this.cookie = "Cookie: " + firstCookieLine[1].trim();
                    }
                    while (this.cookie.endsWith(";") && ++i < lines.length) {
                        this.cookie = this.cookie + "\r\n" + lines[i];
                    }
                    continue;
                }
                if (!line.toLowerCase().contains("www-authenticate") || !line.toLowerCase().contains("digest")) continue;
                String authLine = line.replace("WWW-Authenticate:", "").replace("Digest", "").trim();
                for (String authPart : authParts = authLine.split(",")) {
                    if (authPart.contains("realm")) {
                        this.realm = authPart.trim().replace("realm=", "").replace("\"", "");
                        continue;
                    }
                    if (authPart.contains("Realm")) {
                        this.realm = authPart.trim().replace("Realm=", "").replace("\"", "");
                        continue;
                    }
                    if (authPart.contains("nonce")) {
                        this.nonce = authPart.trim().replace("nonce=", "").replace("\"", "");
                        continue;
                    }
                    if (authPart.contains("Nonce")) {
                        this.nonce = authPart.trim().replace("Nonce=", "").replace("\"", "");
                        continue;
                    }
                    if (authPart.contains("qop")) {
                        this.qop = authPart.trim().replace("qop=", "").replace("\"", "");
                        continue;
                    }
                    if (authPart.contains("Qop")) {
                        this.qop = authPart.trim().replace("Qop=", "").replace("\"", "");
                        continue;
                    }
                    if (!authPart.contains("QOP")) continue;
                    this.qop = authPart.trim().replace("QOP=", "").replace("\"", "");
                }
            }
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getCookie() {
        return this.cookie;
    }

    public String getData() {
        return new String(this.headerData);
    }

    public String getRealm() {
        return this.realm;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getQop() {
        return this.qop;
    }
}

