/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net;

import de.seetec.v5.shared.net.CipherSuitesFilterEngine;
import de.seetec.v5.shared.net.CipherSuitesFilterEngineFactory;
import de.seetec.v5.shared.net.CipherSuitesFilterMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CipherSuitesFilter {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final CipherSuitesFilterEngine cipherSuitesFilterEngine;

    public CipherSuitesFilter() {
        this(CipherSuitesFilterMode.LEGACY);
    }

    public CipherSuitesFilter(CipherSuitesFilterMode mode) {
        this.cipherSuitesFilterEngine = new CipherSuitesFilterEngineFactory().getInstance(mode);
    }

    public String[] filter(String[] enabledCipherSuitesToFilter) {
        if (enabledCipherSuitesToFilter == null) {
            return null;
        }
        String[] suitesAsList = this.cipherSuitesFilterEngine.filter(enabledCipherSuitesToFilter);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(suitesAsList.length + " ciphersuites left over. (" + (enabledCipherSuitesToFilter.length - suitesAsList.length) + " suites sorted out.)");
        }
        return suitesAsList;
    }
}

