/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.crypto;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.crypto.PasswordElementOnlyFilter;
import de.seetec.v5.shared.crypto.digest.MessageDigestGenerator;
import de.seetec.v5.shared.interaction.KeyDataObject;
import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.proxy.ssl.SSLProxy;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.NoSuchElementException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Crypto
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.shared.crypto.Crypto";
    private static final long TIMEOUT = 15000L;
    private static final String CYPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String AES_ENCRYPTION_ALGORITHM = "AES";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private volatile String store = null;
    private Thread thread = null;
    private static boolean encryptionEnabled = false;
    private static String method = null;
    private static byte[] key = null;
    private byte[] keyFromCore;
    private String cayugaToken;
    private String coreServiceMainHost = null;
    private int coreServiceMainPort = -1;
    private String defaultHost = null;
    private int defaultPort = -1;
    private long defaultId = -1L;
    private String fallbackHost = null;
    private int fallbackPort = -1;
    private long fallbackId = -1L;
    private final SSLProxy sslProxy;

    public Crypto(SSLProxy sslProxy) {
        this.sslProxy = sslProxy;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int init(String store, String entMgrHost, int entMgrPort, String coreServiceMainHost, int coreServiceMainPort, long coreID, byte[] key) {
        int errorCode;
        block13: {
            if (coreServiceMainHost != null && !coreServiceMainHost.isEmpty() && !coreServiceMainHost.equals("-1")) {
                this.coreServiceMainHost = coreServiceMainHost;
            }
            if (coreServiceMainPort > 0 && coreServiceMainPort < 65536) {
                this.coreServiceMainPort = coreServiceMainPort;
            }
            if ((this.store = store) == null) {
                this.logger.error("Store is null.");
                return -20002;
            }
            if (!new File(store).exists()) {
                this.logger.error(String.format("File '%s' does not exist.", store));
                return -20020;
            }
            if (entMgrHost == null) {
                this.logger.error("Host is null.");
                return -20002;
            }
            if (entMgrPort == Integer.MIN_VALUE || entMgrPort <= 0 || entMgrPort >= 65536) {
                this.logger.error("entMgrPort has invalid value.");
                return -20002;
            }
            this.keyFromCore = key;
            if (key == null) {
                this.logger.error("Key is null.");
                return -20002;
            }
            encryptionEnabled = true;
            errorCode = this.getEncryptionKey(entMgrHost, entMgrPort, coreID);
            if (errorCode != 0) {
                if (this.coreServiceMainHost != null && !this.coreServiceMainHost.isEmpty() && !this.coreServiceMainHost.equals("-1") && this.coreServiceMainPort != -1) {
                    this.defaultHost = this.coreServiceMainHost;
                    this.defaultPort = this.coreServiceMainPort;
                    this.defaultId = 2L;
                    this.fallbackHost = entMgrHost;
                    this.fallbackPort = entMgrPort;
                    this.fallbackId = coreID;
                    errorCode = this.getEncryptionKey(this.coreServiceMainHost, this.coreServiceMainPort, 2L);
                    if (errorCode != 0) {
                        return errorCode;
                    }
                    break block13;
                } else {
                    this.logger.error("Failed getting encryption key from [" + entMgrHost + ":" + entMgrPort + "] (" + coreID + ")");
                    return errorCode;
                }
            }
            this.defaultHost = entMgrHost;
            this.defaultPort = entMgrPort;
            this.defaultId = coreID;
            if (this.coreServiceMainHost != null && !this.coreServiceMainHost.isEmpty() && !this.coreServiceMainHost.equals("-1") && this.coreServiceMainPort != -1) {
                this.fallbackHost = this.coreServiceMainHost;
                this.fallbackPort = this.coreServiceMainPort;
                this.fallbackId = 2L;
            }
        }
        if (this.defaultHost != null && this.defaultPort >= 0) {
            this.thread = new Thread((Runnable)this, this.toString());
            this.thread.start();
            return errorCode;
        }
        this.logger.error("ATTENTION: Default network parameter [" + this.defaultHost + ":" + this.defaultPort + "] are invalid!");
        return -20002;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.store = null;
        method = null;
        key = null;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        long timeStamp = System.currentTimeMillis();
        EntMgrProxy entMgrProxy = null;
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (!this.isShutdown(CLASS_NAME)) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    this.logger.error("Error while sleeping. " + ex.getMessage());
                }
                if (System.currentTimeMillis() <= timeStamp + 15000L) continue;
                timeStamp = System.currentTimeMillis();
                try {
                    entMgrProxy = new EntMgrProxy();
                    int errorCode = entMgrProxy.init(this.defaultHost, this.defaultPort, this.defaultId, 15000L);
                    if (errorCode == 0) continue;
                    this.logger.error("Cannot create [EntMgrProxy] at [" + this.defaultHost + ":" + this.defaultPort + "]. Error [" + errorCode + "]");
                    if (errorCode == -20231 || errorCode == -20232) {
                        this.logger.error("Key not valid anymore.");
                        this.getEncryptionKey(this.defaultHost, this.defaultPort, this.defaultId);
                        continue;
                    }
                    if (this.fallbackHost == null || this.fallbackHost.isEmpty() || this.fallbackHost.equals("-1") || this.fallbackPort == -1) continue;
                    boolean switchCores = true;
                    errorCode = entMgrProxy.init(this.fallbackHost, this.fallbackPort, this.fallbackId, 15000L);
                    if (errorCode != 0) {
                        this.logger.error("Cannot create [CoreServiceMainProxy] at [" + this.fallbackHost + ":" + this.fallbackPort + "]. Error [" + errorCode + "] :-(");
                        if (errorCode == -20231 || errorCode == -20232) {
                            this.logger.error("Key not valid anymore.");
                            this.getEncryptionKey(this.fallbackHost, this.fallbackPort, this.fallbackId);
                        } else {
                            switchCores = false;
                        }
                    }
                    if (!switchCores) continue;
                    String tempHost = this.defaultHost;
                    int tempPort = this.defaultPort;
                    long tempId = this.defaultId;
                    this.defaultHost = this.fallbackHost;
                    this.defaultPort = this.fallbackPort;
                    this.defaultId = this.fallbackId;
                    this.fallbackHost = tempHost;
                    this.fallbackPort = tempPort;
                    this.fallbackId = tempId;
                }
                catch (Exception ex) {
                    this.logger.error("Exception while connecting to EntMgrProxy [" + ex.getMessage() + "]", (Throwable)ex);
                }
                finally {
                    if (entMgrProxy == null) continue;
                    entMgrProxy.shutdown();
                }
            }
            return;
        }
        catch (Throwable ex) {
            this.logger.fatal("This exception should never happen and be caught inside the while loop. [" + ex.getMessage() + "]", ex);
            this.shutdown();
        }
    }

    public static KeyDataObject getKeyData() {
        return new KeyDataObject(encryptionEnabled, method, key);
    }

    public static void setKeyData(boolean enabled, String meth, byte[] k) {
        encryptionEnabled = enabled;
        method = meth;
        key = k;
    }

    public String getCayugaToken() {
        return this.cayugaToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEncryptionKey(String host, int port, long coreId) {
        int errorCode = 0;
        long timestamp = System.currentTimeMillis();
        do {
            try {
                errorCode = this.sslProxy.init(host, port, coreId, 30000L);
                if (errorCode != 0) {
                    this.logger.error("Cannot create [SSLMgrProxy] at [" + host + ":" + port + "]. Error [" + errorCode + "] :-(");
                    return errorCode;
                }
                try {
                    String pass = Crypto.getPasswordFromFile(this.store, this.keyFromCore);
                    String salt = this.sslProxy.getSalt(15000L);
                    String completePass = MessageDigestGenerator.getSHA512Digest(salt + pass);
                    KeyDataObject keyInfo = this.sslProxy.getEncryptionKey(completePass, null, 15000L);
                    if (null == keyInfo) {
                        throw new SeeTecException(-20000, "KeyInfo is null");
                    }
                    method = keyInfo.getEncryptionMethod();
                    key = keyInfo.getKey();
                    this.cayugaToken = keyInfo.getToken();
                    if (method != null && key != null) {
                        this.logger.info("New key received");
                    } else {
                        this.logger.warn(String.format("One parameter is null. Method [%s] Key [%s]", method, key == null ? "null" : "not null"));
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Error while reading " + this.store + ": " + ex.getErrorCode());
                    errorCode = ex.getErrorCode();
                }
                catch (NoSuchAlgorithmException ex) {
                    this.logger.error("Exception width algorithm for decription ");
                    errorCode = -1;
                }
                catch (Exception ex) {
                    this.logger.error("Exception while getting encryption key: " + ex, (Throwable)ex);
                    errorCode = -1;
                }
                finally {
                    this.sslProxy.shutdown();
                }
            }
            catch (Exception ex) {
                this.logger.error("Initiailizing of [SSLMgrProxy] failed with error [" + ex.getMessage() + "]", (Throwable)ex);
                if (null != this.sslProxy) {
                    this.sslProxy.shutdown();
                }
                return -20000;
            }
            if (errorCode == 0) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (errorCode != 0 && System.currentTimeMillis() - timestamp < 30000L);
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPasswordFromFile(String fileName, byte[] key) throws SeeTecException {
        String string;
        block9: {
            byte[] xmlContent = Files.readAllBytes(Paths.get(fileName, new String[0]));
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            XMLEventReader xmlEventReader = null;
            try {
                xmlEventReader = xmlInputFactory.createFilteredReader(xmlInputFactory.createXMLEventReader(new ByteArrayInputStream(xmlContent)), new PasswordElementOnlyFilter());
                xmlEventReader.nextEvent();
                byte[] hashFromFile = xmlEventReader.getElementText().trim().getBytes("UTF-8");
                byte[] cipheredBytes = Base64.getDecoder().decode(hashFromFile);
                byte[] initilizationVector = new byte[16];
                IvParameterSpec ivParameterSpec = new IvParameterSpec(initilizationVector);
                SecretKeySpec secretKeySpecy = new SecretKeySpec(key, AES_ENCRYPTION_ALGORITHM);
                Cipher cipher = Cipher.getInstance(CYPHER_TRANSFORMATION);
                cipher.init(2, (Key)secretKeySpecy, ivParameterSpec);
                byte[] cipherText = cipher.doFinal(cipheredBytes);
                string = new String(cipherText);
                if (xmlEventReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (xmlEventReader != null) {
                        xmlEventReader.close();
                    }
                    throw throwable;
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new SeeTecException(-20053, "No tag found");
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new SeeTecException(-20053, "Algorithm for decription not found");
                }
                catch (FileNotFoundException ex) {
                    throw new SeeTecException(-20053, "Could not read keystore.xml file");
                }
                catch (Exception ex) {
                    throw new SeeTecException(-20053, "Exception while getting encryption key ");
                }
            }
            xmlEventReader.close();
        }
        return string;
    }
}

