/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.ComponentVersionNumberProvider;
import de.seetec.v5.shared.DefaultSystemPropertyProvider;
import de.seetec.v5.shared.VMParameter;
import de.seetec.v5.shared.util.MemoryFootprint;
import de.seetec.v5.shared.util.MemoryFootprintProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LogHeaderProvider {
    private static final String SSL_APP_COPYRIGHT = "(c) 2003-2022 by Qognify GmbH";

    private LogHeaderProvider() {
    }

    public static String[] getLogHeader(String sAppName, ComponentVersionNumberProvider componentVersionNumberProvider, String sAppDate) {
        LogHeaderProvider.checkArgument(sAppName);
        if (componentVersionNumberProvider == null) {
            throw new IllegalArgumentException();
        }
        LogHeaderProvider.checkArgument(sAppDate);
        ArrayList<String> infos = new ArrayList<String>();
        infos.add("********************************************************");
        infos.add("*");
        infos.add("* " + sAppName + " " + componentVersionNumberProvider.getReleaseVersion() + " / " + sAppDate);
        infos.add("*");
        infos.add("* (c) 2003-2022 by Qognify GmbH");
        infos.add("*");
        infos.add("********************************************************");
        infos.add("");
        infos.addAll(LogHeaderProvider.getLogBody(null));
        String[] info = new String[infos.size()];
        return infos.toArray(info);
    }

    public static List<String> getLogBody(String serverAddress) {
        ArrayList<String> infos = new ArrayList<String>();
        MemoryFootprint memoryFootprint = MemoryFootprintProvider.getMemoryFootprint();
        DefaultSystemPropertyProvider systemPropertyProvider = new DefaultSystemPropertyProvider();
        infos.add("Environment:");
        infos.add("   Date:                [" + new Date() + "]");
        infos.add("   Operating System:    [" + systemPropertyProvider.getProperty("os.name") + "]");
        infos.add("   Java Version:        [" + systemPropertyProvider.getProperty("java.version") + "]");
        infos.add("   Java VM:             [" + systemPropertyProvider.getProperty("java.vm.name") + "]");
        infos.add("   Java VM Parameter:   [" + VMParameter.getVMParameters() + "]");
        infos.add("   Total Memory:        [" + Basic.longToFormattedString(memoryFootprint.getTotalMemory() >> 10) + " KB]");
        infos.add("   Free  Memory:        [" + Basic.longToFormattedString(memoryFootprint.getFreeMemory() >> 10) + " KB]");
        infos.add("   Used  Memory:        [" + Basic.longToFormattedString(memoryFootprint.getUsedMemory() >> 10) + " KB]");
        infos.add("   Max. Used Memory:    [" + Basic.longToFormattedString(memoryFootprint.getMaxUsedMemory() >> 10) + " KB]");
        infos.add("   Local Host Info:     [" + Basic.getLocalHostName() + "/" + Basic.getLocalHostAddress() + "]");
        if (serverAddress != null) {
            infos.add("   Registration address:[" + serverAddress + "]");
        }
        infos.add("   HomeDirectory:       [" + LogHeaderProvider.getHomeDirectory() + "]");
        infos.add("");
        return infos;
    }

    private static void checkArgument(String argument) throws IllegalArgumentException {
        if (argument == null) {
            throw new IllegalArgumentException();
        }
    }

    private static String getHomeDirectory() {
        String sHomeDirectory;
        try {
            sHomeDirectory = new File(".").getCanonicalPath().trim();
        }
        catch (IOException ex) {
            sHomeDirectory = new File(".").getAbsolutePath().trim();
        }
        return sHomeDirectory;
    }
}

