/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

import de.seetec.v5.shared.VMParameter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExportVMMemoryParameters {
    public static VMParamsChangedStatus export() {
        return ExportVMMemoryParameters.export(null);
    }

    protected static VMParamsChangedStatus export(String vmParams) {
        String foundXmxParameter = null;
        Logger logger = LogManager.getLogger((String)ExportVMMemoryParameters.class.getName());
        String vmParameters = vmParams == null ? VMParameter.getVMParameters() : vmParams;
        try {
            if (!vmParameters.isEmpty()) {
                StringTokenizer tokenizer = new StringTokenizer(vmParameters);
                while (tokenizer.hasMoreTokens()) {
                    String parameter = tokenizer.nextToken();
                    if (!(parameter = parameter.trim()).startsWith("-Xmx")) continue;
                    foundXmxParameter = parameter;
                }
                if (foundXmxParameter != null) {
                    String oldContent = null;
                    if (new File("./memParams.dat").exists()) {
                        try {
                            oldContent = new String(Files.readAllBytes(Paths.get("./memParams.dat", new String[0])));
                        }
                        catch (Exception e) {
                            oldContent = null;
                        }
                    }
                    if (oldContent == null) {
                        try (PrintWriter out = new PrintWriter("./memParams.dat");){
                            out.print(foundXmxParameter);
                        }
                        return VMParamsChangedStatus.PARAMS_FILE_WRITTEN;
                    }
                    if (!(oldContent = oldContent.trim()).equals(foundXmxParameter)) {
                        try (PrintWriter out = new PrintWriter("./memParams.dat");){
                            out.print(foundXmxParameter);
                        }
                        return VMParamsChangedStatus.PARAMS_FILE_OVERWRITTEN;
                    }
                    return VMParamsChangedStatus.PARAMS_FILE_UNCHANGED;
                }
                if (ExportVMMemoryParameters.deleteVMParametersFile()) {
                    return VMParamsChangedStatus.PARAMS_NOT_SET_FILE_DELETED;
                }
                return VMParamsChangedStatus.PARAMS_NOT_SET;
            }
            if (ExportVMMemoryParameters.deleteVMParametersFile()) {
                return VMParamsChangedStatus.PARAMS_NOT_SET_FILE_DELETED;
            }
            return VMParamsChangedStatus.PARAMS_NOT_SET;
        }
        catch (IOException ioe) {
            logger.error("Error while processing file './memParams.dat': ", (Throwable)ioe);
            return VMParamsChangedStatus.ERROR;
        }
        catch (Exception ioe) {
            logger.error("Error while processing memory parameters: " + ioe.getMessage());
            return VMParamsChangedStatus.ERROR;
        }
    }

    private static boolean deleteVMParametersFile() {
        if (new File("./memParams.dat").exists()) {
            new File("./memParams.dat").delete();
            return true;
        }
        return false;
    }

    public static enum VMParamsChangedStatus {
        PARAMS_NOT_SET,
        PARAMS_FILE_WRITTEN,
        PARAMS_FILE_OVERWRITTEN,
        PARAMS_FILE_UNCHANGED,
        PARAMS_NOT_SET_FILE_DELETED,
        ERROR;

    }
}

