/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

import de.seetec.v5.shared.EntityType;
import de.seetec.v5.shared.interaction.EntityTypeDataObject;
import de.seetec.v5.shared.tree.Tree;
import de.seetec.v5.shared.tree.TreeNode;
import de.seetec.v5.shared.util.SeeTecException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class EntityTypeMgr
extends Tree<EntityTypeDataObject> {
    private static final long serialVersionUID = 5671775775624546240L;
    private int numberOfFoundTypes = 0;

    public EntityTypeMgr() throws SeeTecException {
        this(EntityType.class);
    }

    public EntityTypeMgr(Class<?> interfaceContainingTypes) throws SeeTecException {
        Field[] fields;
        HashMap<Long, EntityTypeDataObject> htFoundTypes = new HashMap<Long, EntityTypeDataObject>();
        if (interfaceContainingTypes == null) {
            throw new SeeTecException(-20002, "Parameter to start EntityTypeMgr was null.");
        }
        for (Field field : fields = interfaceContainingTypes.getFields()) {
            if (!field.getName().contains("ENT_ENTITYTYPE_")) continue;
            try {
                long parent;
                long id = (Long)field.get(this);
                if (id == 0L) {
                    parent = Long.MIN_VALUE;
                } else if (id < 100L) {
                    parent = 0L;
                } else if (id >= 100L && id < 199L || id >= 200L && id < 299L || id >= 2000L && id < 2100L || id >= 2100L && id < 2200L) {
                    parent = id / 100L;
                    parent *= 10L;
                } else {
                    parent = id >= 270010L && id < 270019L ? id / 10L : (id >= 200000L ? id / 100L : (id >= 9900L && id <= 9999L || id >= 9800L && id <= 9899L || id >= 3000L && id <= 3099L ? id / 100L : id / 10L));
                }
                htFoundTypes.put((Long)field.get(this), new EntityTypeDataObject(id, field.getName(), parent));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new SeeTecException(-20000, "Error while accessing fields: " + e.getMessage());
            }
        }
        if (htFoundTypes.isEmpty()) {
            throw new SeeTecException(-20000, "No EntityTypes found. Indicates implementation or scrambling error.");
        }
        this.numberOfFoundTypes = htFoundTypes.size();
        this.setRoot(new TreeNode(htFoundTypes.remove(0L), 0L));
        int counter = 0;
        while (htFoundTypes.size() > 0) {
            if (++counter > 20) {
                throw new SeeTecException(-20000, "Not all types inserted in 20 iterations. Aborting.");
            }
            Iterator e = htFoundTypes.values().iterator();
            while (e.hasNext()) {
                EntityTypeDataObject tmpElement = (EntityTypeDataObject)e.next();
                int old = this.getSize();
                this.insertIntoTree(tmpElement, tmpElement.getID(), tmpElement.getParent());
                if (old != this.getSize() - 1) continue;
                e.remove();
            }
        }
        if (this.numberOfFoundTypes != this.getSize()) {
            throw new SeeTecException(-20000, "Number of found types unequal the number of types in tree. CHECK THE PARENT CONDITIONS.");
        }
    }

    public boolean isTypeExisting(long type) {
        return this.getNodes().containsKey(Long.toString(type));
    }

    public Tree<EntityTypeDataObject> getPartialTree(long type) throws SeeTecException {
        Tree<EntityTypeDataObject> partialTree = this.getPartialTree(this.getRoot(), type);
        if (partialTree == null) {
            throw new SeeTecException(-50409, "Given type '" + type + "' unknwon.");
        }
        return partialTree;
    }

    private Tree<EntityTypeDataObject> getPartialTree(TreeNode<EntityTypeDataObject> node, long type) {
        if (node != null) {
            if (type == node.getData().getID()) {
                return new Tree<EntityTypeDataObject>(node);
            }
            for (TreeNode<EntityTypeDataObject> child : node.getChildren()) {
                Tree<EntityTypeDataObject> tmpTree = this.getPartialTree(child, type);
                if (tmpTree == null) continue;
                return tmpTree;
            }
            return null;
        }
        return null;
    }

    public List<Long> getPartialTreeAsList(long type) {
        ArrayList<Long> typeList = new ArrayList<Long>();
        Tree<EntityTypeDataObject> partialTree = this.getPartialTree(this.getRoot(), type);
        if (partialTree != null) {
            for (TreeNode<EntityTypeDataObject> value : partialTree.getNodes().values()) {
                typeList.add(value.getData().getID());
            }
        }
        return typeList;
    }

    public int getNumberOfFoundTypes() {
        return this.numberOfFoundTypes;
    }
}

