/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.VMParameter;
import de.seetec.v5.shared.util.SeeTecValidationEventHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public abstract class Basic
implements SSLConstantsIntf {
    public static final String VM_PARAMETERS_FILE = "./memParams.dat";
    private static final String TAG_ROOT = "root";
    private static final String TAG_ROOT_OPEN = "<root>";
    private static final String TAG_ROOT_CLOSE = "</root>";
    private volatile Map<String, String> htShutdown = new Hashtable<String, String>();
    private volatile Map<String, String> htThreadAlive = new Hashtable<String, String>();
    private static Long uidCounter = -1L;
    public static final ConcurrentMap<Class<?>, JAXBContext> contextCache = new ConcurrentHashMap();

    public abstract int shutdown();

    public final boolean isShutdown(String sClassName) {
        return this.htShutdown.get(sClassName) != null;
    }

    protected final boolean startShutdown(String sClassName) {
        if (this.isShutdown(sClassName)) {
            return true;
        }
        this.htShutdown.put(sClassName, sClassName);
        return false;
    }

    protected final void setRunFinished(String sClassName, boolean bFlag) {
        if (bFlag) {
            this.htThreadAlive.remove(sClassName);
        } else {
            this.htThreadAlive.put(sClassName, sClassName);
        }
    }

    public final boolean isRunFinished(String sClassName) {
        return this.htThreadAlive.get(sClassName) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createInt8UID(SystemTimeProvider timeProvider) {
        Long l = uidCounter;
        synchronized (l) {
            uidCounter = uidCounter + 1L;
            return Math.abs(((timeProvider.currentTimeMillis() & 0x7FFFFFFFFFL) << 24) + (timeProvider.nanoTime() & 0xFFFFFFFFFFFFFFFFL) + uidCounter);
        }
    }

    protected final void doDelayBreakedByShutdown(String className, long delay) {
        long tsStart = System.currentTimeMillis();
        long tsFinish = tsStart + delay;
        while (!this.isShutdown(className) && tsStart <= System.currentTimeMillis() && tsFinish > System.currentTimeMillis()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static String getLastChange(String className) {
        String NOT_AVAILABLE = "n/a";
        long fileLastModified = 0L;
        String lastChange = "n/a";
        Logger logger = LogManager.getLogger((String)"de.seetec.v5.shared.SSLConstantsIntf");
        try {
            String classNameAsPath = "/" + className.replace('.', '/') + ".class";
            URL url = Class.forName(className).getResource(classNameAsPath);
            if (url.getProtocol().equalsIgnoreCase("file")) {
                File file = new File(url.getFile());
                fileLastModified = file.lastModified();
            } else if (url.getProtocol().equalsIgnoreCase("jar")) {
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                fileLastModified = conn.getJarEntry().getTime();
            }
            lastChange = new Date(fileLastModified).toString();
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
        return lastChange;
    }

    public static String longToFormattedString(Integer nNumber) {
        if (nNumber == null) {
            return "#undefined#";
        }
        return Basic.longToFormattedString((long)nNumber.intValue());
    }

    public static String longToFormattedString(Long nNumber) {
        if (nNumber == null) {
            return "#undefined#";
        }
        return Basic.longToFormattedString((long)nNumber);
    }

    public static String longToFormattedString(long nNumber) {
        return String.format(Locale.GERMANY, "%,d", nNumber);
    }

    public static String getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String[] getJavaVMInformation() {
        String VM_PREFIX = "Java VM";
        String[] javaVMInformation = new String[]{"Java VM: " + System.getProperty("java.vm.name"), "Java VM version: " + System.getProperty("java.version"), "Java VM parameter: " + VMParameter.getVMParameters()};
        return javaVMInformation;
    }

    public static byte[] int4ToByteArray(int n) {
        byte[] result = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        return result;
    }

    public static byte[] int4ToByteArray(int nNumber, int nSize) {
        int nBitShift = 0;
        byte[] result = new byte[nSize];
        for (int i = nSize - 1; i >= 0; --i) {
            result[i] = (byte)(nNumber >>> nBitShift);
            nBitShift += 8;
        }
        return result;
    }

    public static int int4ToByteArray(int nNumber, byte[] array, int nOffset, int nSize) {
        for (int i = 0; i < nSize; ++i) {
            array[nOffset + i] = (byte)(nNumber << i * 8 >> (nSize - 1) * 8);
        }
        return 0;
    }

    public static byte[] int8ToByteArray(long n) {
        byte[] result = new byte[]{(byte)(n >>> 56), (byte)(n >>> 48), (byte)(n >>> 40), (byte)(n >>> 32), (byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        return result;
    }

    public static byte[] int8ToByteArray(long nNumber, int nSize) {
        int nBitShift = 0;
        byte[] result = new byte[nSize];
        for (int i = nSize - 1; i >= 0; --i) {
            result[i] = (byte)(nNumber >>> nBitShift);
            nBitShift += 8;
        }
        return result;
    }

    public static int int8ToByteArray(long nNumber, byte[] array, int nOffset, int nSize) {
        for (int i = 0; i < nSize; ++i) {
            array[nOffset + i] = (byte)(nNumber << i * 8 >> (nSize - 1) * 8);
        }
        return 0;
    }

    public static int byteArrayToInt4(byte[] array) {
        return Basic.byteArrayToInt4(array, 0, array.length);
    }

    public static int byteArrayToInt4(byte[] array, int nOffset, int nSize) {
        int nResult = 0;
        if (array[0] < 0) {
            nResult = -1;
        }
        for (int i = 0; i < nSize; ++i) {
            nResult = (nResult << 8) + (array[nOffset + i] & 0xFF);
        }
        return nResult;
    }

    public static long byteArrayToInt8(byte[] array) {
        return Basic.byteArrayToInt8(array, 0, array.length);
    }

    public static long byteArrayToInt8(byte[] array, int nOffset, int nSize) {
        long nResult = 0L;
        if (array[nOffset] < 0) {
            nResult = -1L;
        }
        for (int i = 0; i < nSize; ++i) {
            nResult = (nResult << 8) + (long)(array[nOffset + i] & 0xFF);
        }
        return nResult;
    }

    public static String byteArrayToHexString(byte[] array) {
        return Basic.byteArrayToHexString(array, 0, array.length);
    }

    public static String byteArrayToHexString(byte[] array, int nOffset, int nLength) {
        if (nOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset negative");
        }
        char[] tokens = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder sbHex = new StringBuilder(array.length << 1);
        for (int i = nOffset; i < array.length && i < nOffset + nLength; ++i) {
            int high = array[i] >> 4 & 0xF;
            int low = array[i] & 0xF;
            sbHex.append(tokens[high]);
            sbHex.append(tokens[low]);
        }
        return sbHex.toString();
    }

    public static byte[] hexStringToByteArray(String sHexString) {
        char[] tokens = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String s = sHexString.trim().toUpperCase();
        if (s.length() % 2 > 0) {
            s = "0" + s;
        }
        byte[] result = new byte[s.length() >> 1];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < tokens.length; ++j) {
                if (s.charAt(i * 2) == tokens[j]) {
                    result[i] = (byte)(result[i] | j << 4);
                }
                if (s.charAt(i * 2 + 1) != tokens[j]) continue;
                result[i] = (byte)(result[i] | j);
            }
        }
        return result;
    }

    public static int indexOfByteArray(byte[] buffer, byte[] boundary, int nOffset) {
        return Basic.indexOfByteArray(buffer, boundary, nOffset, Integer.MIN_VALUE, false);
    }

    public static int indexOfByteArray(byte[] buffer, byte[] boundary, int nOffset, boolean returnIndexBeforePattern) {
        return Basic.indexOfByteArray(buffer, boundary, nOffset, Integer.MIN_VALUE, returnIndexBeforePattern);
    }

    public static int indexOfByteArray(byte[] buffer, byte[] boundary, int nOffset, int nLength) {
        return Basic.indexOfByteArray(buffer, boundary, nOffset, nLength, false);
    }

    public static int indexOfByteArray(byte[] buffer, byte[] boundary, int nOffset, int nLength, boolean returnIndexBeforePattern) {
        int nMaxPosition = nLength != Integer.MIN_VALUE ? nOffset + nLength - boundary.length : buffer.length - boundary.length;
        for (int nIndex = nOffset; nIndex <= nMaxPosition; ++nIndex) {
            boolean bFound = true;
            for (int j = 0; j < boundary.length; ++j) {
                if (buffer[nIndex + j] == boundary[j]) continue;
                bFound = false;
                break;
            }
            if (!bFound) continue;
            if (returnIndexBeforePattern) {
                return nIndex;
            }
            return nIndex + boundary.length;
        }
        return -1;
    }

    public static <T> T unmarshalXML(Class<T> clazz, Object xml) throws SAXException, JAXBException {
        return Basic.unmarshalXML(clazz, xml, false);
    }

    public static <T> T unmarshalXML(Class<T> clazz, Object xml, boolean doValidation) throws SAXException, JAXBException {
        Logger logger = LogManager.getLogger((String)"de.seetec.v5.shared.SSLConstantsIntf");
        if (clazz == null || xml == null) {
            return null;
        }
        JAXBContext context = (JAXBContext)contextCache.get(clazz);
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            contextCache.put(clazz, context);
        }
        Unmarshaller um = context.createUnmarshaller();
        if (doValidation) {
            Schema schema = null;
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                String xsdNameAsPath = "/" + clazz.getCanonicalName().replace('.', '/') + ".xsd";
                URL url = Class.forName(clazz.getCanonicalName()).getResource(xsdNameAsPath);
                if (url.getProtocol().equalsIgnoreCase("file")) {
                    File file = new File(url.getFile());
                    schema = sf.newSchema(file);
                } else if (url.getProtocol().equalsIgnoreCase("jar")) {
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    schema = sf.newSchema(conn.getURL());
                }
            }
            catch (Exception e) {
                logger.error("Error while validating object.", (Throwable)e);
                return null;
            }
            um.setSchema(schema);
            um.setEventHandler((ValidationEventHandler)new SeeTecValidationEventHandler());
        }
        Object obj = null;
        if (xml instanceof String) {
            obj = um.unmarshal((Reader)new StringReader((String)xml));
        } else if (xml instanceof byte[]) {
            obj = um.unmarshal((InputStream)new ByteArrayInputStream((byte[])xml));
        } else if (xml instanceof File) {
            try (FileInputStream stream = new FileInputStream((File)xml);){
                obj = um.unmarshal((InputStream)stream);
            }
            catch (IOException fnfe) {
                throw new JAXBException("File not found: " + xml);
            }
        }
        try {
            return clazz.cast(obj);
        }
        catch (ClassCastException exc) {
            logger.error("Error while casting object.", (Throwable)exc);
            return null;
        }
    }

    public static <T> String marshalXML(T data) throws SAXException, JAXBException, FileNotFoundException {
        if (data == null) {
            return null;
        }
        JAXBContext context = (JAXBContext)contextCache.get(data.getClass());
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{data.getClass()});
            contextCache.put(data.getClass(), context);
        }
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream sos = new ByteArrayOutputStream();
        m.marshal(data, (OutputStream)sos);
        return ((Object)sos).toString();
    }

    public static <T> byte[] marshalXMLToByteArray(T data) throws SAXException, JAXBException, FileNotFoundException {
        return Basic.marshalXML(data).getBytes();
    }

    public static <T> String marshalUTF8XML(T data) throws SAXException, JAXBException, FileNotFoundException {
        return Basic.marshalUTF8XML(data, null);
    }

    public static <T> String marshalUTF8XML(T data, String fileName) throws SAXException, JAXBException, FileNotFoundException {
        String result = null;
        Logger logger = LogManager.getLogger((String)"de.seetec.v5.shared.SSLConstantsIntf");
        if (data != null) {
            JAXBContext context = (JAXBContext)contextCache.get(data.getClass());
            if (context == null) {
                context = JAXBContext.newInstance((Class[])new Class[]{data.getClass()});
                contextCache.put(data.getClass(), context);
            }
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            ByteArrayOutputStream sos = new ByteArrayOutputStream();
            if (fileName != null) {
                m.marshal(data, (OutputStream)new FileOutputStream(fileName));
            }
            m.marshal(data, (OutputStream)sos);
            try {
                result = sos.toString("UTF-8");
            }
            catch (Exception e) {
                logger.error("UnsupportedEncoding while marshalling: " + e.getMessage());
            }
        }
        return result;
    }

    public static String addRootTag(byte[] data) throws NullPointerException {
        if (data == null) {
            throw new NullPointerException();
        }
        return TAG_ROOT_OPEN + new String(data) + TAG_ROOT_CLOSE;
    }

    public static String cutOffRoot(String data) {
        return Basic.cutOffRoot(data, null, null);
    }

    public static String cutOffRoot(String data, String openTag, String closeTag) {
        int start;
        if (data == null) {
            return null;
        }
        if (openTag == null && closeTag == null) {
            openTag = TAG_ROOT_OPEN;
            closeTag = TAG_ROOT_CLOSE;
        }
        if (openTag != null && (start = data.indexOf(openTag)) != -1) {
            data = data.substring(start + openTag.length());
        }
        if (closeTag != null && (start = data.indexOf(closeTag)) != -1) {
            data = data.substring(0, start);
        }
        return data;
    }

    public static String generateIndentedMultiLineLog(String[] multiLine) {
        StringBuilder result = new StringBuilder();
        if (multiLine != null && multiLine.length >= 1) {
            int maxLineLength = 0;
            result.append("\r\n");
            for (String singleLine : multiLine) {
                maxLineLength = singleLine.length() > maxLineLength ? singleLine.length() : maxLineLength;
                result.append("       ");
                result.append(singleLine);
                result.append("\r\n");
            }
            StringBuilder delimiter = new StringBuilder("       ");
            for (int i = 0; i < maxLineLength; ++i) {
                delimiter.append("=");
            }
            result.insert(0, delimiter.toString());
            result.insert(0, "\r\n");
            result.append(delimiter.toString());
        }
        return result.toString();
    }

    public static String generateIndentedMultiLineLog(List<String> multiLine) {
        if (multiLine != null && !multiLine.isEmpty()) {
            return Basic.generateIndentedMultiLineLog(multiLine.toArray(new String[multiLine.size()]));
        }
        return "";
    }

    public static String generateIndentedMultiLineLog(String singleLine) {
        if (singleLine != null && !singleLine.isEmpty()) {
            return Basic.generateIndentedMultiLineLog(new String[]{singleLine});
        }
        return "";
    }

    public static String getClassNameAndHash(Object c) {
        return c.getClass().getSimpleName() + "@" + Integer.toHexString(c.hashCode());
    }
}

