/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.SCRAMSHA256Authentication;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;

public class SCRAMSHA256AuthenticationV2
extends SCRAMSHA256Authentication {
    private byte[] m_ServerProofs = null;

    public SCRAMSHA256AuthenticationV2() {
        this.m_MethodName = "SCRAMSHA256V2";
    }

    boolean needsLegacyPassword() {
        return false;
    }

    protected void createServerProofs(String pwd, boolean isUnicode) throws SQLException {
        this.m_ServerProofs = null;
        try {
            int numOfProofs = this.m_Salt.size();
            byte[] passwdByte = this.preprocessPassword(pwd, isUnicode);
            this.m_ServerProofs = new byte[1 + this.m_HashSize * numOfProofs];
            this.m_ServerProofs[0] = numOfProofs;
            for (int proof = 0; proof < numOfProofs; ++proof) {
                byte[] serverproof = this.createServerProof((byte[])this.m_Salt.get(proof), passwdByte, this.getClientChallenge(), this.getServerChallenge());
                System.arraycopy(serverproof, 0, this.m_ServerProofs, 1 + proof * this.m_HashSize, serverproof.length);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)"NoSuchAlgorithmException - algorithm \"SHA-256\" not supported by the java vm");
        }
    }

    private byte[] createServerProof(byte[] salt, byte[] password, byte[] clientChallenge, byte[] serverChallenge) throws NoSuchAlgorithmException {
        this.DumpHex("salt", salt);
        this.DumpHex("password", password);
        this.DumpHex("clientChallenge", clientChallenge);
        this.DumpHex("serverChallenge", serverChallenge);
        MessageDigest digest = MessageDigest.getInstance(this.m_DigestAlgo);
        byte[] saltedPwd = this.hmac(salt, password, digest);
        this.DumpHex("saltedPwd", saltedPwd);
        byte[] serverVerifier = this.hmac(salt, saltedPwd, digest);
        this.DumpHex("serverVerifier", serverVerifier);
        byte[] content = new byte[clientChallenge.length + salt.length + serverChallenge.length];
        System.arraycopy(clientChallenge, 0, content, 0, clientChallenge.length);
        System.arraycopy(salt, 0, content, clientChallenge.length, salt.length);
        System.arraycopy(serverChallenge, 0, content, clientChallenge.length + salt.length, serverChallenge.length);
        this.DumpHex("content", content);
        byte[] serverProof = this.hmac(content, serverVerifier, digest);
        this.DumpHex("serverProof", serverProof);
        return serverProof;
    }

    protected void evaluateServerFinalData(DataPartVariable input, Tracer tracer) throws SQLException {
        if (input != null && input.nextField()) {
            if (input.getCurrentFieldLen() == this.getMethodName().length()) {
                String methodName = input.getString(1, 0);
                if (this.getMethodName().equals(methodName)) {
                    if (input.nextField() && input.getCurrentFieldLen() == 1 && input.getBase().getInt1(input.getCurrentOffset()) == 1 && input.nextField() && input.getCurrentFieldLen() == this.m_HashSize) {
                        byte[] srvProof = input.getBase().getBytes(input.getCurrentOffset(), input.getCurrentFieldLen());
                        byte[] cmpProof = new byte[this.m_HashSize];
                        for (int proof = 0; proof < this.m_ServerProofs[0]; ++proof) {
                            System.arraycopy(this.m_ServerProofs, 1 + proof * this.m_HashSize, cmpProof, 0, this.m_HashSize);
                            if (!SCRAMSHA256AuthenticationV2.serverProofIsEqual(cmpProof, srvProof)) continue;
                            return;
                        }
                        throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverproofreceived");
                    }
                    throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat", (Object)Tracer.Hex2String(input.getBytes(0, input.size())));
                }
                throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat", (Object)Tracer.Hex2String(input.getBytes(0, input.size())));
            }
            throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat", (Object)Tracer.Hex2String(input.getBytes(0, input.size())));
        }
    }

    private static boolean serverProofIsEqual(byte[] sProof1, byte[] sProof2) {
        if (sProof1 == sProof2) {
            return true;
        }
        if (sProof1 == null || sProof2 == null) {
            return false;
        }
        int length = sProof1.length;
        if (sProof2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (sProof1[i] == sProof2[i]) continue;
            return false;
        }
        return true;
    }
}

