/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.SCRAMAuthentication;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;

public class SCRAMSHA256Authentication
extends SCRAMAuthentication {
    protected ArrayList m_Salt = new ArrayList();

    public SCRAMSHA256Authentication() {
        this.m_DigestAlgo = "SHA-256";
        this.m_HashSize = (byte)32;
        this.m_MethodName = "SCRAMSHA256";
    }

    boolean needsLegacyPassword() {
        return true;
    }

    byte[] evaluateServerFirstData(DataPartVariable vData, Tracer tracer) throws SQLException {
        this.modifyInternalSeed();
        DataPartVariable vd = new DataPartVariable((StructuredMem)new StructuredBytes(vData.getBase().getBytes(vData.getCurrentOffset(), vData.getCurrentFieldLen())), 1);
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
        }
        byte[] value = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        this.m_Salt.add(value);
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
        }
        while (true) {
            value = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
            if (!vd.nextField()) break;
            this.m_Salt.add(value);
        }
        this.m_ServerChallenge = value;
        this.modifyInternalSeed();
        return null;
    }

    protected byte[] preprocessPassword(String pwd, boolean isUnicode) throws SQLException {
        try {
            return pwd.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)"UnsupportedEncodingException - character set \"UTF-8\" not supported by the java vm");
        }
    }

    protected byte[] getClientFinalData(String pwd, boolean isUnicode) throws SQLException {
        this.createServerProofs(pwd, isUnicode);
        try {
            byte[] passwdByte = this.preprocessPassword(pwd, isUnicode);
            byte[] erg = new byte[2 + (this.m_HashSize + 1) * this.m_Salt.size()];
            erg[0] = 0;
            erg[1] = (byte)this.m_Salt.size();
            for (int salt = 0; salt < this.m_Salt.size(); ++salt) {
                byte[] clientproof = this.createClientFinalData((byte[])this.m_Salt.get(salt), passwdByte, this.getClientChallenge(), this.getServerChallenge());
                erg[2 + salt * (this.m_HashSize + 1)] = this.m_HashSize;
                System.arraycopy(clientproof, 0, erg, 2 + (salt + 1) * 1 + salt * this.m_HashSize, clientproof.length);
            }
            return erg;
        }
        catch (NoSuchAlgorithmException ex) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)"NoSuchAlgorithmException - algorithm \"SHA-256\" not supported by the java vm");
        }
    }

    protected void createServerProofs(String pwd, boolean isUnicode) throws SQLException {
    }

    protected void evaluateServerFinalData(DataPartVariable input, Tracer tracer) throws SQLException {
    }
}

