/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.SCRAMAuthentication;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;

public class SCRAMMD5Authentication
extends SCRAMAuthentication {
    private byte[] m_Salt;
    private int m_MaxpasswordLen = 0;

    public SCRAMMD5Authentication() {
        this.m_DigestAlgo = "MD5";
        this.m_HashSize = (byte)16;
        this.m_MethodName = "SCRAMMD5";
    }

    boolean needsLegacyPassword() {
        return true;
    }

    public void parseServerChallenge(byte[] vData) throws SQLException {
        this.modifyInternalSeed();
        DataPartVariable vd = new DataPartVariable((StructuredMem)new StructuredBytes(vData), 1);
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)Tracer.Hex2String(vData));
        }
        this.m_Salt = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)Tracer.Hex2String(vData));
        }
        this.m_ServerChallenge = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        this.modifyInternalSeed();
    }

    byte[] evaluateServerFirstData(DataPartVariable vData, Tracer tracer) throws SQLException {
        this.modifyInternalSeed();
        if (vData.getCurrentFieldLen() == 40) {
            this.m_Salt = vData.getBase().getBytes(vData.getCurrentOffset(), 8);
            this.m_ServerChallenge = vData.getBase().getBytes(vData.getCurrentOffset() + 8, vData.getCurrentFieldLen() - 8);
        } else {
            DataPartVariable vd = new DataPartVariable((StructuredMem)new StructuredBytes(vData.getBase().getBytes(vData.getCurrentOffset(), vData.getCurrentFieldLen())), 1);
            if (!vd.nextField()) {
                throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
            }
            this.m_Salt = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
            if (!vd.nextField()) {
                throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
            }
            this.m_ServerChallenge = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
            if (vData.nextField()) {
                DataPartVariable mp_vd = new DataPartVariable((StructuredMem)new StructuredBytes(vData.getBase().getBytes(vData.getCurrentOffset(), vData.getCurrentFieldLen())), 1);
                if (!mp_vd.nextField()) {
                    throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
                }
                do {
                    if (mp_vd.getBase().getString(mp_vd.getCurrentOffset(), mp_vd.getCurrentFieldLen()).equals("maxpasswordlen")) {
                        if (!mp_vd.nextField()) {
                            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
                        }
                        try {
                            this.m_MaxpasswordLen = Integer.parseInt(mp_vd.getBase().getString(mp_vd.getCurrentOffset(), mp_vd.getCurrentFieldLen()));
                        }
                        catch (NumberFormatException e) {
                            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
                        }
                    } else {
                        if (mp_vd.nextField()) continue;
                        throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
                    }
                } while (mp_vd.nextField());
            }
        }
        this.modifyInternalSeed();
        return null;
    }

    protected byte[] preprocessPassword(String pwd, boolean isUnicode) {
        if (0 != this.m_MaxpasswordLen && pwd.length() > this.m_MaxpasswordLen) {
            pwd = "";
        }
        if (isUnicode) {
            StructuredBytes pwdBytes = new StructuredBytes(pwd.length() * 2);
            pwdBytes.putBigUnicode(pwd.toCharArray(), 0, pwd.length() * 2);
            return pwdBytes.getBytes(0, pwdBytes.size());
        }
        return pwd.getBytes();
    }

    protected byte[] getClientFinalData(String pwd, boolean isUnicode) throws SQLException {
        try {
            byte[] passwdByte = this.preprocessPassword(pwd, isUnicode);
            return this.createClientFinalData(this.m_Salt, passwdByte, this.getClientChallenge(), this.getServerChallenge());
        }
        catch (NoSuchAlgorithmException ex) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", (Object)"NoSuchAlgorithmException - algorithm \"MD5\" not supported by the java vm");
        }
    }

    protected void evaluateServerFinalData(DataPartVariable input, Tracer tracer) throws SQLException {
    }
}

