/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.UserPassword;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.AbstractAuthenticationMethod;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;

public abstract class SCRAMAuthentication
extends AbstractAuthenticationMethod {
    protected static boolean m_DumpEnabled = false;
    protected byte[] m_ClientChallenge = null;
    protected byte[] m_ServerChallenge;
    protected String m_DigestAlgo;
    protected byte m_HashSize;
    protected String m_MethodName;
    private static long s_InternalSeed = 42L;

    protected abstract byte[] preprocessPassword(String var1, boolean var2) throws SQLException;

    protected abstract byte[] getClientFinalData(String var1, boolean var2) throws SQLException;

    public byte[] getServerChallenge() {
        return this.m_ServerChallenge;
    }

    public byte[] getClientFirstData() throws SQLException {
        return this.getClientChallenge();
    }

    public byte[] getClientFinalData(UserPassword userPassword) throws SQLException {
        if (userPassword.getPwd(this.needsLegacyPassword()) == null) {
            throw SQLExceptionSapDB.generateSQLException("error.nopassword");
        }
        this.modifyInternalSeed();
        byte[] clientProof = this.getClientFinalData(userPassword.getPwd(this.needsLegacyPassword()), userPassword.userAndPasswordIsNotAscii());
        return clientProof;
    }

    public String getMethodName() {
        return this.m_MethodName;
    }

    protected void modifyInternalSeed() {
        s_InternalSeed += System.currentTimeMillis();
    }

    protected byte[] getClientChallenge() throws SQLException {
        if (this.m_ClientChallenge == null) {
            this.m_ClientChallenge = this.createClientChallenge();
        }
        return this.m_ClientChallenge;
    }

    protected byte[] createClientFinalData(byte[] salt, byte[] password, byte[] clientChallenge, byte[] serverChallenge) throws NoSuchAlgorithmException {
        this.DumpHex("salt", salt);
        this.DumpHex("password", password);
        this.DumpHex("clientChallenge", clientChallenge);
        this.DumpHex("serverChallenge", serverChallenge);
        MessageDigest digest = MessageDigest.getInstance(this.m_DigestAlgo);
        byte[] saltedPwd = this.hmac(salt, password, digest);
        this.DumpHex("saltedPwd", saltedPwd);
        byte[] clientKey = digest.digest(saltedPwd);
        this.DumpHex("clientKey", clientKey);
        byte[] clientVerifier = digest.digest(clientKey);
        this.DumpHex("clientVerifier", clientVerifier);
        byte[] content = new byte[salt.length + serverChallenge.length + clientChallenge.length];
        System.arraycopy(salt, 0, content, 0, salt.length);
        System.arraycopy(serverChallenge, 0, content, salt.length, serverChallenge.length);
        System.arraycopy(clientChallenge, 0, content, salt.length + serverChallenge.length, clientChallenge.length);
        this.DumpHex("content", content);
        byte[] sharedKey = this.hmac(content, clientVerifier, digest);
        this.DumpHex("sharedKey", sharedKey);
        byte[] clientProof = new byte[sharedKey.length];
        for (int i = sharedKey.length - 1; i >= 0; --i) {
            clientProof[i] = (byte)(sharedKey[i] ^ clientKey[i]);
        }
        this.DumpHex("clientProof", clientProof);
        return clientProof;
    }

    protected byte[] hmac(byte[] data, byte[] key, MessageDigest digest) throws NoSuchAlgorithmException {
        int i;
        if (key.length > 64) {
            digest.update(key);
            key = digest.digest();
        }
        byte[] ipad = new byte[64];
        byte[] opad = new byte[64];
        for (i = 0; i < 64; ++i) {
            ipad[i] = 54;
            opad[i] = 92;
        }
        for (i = key.length - 1; i >= 0; --i) {
            int n = i;
            ipad[n] = (byte)(ipad[n] ^ key[i]);
            int n2 = i;
            opad[n2] = (byte)(opad[n2] ^ key[i]);
        }
        byte[] content = new byte[data.length + 64];
        System.arraycopy(ipad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        data = digest.digest(content);
        content = new byte[data.length + 64];
        System.arraycopy(opad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        return digest.digest(content);
    }

    protected void DumpHex(String text, byte[] bytearr) {
        if (m_DumpEnabled) {
            System.out.println(this.m_MethodName + " - " + text + ": " + Tracer.Hex2String(bytearr));
        }
    }

    private byte[] createClientChallenge() throws SQLException {
        byte[] clientChallenge = null;
        int retrycount = 10;
        while (null == clientChallenge) {
            clientChallenge = new byte[64];
            try {
                this.modifyInternalSeed();
                SecureRandom srnd = new SecureRandom();
                srnd.setSeed(System.currentTimeMillis());
                srnd.setSeed(Runtime.getRuntime().freeMemory());
                srnd.setSeed(Runtime.getRuntime().totalMemory());
                srnd.setSeed(s_InternalSeed);
                srnd.nextBytes(clientChallenge);
            }
            catch (Exception e) {
                clientChallenge = null;
                if (--retrycount > 0) continue;
                throw SQLExceptionSapDB.generateSQLException("error.connection.challengeresponserandombytes", (Object)e.toString());
            }
        }
        return clientChallenge;
    }
}

