/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.UserPassword;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.AbstractAuthenticationMethod;
import java.sql.SQLException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GSSAuthentication
extends AbstractAuthenticationMethod {
    static final int c_init = 0;
    static final int c_unestablished = 1;
    static final int c_established = 2;
    Oid m_krb5Oid;
    GSSManager m_manager;
    GSSContext m_context = null;
    byte[] m_finalData = null;
    int m_state;

    boolean needsLegacyPassword() {
        return false;
    }

    public GSSAuthentication(Tracer tracer) throws GSSException {
        if (tracer != null) {
            tracer.println("Property: java.security.auth.login.config=" + System.getProperty("java.security.auth.login.config", "not set"));
            tracer.println("Property: javax.security.auth.useSubjectCredsOnly=" + System.getProperty("javax.security.auth.useSubjectCredsOnly", "not set"));
        }
        this.m_manager = GSSManager.getInstance();
        this.m_krb5Oid = new Oid("1.2.840.113554.1.2.2");
        this.m_state = 0;
    }

    private byte[] reject() {
        return this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {0}});
    }

    byte[] evaluateServerFirstData(DataPartVariable input, Tracer tracer) throws SQLException {
        GSSCredential defaultCred = null;
        DataPartVariable vd = new DataPartVariable((StructuredMem)new StructuredBytes(input.getBytes(input.getCurrentOffset(), input.getCurrentFieldLen())), 1);
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat");
        }
        String kerneloid = vd.getBase().getString(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        if (!kerneloid.equals(this.m_krb5Oid.toString())) {
            if (tracer != null) {
                tracer.println("Reject GSS Authentication - wrong OID found " + kerneloid + " expected " + this.m_krb5Oid.toString());
            }
            return this.reject();
        }
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat");
        }
        byte commType = vd.getBase().getInt1(vd.getCurrentOffset());
        byte[] token = null;
        if (!vd.nextField()) {
            if (commType != 6) {
                throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat");
            }
        } else {
            token = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        }
        if (commType == 2) {
            if (!vd.nextField()) {
                throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat");
            }
            String plainServerName = vd.getBase().getString(vd.getCurrentOffset(), vd.getCurrentFieldLen());
            try {
                GSSName serverName = this.m_manager.createName(plainServerName, null);
                this.m_context = this.m_manager.createContext(serverName, this.m_krb5Oid, defaultCred, 0);
                this.m_context.requestMutualAuth(true);
                this.m_context.requestConf(true);
                this.m_context.requestInteg(true);
            }
            catch (Exception e) {
                if (tracer != null) {
                    tracer.println("Reject GSS Authentication");
                    tracer.traceException(e);
                }
                return this.reject();
            }
            token = new byte[]{};
        }
        if (commType == 4 || commType == 2) {
            try {
                token = this.m_context.initSecContext(token, 0, token.length);
            }
            catch (Exception e) {
                if (tracer != null) {
                    tracer.println("Reject GSS Authentication");
                    tracer.traceException(e);
                }
                return this.reject();
            }
            if (token == null) {
                if (tracer != null) {
                    tracer.print("Reject GSS Authentication due to protocol error");
                }
                return this.reject();
            }
            if (this.m_context.isEstablished()) {
                return this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {5}, token});
            }
            return this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {3}, token});
        }
        if (commType == 6) {
            if (token == null) {
                this.m_finalData = this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {5}});
                return null;
            }
            try {
                token = this.m_context.initSecContext(token, 0, token.length);
            }
            catch (Exception e) {
                if (tracer != null) {
                    tracer.println("Reject GSS Authentication");
                    tracer.traceException(e);
                }
                return this.reject();
            }
            if (this.m_context.isEstablished()) {
                this.m_finalData = token == null ? this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {5}}) : this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {5}, token});
                return null;
            }
            if (tracer != null) {
                tracer.println("Reject GSS Authentication - communocation type 6 but not established");
            }
            return this.reject();
        }
        if (tracer != null) {
            tracer.println("Reject GSS Authentication - no suitable communication type");
        }
        return this.reject();
    }

    byte[] getClientFinalData(UserPassword userPassword) throws SQLException {
        if (this.m_finalData != null) {
            return this.m_finalData;
        }
        throw SQLExceptionSapDB.generateSQLException("error.connection.gssauthenticationerror", (Object)"GSS Protokoll error, context is still unestablished.");
    }

    String getMethodName() {
        return "GSS";
    }

    private byte[] pack(byte[][] chunks) {
        int length_pos = 2;
        for (int i = 0; i < chunks.length; ++i) {
            int chunkLen = chunks[i].length;
            length_pos += chunkLen;
            length_pos += chunkLen <= 250 ? 1 : 3;
        }
        StructuredBytes part = new StructuredBytes(length_pos);
        part.putInt2(chunks.length, 0);
        length_pos = 2;
        for (int i = 0; i < chunks.length; ++i) {
            int chunkLen = chunks[i].length;
            if (chunkLen <= 250) {
                part.putInt1(chunkLen, length_pos++);
            } else {
                part.putInt1(255, length_pos++);
                part.putInt2(chunkLen, length_pos);
                length_pos += 2;
            }
            part.putBytes(chunks[i], length_pos);
            length_pos += chunkLen;
        }
        return part.bytes();
    }

    byte[] getClientFirstData() throws SQLException {
        try {
            GSSCredential clientCredential = this.m_manager.createCredential(1);
            GSSName client = clientCredential.getName().canonicalize(this.m_krb5Oid);
            Oid typeOID = client.getStringNameType();
            return this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {1}, typeOID.toString().getBytes(), ((Object)client).toString().getBytes()});
        }
        catch (GSSException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.gssauthenticationerror", (Object)e.toString());
        }
        catch (Exception e) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.gssauthenticationerror", (Object)e.toString());
        }
    }

    protected void evaluateServerFinalData(DataPartVariable input, Tracer tracer) throws SQLException {
    }
}

