/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.UserPassword;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.AbstractAuthenticationMethod;
import com.sap.dbtech.util.security.AuthenticationManager;
import java.sql.SQLException;

public class AuthenticationManagerOI
extends AuthenticationManager {
    protected UserPassword m_UserPassword;

    public AuthenticationManagerOI(ConnectionSapDB conn, UserPassword userPassword) throws SQLException {
        this.m_UserPassword = userPassword;
        this.fillAuthMethodList(userPassword, conn.tracer);
    }

    public void SendFirstClientMessage(ConnectionSapDB conn) throws SQLException {
        RequestPacket reqPckg = conn.getRequestPacket(this.m_UserPassword.userAndPasswordIsNotAscii());
        boolean errorOccured = false;
        do {
            int index = 0;
            DataPartVariable dataPart = reqPckg.initAuthenticationMethodRequest(this.m_UserPassword.getRawEscapedUser());
            dataPart.addArg(0, 0);
            dataPart.addRow(2 * this.m_authMethods.size());
            errorOccured = false;
            for (index = 0; index < this.m_authMethods.size() && !errorOccured; ++index) {
                Object obj = this.m_authMethods.get(index);
                AbstractAuthenticationMethod method = (AbstractAuthenticationMethod)obj;
                try {
                    dataPart.putBytes(method.getMethodName().getBytes(), dataPart.getCurrentOffset());
                    dataPart.putBytes(method.getClientFirstData(), dataPart.getCurrentOffset());
                    continue;
                }
                catch (SQLException e) {
                    conn.tracer.println("Reject authentication method " + method.getMethodName());
                    conn.tracer.traceException(e);
                    this.m_authMethods.remove(index);
                    errorOccured = true;
                    if (this.m_authMethods.size() != 0) continue;
                    conn.freeRequestPacket(reqPckg);
                    throw new SQLException(MessageTranslator.translate("error.connection.noauthenticationmethodavailable"), "08001", -11111);
                }
            }
            if (errorOccured) continue;
            dataPart.close();
        } while (errorOccured);
        byte[] data = null;
        do {
            ReplyPacket replPckg;
            DataPartVariable vData;
            if ((vData = (replPckg = conn.execute(reqPckg, this, 2)).getVarDataPart()) == null || !vData.nextField()) {
                throw SQLExceptionSapDB.generateSQLException("error.connection.noauthenticationmethodavailable");
            }
            String methodName = vData.getString(1, 0);
            if (!vData.nextField() || vData.getCurrentFieldLen() < 3) {
                throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat", (Object)Tracer.Hex2String(vData.getBytes(0, vData.size())));
            }
            for (int index = 0; index < this.m_authMethods.size() && !errorOccured; ++index) {
                this.m_method = (AbstractAuthenticationMethod)this.m_authMethods.get(index);
                if (this.m_method.getMethodName().equals(methodName)) break;
            }
            if ((data = this.m_method.evaluateServerFirstData(vData, conn.tracer)) == null) continue;
            reqPckg = conn.getRequestPacket(this.m_UserPassword.userAndPasswordIsNotAscii());
            DataPartVariable dpOutput = reqPckg.initAuthenticationMethodRequest(this.m_UserPassword.getRawEscapedUser());
            dpOutput.addArg(0, 0);
            dpOutput.addRow(2);
            dpOutput.putBytes(methodName.getBytes(), dpOutput.getCurrentOffset());
            dpOutput.putBytes(data, dpOutput.getCurrentOffset());
            dpOutput.close();
        } while (data != null);
    }

    public void addClientFinalDataToNewDataPart(RequestPacket requestPacket, Tracer tracer) throws SQLException {
        DataPartVariable data = (DataPartVariable)requestPacket.newDataPart(true);
        data.addRow(3);
        if (this.m_UserPassword.userAndPasswordIsNotAscii()) {
            char[] userArray = this.m_UserPassword.getUser().toCharArray();
            data.putBigUnicode(userArray, data.getExtent(), userArray.length * 2);
        } else {
            data.putString(this.m_UserPassword.getUser(), data.getExtent());
        }
        data.addArg(data.getExtent(), 0);
        data.putString(this.m_method.getMethodName(), data.getExtent());
        data.addArg(data.getExtent(), 0);
        data.putBytes(this.m_method.getClientFinalData(this.m_UserPassword), data.getExtent());
        data.addArg(data.getExtent(), 0);
        data.close();
    }

    public void checkServerFinalData(ReplyPacket replyPacket, Tracer tracer) throws SQLException {
        this.m_method.evaluateServerFinalData(replyPacket.getVarDataPart(), tracer);
    }
}

