/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.UserPassword;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.AbstractAuthenticationMethod;
import com.sap.dbtech.util.security.AuthenticationManager;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Arrays;

public class AuthenticationManagerDBM
extends AuthenticationManager {
    protected UserPassword m_UserPassword;

    public AuthenticationManagerDBM(DBM conn, UserPassword userPassword) throws SQLException {
        this.m_UserPassword = userPassword;
        this.fillAuthMethodList(userPassword, conn.getTracer());
    }

    public void sendFirstConnectCmd(DBM conn) throws SQLException, RTEException, DBMException {
        StringBuffer reqPckg = new StringBuffer();
        boolean errorOccured = false;
        do {
            int index = 0;
            char delimiter = ' ';
            reqPckg.append("USER_GETCHALLENGE " + this.m_UserPassword.getUser() + " METHODS");
            errorOccured = false;
            for (index = 0; index < this.m_authMethods.size() && !errorOccured; ++index) {
                Object obj = this.m_authMethods.get(index);
                AbstractAuthenticationMethod method = (AbstractAuthenticationMethod)obj;
                try {
                    reqPckg.append(delimiter);
                    reqPckg.append(method.getMethodName());
                    reqPckg.append(" ");
                    reqPckg.append(Tracer.Hex2String(method.getClientFirstData()).toUpperCase());
                    reqPckg.append(" ");
                    continue;
                }
                catch (SQLException e) {
                    conn.trace("Reject authentication method " + method.getMethodName());
                    conn.traceException(e);
                    this.m_authMethods.remove(index);
                    reqPckg = new StringBuffer();
                    errorOccured = true;
                    if (this.m_authMethods.size() != 0) continue;
                    throw new SQLException(MessageTranslator.translate("error.connection.noauthenticationmethodavailable"), "08001", -11111);
                }
            }
        } while (errorOccured);
        byte[] data = null;
        do {
            String replPckg;
            int pos;
            if ((pos = (replPckg = conn.cmd(reqPckg.toString())).indexOf(32)) == -1 && (pos = replPckg.indexOf(10)) == -1) {
                throw SQLExceptionSapDB.generateSQLException("error.connection.noauthenticationmethodavailable");
            }
            String methodName = replPckg.substring(0, pos);
            while (replPckg.charAt(pos) == ' ' || replPckg.charAt(pos) == '\n') {
                ++pos;
            }
            if (replPckg.length() - pos < 8) {
                throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat", (Object)replPckg);
            }
            replPckg = replPckg.substring(pos, replPckg.length() - 1);
            for (int index = 0; index < this.m_authMethods.size() && !errorOccured; ++index) {
                this.m_method = (AbstractAuthenticationMethod)this.m_authMethods.get(index);
                if (this.m_method.getMethodName().equals(methodName)) break;
            }
            byte[] prefix = new byte[]{0, 1, 0};
            byte[] tail = Tracer.String2Hex(replPckg);
            prefix[2] = (byte)tail.length;
            byte[] packet = new byte[prefix.length + tail.length];
            System.arraycopy(prefix, 0, packet, 0, prefix.length);
            System.arraycopy(tail, 0, packet, prefix.length, tail.length);
            DataPartVariable vData = new DataPartVariable((StructuredMem)new StructuredBytes(packet), 1);
            vData.nextField();
            data = this.m_method.evaluateServerFirstData(vData, conn.getTracer());
            if (data == null) continue;
            reqPckg = new StringBuffer();
            reqPckg.append("USER_GETCHALLENGE " + this.m_UserPassword.getUser() + " METHODS ");
            reqPckg.append(methodName);
            reqPckg.append(" ");
            reqPckg.append(Tracer.Hex2String(data).toUpperCase());
        } while (data != null);
    }

    public String sendFinalConnectCmd(DBM conn) throws SQLException, RTEException, DBMException {
        String cmd = "USER_RESPONSE " + this.m_method.getMethodName() + " " + Tracer.Hex2String(this.m_method.getClientFinalData(this.m_UserPassword)).toUpperCase();
        String result = conn.cmd(cmd, false);
        result = result.trim();
        String[] values = result.split("(\r\n|\r|\n| )", -1);
        byte[] serverProofCnt = new byte[]{0};
        byte[] serverProof = new byte[]{0};
        byte[] method = String.valueOf("???").getBytes();
        if (3 == values.length) {
            method = values[0].trim().getBytes();
            serverProofCnt[0] = Integer.valueOf(values[1].trim()).byteValue();
            serverProof = AuthenticationManagerDBM.convertServerProofToBytes(values[2]);
        }
        int prefixLen = 2;
        int pos = 0;
        int fieldCnt = 3;
        byte[] packet = new byte[prefixLen + fieldCnt + method.length + 1 + serverProof.length];
        packet[pos] = 0;
        packet[pos + 1] = fieldCnt;
        packet[pos += prefixLen] = (byte)method.length;
        System.arraycopy(method, 0, packet, pos + 1, packet[pos]);
        pos += 1 + packet[pos];
        packet[pos] = (byte)serverProofCnt.length;
        System.arraycopy(serverProofCnt, 0, packet, pos + 1, packet[pos]);
        pos += 1 + packet[pos];
        packet[pos] = (byte)serverProof.length;
        System.arraycopy(serverProof, 0, packet, pos + 1, packet[pos]);
        pos += 1 + packet[pos];
        DataPartVariable vData = new DataPartVariable((StructuredMem)new StructuredBytes(packet), 1);
        this.m_method.evaluateServerFinalData(vData, conn.getTracer());
        return result;
    }

    private static byte[] convertServerProofToBytes(String valStr) {
        byte[] valBytes;
        try {
            valBytes = new BigInteger(valStr, 16).toByteArray();
            int len = valBytes.length;
            int bytesInStr = (valStr.length() + 1) / 2;
            if (len > bytesInStr) {
                int strip;
                for (strip = 0; strip < len - bytesInStr && 0 == valBytes[strip]; ++strip) {
                }
                return Arrays.copyOfRange(valBytes, strip, len);
            }
        }
        catch (NumberFormatException e) {
            valBytes = new byte[]{0};
        }
        return valBytes;
    }
}

