/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.UserPassword;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.AbstractAuthenticationMethod;
import com.sap.dbtech.util.security.GSSAuthentication;
import com.sap.dbtech.util.security.SCRAMMD5Authentication;
import com.sap.dbtech.util.security.SCRAMMD5AuthenticationV1;
import com.sap.dbtech.util.security.SCRAMSHA256Authentication;
import com.sap.dbtech.util.security.SCRAMSHA256AuthenticationV2;
import java.sql.SQLException;
import java.util.ArrayList;

public class AuthenticationManager {
    protected ArrayList m_authMethods = new ArrayList(2);
    protected AbstractAuthenticationMethod m_method;

    protected void fillAuthMethodList(UserPassword userPassword, Tracer tracer) throws SQLException {
        if (userPassword.getPwd(false).length() == 0) {
            try {
                GSSAuthentication gss = new GSSAuthentication(tracer);
                this.m_authMethods.add(gss);
            }
            catch (Exception e) {
                tracer.println("Reject GSS Authentication");
                throw new SQLException(MessageTranslator.translate("error.connection.gssauthenticationerror"), "08001", -11111);
            }
        } else {
            tracer.println("No GSS Authentication (password is not empty)");
        }
        SCRAMSHA256AuthenticationV2 scrammSHA256V2 = new SCRAMSHA256AuthenticationV2();
        this.m_authMethods.add(scrammSHA256V2);
        SCRAMSHA256Authentication scrammSHA256 = new SCRAMSHA256Authentication();
        this.m_authMethods.add(scrammSHA256);
        SCRAMMD5AuthenticationV1 scrammMD5v1 = new SCRAMMD5AuthenticationV1();
        this.m_authMethods.add(scrammMD5v1);
        SCRAMMD5Authentication scrammMD5 = new SCRAMMD5Authentication();
        this.m_authMethods.add(scrammMD5);
    }
}

