/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.rte.comm.BasicSocketComm;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.Tracer;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;

public class SocketComm
extends BasicSocketComm {
    public static final JdbcCommFactory factory = new JdbcCommFactory(){

        public JdbcCommunication open(String host, String dbname, Properties properties, Tracer tracer) throws RTEException {
            SocketComm sc = new SocketComm(host, properties, 0, tracer);
            sc.connectDB(dbname);
            return sc;
        }

        public JdbcCommunication xopen(String host, String db, String dbroot, String pgm, Properties properties, Tracer tracer) throws RTEException {
            SocketComm sc = new SocketComm(host, properties, 4, tracer);
            sc.connectAdmin(db, dbroot, pgm);
            return sc;
        }
    };

    protected SocketComm(String hostPort, Properties properties, int aServiceType, Tracer tracer) throws RTEException {
        super(hostPort, properties, aServiceType, tracer);
        this.openSocket();
    }

    protected void openSocket() throws RTEException {
        try {
            this.socket = new Socket(this.host, this.lookupPort());
            this._setSocketOptions(this.socket);
            this.instream = this.socket.getInputStream();
            this.outstream = this.socket.getOutputStream();
        }
        catch (UnknownHostException uhexc) {
            throw new RTEException(MessageTranslator.translate("error.unknown.host", this.host + ":" + this.port, uhexc.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 13, uhexc);
        }
        catch (IOException ioexc) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host + ":" + this.port, ioexc.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, ioexc);
        }
        try {
            this.socket.setSoLinger(true, 15);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    protected BasicSocketComm getNewCommunication() throws RTEException {
        return new SocketComm(this.host + ":" + this.port, null, this.m_serviceType, this.m_tracer);
    }

    protected int getDefaultPort() {
        return 7210;
    }

    protected boolean supportsInfoRequest() {
        return true;
    }
}

