/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.rte.comm.BasicSocketComm;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.SSLUtils;
import com.sap.dbtech.util.Tracer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class SecureCommunication
extends BasicSocketComm {
    public static final JdbcCommFactory factory = new JdbcCommFactory(){

        public JdbcCommunication open(String host, String dbname, Properties properties, Tracer tracer) throws RTEException {
            SecureCommunication sc = new SecureCommunication(host, properties, 0, tracer);
            sc.connectDB(dbname);
            return sc;
        }

        public JdbcCommunication xopen(String host, String db, String dbroot, String pgm, Properties properties, Tracer tracer) throws RTEException {
            SecureCommunication sc = new SecureCommunication(host, properties, 4, tracer);
            sc.connectAdmin(db, dbroot, pgm);
            return sc;
        }
    };
    private final boolean _validateCertificate;
    private final String _hostNameInCertificate;
    private final String _keyStore;
    private final String _keyStoreType;
    private final String _keyStorePasswd;
    private final String _trustStore;
    private final String _trustStoreType;
    private final String _trustStorePasswd;
    private final String _sniHostname;

    private SecureCommunication(String hostPort, Properties properties, int aServiceType, Tracer tracer) throws RTEException {
        super(hostPort, properties, aServiceType, tracer);
        this._validateCertificate = !DriverSapDB.getBooleanProperty(properties, "acceptServerCertAlways", false);
        this._hostNameInCertificate = DriverSapDB.getBooleanProperty(properties, "ignoreHostNameInCert", false) ? "*" : properties.getProperty("hostNameInCertificate");
        this._keyStore = properties.getProperty("keyStore");
        this._keyStoreType = properties.getProperty("keyStoreType");
        this._keyStorePasswd = properties.getProperty("keyStorePassword");
        this._trustStore = properties.getProperty("trustStore");
        this._trustStoreType = properties.getProperty("trustStoreType");
        this._trustStorePasswd = properties.getProperty("trustStorePassword");
        this._sniHostname = properties.getProperty("sniHostname");
        this.openSocket();
    }

    protected BasicSocketComm getNewCommunication() throws RTEException {
        return new SecureCommunication(this.host + ":" + this.port, null, this.m_serviceType, this.m_tracer);
    }

    protected int getDefaultPort() {
        return 7270;
    }

    protected boolean supportsInfoRequest() {
        return true;
    }

    protected void openSocket() throws RTEException {
        try {
            SSLSocketFactory factory;
            SSLContext sc;
            if (!this._validateCertificate) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                factory = sc.getSocketFactory();
            } else if (this._isSystemDefaultUsed()) {
                factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else {
                KeyManagerFactory kmf = this._getKeyManagerFactory(this.host);
                TrustManagerFactory tmf = this._getTrustManagerFactory(this.host);
                KeyManager[] km = null;
                TrustManager[] tm = null;
                if (kmf != null) {
                    km = kmf.getKeyManagers();
                }
                if (tmf != null) {
                    tm = tmf.getTrustManagers();
                }
                sc = SSLContext.getInstance("TLS");
                sc.init(km, tm, new SecureRandom());
                factory = sc.getSocketFactory();
            }
            this.socket = factory.createSocket(this.host, this.port);
            SSLSocket sslsocket = (SSLSocket)this.socket;
            sslsocket.setUseClientMode(true);
            ArrayList<String> protocols = new ArrayList<String>();
            String[] supportedProtocols = sslsocket.getSupportedProtocols();
            for (int i = 0; i < supportedProtocols.length; ++i) {
                if (!supportedProtocols[i].startsWith("TLS")) continue;
                protocols.add(supportedProtocols[i]);
            }
            sslsocket.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
            sslsocket.startHandshake();
            if (!"*".equals(this._hostNameInCertificate) && this._validateCertificate) {
                Certificate[] certs;
                try {
                    certs = sslsocket.getSession().getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException e) {
                    certs = new Certificate[]{};
                }
                if (certs.length == 0) {
                    SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.nocertificatefound");
                    throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, sqlex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
                }
                try {
                    X509Certificate x509cert = (X509Certificate)certs[0];
                    X500Principal principal = x509cert.getSubjectX500Principal();
                    String rfc2253name = principal.getName("RFC2253");
                    Collection<List<?>> alternativenames = x509cert.getSubjectAlternativeNames();
                    if (!SSLUtils.validateHostName(rfc2253name, alternativenames, this._hostNameInCertificate == null ? this.host : this._hostNameInCertificate)) {
                        SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.hostnameverificationfailed", (Object)rfc2253name, (Object)(this._hostNameInCertificate == null ? this.host : this._hostNameInCertificate));
                        throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, sqlex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
                    }
                }
                catch (ClassCastException e) {
                    SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.nox509certificate");
                    throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, sqlex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
                }
                catch (CertificateParsingException e) {
                    SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.nox509certificate");
                    throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, sqlex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
                }
            }
            this._setSocketOptions(this.socket);
            this.instream = this.socket.getInputStream();
            this.outstream = this.socket.getOutputStream();
        }
        catch (NoSuchAlgorithmException e) {
            SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.nosuchalgorithm", (Object)e.getMessage());
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, sqlex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
        }
        catch (KeyManagementException e) {
            SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.keymanagementexception", (Object)e.getMessage());
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, sqlex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
        }
        catch (UnknownHostException e) {
            throw new RTEException(MessageTranslator.translate("error.unknown.host", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 13, e);
        }
        catch (SSLHandshakeException e) {
            SQLException sqlex = e.getMessage().contains("PKIX path building failed") ? SQLExceptionSapDB.generateSQLException(e, "error.ssl.certificatepath", (Object)e.getMessage()) : SQLExceptionSapDB.generateSQLException(e, "error.ssl.handshake", (Object)e.getMessage());
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, sqlex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
        }
        catch (SSLException e) {
            SQLException sqlex = e.getMessage().contains("Received fatal alert: internal_error") ? SQLExceptionSapDB.generateSQLException(e, "error.ssl.nosslsupport", (Object)e.getMessage()) : SQLExceptionSapDB.generateSQLException(e, "error.ssl.handshake", (Object)e.getMessage());
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, sqlex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, sqlex);
        }
        catch (IOException e) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, e);
        }
    }

    private boolean _isSystemDefaultUsed() {
        return this._keyStore == null && this._keyStoreType == null && this._keyStorePasswd == null && this._trustStore == null && this._trustStorePasswd == null && this._trustStoreType == null;
    }

    private KeyManagerFactory _getKeyManagerFactory(String hostName) throws RTEException {
        String keyStoreFileName = this._getKeyStoreFileName();
        if (keyStoreFileName == null) {
            return null;
        }
        KeyManagerFactory kmf = null;
        KeyStore ks = null;
        FileInputStream fis = null;
        try {
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.keymanagerfactorynodefault", (Object)e.getMessage());
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
        }
        try {
            ks = KeyStore.getInstance(this._getKeyStoreType());
        }
        catch (KeyStoreException e) {
            SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.keystore.create", this._getKeyStoreType(), e.getMessage());
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, sqlex);
        }
        try {
            fis = new FileInputStream(keyStoreFileName);
            try {
                ks.load(fis, this._getKeyStorePasswd().toCharArray());
            }
            catch (NoSuchAlgorithmException e) {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.keystoreloadfailed.nosuchalgorithm", (Object)e.getMessage());
                throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, sqlex);
            }
            catch (CertificateException e) {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.keystoreloadfailed.certificate", (Object)e.getMessage());
                throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, sqlex);
            }
            catch (IOException e) {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.keystoreloadfailed.ioexception", (Object)e.getMessage());
                throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, sqlex);
            }
            try {
                kmf.init(ks, this._getKeyStorePasswd().toCharArray());
            }
            catch (KeyStoreException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, "Key manager initialization failed: " + e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, e);
            }
            catch (UnrecoverableKeyException e) {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.keymanagerfactory.unrecoverablekey", (Object)e.getMessage());
                throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, sqlex);
            }
            catch (NoSuchAlgorithmException e) {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.keymanagerfactory.nosuchalgorithm", (Object)e.getMessage());
                throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, sqlex);
            }
        }
        catch (FileNotFoundException e) {
            SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.keystorefilenotfound", (Object)e.getMessage());
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, sqlex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return kmf;
    }

    private TrustManagerFactory _getTrustManagerFactory(String hostName) throws RTEException {
        String trustStoreFileName = this._getTrustStoreFileName();
        if (trustStoreFileName == null) {
            return null;
        }
        TrustManagerFactory tmf = null;
        KeyStore ks = null;
        FileInputStream fis = null;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.trustmanagerfactorynodefault", (Object)e.getMessage());
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, sqlex);
        }
        try {
            ks = KeyStore.getInstance(this._getTrustStoreType());
        }
        catch (KeyStoreException e) {
            SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.truststore.create", (Object)e.getMessage());
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 5, sqlex);
        }
        try {
            fis = new FileInputStream(trustStoreFileName);
            try {
                String tspass = this._getTrustStorePasswd();
                ks.load(fis, tspass == null ? null : tspass.toCharArray());
            }
            catch (NoSuchAlgorithmException e) {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.truststoreloadfailed.nosuchalgorithm", (Object)e.getMessage());
                throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
            }
            catch (CertificateException e) {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.truststoreloadfailed.certificate", (Object)e.getMessage());
                throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
            }
            catch (IOException e) {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.truststoreloadfailed.ioexception", (Object)e.getMessage());
                throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
            }
            try {
                tmf.init(ks);
            }
            catch (KeyStoreException e) {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.trustmanagerfactory.keystore", (Object)e.getMessage());
                throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
            }
        }
        catch (FileNotFoundException e) {
            SQLException sqlex = SQLExceptionSapDB.generateSQLException(e, "error.ssl.truststorefilenotfound", (Object)e.getMessage());
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return tmf;
    }

    private String _getKeyStoreFileName() {
        if (this._keyStore == null) {
            return System.getProperty("javax.net.ssl.keyStore");
        }
        return this._keyStore;
    }

    private String _getKeyStoreType() {
        if (this._keyStoreType == null) {
            return "jks";
        }
        return this._keyStoreType;
    }

    private String _getKeyStorePasswd() {
        if (this._keyStorePasswd != null) {
            return this._keyStorePasswd;
        }
        String syspasswd = System.getProperty("javax.net.ssl.keyStorePassword");
        if (syspasswd != null) {
            return syspasswd;
        }
        return "";
    }

    private String _getTrustStoreFileName() {
        if (this._trustStore == null) {
            return System.getProperty("javax.net.ssl.trustStore");
        }
        return this._trustStore;
    }

    private String _getTrustStoreType() {
        if (this._trustStoreType == null) {
            return "jks";
        }
        return this._trustStoreType;
    }

    private String _getTrustStorePasswd() {
        if (this._trustStorePasswd != null) {
            return this._trustStorePasswd;
        }
        String syspasswd = System.getProperty("javax.net.ssl.trustStorePassword");
        return syspasswd;
    }
}

