/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.BinaryDataTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.VDNNumber;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

class NumericTranslator
extends BinaryDataTranslator {
    protected int frac;
    protected boolean isFloatingPoint = false;

    private DecimalFormat getDoubleInputFormat() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        DecimalFormat doubleInputFormat = DriverSapDB.currentVMVersion <= 1002999 ? new DecimalFormat("###############################################################.000000000000000000000000000000000000000000000000000000000000000", dfs) : new DecimalFormat("0.0000000000000000000000000000000000000E00", dfs);
        try {
            new BigDecimal(doubleInputFormat.format(0.0));
        }
        catch (ArithmeticException ex) {
            doubleInputFormat = new DecimalFormat("###############################################################.000000000000000000000000000000000000000000000000000000000000000", dfs);
        }
        doubleInputFormat.setGroupingSize(Integer.MAX_VALUE);
        return doubleInputFormat;
    }

    private DecimalFormat getDoubleInputFormatInstance() {
        DecimalFormat doubleInputFormat = (DecimalFormat)DecimalFormatHolder.INSTANCE.get();
        if (doubleInputFormat == null) {
            doubleInputFormat = this.getDoubleInputFormat();
            DecimalFormatHolder.INSTANCE.set(doubleInputFormat);
        }
        return doubleInputFormat;
    }

    private String formatDoubleInput(double value) {
        return this.getDoubleInputFormatInstance().format(value);
    }

    protected NumericTranslator(int mode, int ioType, int dataType, int len, int frac, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
        switch (dataType) {
            case 1: 
            case 12: {
                frac = 38;
                this.isFloatingPoint = true;
            }
        }
        this.frac = frac;
    }

    public BigDecimal getBigDecimal(int scale, SQLParamController controller, DataPart mem) throws SQLException {
        BigDecimal result = null;
        try {
            switch (this.checkDefineByte(controller, mem)) {
                case 1: {
                    return result;
                }
                case 2: {
                    throw SQLExceptionSapDB.generateSQLException("error.conversion.SpecialNullValue");
                }
            }
            result = VDNNumber.number2BigDecimal(mem.getBytesFillUp(this.bufpos_output, this.physicalLength - 1));
            result = result.setScale(scale, 6);
            return result;
        }
        catch (ArithmeticException exc) {
            throw this.newParseException(result + " scale: " + scale, null);
        }
    }

    public BigDecimal getBigDecimal(SQLParamController controller, DataPart mem) throws SQLException {
        BigDecimal result = null;
        try {
            switch (this.checkDefineByte(controller, mem)) {
                case 1: {
                    return result;
                }
                case 2: {
                    throw SQLExceptionSapDB.generateSQLException("error.conversion.SpecialNullValue");
                }
            }
            result = VDNNumber.number2BigDecimal(mem.getBytesFillUp(this.bufpos_output, this.physicalLength - 1));
            if (!this.isFloatingPoint) {
                result = result.setScale(this.frac, 6);
            }
            return result;
        }
        catch (ArithmeticException exc) {
            throw this.newParseException(result + " scale: " + this.frac, null);
        }
    }

    public boolean getBoolean(SQLParamController controller, DataPart mem) throws SQLException {
        int intResult = this.getInt(controller, mem);
        return intResult != 0;
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        return (byte)this.getLong(controller, mem);
    }

    public double getDouble(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return 0.0;
            }
            case 2: {
                return Double.NaN;
            }
        }
        return this.bigDecimal2Double(VDNNumber.number2BigDecimal(mem.getBytesFillUp(this.bufpos_output, this.physicalLength - 1)));
    }

    public float getFloat(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return 0.0f;
            }
            case 2: {
                return Float.NaN;
            }
        }
        return this.bigDecimal2Float(VDNNumber.number2BigDecimal(mem.getBytesFillUp(this.bufpos_output, this.physicalLength - 1)));
    }

    public int getInt(SQLParamController controller, DataPart mem) throws SQLException {
        return (int)this.getLong(controller, mem);
    }

    public long getLong(SQLParamController controller, DataPart mem) throws SQLException {
        long result = 0L;
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return result;
            }
            case 2: {
                throw SQLExceptionSapDB.generateSQLException("error.conversion.SpecialNullValue");
            }
        }
        byte[] number = mem.getBytesFillUp(this.bufpos_output, this.physicalLength - 1);
        result = VDNNumber.number2long(number);
        return result;
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        if (this.isNull(controller, mem)) {
            return null;
        }
        switch (this.dataType) {
            case 1: {
                if (this.logicalLength < 15) {
                    return new Float(this.getFloat(controller, mem));
                }
                if (this.logicalLength < 16) {
                    return new Double(Float.toString(this.getFloat(controller, mem)));
                }
                return new Double(this.getDouble(controller, mem));
            }
            case 29: 
            case 30: {
                return new Integer(this.getInt(controller, mem));
            }
        }
        return this.getBigDecimal(controller, mem);
    }

    public int getPrecision() {
        int result;
        switch (this.dataType) {
            case 0: {
                result = this.logicalLength;
                break;
            }
            default: {
                result = this.logicalLength;
            }
        }
        return result;
    }

    public int getScale() {
        int result;
        switch (this.dataType) {
            case 0: {
                result = this.frac;
                break;
            }
            case 29: 
            case 30: {
                result = 0;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    public short getShort(SQLParamController controller, DataPart mem) throws SQLException {
        return (short)this.getLong(controller, mem);
    }

    public Object transBigDecimalForInput(BigDecimal value) {
        if (value == null) {
            return null;
        }
        value.setScale(this.frac, 5);
        byte[] number = VDNNumber.bigDecimal2number(value);
        return number;
    }

    public Object transDoubleForInput(double value) throws SQLException {
        try {
            BigDecimal bigD = new BigDecimal(this.formatDoubleInput(value));
            if (this.dataType == 0) {
                bigD = bigD.setScale(this.frac, 5);
            }
            byte[] number = VDNNumber.bigDecimal2number(bigD, 16);
            return number;
        }
        catch (NumberFormatException numberFormatEx) {
            if (Double.isInfinite(value) || Double.isNaN(value)) {
                throw SQLExceptionSapDB.generateSQLException("error.special.number.unsupported", (Object)Double.toString(value));
            }
            throw numberFormatEx;
        }
    }

    public Object transFloatForInput(float value) throws SQLException {
        try {
            BigDecimal bigD = new BigDecimal(this.formatDoubleInput(value));
            if (this.dataType == 0) {
                bigD = bigD.setScale(this.frac, 5);
            }
            byte[] number = VDNNumber.bigDecimal2number(bigD, 14);
            return number;
        }
        catch (NumberFormatException numberFormatEx) {
            if (Float.isInfinite(value) || Float.isNaN(value)) {
                throw SQLExceptionSapDB.generateSQLException("error.special.number.unsupported", (Object)Float.toString(value));
            }
            throw numberFormatEx;
        }
    }

    public Object transIntForInput(int value) throws SQLException {
        byte[] number = VDNNumber.long2number(value);
        return number;
    }

    public Object transLongForInput(long value) throws SQLException {
        byte[] number = VDNNumber.long2number(value);
        return number;
    }

    public Object transShortForInput(short value) throws SQLException {
        byte[] number = VDNNumber.long2number(value);
        return number;
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            result = this.transBigDecimalForInput((BigDecimal)obj);
        } else if (obj instanceof Boolean) {
            result = this.transBooleanForInput((Boolean)obj);
        } else if (obj instanceof Byte) {
            result = this.transByteForInput((Byte)obj);
        } else if (obj instanceof Double) {
            result = this.transDoubleForInput((Double)obj);
        } else if (obj instanceof Float) {
            result = this.transFloatForInput(((Float)obj).floatValue());
        } else if (obj instanceof Integer) {
            result = this.transIntForInput((Integer)obj);
        } else if (obj instanceof Long) {
            result = this.transLongForInput((Long)obj);
        } else if (obj instanceof Short) {
            result = this.transShortForInput((Short)obj);
        }
        return result;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return null;
            }
            case 2: {
                return "NaN";
            }
        }
        return VDNNumber.number2string(mem.getBytesFillUp(this.bufpos_output, this.physicalLength - 1), this.dataType != 1 && this.dataType != 12, this.logicalLength, this.frac);
    }

    public Object transStringForInput(String value) throws SQLException {
        BigDecimal decimal;
        if (value == null) {
            return null;
        }
        try {
            decimal = new BigDecimal(value.trim());
        }
        catch (NumberFormatException exc) {
            throw this.newParseException(value, null);
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw this.newParseException(value, null);
        }
        return this.transBigDecimalForInput(decimal);
    }

    private static final class DecimalFormatHolder {
        private static final ThreadLocal INSTANCE = new ThreadLocal();

        private DecimalFormatHolder() {
        }
    }
}

