/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.translators.GetvalUnicode;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;

public class GetvalUnicodeClob
extends GetvalUnicode
implements Clob {
    public GetvalUnicodeClob(ConnectionSapDB connection, byte[] descriptor, StructuredMem dataPart, boolean isUnicodeColumn, boolean isPacketEncodingUnicode) {
        super(connection, descriptor, dataPart, isUnicodeColumn, isPacketEncodingUnicode);
    }

    public String getSubString(long pos, int length) throws SQLException {
        char[] result;
        int charsRead = length;
        --pos;
        try {
            if (pos < this.longPosition) {
                throw SQLExceptionSapDB.generateSQLException("error.movebackwardinblob", (Object)"getSubString", (Object)"GetvalUnicodeClob");
            }
            Reader stream = this.getCharacterStream();
            if (pos > this.longPosition) {
                stream.skip(pos - this.longPosition);
            }
            result = new char[length];
            charsRead = stream.read(result, 0, length);
        }
        catch (StreamIOException sioExc) {
            throw sioExc.getSqlException();
        }
        catch (IOException ioExc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)ioExc.getMessage());
        }
        return new String(result, 0, charsRead);
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getCharacterStream", (Object)"GetvalUnicodeClob");
    }
}

