/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.translators.Getval;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

class GetvalLob
extends Getval
implements Blob,
Clob {
    public GetvalLob(ConnectionSapDB connection, byte[] descriptor, StructuredMem dataPart, int dataKind, boolean isPacketEncodingUnicode) {
        super(connection, descriptor, dataPart, dataKind, isPacketEncodingUnicode);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] result;
        --pos;
        try {
            int bytesRead;
            if (pos < this.longPosition) {
                throw SQLExceptionSapDB.generateSQLException("error.movebackwardinblob", (Object)"getBytes", (Object)"GetvalLob");
            }
            InputStream stream = this.getBinaryStream();
            if (pos > this.longPosition) {
                stream.skip(pos - this.longPosition);
            }
            if ((bytesRead = stream.read(result = new byte[length], 0, length)) < length) {
                byte[] tmp = new byte[bytesRead];
                System.arraycopy(result, 0, tmp, 0, bytesRead);
                result = tmp;
            }
        }
        catch (StreamIOException sioExc) {
            throw sioExc.getSqlException();
        }
        catch (IOException ioExc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)ioExc.getMessage());
        }
        return result;
    }

    public String getSubString(long pos, int length) throws SQLException {
        byte[] bytes = this.getBytes(pos, length);
        try {
            return new String(bytes, "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    public long position(byte[] pattern, long start) throws SQLException {
        if (!this.supportsLobSearch) {
            throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"GetvalLob", (Object)"position");
        }
        return this.getPositionGetval(pattern, start);
    }

    public long position(Blob pattern, long start) throws SQLException {
        if (!this.supportsLobSearch) {
            throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"GetvalLob", (Object)"position");
        }
        byte[] patternBytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(patternBytes, start);
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getBinaryStream", (Object)"GetvalLob");
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getCharacterStream", (Object)"GetvalLob");
    }
}

