/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.BinaryDataTranslator;
import com.sap.dbtech.jdbc.translators.GetvalCharByte;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;

class BytesTranslator
extends BinaryDataTranslator {
    BytesTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] result = null;
        if (this.isNull(controller, mem)) {
            return 0;
        }
        result = mem.getBytesFillUp(this.bufpos_output, 1);
        return result[0];
    }

    public Blob getBlob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        GetvalCharByte result = null;
        if (!this.isNull(controller, mem)) {
            result = new GetvalCharByte(mem.getBytesFillUp(this.bufpos_output, this.logicalLength));
        }
        return result;
    }

    public byte[] getBytes(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] result = null;
        if (!this.isNull(controller, mem)) {
            result = mem.getBytesFillUp(this.bufpos_output, this.logicalLength);
        }
        return result;
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBytes(controller, mem);
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] rawResult = this.getBytes(controller, mem);
        String result = rawResult == null ? null : new String(rawResult);
        return result;
    }

    public Object transByteForInput(byte val) throws SQLException {
        byte[] barr = new byte[]{val};
        return this.transBytesForInput(barr);
    }

    public Object transBytesForInput(byte[] arg) throws SQLException {
        if (arg == null) {
            return arg;
        }
        this.checkFieldLimits(arg.length);
        return arg;
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        String clazzName;
        Object result = null;
        Class<?> clazz = obj.getClass();
        if (clazz.isArray() && (clazzName = clazz.getName()).equals("[B")) {
            result = this.transBytesForInput((byte[])obj);
        }
        return result;
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        return this.transBytesForInput(val.getBytes());
    }

    public Object transCharacterStreamForInput(Reader stream, long length) throws SQLException {
        if (length <= 0L) {
            return null;
        }
        try {
            if (length > Integer.MAX_VALUE) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)"Streams that size is longer than Integer.MAX_VALUE are not supported");
            }
            char[] ba = new char[(int)length];
            int r = stream.read(ba);
            if ((long)r != length) {
                if (r == -1) {
                    r = 0;
                }
                char[] ba2 = ba;
                ba = new char[r];
                System.arraycopy(ba2, 0, ba, 0, r);
            }
            return this.transStringForInput(new String(ba));
        }
        catch (IOException ioex) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)ioex.getMessage());
        }
    }

    public Object transBinaryStreamForInput(InputStream stream, long length) throws SQLException {
        if (length <= 0L) {
            return null;
        }
        try {
            if (length > Integer.MAX_VALUE) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)"Streams that size is longer than Integer.MAX_VALUE are not supported");
            }
            byte[] ba = new byte[(int)length];
            int r = stream.read(ba);
            if ((long)r != length) {
                if (r == -1) {
                    r = 0;
                }
                byte[] ba2 = ba;
                ba = new byte[r];
                System.arraycopy(ba2, 0, ba, 0, r);
            }
            return this.transBytesForInput(ba);
        }
        catch (IOException ioex) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)ioex.getMessage());
        }
    }

    public InputStream getBinaryStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        byte[] asBytes = this.getBytes(controller, mem);
        if (asBytes == null) {
            return null;
        }
        ByteArrayInputStream result = new ByteArrayInputStream(asBytes);
        return result;
    }
}

