/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.StreamTranslator;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class BinaryStreamTranslator
extends StreamTranslator {
    protected BinaryStreamTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public InputStream getBinaryStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getStream(controller, mem, longData);
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] result = null;
        if (this.isNull(controller, mem)) {
            return 0;
        }
        result = this.getBytes(controller, mem);
        return result[0];
    }

    public byte[] getBytes(SQLParamController controller, DataPart mem) throws SQLException {
        ByteArrayOutputStream tmpStream;
        InputStream blobStream = this.getBinaryStream(controller, mem, controller.getReplyData());
        if (blobStream == null) {
            return null;
        }
        try {
            int bufSizeC = 4096;
            byte[] buf = new byte[4096];
            tmpStream = new ByteArrayOutputStream();
            int readLen = blobStream.read(buf);
            while (readLen > 0) {
                tmpStream.write(buf, 0, readLen);
                if (readLen >= 4096) {
                    readLen = blobStream.read(buf);
                    continue;
                }
                break;
            }
        }
        catch (StreamIOException sqlExc) {
            throw sqlExc.getSqlException();
        }
        catch (IOException ioExc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)ioExc.getMessage());
        }
        return tmpStream.toByteArray();
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] tmp = this.getBytes(controller, mem);
        if (tmp == null) {
            tmp = null;
        }
        return tmp;
    }

    public Object transByteForInput(byte val) throws SQLException {
        byte[] barr = new byte[]{val};
        return this.transBytesForInput(barr);
    }

    public Object transBytesForInput(byte[] val) throws SQLException {
        if (val == null) {
            return null;
        }
        return new Putval(val, this.bufpos_input);
    }

    public Object transBinaryStreamForInput(InputStream stream, long length) throws SQLException {
        return this.transStreamForInput(stream, length);
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj instanceof InputStream) {
            result = this.transBinaryStreamForInput((InputStream)obj, -1L);
        }
        return result;
    }

    boolean isPackectEncodingUnicode() {
        return false;
    }
}

