/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.AbstractProcedurePutval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.InputStreamFilter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

abstract class BasisProcedurePutval
extends AbstractProcedurePutval {
    protected InputStream stream;
    protected boolean marksupported;
    protected long length;
    protected boolean atBegin = true;

    public BasisProcedurePutval(DBTechTranslator translator, InputStream stream, long length) throws SQLException {
        super(translator);
        if (length == -1L) {
            this.stream = stream;
            this.marksupported = this.stream.markSupported();
            this.length = Integer.MAX_VALUE;
        } else {
            this.stream = new InputStreamFilter(stream, length);
            this.marksupported = this.stream.markSupported();
            this.length = length;
        }
        if (this.marksupported) {
            if (length > Integer.MAX_VALUE) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)"Streams that size is longer than Integer.MAX_VALUE are not supported");
            }
            this.stream.mark((int)this.length);
        }
    }

    public void transferStream(DataPart dataPart, short rowCount) throws SQLException {
        if (rowCount == -2) {
            if (!this.atBegin) {
                if (this.marksupported) {
                    try {
                        this.stream.reset();
                        this.atBegin = true;
                        if (this.length > Integer.MAX_VALUE) {
                            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)"Streams that size is longer than Integer.MAX_VALUE are not supported");
                        }
                        this.stream.mark((int)this.length);
                    }
                    catch (IOException ioEx) {
                        throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)ioEx.getMessage());
                    }
                } else {
                    throw SQLExceptionSapDB.generateSQLException("error.reset.stream");
                }
            }
            rowCount = Short.MAX_VALUE;
        } else if (this.atBegin && this.marksupported) {
            if (this.length > Integer.MAX_VALUE) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)"Streams that size is longer than Integer.MAX_VALUE are not supported");
            }
            this.stream.mark((int)this.length);
        }
        if (dataPart.fillWithProcedureStream(this.stream, rowCount)) {
            // empty if block
        }
        this.atBegin = false;
    }

    public void closeStream() throws SQLException {
        try {
            this.stream.close();
        }
        catch (IOException ioex) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)ioex.getMessage());
        }
    }
}

