/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.vsp00.LongDesc;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public abstract class AbstractGetval {
    protected ConnectionSapDB connection;
    protected byte[] descriptor;
    protected StructuredMem streamBuffer;
    protected int itemsInBuffer;
    protected int itemSize;
    protected boolean atEnd;
    protected boolean firstChunk = true;
    protected long longPosition = 0L;
    protected long longSize = -1L;
    protected boolean packetEncodingUnicode = false;
    protected boolean supportsLobSearch = false;
    protected boolean isUnicodeColumn = false;

    public AbstractGetval(ConnectionSapDB connection, byte[] descriptor, StructuredMem dataPart, int itemSize, boolean ispacketEncodingUnicode) {
        this.connection = connection;
        this.atEnd = false;
        this.itemSize = itemSize;
        this.packetEncodingUnicode = ispacketEncodingUnicode;
        this.setupStreamBuffer(descriptor, dataPart);
        this.supportsLobSearch = this.connection.isKernelFeaturesupported(11);
    }

    protected boolean nextChunk() throws StreamIOException {
        try {
            ReplyPacket replyPacket;
            byte valMode = this.descriptor[27];
            if (valMode == 2 || valMode == 1) {
                this.atEnd = true;
                return false;
            }
            this.firstChunk = false;
            RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
            DataPart longpart = requestPacket.initGetval(this.connection.getAutoCommit());
            longpart.putInt1(0, 0);
            longpart.putBytes(this.descriptor, 1);
            int maxval = 0x7FFFFFFE;
            longpart.putInt4(maxval, 37);
            longpart.addArg(1, 40);
            longpart.close();
            try {
                replyPacket = this.connection.execute(requestPacket, this, 2);
            }
            catch (SQLExceptionSapDB sqlExc) {
                throw new StreamIOException(sqlExc);
            }
            if (replyPacket.findPart(18) == -1) {
                throw new StreamIOException(SQLExceptionSapDB.generateSQLException("error.longdata.expected"));
            }
            int dataPos = replyPacket.getPartDataPos();
            this.descriptor = replyPacket.getDataBytes(dataPos, 41);
            if (this.descriptor[27] == 9) {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.startposition");
            }
            this.setupStreamBuffer(this.descriptor, replyPacket.getPointer(dataPos));
            return true;
        }
        catch (SQLException exc) {
            throw new StreamIOException((SQLExceptionSapDB)exc);
        }
    }

    protected ReplyPacket executeGetval(byte[] descriptor) throws SQLException {
        RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
        DataPart longpart = requestPacket.initGetval(this.connection.getAutoCommit());
        longpart.putInt1(0, 0);
        longpart.putBytes(descriptor, 1);
        longpart.putInt4(0x7FFFFFFE, 37);
        longpart.addArg(1, 40);
        longpart.close();
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, 2);
        return replyPacket;
    }

    protected long getPositionGetval(byte[] pattern, long start) throws SQLException {
        int patternLen;
        if (start > Integer.MAX_VALUE || start < 1L) {
            throw SQLExceptionSapDB.generateSQLException("error.illegalparam", new Integer(2), (Object)new Long(start));
        }
        if (pattern == null || (patternLen = pattern.length) == 0) {
            throw SQLExceptionSapDB.generateSQLException("error.illegalparam", new Integer(1), (Object)new Integer(pattern == null ? 0 : pattern.length));
        }
        RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
        DataPart longpart = requestPacket.initGetval(this.connection.getAutoCommit());
        longpart.putInt1(0, 0);
        longpart.putBytes(this.descriptor, 1);
        longpart.putInt4((int)start, 21);
        longpart.putInt1(11, 28);
        longpart.putInt4(42, 33);
        longpart.putBytes(pattern, 41, patternLen);
        longpart.putInt4(patternLen, 37);
        longpart.addArg(1, 41 + patternLen);
        longpart.close();
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, 2);
        StructuredBytes descBytes = new StructuredBytes(this.getDescriptorFromReply(replyPacket));
        long result = -1L;
        if (descBytes.getInt1(27) != 3) {
            result = descBytes.getInt4(20);
        }
        int oldInternPos = LongDesc.getInternPos(this.descriptor);
        descBytes.putInt4(oldInternPos, 20);
        descBytes.putInt1(this.descriptor[27], 27);
        this.descriptor = descBytes.bytes();
        return result;
    }

    private void setupStreamBuffer(byte[] descriptor, StructuredMem dataPart) {
        StructuredBytes desc = new StructuredBytes(descriptor);
        int dataStart = desc.getInt4(32) - 1;
        this.itemsInBuffer = desc.getInt4(36) / this.itemSize;
        this.streamBuffer = dataPart.getPointer(dataStart);
        this.descriptor = descriptor;
        if (descriptor[20] == 0 && descriptor[21] == 0 && descriptor[22] == 0 && descriptor[23] == 0) {
            descriptor[23] = 1;
        }
    }

    public long lengthInBytes() throws SQLException {
        if (this.longSize > -1L) {
            return this.longSize;
        }
        StructuredBytes desc = new StructuredBytes(this.descriptor);
        this.longSize = desc.getInt4(16);
        if (this.longSize > 0L) {
            return this.longSize;
        }
        this.longSize = this.longSizeRequest();
        return this.longSize;
    }

    private byte[] getDescriptorFromReply(ReplyPacket replyPacket) throws SQLException {
        if (replyPacket.findPart(18) == -1) {
            throw SQLExceptionSapDB.generateSQLException("error.longdata.expected");
        }
        int dataPos = replyPacket.getPartDataPos();
        return replyPacket.getDataBytes(dataPos, 41);
    }

    protected long longSizeRequest() throws SQLException {
        byte[] requestDescriptor = new byte[this.descriptor.length];
        System.arraycopy(this.descriptor, 0, requestDescriptor, 0, this.descriptor.length);
        requestDescriptor[27] = 6;
        ReplyPacket replyPacket = this.executeGetval(requestDescriptor);
        StructuredBytes descBytes = new StructuredBytes(this.getDescriptorFromReply(replyPacket));
        long result = descBytes.getInt4(16);
        return result;
    }

    abstract InputStream getAsciiStream() throws SQLException;

    abstract InputStream getBinaryStream() throws SQLException;

    abstract Reader getCharacterStream() throws SQLException;

    public long position(String searchstr, long start) throws SQLException {
        if (!this.supportsLobSearch) {
            throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"AbstractGetval", (Object)"position");
        }
        byte[] pattern = this.transSearchPattern(searchstr);
        return this.getPositionGetval(pattern, start);
    }

    public final int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setbytes.notimplemented"));
    }

    public final int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setbytes.notimplemented"));
    }

    public final OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setbinarystream.notimplemented"));
    }

    public final void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.truncate.notimplemented"));
    }

    public final int setString(long pos, String str) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setstring.notimplemented"));
    }

    public final int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setstring.notimplemented"));
    }

    public final OutputStream setAsciiStream(long pos) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setasciistream.notimplemented"));
    }

    public final Writer setCharacterStream(long pos) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setcharacterstream.notimplemented"));
    }

    public long position(Clob lob, long start) throws SQLException {
        if (!this.supportsLobSearch) {
            throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"AbstractGetval", (Object)"position");
        }
        String val = lob.getSubString(1L, (int)lob.length());
        return this.position(val, start);
    }

    public final ConnectionSapDB getConnection() {
        return this.connection;
    }

    public byte[] getDescriptor() {
        return this.descriptor;
    }

    public abstract long length() throws SQLException;

    public abstract byte[] transSearchPattern(String var1);

    public void free() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"GetvalLob", (Object)"free");
    }

    public boolean isUnicodeColumn() {
        return this.isUnicodeColumn;
    }
}

