/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.ABAPStreamDescriptor;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.AsciiABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.AsciiABAPStreamPutval;
import com.sap.dbtech.jdbc.translators.BinaryABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.BinaryABAPStreamPutval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.ReaderInputStream;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.StructureABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.UnicodeABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.UnicodeABAPStreamPutval;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class ABAPStreamTranslator
extends DBTechTranslator {
    private static final int STREAMTYPE_ASCII = 1;
    private static final int STREAMTYPE_UNICODE = 2;
    private static final int STREAMTYPE_BYTE = 3;
    private static final int STREAMTYPE_STRUCTURED = 4;
    private DBProcParameterInfo parameterStructure;
    private boolean isUnicodeConnection;
    private int streamtype;

    public ABAPStreamTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncre) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
        this.isUnicodeConnection = false;
        this.streamtype = 0;
    }

    public ABAPStreamTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean unicode, boolean readOnly, boolean autoIncre) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
        this.isUnicodeConnection = unicode;
        this.streamtype = 0;
    }

    protected void putSpecific(DataPart dataPart, Object data) throws SQLException {
        ABAPStreamDescriptor d = (ABAPStreamDescriptor)data;
        d.putDescriptor(dataPart, this.bufpos_input);
    }

    protected Object transSpecificForInput(Object obj) throws SQLException {
        return null;
    }

    public Object transBinaryStreamForInput(InputStream stream, long length) throws SQLException {
        if (this.streamtype == 3) {
            if (stream == null) {
                return null;
            }
            return new BinaryABAPStreamPutval(this, stream, length);
        }
        throw SQLExceptionSapDB.generateSQLException("error.stream.conversion.bytes");
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        switch (this.streamtype) {
            case 1: {
                if (this.isUnicodeConnection) {
                    return new AsciiABAPStreamPutval(this, StringUtil.bytes_ascii7bit(val), true);
                }
                return new AsciiABAPStreamPutval(this, StringUtil.bytes_iso8859_1(val), false);
            }
            case 2: {
                if (this.isUnicodeConnection) {
                    return new UnicodeABAPStreamPutval(this, val.toCharArray());
                }
                return new AsciiABAPStreamPutval(this, StringUtil.bytes_ascii7bit(val), false);
            }
        }
        throw SQLExceptionSapDB.generateSQLException("error.stream.conversion.string");
    }

    public Object transCharacterStreamForInput(Reader reader, long length) throws SQLException {
        switch (this.streamtype) {
            case 1: {
                if (reader == null) {
                    return null;
                }
                if (this.isUnicodeConnection) {
                    return new AsciiABAPStreamPutval(this, new ReaderInputStream(reader, true), length, true);
                }
                return new AsciiABAPStreamPutval(this, new ReaderInputStream(reader, false), length, false);
            }
            case 2: {
                if (this.isUnicodeConnection) {
                    return new UnicodeABAPStreamPutval(this, reader, length);
                }
                return new AsciiABAPStreamPutval(this, new ReaderInputStream(reader, true), length, false);
            }
        }
        throw SQLExceptionSapDB.generateSQLException("error.stream.conversion.string");
    }

    public void setProcParamInfo(DBProcParameterInfo info) {
        this.parameterStructure = info;
        if (this.parameterStructure != null) {
            if (this.parameterStructure.getMemberCount() == 1) {
                DBProcParameterInfo.StructureElement s = this.parameterStructure.getMember(0);
                if (s.typeName.equals("CHAR")) {
                    if (s.codeType.equals("ASCII")) {
                        this.streamtype = 1;
                        return;
                    }
                    if (s.codeType.equals("BYTE")) {
                        this.streamtype = 3;
                        return;
                    }
                } else if (s.typeName.equals("WYDE")) {
                    this.streamtype = 2;
                    return;
                }
            }
            this.streamtype = 4;
        }
    }

    public boolean isStreamKind() {
        return true;
    }

    public Object transClobForInput(Clob clob, ConnectionSapDB conn) throws SQLException {
        if (this.streamtype == 1 || this.streamtype == 2) {
            if (clob == null) {
                return null;
            }
            Reader r = clob.getCharacterStream();
            StringBuffer data = new StringBuffer();
            char[] readerData = new char[4096];
            int charsRead = 0;
            do {
                try {
                    charsRead = r.read(readerData);
                    if (charsRead == -1) continue;
                    data.append(readerData, 0, charsRead);
                }
                catch (IOException ioex) {
                    throw SQLExceptionSapDB.generateSQLException("error.stream.sourceread", (Object)ioex.getMessage());
                }
            } while (charsRead != -1);
            try {
                r.close();
            }
            catch (IOException ignoredIoEx) {
                // empty catch block
            }
            return this.transStringForInput(data.toString());
        }
        throw SQLExceptionSapDB.generateSQLException("error.stream.conversion.string");
    }

    public Object transBytesForInput(byte[] val) throws SQLException {
        if (val == null) {
            return this.transBinaryStreamForInput(null, -1L);
        }
        return this.transBinaryStreamForInput(new ByteArrayInputStream(val), -1L);
    }

    public AbstractABAPStreamGetval createGetval() throws SQLException {
        switch (this.streamtype) {
            case 1: {
                return new AsciiABAPStreamGetval(this);
            }
            case 2: {
                if (this.isUnicodeConnection) {
                    return new UnicodeABAPStreamGetval(this);
                }
                return new AsciiABAPStreamGetval(this);
            }
            case 3: {
                return new BinaryABAPStreamGetval(this);
            }
            case 4: {
                return new StructureABAPStreamGetval(this, this.parameterStructure, this.isUnicodeConnection);
            }
        }
        throw SQLExceptionSapDB.generateSQLException("error.stream.unknowntype");
    }

    private AbstractABAPStreamGetval getGetval(SQLParamController controller) throws SQLException {
        AbstractABAPStreamGetval gv = controller.getOMSGetval(this.getColIndex());
        if (gv == null) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.nodata");
        }
        return gv;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getGetval(controller).getString();
    }

    public InputStream getAsciiStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getGetval(controller).getAsciiStream();
    }

    public BigDecimal getBigDecimal(int scale, SQLParamController controller, DataPart mem) throws SQLException {
        return this.getGetval(controller).getBigDecimal(scale);
    }

    public BigDecimal getBigDecimal(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getGetval(controller).getBigDecimal();
    }

    public InputStream getBinaryStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getGetval(controller).getBinaryStream();
    }

    public Blob getBlob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getGetval(controller).getBlob();
    }

    public boolean getBoolean(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getGetval(controller).getBoolean();
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getGetval(controller).getByte();
    }

    public byte[] getBytes(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getGetval(controller).getBytes();
    }

    public Reader getCharacterStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getGetval(controller).getCharacterStream();
    }

    public Clob getClob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getGetval(controller).getClob();
    }

    public Date getDate(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        return this.getGetval(controller).getDate(cal);
    }

    public double getDouble(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getGetval(controller).getDouble();
    }

    public float getFloat(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getGetval(controller).getFloat();
    }

    public int getInt(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getGetval(controller).getInt();
    }

    public long getLong(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getGetval(controller).getLong();
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getGetval(controller).getObject();
    }

    public Time getTime(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        return this.getGetval(controller).getTime(cal);
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        return this.getGetval(controller).getTimestamp(cal);
    }

    public String getBaseTypeName() {
        return this.parameterStructure.getBaseTypeName();
    }

    public String getColumnTypeName() {
        return this.parameterStructure.getSQLTypeName();
    }
}

