/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.StructMemberTranslator;
import com.sap.dbtech.jdbc.translators.Structure;
import com.sap.dbtech.util.StructuredBytes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;

public class ABAPStreamArray
implements Array {
    StructMemberTranslator[] memberTranslator;
    StructuredBytes rawData;
    int elementCount;
    int recordSize;
    ArrayList elements;
    String baseTypeName;

    public ABAPStreamArray(StructuredBytes data, StructMemberTranslator[] translator, int elementCount, String baseTypeName) throws SQLException {
        this.rawData = data;
        this.memberTranslator = translator;
        this.elementCount = elementCount;
        this.elements = new ArrayList();
        if (this.rawData.size() % elementCount != 0) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.oddsize");
        }
        this.recordSize = this.rawData.size() / elementCount;
        this.baseTypeName = baseTypeName;
        this.rawData.traceOn(System.err);
    }

    public int getBaseType() throws SQLException {
        return 0;
    }

    public Object getArray() throws SQLException {
        this.checkArray(0L, this.elementCount);
        return this.elements.toArray();
    }

    public Object getArray(long index, int count) throws SQLException {
        return null;
    }

    public String getBaseTypeName() throws SQLException {
        return this.baseTypeName;
    }

    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    public ResultSet getResultSet(long arg0, int arg1) throws SQLException {
        return null;
    }

    public Object getArray(long arg0, int arg1, Map arg2) throws SQLException {
        return null;
    }

    public Object getArray(Map arg0) throws SQLException {
        return null;
    }

    public ResultSet getResultSet(long arg0, int arg1, Map arg2) throws SQLException {
        return null;
    }

    public ResultSet getResultSet(Map arg0) throws SQLException {
        return null;
    }

    private void checkArray(long startindex, int count) throws SQLException {
        for (long ex = startindex; ex < (long)count && ex < (long)this.elements.size(); ++ex) {
            if (this.elements.get((int)ex) != null) continue;
            this.elements.set((int)ex, this.getObject(ex));
        }
        for (long i = (long)this.elements.size(); i < (long)count; ++i) {
            this.elements.add(this.getObject(i));
        }
    }

    private Object getObject(long index) throws SQLException {
        if (this.memberTranslator.length == 1) {
            return this.memberTranslator[0].getObject(this.rawData, (int)index * this.recordSize);
        }
        Object[] result = new Object[this.memberTranslator.length];
        for (int i = 0; i < this.memberTranslator.length; ++i) {
            result[i] = this.memberTranslator[i].getObject(this.rawData, (int)index * this.recordSize);
        }
        Structure s = new Structure(result, this.baseTypeName);
        return s;
    }

    public String toString() {
        try {
            Object[] values = (Object[])this.getArray();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("ARRAY [" + values.length + "] = {");
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    pw.println(",");
                }
                pw.print(values[i].toString());
            }
            pw.println("");
            pw.println("}");
            return sw.toString();
        }
        catch (Exception ex) {
            return "*** not available ***";
        }
    }

    public void free() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"free", (Object)"ABAPStreamArray");
    }
}

