/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.UnicodeConversionException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.DataPartFixed;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.jdbc.packet.SQLPacket;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.VDNNumber;
import java.io.PrintStream;
import java.sql.SQLException;

public class RequestPacket
extends SQLPacket {
    private String ApplID = "ODB";
    private String ApplVers = "70400";
    private int packetLength;
    private int packetSegments;
    private int segmLength;
    private int maxNumberOfSegm = 6;
    private int segmParts;
    protected int partLength;
    private int partArguments;
    private int replyReserve;
    private int currentSqlMode = 1;
    public static final boolean reset_C = true;
    public static final boolean append_C = false;
    public static final int resultCountSize_C = 6;
    public static final int defaultmaxNumberOfSegm_C = 6;
    public static final int reserveFor2ndSegment_C = 8192;
    public static final int reserveForReply_C = 224;

    public RequestPacket(StructuredMem rawPacket) {
        this(rawPacket, 0, null, null);
    }

    public RequestPacket(StructuredMem rawPacket, int clientEncodinng, String applID, String applVers) {
        super(rawPacket);
        if (rawPacket != null) {
            this.initPacket(clientEncodinng, applID, applVers);
        }
    }

    public void addBytes(byte[] bytes) {
        this.mem.putBytes(bytes, this.dataPos());
        this.partLength += bytes.length;
    }

    public void addCursorPart(String cursorName) {
        if (cursorName != null && cursorName.length() != 0) {
            this.newPart(13);
            this.addString(cursorName);
            ++this.partArguments;
            this.closePart();
        }
    }

    public void addErrorTextPart(String errortext) {
        if (errortext != null && errortext.length() != 0) {
            this.newPart(6);
            this.addString(errortext.substring(0, 255));
            ++this.partArguments;
            this.closePart();
        }
    }

    public void setSQLState(String sqlstate) {
        if (sqlstate.length() == 5) {
            this.mem.putBytes(sqlstate.getBytes(), this.segmOffs + 13, 5);
        }
    }

    public void setErrorCode(int errorcode) {
        this.mem.putInt2(errorcode, this.segmOffs + 18);
    }

    public void addFeatureRequestPart(byte[] features) {
        if (features != null && features.length != 0) {
            this.newPart(34);
            this.addBytes(features);
            this.incrPartArguments(features.length / 2);
            this.closePart();
        }
    }

    public void addParseidPart(byte[] parseID) throws SQLException {
        if (parseID == null) {
            throw SQLExceptionSapDB.generateSQLException("error.internal.invalidParseid");
        }
        this.newPart(10);
        this.addBytes(parseID);
        this.partArguments = 1;
        this.closePart();
    }

    public void addDataBytes(byte[] bytes) {
        this.mem.putInt1(0, this.dataPos());
        this.mem.putBytes(bytes, this.dataPos() + 1);
        this.partLength += bytes.length + 1;
    }

    public void addNullData(int len) {
        this.mem.putInt1(-1, this.dataPos());
        this.partLength += len + 1;
    }

    public void addDataString(String data) {
        this.mem.putInt1(32, this.dataPos());
        this.partLength += this.mem.putString(data, this.dataPos() + 1) + 1;
    }

    public void addFetchCount(int count) {
        this.newPart(12);
        this.addBytes(VDNNumber.long2number(count));
        ++this.partArguments;
        this.setMassCommand();
    }

    public void addResultCount(int count) {
        this.newPart(12);
        byte[] fullNumber = VDNNumber.long2number(count);
        byte[] countNumber = new byte[6];
        System.arraycopy(fullNumber, 0, countNumber, 0, fullNumber.length);
        this.addDataBytes(countNumber);
        ++this.partArguments;
    }

    public void addUndefResultCount() {
        this.newPart(12);
        this.addNullData(6);
        ++this.partArguments;
    }

    public void addResultsetName(String name) {
        this.newPart(13);
        this.addString(name);
    }

    public void addString(String data) {
        this.partLength += this.mem.putString(data, this.dataPos());
    }

    public void addStringThrowExc(String data) throws UnicodeConversionException {
        this.partLength += this.mem.putStringThrowExc(data, this.dataPos());
    }

    public void closePacket() {
        this.closeSegment();
        this.mem.putInt4(this.packetLength - 32, 16);
        this.mem.putInt2(this.packetSegments, 22);
    }

    private void closePart() {
        this.closePart(this.partLength, this.partArguments);
    }

    void closePart(int extent, int arguments) {
        if (this.partOffs == -1) {
            return;
        }
        this.mem.putInt4(extent, this.partOffs + 8);
        this.mem.putInt2(arguments, this.partOffs + 2);
        this.segmLength += this.aligned(extent + 16);
        this.partOffs = -1;
        this.partLength = -1;
        this.partArguments = -1;
    }

    private void closeSegment() {
        if (this.segmOffs == -1) {
            return;
        }
        this.closePart();
        this.mem.putInt4(this.segmLength, this.segmOffs + 0);
        this.mem.putInt2(this.segmParts, this.segmOffs + 8);
        this.packetLength += this.segmLength;
        this.segmOffs = -1;
        this.segmLength = -1;
        this.segmParts = -1;
    }

    protected int dataPos() {
        return this.partOffs + 16 + this.partLength;
    }

    public boolean dropPid(byte[] pid, boolean reset) {
        if (reset) {
            this.resetPacket();
        } else {
            int remainingSpace;
            if (this.segmOffs != -1) {
                this.closeSegment();
            }
            if ((remainingSpace = this.size() - this.packetLength - 40 - 16 - this.replyReserve - 224 - 12 - 40 - 16 - 12) <= 0 || this.packetSegments >= this.maxNumberOfSegm) {
                return false;
            }
        }
        this.newSegment(2, false, false, 1004);
        this.newPart(3);
        this.partArguments = 1;
        this.addString("Drop Parseid");
        this.newPart(10);
        this.partArguments = 1;
        this.addBytes(pid);
        return true;
    }

    public boolean dropPidAddtoParsidPart(byte[] pid) {
        int remainingSpace = this.size() - this.packetLength - 40 - 16 - this.replyReserve - 224 - this.partLength - 12;
        if (remainingSpace <= 0) {
            return false;
        }
        this.addBytes(pid);
        ++this.partArguments;
        return true;
    }

    int dumpSegment(PrintStream stream, int maxBuf, int segmPos) {
        stream.println("   <SEGMENT ");
        stream.println("    type=\"REQUEST\"");
        stream.println("    index=\"" + this.getInt2(segmPos + 10) + "\"");
        stream.println("    offset=\"" + this.getInt4(segmPos + 4) + "\"");
        stream.println("    length=\"" + this.getInt4(segmPos + 0) + "\"");
        stream.println("    number_of_parts=\"" + this.getInt2(segmPos + 8) + "\"");
        StringUtil.fprintfs(stream, "    <! Detailed info skipped >\n", new Object[0]);
        int partCount = this.getInt2(segmPos + 8);
        int pos = segmPos + 40;
        for (int i = 0; i < partCount; ++i) {
            pos += this.dumpPart(stream, maxBuf, pos);
        }
        stream.println("   </SEGMENT> ");
        return this.getInt4(segmPos + 0);
    }

    public void incrPartArguments() {
        ++this.partArguments;
    }

    public void incrPartArguments(int count) {
        this.partArguments += count;
    }

    public void initHello() {
        this.resetPacket();
        this.newSegment(25, false, false, 1004);
    }

    public void initDbs(boolean autocommit, int scrollableCursor) {
        this.initDbs(true, autocommit, scrollableCursor);
    }

    public void initDbs(boolean reset, boolean autocommit, int scrollableCursor) {
        if (reset) {
            this.resetPacket();
        }
        this.newSegment(2, autocommit, false, scrollableCursor);
        this.newPart(3);
        this.partArguments = 1;
    }

    public void initDbsCommand(boolean autocommit, String cmd, int scrollableCursor) throws UnicodeConversionException {
        this.initDbsCommand(cmd, true, autocommit, scrollableCursor);
    }

    public void initDbsCommandThrowSQLExc(boolean autocommit, String cmd, int scrollableCursor) throws SQLException {
        try {
            this.initDbsCommand(cmd, true, autocommit, scrollableCursor);
        }
        catch (UnicodeConversionException e1) {
            throw SQLExceptionSapDB.generateSQLException("error.unicodetoAscii", (Object)cmd);
        }
    }

    public boolean initDbsCommand(String cmd, boolean reset, boolean autocommit, int scrollableCursor) throws UnicodeConversionException {
        if (!reset) {
            this.closeSegment();
            int remainingSpace = this.size() - this.packetLength - 40 - 16 - this.replyReserve - 224;
            if (remainingSpace < cmd.length() || this.packetSegments >= this.maxNumberOfSegm) {
                return false;
            }
        }
        this.initDbs(reset, autocommit, scrollableCursor);
        this.addStringThrowExc(cmd);
        this.partArguments = 1;
        return true;
    }

    public boolean initSyntaxOnlyCommand(String cmd) {
        this.resetPacket();
        this.newSegment(5, false, false, 1004);
        this.newPart(3);
        this.partArguments = 1;
        this.addString(cmd);
        return true;
    }

    public void initExecute(byte[] parseID, boolean autocommit, int scrollableCursor) throws SQLException {
        this.resetPacket();
        this.newSegment(13, autocommit, false, scrollableCursor);
        this.addParseidPart(parseID);
    }

    public DataPart initGetval(boolean autocommit) {
        this.resetPacket();
        this.newSegment(16, autocommit, false, 1004);
        return this.newDataPart(18);
    }

    public void initMFetch(byte[] parseID, int count, boolean autocommit) {
        this.resetPacket();
        this.newSegment(13, autocommit, false, 1004);
        this.newPart(10);
        this.addBytes(parseID);
        this.partArguments = 1;
        this.addResultCount(count);
        this.setMassCommand();
    }

    private void initPacket(int clientEncoding, String applID, String applVers) {
        StructuredMem packet = this.mem;
        if (applID != null) {
            this.ApplID = applID;
        }
        if (applVers != null) {
            try {
                int vers = Integer.parseInt(applVers);
                if (vers >= 60210 && vers <= 100000) {
                    this.ApplVers = applVers;
                }
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        packet.putInt1(clientEncoding, 0);
        packet.putInt1(1, 1);
        packet.putString(this.ApplVers, 4);
        packet.putString(this.ApplID, 9);
        packet.putInt4(packet.size() - 32, 12);
        this.packetLength = 32;
    }

    public void initParse(boolean reset, boolean parseagain, int resultSetType) {
        if (reset) {
            this.resetPacket();
        }
        this.newSegment(3, false, parseagain, resultSetType);
        this.newPart(3);
    }

    public DataPartVariable initAuthenticationMethodRequest(String user) throws SQLException {
        this.initDbsCommandThrowSQLExc(false, "CONNECT \"" + user + "\"  AUTHENTICATION", 1004);
        this.closePart();
        DataPartVariable data = this.newVarDataPart();
        return data;
    }

    public void addClientProofPart(String method, byte[] clientProof) throws SQLException {
        DataPartVariable data = this.newVarDataPart();
        data.addRow(2);
        data.putBytes(method.getBytes(), data.extent);
        data.addArg(data.extent, 0);
        data.putBytes(clientProof, data.extent);
        data.addArg(data.extent, 0);
        data.close();
    }

    public void addClientIDPart(String clientID) {
        this.newPart(35);
        this.addDataString(clientID);
        this.partArguments = 1;
    }

    public int initParseCommand(String cmd, boolean reset, boolean parseagain, int resultSetType) throws UnicodeConversionException {
        this.initParse(reset, parseagain, resultSetType);
        this.addStringThrowExc(cmd);
        this.partArguments = 1;
        return this.partLength;
    }

    private void initPart(int partKind) {
        StructuredMem packet = this.mem;
        ++this.segmParts;
        this.partOffs = this.segmOffs + this.segmLength;
        this.partLength = 0;
        this.partArguments = 0;
        int pos = this.partOffs;
        packet.putInt1(partKind, pos + 0);
        packet.putInt1(0, pos + 1);
        packet.putInt2(1, pos + 2);
        packet.putInt4(this.segmOffs - 32, pos + 4);
        packet.putInt4(16, pos + 8);
        packet.putInt4(packet.size() - pos, pos + 12);
    }

    public DataPart initPutval(boolean autocommit) {
        this.resetPacket();
        this.newSegment(15, autocommit, false, 1004);
        return this.newDataPart(18);
    }

    protected int createSegment(int segmKind) {
        int pos;
        StructuredMem packet = this.mem;
        this.segmOffs = pos = this.packetLength;
        this.segmLength = 40;
        this.segmParts = 0;
        ++this.packetSegments;
        packet.putInt4(0, pos + 0);
        packet.putInt4(pos - 32, pos + 4);
        packet.putInt2(0, pos + 8);
        packet.putInt2(this.packetSegments, pos + 10);
        packet.putInt1(segmKind, pos + 12);
        return pos;
    }

    public void dropSegment() {
        --this.packetSegments;
    }

    private void initSegment(int messKind, boolean autocommit, boolean parseagain, int resultSetType) {
        StructuredMem packet = this.mem;
        int pos = this.createSegment(1);
        packet.putInt1(messKind, pos + 13);
        packet.putInt1(this.currentSqlMode, pos + 14);
        packet.putInt1(1, pos + 15);
        packet.putInt1(autocommit ? 1 : 0, pos + 16);
        packet.putInt1(0, pos + 17);
        packet.putInt1(0, pos + 18);
        packet.putInt1(0, pos + 19);
        packet.putInt1(0, pos + 20);
        if (parseagain) {
            packet.putInt1(1, pos + 21);
        } else {
            packet.putInt1(0, pos + 21);
        }
        if (resultSetType != 1003) {
            packet.putInt1(2, pos + 22);
        } else {
            packet.putInt1(0, pos + 22);
        }
    }

    public int length() {
        return this.packetLength;
    }

    private DataPartVariable newVarDataPart() throws SQLException {
        this.newPart(33);
        int partDataOffs = this.partOffs + 16;
        DataPartVariable result = new DataPartVariable(this.getPointer(partDataOffs), this);
        return result;
    }

    public DataPart newDataPart(boolean varData) throws SQLException {
        if (varData) {
            return this.newVarDataPart();
        }
        return this.newDataPart();
    }

    private DataPart newDataPart() {
        return this.newDataPart(5);
    }

    public DataPart newDataPart(int partKind) {
        this.newPart(partKind);
        int partDataOffs = this.partOffs + 16;
        DataPartFixed result = new DataPartFixed(this.getPointer(partDataOffs), this);
        return result;
    }

    public void newPart(int partKind) {
        this.closePart();
        this.initPart(partKind);
    }

    private void newSegment(int messKind, boolean autocommit, boolean parseagain, int resultSetType) {
        this.closeSegment();
        this.initSegment(messKind, autocommit, parseagain, resultSetType);
        this.replyReserve = this.packetSegments == 2 ? (this.replyReserve += 8192) : (this.replyReserve += 224);
    }

    public void initializePacket(short maxSegment) {
        this.resetPacket();
        this.maxNumberOfSegm = maxSegment;
    }

    private void resetPacket() {
        this.packetLength = 32;
        this.packetSegments = 0;
        this.segmOffs = -1;
        this.segmLength = -1;
        this.segmParts = -1;
        this.maxNumberOfSegm = 6;
        this.partOffs = -1;
        this.partLength = -1;
        this.partArguments = -1;
        this.replyReserve = 0;
    }

    public static int resultCountPartSize() {
        return 30;
    }

    public void setMaxSegment(short maxSegment) {
        this.maxNumberOfSegm = maxSegment;
    }

    public void setInternalMode() {
        this.putInt1(2, this.segmOffs + 14);
    }

    public void setInternalCmd() {
        this.mem.putInt1(2, this.segmOffs + 15);
    }

    public void setMassCommand() {
        this.putInt1(1, this.segmOffs + 20);
    }

    public void setWithInfo() {
        this.putInt1(1, this.segmOffs + 19);
    }

    public int switchSqlMode(int newMode) {
        int result = this.currentSqlMode;
        this.currentSqlMode = newMode;
        return result;
    }

    void addPartAttribute(int attribute) {
        int attrOffset = this.partOffs + 1;
        int currentAttribute = this.getInt1(attrOffset);
        this.putInt1(currentAttribute |= attribute, attrOffset);
    }

    public DataPart initStreamCommand(boolean autocommit) {
        this.resetPacket();
        this.newSegment(2, autocommit, false, 1004);
        return this.newDataPart(5);
    }

    public boolean isUnicodePacket() {
        return false;
    }
}

