/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class DataPartVariable
extends DataPart {
    public static final int NULL_VALUE_INDICATOR = -1;
    public static final int SPECIAL_NULL_VALUE_INDICATOR = -2;
    public static final int MAX_LENGTH_INDICATOR = -3;
    private int fieldCount = 0;
    private int currentArgCount = 0;
    private int currentFieldCount = 0;
    private int currentFieldLen = 0;
    private int currentPhysicalFieldLen = 0;
    private int currentRecordOffset = 0;

    public DataPartVariable(StructuredMem rawMem, RequestPacket requestPacket) throws SQLException {
        super(rawMem, requestPacket);
    }

    public DataPartVariable(StructuredMem rawMem, int argCount) throws SQLException {
        super(rawMem, null);
        this.argCount = argCount;
        this.reset();
    }

    private void reset() throws SQLException {
        this.extent = 0;
        this.massExtent = 0;
        this.fieldCount = 0;
        this.currentArgCount = 0;
        this.currentRecordOffset = 0;
        this.resetColumn();
        this.initRecord();
    }

    private void resetColumn() {
        this.currentFieldCount = 0;
        this.currentFieldLen = 0;
        this.currentPhysicalFieldLen = 0;
        this.extent = this.currentRecordOffset;
    }

    private void initRecord() {
        ++this.currentArgCount;
        this.fieldCount = this.mem.getInt2(this.extent);
        this.extent += 2;
        this.currentFieldCount = 0;
        this.currentFieldLen = 0;
        this.currentPhysicalFieldLen = 0;
        this.currentRecordOffset = this.extent;
    }

    public boolean nextRow() throws SQLException {
        if (this.currentArgCount >= this.argCount) {
            return false;
        }
        for (int i = this.currentFieldCount; i < this.fieldCount; ++i) {
            this.nextField();
        }
        if (this.currentPhysicalFieldLen > 0) {
            this.extent += this.currentPhysicalFieldLen;
        }
        this.initRecord();
        return true;
    }

    public boolean nextField() throws SQLException {
        if (this.currentFieldCount >= this.fieldCount) {
            return false;
        }
        ++this.currentFieldCount;
        if (this.currentPhysicalFieldLen > 0) {
            this.extent += this.currentPhysicalFieldLen;
        }
        this.currentFieldLen = this.currentPhysicalFieldLen = this.getFieldLength(this.extent);
        this.extent += this.currentPhysicalFieldLen > 245 ? 3 : 1;
        if (this.currentPhysicalFieldLen == -3) {
            this.currentPhysicalFieldLen = this.mem.getInt2(this.extent);
            this.extent += 2;
            this.currentFieldLen = this.getFieldLength(this.extent);
            if (this.currentFieldLen > 245) {
                this.extent += 3;
                this.currentPhysicalFieldLen -= 3;
            } else {
                ++this.extent;
                --this.currentPhysicalFieldLen;
            }
        }
        return true;
    }

    public int getCurrentFieldLen() {
        return this.currentFieldLen;
    }

    public int getCurrentOffset() {
        return this.extent;
    }

    public void addArg(int pos, int len) {
        ++this.argCount;
    }

    public void addRow(int fieldCount) {
        super.putInt2(fieldCount, this.extent);
        this.extent += 2;
    }

    public int getFieldLength(int offset) throws SQLException {
        int erg = this.mem.getUInt1(offset);
        if (erg <= 245) {
            return erg;
        }
        if (erg == 255) {
            return this.mem.getInt2(offset + 1);
        }
        if (erg == 254) {
            return -1;
        }
        if (erg == 251) {
            return -2;
        }
        if (erg == 249) {
            return -3;
        }
        throw SQLExceptionSapDB.generateSQLException("error.internal.illegalFieldLength");
    }

    public int putFieldLength(int value, int offset) {
        if (value <= 245) {
            super.putInt1(value, offset);
            return 1;
        }
        super.putInt1(255, offset);
        super.putInt2(value, offset + 1);
        return 3;
    }

    public void putDefineByte(int value, int offset) {
    }

    public void putBigUnicode(char[] value, int offsetInBytes, int lenInBytes) {
        int vallen = value.length * 2;
        this.extent += this.putFieldLength(vallen, this.extent);
        super.putBigUnicode(value, this.extent, vallen);
        this.extent += vallen;
    }

    public void putBytes(byte[] value, int offset, int len) {
        int vallen = value.length;
        this.extent += this.putFieldLength(vallen, this.extent);
        super.putBytes(value, this.extent, vallen);
        this.extent += vallen;
    }

    public void putBytes(byte[] value, int offset) {
        int len = value.length;
        this.extent += this.putFieldLength(len, this.extent);
        super.putBytes(value, this.extent);
        this.extent += len;
    }

    public void putInt1(int value, int offset) {
        int len = 1;
        this.extent += this.putFieldLength(len, this.extent);
        super.putInt1(value, this.extent);
        this.extent += len;
    }

    public void putInt2(int value, int offset) {
        int len = 2;
        this.extent += this.putFieldLength(len, this.extent);
        super.putInt2(value, this.extent);
        this.extent += len;
    }

    public void putInt4(int value, int offset) {
        int len = 4;
        this.extent += this.putFieldLength(len, this.extent);
        super.putInt4(value, this.extent);
        this.extent += len;
    }

    public void putInt8(long value, int offset) {
        int len = 8;
        this.extent += this.putFieldLength(len, this.extent);
        super.putInt8(value, this.extent);
        this.extent += len;
    }

    public int putString(String value, int offset, int length) {
        int len = value.length();
        this.extent += this.putFieldLength(len, this.extent);
        int result = super.putString(value, this.extent, length);
        this.extent += len;
        return result;
    }

    public int putString(String value, int offset) {
        int len = value.length();
        this.extent += this.putFieldLength(len, this.extent);
        int result = super.putString(value, this.extent, len);
        this.extent += len;
        return result;
    }

    public void putStringBytes(byte[] value, int offset, int length) {
        int len = value.length;
        this.extent += this.putFieldLength(len, this.extent);
        super.putStringBytes(value, this.extent, len);
        this.extent += len;
    }

    public void putUnicodeBytes(byte[] value, int offset, int length) {
        int len = value.length;
        this.extent += this.putFieldLength(len, this.extent);
        super.putUnicodeBytes(value, this.extent, len);
        this.extent += len;
    }

    public void putNull(int pos, int len) {
        super.putInt1(254, this.extent);
        ++this.extent;
        this.addArg(pos, len);
    }

    public void putDefault(int pos, int len) {
        super.putInt1(253, this.extent);
        ++this.extent;
        this.addArg(pos, len);
    }

    public StructuredMem putDescriptor(int pos, byte[] descriptor) {
        int offset = this.extent + 1;
        this.putBytes(descriptor, this.extent);
        return this.mem.getPointer(offset);
    }

    public boolean fillWithOMSReader(Reader stream, int rowSize) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"DataPartVariable", (Object)"fillWithOMSReader");
    }

    public boolean fillWithProcedureReader(Reader reader, short rowCount) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"DataPartVariable", (Object)"fillWithProcedureReader");
    }

    public boolean fillWithProcedureStream(InputStream stream, short rowCount) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"DataPartVariable", (Object)"fillWithProcedureStream");
    }

    public void fillWithOMSReturnCode(int returncode) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"DataPartVariable", (Object)"fillWithOMSReturnCode");
    }

    public boolean fillWithOMSStream(InputStream stream, boolean asciiForUnicode) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"DataPartVariable", (Object)"fillWithOMSStream");
    }

    public boolean fillWithOMSStream(InputStream stream, short rowCount) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"DataPartVariable", (Object)"fillWithOMSStream");
    }

    public void putRawData(byte[] value, int offset) {
        int len = value.length;
        super.putBytes(value, this.extent);
        this.extent += len;
    }

    public void moveRecordPointer(int offset, int recordSize) throws SQLException {
        int destRecord = this.currentArgCount + offset;
        if (destRecord < this.currentArgCount) {
            this.reset();
        }
        while (this.currentArgCount < destRecord && this.nextRow()) {
        }
    }

    public DataPart getRecordPointer() throws SQLException {
        return new DataPartVariable(this.getPointer(this.extent - 2), this.argCount);
    }

    public boolean isNull(SQLParamController controller, int bufpos) throws SQLException {
        this.moveColumnPointer(bufpos);
        boolean erg = this.getCurrentFieldLen() == -1;
        controller.setLastWasNull(erg);
        return erg;
    }

    private void moveColumnPointer(int colindex) {
        try {
            if (colindex < this.currentFieldCount) {
                this.resetColumn();
            } else if (colindex > this.fieldCount) {
                // empty if block
            }
            while (this.currentFieldCount < colindex && this.nextField()) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] getBytesFillUp(int offset, int len) {
        this.moveColumnPointer(offset);
        byte[] erg = new byte[len];
        this.mem.getBytes(erg, this.getCurrentOffset(), this.getCurrentFieldLen());
        return erg;
    }

    public byte[] getBytes(int offset, int len) {
        this.moveColumnPointer(offset);
        return this.mem.getBytes(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public byte getBoolean(int offset) {
        this.moveColumnPointer(offset);
        if (this.getCurrentFieldLen() == 0) {
            return 0;
        }
        return this.mem.getInt1(this.getCurrentOffset());
    }

    public byte getInt1(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getInt1(this.getCurrentOffset());
    }

    public int getUInt1(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getUInt1(this.getCurrentOffset());
    }

    public int getInt2(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getInt2(this.getCurrentOffset());
    }

    public int getInt4(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getInt4(this.getCurrentOffset());
    }

    public long getInt8(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getInt8(this.getCurrentOffset());
    }

    public String getString(int offset, int len) {
        this.moveColumnPointer(offset);
        return this.mem.getString(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public byte[] getStrippedBytes(int offset, int len) {
        this.moveColumnPointer(offset);
        return this.mem.getStrippedBytes(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public String getStrippedUnicodeString(int offset, int len) {
        this.moveColumnPointer(offset);
        return this.mem.getStrippedUnicodeString(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public String getStrippedString(int offset, int len) {
        this.moveColumnPointer(offset);
        return this.mem.getStrippedString(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public char getBigUnicodeChar(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getBigUnicodeChar(this.getCurrentOffset());
    }

    public char[] getBigUnicode(int offset, int lenInBytes) {
        this.moveColumnPointer(offset);
        return this.mem.getBigUnicode(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public int checkDefineByte(SQLParamController controller, DataPart mem, int bufpos) {
        this.moveColumnPointer(bufpos);
        int defByte = this.getCurrentFieldLen();
        switch (defByte) {
            case -1: {
                controller.setLastWasNull(true);
                return 1;
            }
            case -2: {
                controller.setLastWasNull(false);
                return 2;
            }
        }
        controller.setLastWasNull(false);
        return -1;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }
}

