/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class DataPartFixed
extends DataPart {
    DataPartFixed(StructuredMem rawMem, RequestPacket requestPacket) {
        super(rawMem, requestPacket);
    }

    public DataPartFixed(StructuredMem rawMem, int argCount) {
        super(rawMem, null);
        this.argCount = argCount;
    }

    public void putDefineByte(int value, int offset) {
        this.putInt1(value, offset);
    }

    public void addRow(int fieldCount) {
    }

    public void addArg(int pos, int len) {
        ++this.argCount;
        this.extent = Math.max(this.extent, pos + len);
    }

    public void putNull(int pos, int len) {
        this.putInt1(-1, pos - 1);
        this.putBytes(new byte[len], pos);
        this.addArg(pos, len);
    }

    public void putDefault(int pos, int len) {
        this.putInt1(-3, pos - 1);
        this.putBytes(new byte[len], pos);
        this.addArg(pos, len);
    }

    public StructuredMem putDescriptor(int pos, byte[] descriptor) {
        this.putDefineByte(0, pos++);
        this.putBytes(descriptor, pos);
        return this.getPointer(pos);
    }

    public boolean fillWithOMSReader(Reader stream, int rowSize) throws SQLException {
        boolean streamExhausted = false;
        int maxDataSize = this.getMaxDataSize() / rowSize * rowSize;
        int readBufSize = 4096 / rowSize * rowSize;
        if (readBufSize == 0) {
            readBufSize = rowSize;
        }
        char[] readBuf = new char[readBufSize];
        int charsRead = 0;
        int bytesWritten = 0;
        while (!streamExhausted && maxDataSize > 0) {
            charsRead = 0;
            int startPos = 0;
            int charsToRead = Math.min(maxDataSize / 2, readBufSize);
            int currCharsRead = 0;
            while (charsToRead != 0) {
                try {
                    currCharsRead = stream.read(readBuf, startPos, charsToRead);
                }
                catch (IOException ioex) {
                    throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)ioex.getMessage());
                }
                if (currCharsRead == -1) {
                    if (charsRead * 2 % rowSize != 0) {
                        throw SQLExceptionSapDB.generateSQLException("error.stream.oddsize");
                    }
                    charsToRead = 0;
                    streamExhausted = true;
                    continue;
                }
                if ((charsRead += currCharsRead) > 0 && charsRead * 2 % rowSize == 0) {
                    charsToRead = 0;
                    continue;
                }
                charsToRead -= currCharsRead;
                startPos += currCharsRead;
            }
            this.putBigUnicode(readBuf, this.extent, charsRead * 2);
            this.extent += charsRead * 2;
            maxDataSize -= charsRead * 2;
            bytesWritten += charsRead * 2;
        }
        this.argCount = bytesWritten / rowSize;
        if (streamExhausted) {
            this.setLastPart();
        }
        return streamExhausted;
    }

    public boolean fillWithProcedureReader(Reader reader, short rowCount) throws SQLException {
        boolean streamExhausted = false;
        int maxDataSize = this.getMaxDataSize() / 2 * 2;
        int readBufSize = 4096;
        if (readBufSize == 0) {
            readBufSize = 2;
        }
        char[] readBuf = new char[readBufSize];
        int charsRead = 0;
        int bytesWritten = 0;
        while (!streamExhausted && maxDataSize > 0) {
            charsRead = 0;
            int startPos = 0;
            int charsToRead = Math.min(maxDataSize / 2, readBufSize);
            int currCharsRead = 0;
            while (charsToRead != 0) {
                try {
                    currCharsRead = reader.read(readBuf, startPos, charsToRead);
                }
                catch (IOException ioex) {
                    throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)ioex.getMessage());
                }
                if (currCharsRead == -1) {
                    charsToRead = 0;
                    streamExhausted = true;
                    continue;
                }
                if ((charsRead += currCharsRead) > 0) {
                    charsToRead = 0;
                    continue;
                }
                charsToRead -= currCharsRead;
                startPos += currCharsRead;
            }
            this.putBigUnicode(readBuf, this.extent, charsRead * 2);
            this.extent += charsRead * 2;
            maxDataSize -= charsRead * 2;
            bytesWritten += charsRead * 2;
        }
        this.argCount = bytesWritten / 2;
        if (streamExhausted) {
            this.setLastPart();
        }
        return streamExhausted;
    }

    public void fillWithOMSReturnCode(int returncode) throws SQLExceptionSapDB {
        this.putInt4(returncode, this.extent);
        this.extent += 4;
        ++this.argCount;
    }

    public boolean fillWithOMSStream(InputStream stream, boolean asciiForUnicode) throws SQLException {
        boolean streamExhausted = false;
        int maxDataSize = this.getMaxDataSize();
        int readBufSize = 4096;
        byte[] readBuf = new byte[readBufSize];
        byte[] expandbuf = null;
        if (asciiForUnicode) {
            expandbuf = new byte[readBufSize * 2];
        }
        int bytesRead = 0;
        int bytesWritten = 0;
        while (!streamExhausted && maxDataSize > (asciiForUnicode ? 1 : 0)) {
            bytesRead = 0;
            int startPos = 0;
            int bytesToRead = Math.min(maxDataSize / (asciiForUnicode ? 2 : 1), readBufSize);
            int currBytesRead = 0;
            while (bytesToRead != 0) {
                try {
                    currBytesRead = stream.read(readBuf, startPos, bytesToRead);
                }
                catch (IOException ioex) {
                    throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)ioex.getMessage());
                }
                if (currBytesRead == -1) {
                    bytesToRead = 0;
                    streamExhausted = true;
                    continue;
                }
                bytesRead += currBytesRead;
                bytesToRead = 0;
            }
            if (asciiForUnicode) {
                for (int i = 0; i < bytesRead; ++i) {
                    expandbuf[i * 2] = 0;
                    expandbuf[i * 2 + 1] = readBuf[i];
                }
                this.putBytes(expandbuf, this.extent, bytesRead * 2);
                this.extent += bytesRead * 2;
                maxDataSize -= bytesRead * 2;
                bytesWritten += bytesRead * 2;
                continue;
            }
            this.putBytes(readBuf, this.extent, bytesRead);
            this.extent += bytesRead;
            maxDataSize -= bytesRead;
            bytesWritten += bytesRead;
        }
        this.argCount = bytesWritten / (asciiForUnicode ? 2 : 1);
        if (streamExhausted) {
            this.setLastPart();
        }
        return streamExhausted;
    }

    public boolean fillWithProcedureStream(InputStream stream, short rowCount) throws SQLException {
        boolean streamExhausted = false;
        int maxDataSize = this.getMaxDataSize();
        if ((maxDataSize -= 8) > Short.MAX_VALUE) {
            maxDataSize = Short.MAX_VALUE;
        }
        int rowsize = 1;
        int bytesRead = 0;
        int bytesWritten = 0;
        int readBufferSize = 4096;
        byte[] readBuffer = new byte[4096];
        while (!streamExhausted & maxDataSize > rowsize) {
            bytesRead = 0;
            int startPos = 0;
            int currBytesRead = 0;
            int bytesToRead = Math.min(maxDataSize / rowsize, readBufferSize);
            while (bytesToRead != 0) {
                try {
                    currBytesRead = stream.read(readBuffer, startPos, bytesToRead);
                }
                catch (IOException ioEx) {
                    throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)ioEx.getMessage());
                }
                if (currBytesRead == -1) {
                    streamExhausted = true;
                    bytesToRead = 0;
                    continue;
                }
                bytesRead += currBytesRead;
                bytesToRead = 0;
            }
            this.putBytes(readBuffer, this.extent, bytesRead);
            this.extent += bytesRead;
            maxDataSize -= bytesRead;
            bytesWritten += bytesRead;
        }
        this.argCount = bytesWritten / rowsize;
        if (streamExhausted) {
            this.setLastPart();
        }
        return streamExhausted;
    }

    public StructuredMem getRecord(int offset, int recordSize) {
        return this.getPointer(offset * recordSize);
    }

    public DataPart getRecordPointer() {
        return new DataPartFixed(this.getPointer(this.extent), this.argCount);
    }

    public void moveRecordPointer(int offset, int recordSize) {
        this.moveBase(offset * recordSize);
    }

    public boolean isNull(SQLParamController controller, int bufpos) {
        byte defByte = this.mem.getInt1(bufpos - 1);
        boolean isNull = defByte == -1;
        controller.setLastWasNull(isNull);
        return isNull;
    }

    public int checkDefineByte(SQLParamController controller, DataPart mem, int bufpos) {
        byte defByte = mem.getInt1(bufpos - 1);
        switch (defByte) {
            case -1: {
                controller.setLastWasNull(true);
                return 1;
            }
            case -2: {
                controller.setLastWasNull(false);
                return 2;
            }
        }
        controller.setLastWasNull(false);
        return -1;
    }

    public byte getBoolean(int offset) {
        return super.getInt1(offset);
    }

    public byte[] getBytesFillUp(int offset, int len) {
        return super.getBytes(offset, len);
    }
}

