/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.MemIndirection;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public abstract class DataPart
extends MemIndirection {
    private static final int maxArgCount = Short.MAX_VALUE;
    private static final int unicodeWidthC = 2;
    protected int argCount = 0;
    protected int extent = 0;
    protected int massExtent = 0;
    StructuredMem originalMem;
    RequestPacket requestPacket;

    DataPart(StructuredMem rawMem, RequestPacket requestPacket) {
        super(rawMem);
        this.originalMem = rawMem.getPointer(0);
        this.requestPacket = requestPacket;
    }

    public abstract void addArg(int var1, int var2);

    public void close() {
        int argCountOffs = -14;
        this.originalMem.putInt2(this.argCount, argCountOffs);
        this.requestPacket.closePart(this.massExtent + this.extent, this.argCount);
    }

    public void closeArrayPart(int rows) {
        int argCountOffs = -14;
        this.originalMem.putInt2(rows, argCountOffs);
        this.requestPacket.closePart(this.massExtent + this.extent * rows, rows);
    }

    protected int getMaxDataSize() {
        return this.size() - this.extent - 8;
    }

    public boolean hasRoomFor(int recordSize, int reserve) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > recordSize + reserve;
    }

    public boolean hasRoomFor(int recordSize) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > recordSize;
    }

    public int getExtent() {
        return this.extent;
    }

    public void setFirstPart() {
        this.requestPacket.addPartAttribute(4);
    }

    public void setLastPart() {
        this.requestPacket.addPartAttribute(1);
    }

    public void moveRecordBase() {
        this.moveBase(this.extent);
        this.massExtent += this.extent;
        this.extent = 0;
    }

    public abstract void putDefineByte(int var1, int var2);

    public void markEmptyStream(StructuredMem descriptorMark) {
        descriptorMark.putInt1(2, 27);
        descriptorMark.putInt4(this.massExtent + this.extent + 1, 32);
        descriptorMark.putInt4(0, 36);
    }

    public abstract boolean fillWithOMSReader(Reader var1, int var2) throws SQLException;

    public abstract boolean fillWithProcedureReader(Reader var1, short var2) throws SQLException;

    public abstract void addRow(int var1);

    public abstract void putNull(int var1, int var2);

    public abstract void putDefault(int var1, int var2);

    public abstract StructuredMem putDescriptor(int var1, byte[] var2);

    public abstract void fillWithOMSReturnCode(int var1) throws SQLException;

    public abstract boolean fillWithOMSStream(InputStream var1, boolean var2) throws SQLException;

    public abstract boolean fillWithProcedureStream(InputStream var1, short var2) throws SQLException;

    public boolean fillWithStream(InputStream stream, StructuredMem descriptorMark, Putval putval) throws SQLException {
        int maxDataSize = this.getMaxDataSize();
        if (maxDataSize <= 3) {
            descriptorMark.putInt1(3, 27);
            return false;
        }
        int dataStart = this.extent;
        byte[] readBuf = new byte[4096];
        boolean streamExhausted = false;
        try {
            while (!streamExhausted && maxDataSize > 0) {
                int bytesRead = stream.read(readBuf, 0, Math.min(maxDataSize, 4096));
                if (bytesRead == -1) {
                    streamExhausted = true;
                    continue;
                }
                this.mem.putBytes(readBuf, this.extent, bytesRead);
                this.extent += bytesRead;
                maxDataSize -= bytesRead;
            }
        }
        catch (IOException exc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)exc.getMessage());
        }
        if (streamExhausted) {
            descriptorMark.putInt1(2, 27);
        } else {
            descriptorMark.putInt1(0, 27);
        }
        descriptorMark.putInt4(this.massExtent + dataStart + 1, 32);
        descriptorMark.putInt4(this.extent - dataStart, 36);
        putval.markRequestedChunk(this.getPointer(dataStart), this.extent - dataStart);
        return streamExhausted;
    }

    public boolean fillWithReader(Reader reader, StructuredMem descriptorMark, Putval putval) throws SQLException {
        int maxDataSize = this.getMaxDataSize() / 2;
        if (maxDataSize <= 1) {
            descriptorMark.putInt1(3, 27);
            return false;
        }
        int dataStart = this.extent;
        char[] readBuf = new char[4096];
        boolean streamExhausted = false;
        try {
            while (!streamExhausted && maxDataSize > 0) {
                int charsRead = reader.read(readBuf, 0, Math.min(maxDataSize, 4096));
                if (charsRead == -1) {
                    streamExhausted = true;
                    continue;
                }
                this.mem.putBigUnicode(readBuf, this.extent, charsRead * 2);
                this.extent += charsRead * 2;
                maxDataSize -= charsRead;
            }
        }
        catch (IOException exc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", (Object)exc.getMessage());
        }
        if (streamExhausted) {
            descriptorMark.putInt1(2, 27);
        } else {
            descriptorMark.putInt1(0, 27);
        }
        descriptorMark.putInt4(this.massExtent + dataStart + 1, 32);
        descriptorMark.putInt4(this.extent - dataStart, 36);
        putval.markRequestedChunk(this.getPointer(dataStart), this.extent - dataStart);
        return streamExhausted;
    }

    public int getArgCount() {
        return this.argCount;
    }

    public abstract void moveRecordPointer(int var1, int var2) throws SQLException;

    public abstract DataPart getRecordPointer() throws SQLException;

    public abstract boolean isNull(SQLParamController var1, int var2) throws SQLException;

    public abstract int checkDefineByte(SQLParamController var1, DataPart var2, int var3);

    public abstract byte getBoolean(int var1) throws SQLException;

    public abstract byte[] getBytesFillUp(int var1, int var2);
}

