/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.exceptions;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.exceptions.ConnectionException;
import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.NotSupportedException;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.dbtech.jdbc.exceptions.TimeoutException;
import com.sap.dbtech.jdbc.exceptions.jdbc40.SQLDataException;
import com.sap.dbtech.jdbc.exceptions.jdbc40.SQLFeatureNotSupportedException;
import com.sap.dbtech.jdbc.exceptions.jdbc40.SQLIntegrityConstraintViolationException;
import com.sap.dbtech.jdbc.exceptions.jdbc40.SQLInvalidAuthorizationSpecException;
import com.sap.dbtech.jdbc.exceptions.jdbc40.SQLNonTransientConnectionException;
import com.sap.dbtech.jdbc.exceptions.jdbc40.SQLSyntaxErrorException;
import com.sap.dbtech.jdbc.exceptions.jdbc40.SQLTimeoutException;
import com.sap.dbtech.jdbc.exceptions.jdbc40.SQLTransactionRollbackException;
import com.sap.dbtech.util.MessageTranslator;
import java.sql.SQLException;

public class SQLExceptionSapDB
extends SQLException
implements SQLExceptionSapDBInterface {
    protected String prefix = "";
    private int errorPos = 0;
    private int m_rteError = 0;

    public int getRTEReturncode() {
        return this.m_rteError;
    }

    protected SQLExceptionSapDB(String reason, String sqlState, int vendorCode, int errpos) {
        super(reason, sqlState, vendorCode);
        this.errorPos = errpos;
    }

    public int getErrorPos() {
        return this.errorPos;
    }

    public String getMessage() {
        return this.prefix + super.getMessage();
    }

    public boolean isConnectionReleasing() {
        int err = this.getErrorCode();
        switch (err) {
            case -904: 
            case -813: 
            case -709: 
            case -708: 
            case -75: 
            case -71: 
            case -70: 
            case 700: 
            case 710: 
            case 750: {
                return true;
            }
        }
        return false;
    }

    public static SQLException generateSQLException(String messageKey) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, 0);
    }

    public static SQLException generateSQLException(String messageKey, Object val1) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey, val1), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, 0);
    }

    public static SQLException generateSQLException(Throwable cause, String messageKey) {
        return SQLExceptionSapDB.createException(cause, MessageTranslator.translate(messageKey), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, 0);
    }

    public static SQLException generateSQLException(Throwable cause, String messageKey, Object val1) {
        return SQLExceptionSapDB.createException(cause, MessageTranslator.translate(messageKey, val1), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, 0);
    }

    public static SQLException generateSQLException(String messageKey, Object val1, Object val2) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey, val1, val2), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, 0);
    }

    public static SQLException generateSQLException(Throwable cause, String messageKey, Object val1, Object val2) {
        return SQLExceptionSapDB.createException(cause, MessageTranslator.translate(messageKey, val1, val2), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, 0);
    }

    public static SQLException generateSQLException(String message, String sqlState, int vendorCode, int errpos) {
        return SQLExceptionSapDB.createException(message, sqlState, vendorCode, errpos, 0);
    }

    public static SQLException generateDatabaseException(String messageKey, String sqlState, int vendorCode, int errpos, int rteError, Object val1, Object val2, Object val3) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey, val1, val2, val3), sqlState, vendorCode, errpos, rteError);
    }

    public static SQLException generateDatabaseException(String messageKey, String sqlState, int vendorCode, int errpos, int rteError, Object val1, Object val2) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey, val1, val2), sqlState, vendorCode, errpos, rteError);
    }

    private static SQLException createException(Throwable cause, String errText, String sqlState, int vendorCode, int errpos, int rteError) {
        SQLException e = SQLExceptionSapDB.createException(errText, sqlState, vendorCode, errpos, rteError);
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }

    private static SQLException createException(String errText, String sqlState, int vendorCode, int errpos, int rteError) {
        if (sqlState == null || sqlState.length() != 5) {
            return new JDBCDriverException(errText, "HY000", vendorCode, errpos);
        }
        char state1 = sqlState.charAt(0);
        char state2 = sqlState.charAt(1);
        switch (state1) {
            case '0': {
                if (state2 == '8') {
                    if (DriverSapDB.isJDBC40) {
                        return SQLNonTransientConnectionException.createException(errText, sqlState, vendorCode, errpos, rteError);
                    }
                    return new ConnectionException(errText, sqlState, vendorCode, errpos);
                }
                if (state2 != 'A') break;
                if (DriverSapDB.isJDBC40) {
                    return SQLFeatureNotSupportedException.createException(errText, sqlState, vendorCode, errpos, rteError);
                }
                return new NotSupportedException(errText, sqlState, vendorCode);
            }
            case '2': {
                if (state2 == '2') {
                    if (DriverSapDB.isJDBC40) {
                        return SQLDataException.createException(errText, sqlState, vendorCode, errpos, rteError);
                    }
                    return new JDBCDriverException(errText, sqlState, vendorCode, errpos);
                }
                if (state2 == '3') {
                    if (DriverSapDB.isJDBC40) {
                        return SQLIntegrityConstraintViolationException.createException(errText, sqlState, vendorCode, errpos, rteError);
                    }
                    return new DatabaseException(errText, sqlState, vendorCode, errpos);
                }
                if (state2 != '8') break;
                if (DriverSapDB.isJDBC40) {
                    return SQLInvalidAuthorizationSpecException.createException(errText, sqlState, vendorCode, errpos, rteError);
                }
                return new JDBCDriverException(errText, sqlState, vendorCode, errpos);
            }
            case '4': {
                if (state2 == '0') {
                    if (DriverSapDB.isJDBC40) {
                        return SQLTransactionRollbackException.createException(errText, sqlState, vendorCode, errpos, rteError);
                    }
                    return new DatabaseException(errText, sqlState, vendorCode, errpos);
                }
                if (state2 != '2') break;
                if (DriverSapDB.isJDBC40) {
                    return SQLSyntaxErrorException.createException(errText, sqlState, vendorCode, errpos, rteError);
                }
                return new DatabaseException(errText, sqlState, vendorCode, errpos);
            }
            case 'H': {
                if (state2 != 'Y') break;
                if (sqlState.equals("HYT01")) {
                    if (DriverSapDB.isJDBC40) {
                        return SQLTimeoutException.createException(errText, sqlState, vendorCode, errpos, rteError);
                    }
                    return new TimeoutException(errText, sqlState, vendorCode);
                }
                return new JDBCDriverException(errText, sqlState, vendorCode, errpos);
            }
        }
        return new JDBCDriverException(errText, sqlState, vendorCode, errpos);
    }
}

