/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredBytes;

public class UserPassword {
    protected boolean m_UserAndPasswordIsAscii = true;
    protected String m_User = "";
    protected String m_UserRawEscaped = "";
    protected String m_PwdRaw = "";
    protected String m_Pwd = "";
    protected String m_PwdLegacy = "";

    public UserPassword(String userRaw, String pwdRaw, boolean preprocesspwd) {
        char lastChar;
        char firstChar;
        if (userRaw.length() > 0) {
            firstChar = userRaw.charAt(0);
            lastChar = userRaw.charAt(userRaw.length() - 1);
            if (firstChar == '\"' && lastChar == '\"') {
                StringBuffer escaped = new StringBuffer(userRaw.length() * 2);
                for (int i = 1; i < userRaw.length() - 1; ++i) {
                    char c = userRaw.charAt(i);
                    if (c == '\"') {
                        escaped.append('\"');
                    }
                    escaped.append(c);
                }
                this.m_UserRawEscaped = escaped.toString();
                this.m_User = userRaw.substring(1, userRaw.length() - 1);
            } else {
                this.m_UserRawEscaped = this.m_User = userRaw.toUpperCase();
            }
        }
        if (pwdRaw.length() > 0) {
            if (preprocesspwd) {
                firstChar = pwdRaw.charAt(0);
                lastChar = pwdRaw.charAt(pwdRaw.length() - 1);
                if (firstChar == '\"' && lastChar == '\"') {
                    this.m_PwdLegacy = this.m_Pwd = pwdRaw.substring(1, pwdRaw.length() - 1);
                } else {
                    this.m_Pwd = pwdRaw;
                    this.m_PwdLegacy = pwdRaw.toUpperCase();
                }
                this.m_PwdRaw = pwdRaw;
            } else {
                this.m_Pwd = pwdRaw;
                this.m_PwdLegacy = pwdRaw;
                this.m_PwdRaw = pwdRaw;
            }
        }
        this.m_UserAndPasswordIsAscii = StringUtil.isIso8859_1(pwdRaw);
        if (this.m_UserAndPasswordIsAscii) {
            this.m_UserAndPasswordIsAscii = StringUtil.isIso8859_1(userRaw);
        }
    }

    public String getUser() {
        return this.m_User;
    }

    public String getRawEscapedUser() {
        return this.m_UserRawEscaped;
    }

    public String getPwd(boolean legacyPassword) {
        return legacyPassword ? this.m_PwdLegacy : this.m_Pwd;
    }

    public String getRawPwd() {
        return this.m_PwdRaw;
    }

    public boolean userAndPasswordIsAscii() {
        return this.m_UserAndPasswordIsAscii;
    }

    public boolean userAndPasswordIsNotAscii() {
        return !this.m_UserAndPasswordIsAscii;
    }

    public static String preprocessUsername(String user) {
        if (user.length() > 0) {
            char firstChar = user.charAt(0);
            char lastChar = user.charAt(user.length() - 1);
            user = firstChar != '\"' || lastChar != '\"' ? user.toUpperCase() : user.substring(1, user.length() - 1);
        }
        return user;
    }

    byte[] mangledLegacyPwd() {
        int i;
        int vp1_C = 2;
        int vp2_C = 521;
        int vp3_C = 133379;
        int maxPwdLen_C = 18;
        boolean isUnicode = !this.m_UserAndPasswordIsAscii;
        StructuredBytes pwdBytes = new StructuredBytes(18);
        if (isUnicode) {
            pwdBytes.putBigUnicode(this.m_PwdLegacy.toCharArray(), 0, 18);
        } else {
            pwdBytes.putString(this.m_PwdLegacy, 0, 18);
        }
        int[] clearname = pwdBytes.getIntArray(0, pwdBytes.size());
        int[] crypt = new int[6];
        for (i = 1; i <= 6; ++i) {
            crypt[i - 1] = clearname[3 * i - 3] * 133379 + clearname[3 * i - 2] * 521 + clearname[3 * i - 1] * 2;
        }
        for (i = 1; i <= 6; ++i) {
            int left = i > 1 ? crypt[i - 2] : 133379;
            int n = i - 1;
            crypt[n] = crypt[n] + left % 61 * 16805753;
        }
        for (i = 6; i >= 1; --i) {
            int right = i < 5 ? crypt[i] : 521;
            int n = i - 1;
            crypt[n] = crypt[n] + right % 61 * 17072511;
        }
        for (i = 0; i < 6; ++i) {
            if ((crypt[i] & 1) == 0) continue;
            crypt[i] = -crypt[i];
        }
        StructuredBytes result = new StructuredBytes(24);
        for (i = 0; i < 6; ++i) {
            result.putInt4(crypt[i], i * 4);
        }
        return result.bytes();
    }
}

