/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ColumnInfo;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.UnicodeConversionException;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import java.sql.SQLException;
import java.util.Hashtable;

public class FetchInfo {
    private ConnectionSapDB connection;
    private String cursorName;
    private DBTechTranslator[] columnInfo;
    private int recordSize;
    private Hashtable columnMapping = null;
    private Hashtable columnLabelMapping = null;
    private String _fetchparamstring;
    private boolean packetEncodingUnicode = false;
    boolean marker = false;

    public FetchInfo(ConnectionSapDB connection, String cursorName, DBTechTranslator[] infos, ColumnInfo[] columnNames, boolean apacketEncodingUnicode) throws SQLException {
        this.connection = connection;
        this.cursorName = cursorName;
        this.packetEncodingUnicode = apacketEncodingUnicode;
        if (infos == null || columnNames == null) {
            this.columnInfo = null;
            return;
        }
        this.setMetaData(infos, columnNames);
    }

    private void describe() throws SQLException {
        ConnectionSapDB c = this.connection;
        DBTechTranslator[] infos = null;
        ColumnInfo[] columnNames = null;
        RequestPacket request = c.getRequestPacket(this.packetEncodingUnicode);
        try {
            request.initDbsCommand(false, "DESCRIBE \"" + this.cursorName + "\"", 1003);
        }
        catch (UnicodeConversionException e) {
            c.freeRequestPacket(request);
            request = this.connection.getRequestPacket(true);
            this.packetEncodingUnicode = true;
            request.initDbsCommandThrowSQLExc(false, "DESCRIBE \"" + this.cursorName + "\"", 1003);
        }
        ReplyPacket reply = c.execute(request, this, 1);
        PartEnumeration parts = reply.partEnumeration();
        while (parts.hasMoreElements()) {
            parts.nextElement();
            int partKind = parts.partKind();
            if (partKind == 2) {
                columnNames = reply.parseColumnNames(columnNames);
                continue;
            }
            if (partKind == 36) {
                columnNames = reply.parseSchemaTableColumnNames(columnNames);
                continue;
            }
            if (partKind == 14) {
                infos = reply.parseShortFields(this.connection, false, null, false);
                continue;
            }
            if (partKind != 32) continue;
            infos = reply.parseShortFields(this.connection, false, null, true);
        }
        this.setMetaData(infos, columnNames);
    }

    private void setMetaData(DBTechTranslator[] info, ColumnInfo[] colName) throws SQLException {
        int colCount = info.length;
        this.recordSize = 0;
        if (colCount == colName.length) {
            this.columnInfo = info;
            for (int i = 0; i < colCount; ++i) {
                DBTechTranslator currentInfo = info[i];
                currentInfo.setColName(colName[i]);
                currentInfo.setColIndex(i);
                int currentFieldEnd = currentInfo.getPhysicalLength() + currentInfo.getOutputBufpos() - 1;
                this.recordSize = Math.max(this.recordSize, currentFieldEnd);
            }
        } else {
            int outputColCnt = 0;
            this.columnInfo = new DBTechTranslator[colName.length];
            for (int i = 0; i < colCount; ++i) {
                if (!info[i].isOutput()) continue;
                DBTechTranslator currentInfo = this.columnInfo[outputColCnt] = info[i];
                currentInfo.setColName(colName[outputColCnt]);
                currentInfo.setColIndex(outputColCnt++);
                int currentFieldEnd = currentInfo.getPhysicalLength() + currentInfo.getOutputBufpos() - 1;
                this.recordSize = Math.max(this.recordSize, currentFieldEnd);
            }
        }
    }

    private void setColMapping() throws SQLException {
        int colCnt = this.columnInfo.length;
        this.columnMapping = new Hashtable(2 * colCnt);
        this.columnLabelMapping = new Hashtable(2 * colCnt);
        for (int i = 0; i < colCnt; ++i) {
            DBTechTranslator currentInfo = this.columnInfo[i];
            if (currentInfo == null) {
                throw SQLExceptionSapDB.generateSQLException("error.internal.invalidColumnDescription", new Integer(i + 1));
            }
            if (!this.columnMapping.containsKey(currentInfo.getColumnName())) {
                this.columnMapping.put(currentInfo.getColumnName(), currentInfo);
            }
            if (this.columnLabelMapping.containsKey(currentInfo.getColumnLabel())) continue;
            this.columnLabelMapping.put(currentInfo.getColumnLabel(), currentInfo);
        }
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public ReplyPacket executeFetchNext(int fetchSize) throws SQLException {
        String cmd = "FETCH NEXT \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        ReplyPacket r = this.executeFetchCommand(cmd, fetchSize);
        return r;
    }

    public ReplyPacket executeFetchAbsolute(long position, int fetchSize) throws SQLException {
        String cmd = "FETCH ABSOLUTE " + position + " \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        ReplyPacket r = this.executeFetchCommand(cmd, fetchSize);
        return r;
    }

    public ReplyPacket executeFetchLastWithRowNo(int fetchSize) throws SQLException {
        String cmd = "FETCH LAST \"" + this.cursorName + "\" INTO " + this.getFetchParamString() + "  WITH ROWNO";
        ReplyPacket r = this.executeFetchCommand(cmd, fetchSize);
        return r;
    }

    public ReplyPacket executeFetchRelative(long position, int fetchSize) throws SQLException {
        String cmd = "FETCH RELATIVE " + position + " \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        return this.executeFetchCommand(cmd, fetchSize);
    }

    public ReplyPacket executeFetchFirst(int fetchSize) throws SQLException {
        String cmd = "FETCH FIRST \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        return this.executeFetchCommand(cmd, fetchSize);
    }

    public ReplyPacket executeFetchLast(int fetchSize) throws SQLException {
        String cmd = "FETCH LAST \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        return this.executeFetchCommand(cmd, fetchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplyPacket executeFetchCommand(String command, int fetchSize) throws SQLException {
        RequestPacket request = this.connection.getRequestPacket(this.packetEncodingUnicode);
        int currentSQLMode = request.switchSqlMode(2);
        request.initDbsCommandThrowSQLExc(this.connection.getAutoCommit(), command, 1003);
        if (fetchSize > 1) {
            request.setMassCommand();
        } else {
            fetchSize = 1;
        }
        request.addResultCount(fetchSize);
        try {
            ReplyPacket replyPacket = this.connection.execute(request, this, 2);
            return replyPacket;
        }
        finally {
            request.switchSqlMode(currentSQLMode);
        }
    }

    private String getFetchParamString() throws SQLException {
        if (this.columnInfo == null) {
            this.describe();
        }
        if (this._fetchparamstring == null) {
            StringBuffer tmp = new StringBuffer("?");
            for (int i = 1; i < this.columnInfo.length; ++i) {
                tmp.append(", ?");
            }
            this._fetchparamstring = tmp.toString();
        }
        return this._fetchparamstring;
    }

    public final DBTechTranslator getColumnInfo(String name) throws SQLException {
        String uc;
        Object o;
        if (this.columnInfo == null) {
            this.describe();
        }
        if (this.columnMapping == null) {
            this.setColMapping();
        }
        if ((o = this.columnLabelMapping.get(name)) == null && (o = this.columnLabelMapping.get(uc = name.toUpperCase())) != null) {
            this.columnLabelMapping.put(uc, o);
        }
        if (o == null && (o = this.columnMapping.get(name)) == null && (o = this.columnMapping.get(uc = name.toUpperCase())) != null) {
            this.columnMapping.put(uc, o);
        }
        return (DBTechTranslator)o;
    }

    public DBTechTranslator[] getColInfo() throws SQLException {
        if (this.columnInfo == null) {
            this.describe();
        }
        return this.columnInfo;
    }

    int numberOfColumns() {
        return this.columnInfo.length;
    }

    int getRecordSize() {
        return this.recordSize;
    }
}

