/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.ConnectionSapDBFinalize;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.trace.Connection;
import com.sap.dbtech.jdbc.trace.TraceControl;
import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.NiCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.SecureCommunication;
import com.sap.dbtech.rte.comm.SocketComm;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.TraceConfiguration;
import com.sap.dbtech.util.TraceTool;
import com.sap.dbtech.util.VersionInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DriverSapDB
implements Driver {
    static DriverSapDB driver = new DriverSapDB();
    public static TraceControl pptracer;
    static JdbcCommFactory commFactory;
    public static boolean isJDBC20;
    public static boolean isJDBC40;
    static VersionInfo jdbcDriverVersion;
    static final String protocolName_C = "jdbc:sapdb:";
    static final String loadbinProperty_C = "com.sap.dbtech.jdbc.loadbin";
    static final String osNameProperty_C = "os.name";
    static final String osLinuxString_C = "Linux";
    public static String sqlj_C;
    public static String computername;
    public static String fullcomputername;
    public static int processid;
    static final String driverName_C = "SAP DB";
    public static final String sapdbEncodingC = "ISO8859_1";
    public static final int JAVA_1_1 = 1001999;
    public static final int JAVA_1_2 = 1002999;
    public static final int JAVA_1_3 = 1003999;
    public static final int currentVMVersion;
    static final String userName_C = "user";
    static final String preprocesspwd_C = "preprocesspwd";
    static final String passwordName_C = "password";
    static final String urlName_C = "url";
    static final String sqlmodeName_C = "sqlmode";
    static final String cachelimitName_C = "cachelimit";
    static final String timeoutName_C = "timeout";
    static final String isolationName_C = "isolation";
    static final String autocommitName_C = "autocommit";
    public static final String traceName_C = "trace";
    static final String connectiontraceName_C = "connectiontrace";
    static final String traceSize_C = "tracesize";
    public static final String transportName_C = "transport";
    static final String cacheName_C = "cache";
    static final String cacheSizeName_C = "cachesize";
    static final String currentSchemaName_C = "currentschema";
    static final String unicodeName_C = "unicode";
    static final String reconnect_C = "reconnect";
    static final String spaceoption_C = "spaceoption";
    static final String application_C = "application";
    static final String appversion_C = "appversion";
    public static final String communicationtimeout_C = "communicationtimeout";
    static final String authentication_C = "authentication";
    static final String encrytption_C = "encryption";
    static final String useDefaultValueForUpdatableRS_C = "useDefaultValueForUpdatableRS";
    static final String connecttype_C = "connecttype";
    static final String dbproviderprogram_C = "program";
    static final String dbrootKeyC = "dbroot";
    static final String pickyC = "picky";
    public static final String disableTracing_C = "disableTracing";
    public static final String defaultResultSetType = "defaultresultsettype";
    public static final String closeHandlesOnFinalize = "closehandlesonfinalize";
    public static final String disableSelectFetchOptimize_C = "disableselectfetchoptimize";
    public static final String ni_sap_logon_clientC = "ni_sap_logon_client";
    public static final String ni_sap_logon_userC = "ni_sap_logon_user";
    public static final String ni_sap_logon_authC = "ni_sap_logon_auth";
    public static final String ni_sap_logon_langC = "ni_sap_logon_lang";
    public static final String ni_sap_logon_hostC = "ni_sap_logon_host";
    public static final String ni_sap_logon_systemC = "ni_sap_logon_system";
    public static final String ni_sap_logon_groupC = "ni_sap_logon_group";
    public static final String ni_sap_logon_transC = "ni_sap_logon_trans";
    public static final String ni_sap_keyC = "ni_sap_key";
    static final String dburlName_C = "dburl";
    static final String dbName_C = "dbname";
    static final String sqlmodeOracle_C = "oracle";
    static final String niconnect_C = "niconnect";
    public static final boolean catchAllNotImplemented_C = false;
    private static final String[] trueStrings;
    static boolean isTraceOn;

    static int getVMVersion() {
        try {
            String vers = System.getProperty("java.version");
            int startpos = vers.indexOf(49);
            if (startpos == -1) {
                return 1003999;
            }
            int endpos = vers.indexOf(46, startpos);
            if (endpos == -1) {
                return 1003999;
            }
            int major = Integer.parseInt(vers.substring(startpos, endpos));
            startpos = endpos + 1;
            if ((endpos = vers.indexOf(46, startpos)) == -1) {
                return 1003999;
            }
            int minor = Integer.parseInt(vers.substring(startpos, endpos));
            return major * 1000000 + minor * 1000;
        }
        catch (NumberFormatException numberFormatEx) {
            return 1003999;
        }
        catch (AccessControlException ex) {
            return 1002999;
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        boolean result = url.startsWith(protocolName_C);
        return result;
    }

    public static final String buildURL(String host, String dbname) {
        return "jdbc:sapdb://" + host + "/" + dbname;
    }

    public static final java.sql.Connection connect(String user, String pwd, String host, String dbname, String properties) throws SQLException {
        String url = DriverSapDB.buildURL(host, dbname);
        if (properties != null && properties.length() > 0) {
            url = url + "?" + properties;
        }
        Properties info = new Properties();
        info.put(userName_C, user);
        info.put(passwordName_C, pwd);
        return DriverSapDB.singleton().connect(url, info);
    }

    public java.sql.Connection connect(String url, Properties info) throws SQLException {
        JdbcCommunication session = null;
        if (!this.acceptsURL(url)) {
            return null;
        }
        url = this.parseURLProperties(url, info);
        TraceControl mytrc = DriverSapDB.openTrace(info);
        mytrc.refreshTraceSettings();
        mytrc.tracer.print("new Connection '" + url + "'", info);
        try {
            session = this.openByURL(url, info, mytrc);
        }
        catch (RTEException rteExc) {
            if (mytrc.isTraceOn()) {
                mytrc.tracer.println("using " + session);
                mytrc.tracer.println("=> FAILED");
            }
            throw SQLExceptionSapDB.generateDatabaseException("error.connect.rteexception", "", rteExc.getDetailErrorCode(), 0, rteExc.getRTEReturncode(), url, rteExc.getMessage());
        }
        ConnectionSapDB innerCon = DriverSapDB.getBooleanProperty(info, closeHandlesOnFinalize, true) ? new ConnectionSapDBFinalize(session, info, mytrc) : new ConnectionSapDB(session, info, mytrc);
        java.sql.Connection result = DriverSapDB.getBooleanProperty(info, disableTracing_C, false) ? innerCon : Connection.createNew(innerCon, this, mytrc);
        if (mytrc.isTraceOn()) {
            ((Connection)result).traceOn();
            mytrc.tracer.println("using " + session);
            mytrc.tracer.println("=> " + innerCon);
        }
        return result;
    }

    public static final synchronized TraceControl openTrace(Properties info) {
        TraceControl mytrcCtl = pptracer;
        String trace = info.getProperty(traceName_C);
        if (trace == null) {
            try {
                trace = System.getProperty("sapdbctrace");
            }
            catch (AccessControlException ignore) {
                // empty catch block
            }
        }
        if (trace == null && (trace = info.getProperty(connectiontraceName_C)) != null) {
            mytrcCtl = new TraceControl();
        }
        String maxTraceSize = info.getProperty(traceSize_C);
        if (trace != null) {
            boolean forceReopen = mytrcCtl.tracer.setTraceFileName(trace);
            if (forceReopen |= mytrcCtl.tracer.setMaxTraceSize(maxTraceSize)) {
                mytrcCtl.switchTraceOff();
            }
            mytrcCtl.switchTraceOn();
        }
        return mytrcCtl;
    }

    public static final boolean getBooleanProperty(Properties properties, String name, boolean defaultValue) {
        boolean result = defaultValue;
        String value = properties.getProperty(name);
        if (value != null) {
            result = false;
            for (int i = 0; i < trueStrings.length; ++i) {
                if (!value.equalsIgnoreCase(trueStrings[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static final int getIntProperty(Properties properties, String name, int defaultValue) {
        int result = defaultValue;
        String value = properties.getProperty(name);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        return result;
    }

    public final int getMajorVersion() {
        return jdbcDriverVersion.getMajorVersion();
    }

    public final int getMinorVersion() {
        return jdbcDriverVersion.getMinorVersion();
    }

    final String getName() {
        return driverName_C;
    }

    public final DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo userItem = null;
        DriverPropertyInfo passwordItem = null;
        int count = 0;
        int i = 0;
        if (info.getProperty(userName_C) == null) {
            userItem = new DriverPropertyInfo(userName_C, null);
            userItem.required = true;
            ++count;
        }
        if (info.getProperty(passwordName_C) == null) {
            passwordItem = new DriverPropertyInfo(passwordName_C, null);
            passwordItem.required = true;
            ++count;
        }
        DriverPropertyInfo[] result = new DriverPropertyInfo[count];
        if (userItem != null) {
            result[i] = userItem;
            ++i;
        }
        if (passwordItem != null) {
            result[i] = passwordItem;
            ++i;
        }
        return result;
    }

    public static final String getProtocol() {
        return protocolName_C;
    }

    public static final String getVersionString() {
        return DriverSapDB.getStaticVersion();
    }

    public static String getStaticVersion() {
        return jdbcDriverVersion.toString();
    }

    public static String getStaticShortVersion() {
        return jdbcDriverVersion.toMiniString();
    }

    public final boolean jdbcCompliant() {
        return true;
    }

    public static void load() {
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar sapdbc.jar -V|--version\n         to get the version information\n\n   or  java -jar sapdbc.jar -d <dbname> -u <user,password>\n         [-n <hostname> -o <connect option>\n          -c < sql command> | -a <dbm command>]\n         to check if a connection can be established\n         or to execute a simple command\n\n   or  java -jar sapdbc.jar -g|--gui|GUI\n         to run a GUI tool to configure trace settings\n\n   or  java -jar sapdbc.jar <command>\n         Commands:\n           TRACE ON|OFF\n            Enables/disables trace.\n           TRACE SIZE <size>\n             Limits the size of the trace file to <size> bytes,\n             at least 8192 bytes are required.\n           TRACE FILENAME <filename>\n             Sets the name of the trace file. Note the driver\n             adds an unique suffix to the trace file name.\n           TRACE STOP ON ERROR <error>|OFF\n             Stops tracing after the error <error> has happened\n             or sswitches the trace stop feature off.\n           SHOW [ALL|TRACESETTINGS]\n             Displays the current trace setting.\n");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        TraceConfiguration settings;
        if (args.length == 0) {
            TraceTool.main(null);
            return;
        }
        int currElem = 0;
        if ((args[currElem].equals("-u") || args[currElem].equals("--user")) && args.length > currElem + 1) {
            String user = args[currElem + 1];
            Properties prop = System.getProperties();
            prop.put("user.name", user);
            System.setProperties(prop);
            currElem += 2;
            if (args.length == 2) {
                TraceTool.main(null);
                return;
            }
        }
        if (args[currElem].equals("-h") || args[currElem].equals("--help") || args[currElem].equalsIgnoreCase("help")) {
            DriverSapDB.printUsage();
        } else if (args[currElem].equals("-V") || args[currElem].equals("--version")) {
            System.out.println(DriverSapDB.getStaticVersion());
        } else if (args[currElem].equals("-g") || args[currElem].equals("--gui") || args[currElem].equalsIgnoreCase("gui")) {
            TraceTool.main(null);
        } else if (args[currElem].equalsIgnoreCase("TRACE")) {
            settings = new TraceConfiguration();
            if (args.length > currElem + 1) {
                if (args[currElem + 1].equalsIgnoreCase("ON")) {
                    settings.setTraceOn(true);
                } else if (args[currElem + 1].equalsIgnoreCase("OFF")) {
                    settings.setTraceOn(false);
                } else if (args.length > currElem + 2 && args[currElem + 1].equalsIgnoreCase("SIZE")) {
                    String size = args[currElem + 2].toUpperCase();
                    long filesize = 0L;
                    String unit = "";
                    if (size.equalsIgnoreCase("UNLIMITED")) {
                        filesize = Long.MAX_VALUE;
                    } else {
                        int i;
                        for (i = currElem + 3; i < args.length; ++i) {
                            size = size + args[i].toUpperCase();
                        }
                        for (i = 0; i < size.length(); ++i) {
                            if (!Character.isDigit(size.charAt(i))) {
                                if (i == 0) {
                                    System.err.print("invalid size");
                                    DriverSapDB.printUsage();
                                    break;
                                }
                                if (i + 1 == size.length()) {
                                    filesize = Long.parseLong(size);
                                    break;
                                }
                                filesize = Long.parseLong(size.substring(0, i));
                                while (Character.isSpace(size.charAt(i))) {
                                    ++i;
                                }
                                switch (size.charAt(i)) {
                                    case 'K': {
                                        unit = "KB";
                                        break;
                                    }
                                    case 'M': {
                                        unit = "MB";
                                        break;
                                    }
                                    case 'G': {
                                        unit = "GB";
                                        break;
                                    }
                                    default: {
                                        System.err.print("invalid size");
                                        DriverSapDB.printUsage();
                                        break;
                                    }
                                }
                                break;
                            }
                            if (i + 1 != size.length()) continue;
                            filesize = Long.parseLong(size);
                        }
                    }
                    settings.setTraceSize(filesize, unit);
                } else if (args.length > currElem + 2 && args[currElem + 1].equalsIgnoreCase("FILENAME")) {
                    String filename = args[currElem + 2];
                    int index = filename.lastIndexOf(File.separatorChar);
                    if (-1 != index) {
                        settings.setTraceFolder(filename.substring(0, index));
                        settings.setTraceFileName(filename.substring(index + 1));
                    } else {
                        settings.setTraceFileName(filename);
                    }
                } else if (args.length > currElem + 4 && args[currElem + 1].equalsIgnoreCase("STOP") && args[currElem + 2].equalsIgnoreCase("ON") && args[currElem + 3].equalsIgnoreCase("ERROR")) {
                    int errornum = 0;
                    if (!args[currElem + 4].equalsIgnoreCase("OFF")) {
                        try {
                            errornum = Integer.parseInt(args[currElem + 4]);
                        }
                        catch (Exception e) {
                            System.err.print("invalid error number " + args[currElem + 4]);
                            DriverSapDB.printUsage();
                        }
                    }
                    settings.setStopOnError(errornum);
                } else {
                    System.err.print("invalid command");
                    for (int i = currElem; i < args.length; ++i) {
                        System.err.print(args[i] + " ");
                    }
                    System.err.print("\n");
                    DriverSapDB.printUsage();
                }
            } else {
                System.err.println("invalid command");
                DriverSapDB.printUsage();
            }
            try {
                settings.saveTraceSettings();
            }
            catch (FileNotFoundException ex) {
                System.err.println(ex);
            }
            catch (IOException ex) {
                System.err.println(ex.toString());
            }
            settings.setTraceSettingsChangeFlag();
            settings.dumpTracesettings(System.out);
        } else if (args[currElem].equalsIgnoreCase("SHOW")) {
            settings = new TraceConfiguration();
            settings.dumpTracesettings(System.out);
        } else {
            String currentArg;
            Properties info = new Properties();
            boolean hasUser = false;
            boolean hasDb = false;
            boolean hasDbm = false;
            info.put("host", "");
            info.put("options", "");
            info.put("cmd", "Select 'successfully connected' as \"connect test\" from dual");
            info.put("dbm", "db_enum");
            block40: for (int i = 0; i < args.length && (currentArg = args[i]).charAt(0) == '-'; ++i) {
                char currentOpt = currentArg.charAt(1);
                switch (currentOpt) {
                    case 'u': {
                        currentArg = args[++i];
                        int pos = currentArg.indexOf(44);
                        info.put(userName_C, currentArg.substring(0, pos));
                        info.put(passwordName_C, currentArg.substring(pos + 1));
                        hasUser = true;
                        continue block40;
                    }
                    case 'd': {
                        info.put(dbName_C, args[++i]);
                        hasDb = true;
                        continue block40;
                    }
                    case 'n': {
                        info.put("host", args[++i]);
                        continue block40;
                    }
                    case 'o': {
                        info.put("options", "?" + args[++i]);
                        continue block40;
                    }
                    case 'c': {
                        info.put("cmd", args[++i]);
                        continue block40;
                    }
                    case 'a': {
                        info.put("dbm", args[++i]);
                        hasDbm = true;
                        continue block40;
                    }
                    default: {
                        System.err.println("invalid option " + currentOpt);
                        DriverSapDB.printUsage();
                    }
                }
            }
            if (hasDb && hasUser) {
                if (hasDbm) {
                    try {
                        Properties props = new Properties();
                        DriverSapDB.parsePropertiesString((String)info.get("options"), props);
                        props.put("host", (String)info.get("host"));
                        props.put(dbName_C, (String)info.get(dbName_C));
                        DBM repman = new DBM(props);
                        String erg = repman.cmd("user_logon " + (String)info.get(userName_C) + "," + (String)info.get(passwordName_C));
                        erg = repman.cmd((String)info.get("dbm"));
                        System.out.println(erg);
                        repman.release();
                    }
                    catch (DBMException ex) {
                        ex.printStackTrace();
                    }
                    catch (RTEException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    java.sql.Connection connection = null;
                    try {
                        connection = new DriverSapDB().connect(DriverSapDB.buildURL((String)info.get("host"), (String)info.get(dbName_C)) + info.get("options"), info);
                        Statement stmt = connection.createStatement();
                        if (stmt.execute((String)info.get("cmd"))) {
                            DriverSapDB.printResultSet(System.out, stmt.getResultSet());
                        } else {
                            System.out.println(stmt.getUpdateCount() + " row(s) affected");
                        }
                    }
                    catch (SQLException ex) {
                        System.err.println("SQLException: " + ex.getErrorCode() + " " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e) {}
                        }
                    }
                }
            }
        }
    }

    public static void printResultSet(PrintStream out, ResultSet rs) throws SQLException {
        if (!rs.next()) {
            out.println("row not found");
        } else {
            int j;
            int len;
            String val;
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            StringBuffer res = new StringBuffer(50);
            res.append("| ");
            for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                val = rsmd.getColumnName(i);
                len = rsmd.getPrecision(i);
                if (rsmd.getColumnType(i) == 2005 || rsmd.getColumnType(i) == 2004 || len == Integer.MAX_VALUE) {
                    len = 200;
                }
                if (val.length() > len) {
                    res.append(val.substring(0, len));
                } else {
                    res.append(val);
                    for (j = 0; j < len - val.length(); ++j) {
                        res.append(" ");
                    }
                }
                res.append(" | ");
            }
            out.println(res.toString());
            for (int j2 = 1; j2 < res.length(); ++j2) {
                out.print("-");
            }
            out.println("");
            do {
                res = new StringBuffer(res.capacity());
                res.append("| ");
                for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                    val = rs.getString(i);
                    if (val == null) {
                        val = "?";
                    }
                    len = rsmd.getPrecision(i);
                    if (rsmd.getColumnType(i) == 2005 || rsmd.getColumnType(i) == 2004 || len == Integer.MAX_VALUE) {
                        len = 200;
                    }
                    if (val.length() > len) {
                        res.append(val.substring(0, len));
                    } else {
                        res.append(val);
                        for (j = 0; j < len - val.length(); ++j) {
                            res.append(" ");
                        }
                    }
                    res.append(" | ");
                }
                out.println(res.toString());
            } while (rs.next());
        }
    }

    static String mapIsolation(String isolationProperty) throws SQLException {
        String result;
        int isolevel;
        block14: {
            isolevel = -1;
            try {
                isolevel = Integer.parseInt(isolationProperty);
            }
            catch (NumberFormatException exc1) {
                String sapdbtechPrefix = "ADABAS";
                String jdbcPrefix = "TRANSACTION_";
                if (isolationProperty.startsWith("ADABAS")) {
                    try {
                        isolevel = Integer.parseInt(isolationProperty.substring("ADABAS".length()));
                    }
                    catch (NumberFormatException exc2) {}
                }
                if (!isolationProperty.startsWith("TRANSACTION_")) break block14;
                String rest = isolationProperty.substring("TRANSACTION_".length());
                if (rest.equals("READ_UNCOMMITTED")) {
                    isolevel = 1;
                }
                if (rest.equals("READ_COMMITTED")) {
                    isolevel = 2;
                }
                if (rest.equals("REPEATABLE_READ")) {
                    isolevel = 4;
                }
                if (!rest.equals("SERIALIZABLE")) break block14;
                isolevel = 8;
            }
        }
        switch (isolevel) {
            case 1: {
                result = "0";
                break;
            }
            case 2: {
                result = "1";
                break;
            }
            case 4: {
                result = "2";
                break;
            }
            case 8: {
                result = "3";
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.transactionisolation", (Object)isolationProperty);
            }
        }
        return result;
    }

    static int resultSetTypeString2Jdbc(String resultSetType) {
        int resType;
        block4: {
            resType = 1003;
            try {
                resType = Integer.parseInt(resultSetType);
            }
            catch (NumberFormatException exc1) {
                if (resultSetType.equals("TYPE_FORWARD_ONLY")) {
                    resType = 1003;
                }
                if (resultSetType.equals("TYPE_SCROLL_INSENSITIVE")) {
                    resType = 1004;
                }
                if (!resultSetType.equals("TYPE_SCROLL_SENSITIVE")) break block4;
                resType = 1005;
            }
        }
        return resType;
    }

    static int isolevelString2Jdbc(String isolationProperty) {
        int isolevel;
        block8: {
            isolevel = -1;
            try {
                isolevel = Integer.parseInt(isolationProperty);
            }
            catch (NumberFormatException exc1) {
                String sapdbtechPrefix = "ADABAS";
                String jdbcPrefix = "TRANSACTION_";
                if (isolationProperty.startsWith("ADABAS")) {
                    try {
                        isolevel = Integer.parseInt(isolationProperty.substring("ADABAS".length()));
                    }
                    catch (NumberFormatException exc2) {}
                }
                if (!isolationProperty.startsWith("TRANSACTION_")) break block8;
                String rest = isolationProperty.substring("TRANSACTION_".length());
                if (rest.equals("READ_UNCOMMITTED")) {
                    isolevel = 1;
                }
                if (rest.equals("READ_COMMITTED")) {
                    isolevel = 2;
                }
                if (rest.equals("REPEATABLE_READ")) {
                    isolevel = 4;
                }
                if (!rest.equals("SERIALIZABLE")) break block8;
                isolevel = 8;
            }
        }
        return isolevel;
    }

    static String isolevelJdbc2native(int isolevel) throws SQLException {
        String result;
        switch (isolevel) {
            case 0: 
            case 1: {
                result = "0";
                break;
            }
            case 2: {
                result = "1";
                break;
            }
            case 4: {
                result = "2";
                break;
            }
            case 8: {
                result = "3";
                break;
            }
            case 15: {
                result = "15";
                break;
            }
            case 50: {
                result = "50";
                break;
            }
            case 60: {
                result = "60";
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.transactionisolation", (Object)Integer.toString(isolevel));
            }
        }
        return result;
    }

    private final JdbcCommunication openByURL(String url, Properties info, TraceControl mytrc) throws RTEException, SQLException {
        String dbname;
        String host;
        int slashPos;
        int urlLength = url.length();
        if (urlLength >= (slashPos = protocolName_C.length()) + 3 && url.substring(slashPos, slashPos + 2).equals("//")) {
            String strippedUrl = url.substring(slashPos + 2);
            if (strippedUrl.startsWith("sapni:")) {
                int endPattern = strippedUrl.indexOf(":inpas", 6);
                if (-1 == endPattern) {
                    throw SQLExceptionSapDB.generateSQLException("error.host.wrongconnecturl", (Object)"closing token \":inpas\" not found for SAP routerstring");
                }
                host = strippedUrl.substring(6, endPattern);
                dbname = strippedUrl.substring(endPattern + 7, strippedUrl.length());
                info.put(niconnect_C, "true");
                if (commFactory == SocketComm.factory) {
                    commFactory = NiCommunication.factory;
                }
            } else {
                int closingSlashPos = strippedUrl.indexOf(47);
                host = strippedUrl.substring(0, closingSlashPos);
                dbname = strippedUrl.substring(closingSlashPos + 1, strippedUrl.length());
            }
        } else {
            host = "";
            dbname = url.substring(slashPos, urlLength).trim();
        }
        dbname = dbname.toUpperCase();
        String dburl = DriverSapDB.buildURL(host, dbname);
        info.put(dburlName_C, dburl);
        info.put(dbName_C, dbname);
        return this.openConnection(host, dbname, info, mytrc);
    }

    private final String parseURLProperties(String url, Properties info) {
        int questionPos = url.indexOf(63);
        if (questionPos >= 0) {
            DriverSapDB.parsePropertiesString(url.substring(questionPos + 1), info);
            url = url.substring(0, questionPos);
        }
        return url;
    }

    public final JdbcCommunication openConnection(String host, String dbname, Properties info, TraceControl mytrc) throws RTEException {
        JdbcCommunication result;
        JdbcCommFactory factory;
        String dbproviderProg = info.getProperty(dbproviderprogram_C, null);
        String transport = DriverSapDB.getBooleanProperty(info, encrytption_C, false) ? "secure" : info.getProperty(transportName_C, "socket");
        if (transport.equalsIgnoreCase("socket")) {
            factory = DriverSapDB.getBooleanProperty(info, niconnect_C, false) ? NiCommunication.factory : SocketComm.factory;
        } else if (transport.equals("secure")) {
            factory = SecureCommunication.factory;
        } else {
            throw new RTEException(MessageTranslator.translate("error.invalid.transport", transport), -10899, mytrc.tracer, 1, null);
        }
        if (dbproviderProg != null) {
            String dbroot = info.getProperty(dbrootKeyC, "");
            result = factory.xopen(host, dbname, dbroot, dbproviderProg, info, mytrc.tracer);
        } else {
            result = factory.open(host, dbname, info, mytrc.tracer);
        }
        return result;
    }

    public static boolean parseBooleanProperty(String property) {
        boolean result = false;
        if (property.equalsIgnoreCase("true")) {
            result = true;
        }
        return result;
    }

    private static void parsePropertiesString(String urlArgs, Properties info) {
        if (urlArgs != null && urlArgs.length() > 0 && urlArgs.charAt(0) == '?') {
            urlArgs = urlArgs.substring(1);
        }
        String[] args = StringUtil.split(urlArgs, "&");
        for (int i = 0; i < args.length; ++i) {
            String key;
            String arg = args[i];
            int assignPos = arg.indexOf(61);
            if (assignPos <= 0 || sqlj_C.equals(key = arg.substring(0, assignPos))) continue;
            info.put(arg.substring(0, assignPos), arg.substring(assignPos + 1));
        }
    }

    public static DriverSapDB singleton() {
        return driver;
    }

    private static void loadDriver() {
        jdbcDriverVersion = new VersionInfo("com.sap.dbtech.jdbc", "package com.sap.dbtech.jdbc, SAP DB JDBC Driver, SAP AG, ");
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException sqlExc) {
            // empty catch block
        }
        try {
            computername = InetAddress.getLocalHost().getHostName();
            int pos = computername.indexOf(46);
            if (-1 != pos) {
                computername = computername.substring(0, pos);
            }
        }
        catch (UnknownHostException e) {
            computername = null;
        }
        try {
            fullcomputername = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            fullcomputername = null;
        }
        try {
            Class<?> mfc = Class.forName("java.lang.management.ManagementFactory");
            Class<?> runtimeMXBean = Class.forName("java.lang.management.RuntimeMXBean");
            Method meth = mfc.getMethod("getRuntimeMXBean", new Class[0]);
            Object runtimeMXBeanObj = meth.invoke(null, new Object[0]);
            meth = runtimeMXBean.getMethod("getName", new Class[0]);
            String name = (String)meth.invoke(runtimeMXBeanObj, new Object[0]);
            int pos = name.indexOf(64);
            if (pos != -1) {
                processid = Integer.parseInt(name.substring(0, pos));
            }
        }
        catch (Exception ex) {
        }
        catch (Error error) {
            // empty catch block
        }
        pptracer = new TraceControl();
    }

    private static boolean detectJDBC20() {
        boolean result;
        try {
            Class.forName("java.sql.Clob");
            result = true;
        }
        catch (ClassNotFoundException exc) {
            result = false;
        }
        return result;
    }

    private static boolean detectJDBC40() {
        boolean result;
        try {
            Class.forName("java.sql.SQLFeatureNotSupportedException");
            result = true;
        }
        catch (ClassNotFoundException exc) {
            result = false;
        }
        return result;
    }

    public static JdbcCommFactory getCommunicationFactory() {
        return commFactory;
    }

    public static synchronized void switchTraceOn() {
        pptracer.switchTraceOn();
    }

    public static synchronized void switchTraceOff() {
        pptracer.switchTraceOff();
    }

    static {
        isJDBC20 = DriverSapDB.detectJDBC20();
        isJDBC40 = DriverSapDB.detectJDBC40();
        sqlj_C = "sqlj";
        computername = null;
        fullcomputername = null;
        processid = 0;
        DriverSapDB.loadDriver();
        currentVMVersion = DriverSapDB.getVMVersion();
        trueStrings = new String[]{"true", "yes", "on"};
        isTraceOn = false;
    }
}

