/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DatabaseMetaDataBase;
import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.util.VersionInfo;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;

public class DatabaseMetaDataMaxDB
extends DatabaseMetaDataBase {
    private VersionInfo dbVersionInfo;
    private String dbVersion;
    private final int supportsSchemasPerUser = 2;
    private final int supportsJDBC_30_getTables = 2;
    private Hashtable systeminfo;
    private boolean catalogUsesProcedures;

    DatabaseMetaDataMaxDB(ConnectionSapDB connection, VersionInfo dbVersionInfo) throws SQLException {
        super(connection);
        this.dbVersionInfo = dbVersionInfo;
        this.hasSchemaSupport = true;
        this.checkProcedureUsage();
        this.loadSystemInfo();
    }

    private final void checkProcedureUsage() {
        try {
            ResultSet rs = this.internalPreparedQuery("CALL SYSJDBC.PROCEDURECATALOG", "checkProcedureUsage");
            if (rs.next()) {
                this.catalogUsesProcedures = rs.getBoolean(1);
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.dbVersionInfo.getMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.dbVersionInfo.getMinorVersion();
    }

    public int getMaxConnections() throws SQLException {
        return this.getIntProperty("MAXCONNECTIONS");
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getIntProperty("MAXCURSORNAMELENGTH");
    }

    public int getMaxIndexLength() throws SQLException {
        return this.getIntProperty("MAXINDEXLENGTH");
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getIntProperty("MAXPROCEDURENAMELENGTH");
    }

    public int getMaxRowSize() throws SQLException {
        return this.getIntProperty("MAXROWSIZE");
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getIntProperty("MAXSCHEMANAMELENGTH");
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getIntProperty("MAXTABLENAMELENGTH");
    }

    public int getMaxTablesInSelect() throws SQLException {
        return this.getIntProperty("MAXTABLESINSELECT");
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getIntProperty("MAXUSERNAMELENGTH");
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (this.dbVersion == null) {
            ResultSet rs = this.internalQuery("SELECT \"VALUE\" FROM SYSJDBC.SYSTEMINFO WHERE PROPERTY='KERNELVERSION'", "getDatabaseProductVersion");
            rs.next();
            this.dbVersion = rs.getString(1);
            rs.close();
        }
        return this.dbVersion;
    }

    public String getDriverName() throws SQLException {
        return DriverSapDB.singleton().getName();
    }

    public String getDriverVersion() throws SQLException {
        return DriverSapDB.getVersionString();
    }

    public ResultSet getCatalogs() throws SQLException {
        return this.internalQuery("SELECT TABLE_CAT FROM SYSJDBC.CATALOGS", "getCatalogs");
    }

    public ResultSet getSchemas(String schemapattern) throws SQLException {
        if (schemapattern == null) {
            return this.getSchemas();
        }
        PreparedStatement ps = null;
        ps = Integer.parseInt((String)this.systeminfo.get("SYSTEMTABLES_VERSION")) < 2 ? this.internalPreparedStatement("SELECT SCHEMANAME AS TABLE_SCHEM, '' AS TABLE_CATALOG FROM DOMAIN.SCHEMAS WHERE OWNER LIKE ? ESCAPE '\\' ORDER BY TABLE_SCHEM", "getSchemas") : this.internalPreparedStatement("SELECT TABLE_SCHEM, TABLE_CATALOG FROM SYSJDBC.SCHEMAS WHERE SCHEMA_OWNER LIKE ? ESCAPE '\\' ORDER BY TABLE_SCHEM", "getSchemas");
        ps.setString(1, schemapattern);
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getSchemas() throws SQLException {
        return this.internalQuery("SELECT TABLE_SCHEM, TABLE_CATALOG FROM SYSJDBC.SCHEMAS ORDER BY TABLE_SCHEM", "getSchemas");
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.internalQuery("SELECT TABLE_TYPE FROM SYSJDBC.TABLETYPES ORDER BY TABLE_TYPE", "getTableTypes");
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.internalQuery("SELECT TYPE_NAME, DATA_TYPE, PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX, CREATE_PARAMS, NULLABLE,CASE_SENSITIVE, SEARCHABLE, UNSIGNED_ATTRIBUTE, FIXED_PREC_SCALE,AUTO_INCREMENT, LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE,SQL_DATA_TYPE, SQL_DATETIME_SUB, NUM_PREC_RADIX FROM SYSJDBC.SESSIONTYPEINFO ORDER BY DATA_TYPE, MATCHORDER", "getTypeInfo");
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuffer sb = new StringBuffer("SELECT PKTABLE_CAT,PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYSJDBC.CROSSREFERENCES WHERE ");
        if (schema != null) {
            sb.append(" PKTABLE_SCHEM = ? AND ");
        }
        sb.append(" PKTABLE_NAME = ? ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        PreparedStatement ps = this.internalPreparedStatement(sb.toString(), "getExportedKeys");
        if (schema != null) {
            ps.setString(1, schema);
            ps.setString(2, table);
        } else {
            ps.setString(1, table);
        }
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String concat = " WHERE";
        StringBuffer sb = new StringBuffer("SELECT FUNCTION_CAT,FUNCTION_SCHEM, FUNCTION_NAME, REMARKS, FUNCTION_TYPE, SPECIFIC_NAME FROM SYSJDBC.FUNCTIONS ");
        if (functionNamePattern != null) {
            sb.append(concat);
            sb.append(" DBFUNCNAME LIKE '" + functionNamePattern + "' ESCAPE '\\' ");
            concat = "AND ";
        }
        if (schemaPattern != null) {
            sb.append(concat);
            sb.append("OWNER LIKE '" + schemaPattern + "' ESCAPE '\\' ");
        }
        sb.append(" ORDER BY FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME");
        PreparedStatement ps = this.internalPreparedStatement(sb.toString(), "getFunctions");
        if (functionNamePattern != null) {
            ps.setString(1, functionNamePattern);
            if (schemaPattern != null) {
                ps.setString(2, schemaPattern);
            }
        } else if (schemaPattern != null) {
            ps.setString(1, schemaPattern);
        }
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuffer sb = new StringBuffer("SELECT PKTABLE_CAT,PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY, COMMENT FROM SYSJDBC.CROSSREFERENCES WHERE ");
        if (schema != null) {
            sb.append(" FKTABLE_SCHEM = ? AND ");
        }
        sb.append(" FKTABLE_NAME = ? ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        PreparedStatement ps = this.internalPreparedStatement(sb.toString(), "getImportedKeys");
        if (schema != null) {
            ps.setString(1, schema);
            ps.setString(2, table);
        } else {
            ps.setString(1, table);
        }
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        StringBuffer sb = new StringBuffer("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, KEY_SEQ, PK_NAME FROM SYSJDBC.PRIMARYKEYS WHERE ");
        if (schema != null) {
            sb.append(" TABLE_SCHEM = ? AND ");
        }
        sb.append(" TABLE_NAME = ?");
        PreparedStatement ps = this.internalPreparedStatement(sb.toString(), "getPrimaryKeys");
        if (schema != null) {
            ps.setString(1, schema);
            ps.setString(2, table);
        } else {
            ps.setString(1, table);
        }
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getProcedures(String catalog, String schemapattern, String procedurepattern) throws SQLException {
        PreparedStatement ps = this.internalPreparedStatement("SELECT PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, RESERVED4, RESERVED5, RESERVED6, REMARKS, PROCEDURE_TYPE FROM SYSJDBC.PROCEDURES WHERE PROCEDURE_SCHEM LIKE ? ESCAPE '\\'  AND PROCEDURE_NAME LIKE ? ESCAPE '\\' ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME", "getProcedures");
        ps.setString(1, schemapattern == null ? "%" : schemapattern);
        ps.setString(2, procedurepattern == null ? "%" : procedurepattern);
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getSuperTables(String catalog, String schema, String tablename) throws SQLException {
        return this.internalQuery("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, SUPERTABLE_NAME FROM SYSJDBC.SUPERTABLES", "getSuperTables");
    }

    public ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        return this.internalQuery("SELECT TYPE_CAT, TYPE_SCHEM, TYPE_NAME,SUPERTYPE_CAT, SUPERTYPE_SCHEM, SUPERTYPE_NAME FROM SYSJDBC.SUPERTYPES", "getSuperTypes");
    }

    public ResultSet getTablePrivileges(String catalog, String schema, String table) throws SQLException {
        PreparedStatement ps = this.internalPreparedStatement("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM SYSJDBC.TABLEPRIVILEGES WHERE TABLE_SCHEM LIKE ? ESCAPE '\\' AND TABLE_NAME LIKE ? ESCAPE '\\' ORDER BY TABLE_SCHEM, TABLE_NAME, PRIVILEGE", "getTablePrivileges");
        ps.setString(1, schema == null ? "%" : schema);
        ps.setString(2, table == null ? "%" : table);
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.internalQuery("SELECT SCOPE, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, PSEUDO_COLUMN FROM SYSJDBC.VERSIONCOLUMNS", "getVersionColumns");
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        PreparedStatement ps = null;
        if (schema != null) {
            ps = this.internalPreparedStatement("SELECT SCOPE, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, PSEUDO_COLUMN FROM SYSJDBC.BESTROWIDENTIFIER WHERE TABLE_SCHEM=? AND TABLE_NAME=? ORDER BY SCOPE, COLUMN_NAME", "getBestRowIdentifier");
            ps.setString(1, schema);
            ps.setString(2, table);
        } else {
            ps = this.internalPreparedStatement("SELECT SCOPE, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, PSEUDO_COLUMN FROM SYSJDBC.BESTROWIDENTIFIER WHERE TABLE_NAME=? ORDER BY SCOPE, COLUMN_NAME", "getBestRowIdentifier");
            ps.setString(1, table);
        }
        return this.setFromMetaData(ps.executeQuery());
    }

    private String getIndexInfoTable(boolean unique, boolean approximate) {
        if (approximate) {
            return "SYSJDBC.APPROXINDEXINFO";
        }
        if (unique) {
            return "SYSJDBC.UNIQUEINDEXINFO";
        }
        return "SYSJDBC.INDEXINFO";
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String stmt = "SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, NON_UNIQUE, INDEX_QUALIFIER,  INDEX_NAME, TYPE, ORDINAL_POSITION, COLUMN_NAME, ASC_OR_DESC,  CARDINALITY, PAGES, FILTER_CONDITION, COMMENT FROM " + this.getIndexInfoTable(unique, approximate) + " WHERE TABLE_NAME = ? ";
        if (schema != null) {
            stmt = stmt + "AND TABLE_SCHEM = ? ";
        }
        if (unique) {
            stmt = stmt + "AND NON_UNIQUE = FALSE ";
        }
        stmt = stmt + "ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION";
        PreparedStatement ps = this.internalPreparedStatement(stmt, "getIndexInfo");
        ps.setString(1, table);
        if (schema != null) {
            ps.setString(2, schema);
        }
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getUDTs(String catalog, String schemapatterm, String typeNamePattern, int[] types) throws SQLException {
        return this.internalQuery("SELECT TYPE_CAT, TYPE_SCHEM, TYPE_NAME, CLASS_NAME, DATA_TYPE, REMARKS, BASE_TYPE FROM SYSJDBC.UDTS", "getUDTs");
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.internalQuery("SELECT TYPE_CAT,                              TYPE_SCHEM,                             TYPE_NAME,                             ATTR_NAME,                             DATA_TYPE,                             ATTR_TYPE_NAME,                             ATTR_SIZE,                             DECIMAL_DIGITS,                             NUM_PREC_RADIX,                             NULLABLE,                             REMARKS,                             ATTR_DEF,                             SQL_DATA_TYPE,                             SQL_DATETIME_SUB,                             CHAR_OCTET_LENGTH,                             ORDINAL_POSITION,                             IS_NULLABLE,                             SCOPE_CATALOG,                             SCOPE_SCHEMA,                             SCOPE_TABLE,                             SOURCE_DATA_TYPE                              FROM SYSJDBC.ATTRIBUTES", "getAttributes");
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String tablename, String columnnamepattern) throws SQLException {
        PreparedStatement ps = null;
        if (schema != null) {
            ps = this.internalPreparedStatement("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM SYSJDBC.COLUMNPRIVILEGES WHERE TABLE_SCHEM=? AND TABLE_NAME=? AND COLUMN_NAME LIKE ? ESCAPE '\\'", "getColumnPrivileges");
            ps.setString(1, schema);
            ps.setString(2, tablename);
            ps.setString(3, columnnamepattern);
        } else {
            ps = this.internalPreparedStatement("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM SYSJDBC.COLUMNPRIVILEGES WHERE TABLE_NAME=? AND COLUMN_NAME LIKE ? ESCAPE '\\' ", "getColumnPrivileges");
            ps.setString(1, tablename);
            ps.setString(2, columnnamepattern);
        }
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tablePattern, String columnPattern) throws SQLException {
        PreparedStatement ps = this.internalPreparedStatement("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, NUM_PREC_RADIX, NULLABLE,REMARKS, COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB, CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE, SCOPE_CATLOG, SCOPE_SCHEMA, SCOPE_TABLE, SOURCE_DATA_TYPE, COLUMN_DEF_FUNC FROM SYSJDBC.COLUMNS WHERE TABLE_SCHEM LIKE ? ESCAPE '\\' AND TABLE_NAME LIKE ? ESCAPE '\\' AND COLUMN_NAME LIKE ? ESCAPE '\\'ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION", "getColumns");
        ps.setString(1, schemaPattern == null ? "%" : schemaPattern);
        ps.setString(2, tablePattern == null ? "%" : tablePattern);
        ps.setString(3, columnPattern == null ? "%" : columnPattern);
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedurePattern, String columnPattern) throws SQLException {
        PreparedStatement ps = this.internalPreparedStatement("SELECT PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, COLUMN_NAME, COLUMN_TYPE, DATA_TYPE, TYPE_NAME, PRECISION, LENGTH, SCALE, RADIX, NULLABLE, REMARKS FROM SYSJDBC.PROCEDURECOLUMNS WHERE (PROCEDURE_SCHEM LIKE ? ESCAPE '\\' )   AND (PROCEDURE_NAME LIKE ? ESCAPE '\\' )   AND (COLUMN_NAME LIKE ? ESCAPE '\\' ) ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, ORDINAL_POSITION", "getProcedureColumns");
        ps.setString(1, schemaPattern == null ? "%" : schemaPattern);
        ps.setString(2, procedurePattern == null ? "%" : procedurePattern);
        ps.setString(3, columnPattern == null ? "%" : columnPattern);
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getTables(String catalog, String schemapattern, String tablepattern, String[] types) throws SQLException {
        boolean whereadded = false;
        String s = Integer.parseInt((String)this.systeminfo.get("SYSTEMTABLES_VERSION")) < 2 ? "SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, REMARKS, NULL                 AS TYPE_CAT,  NULL                 AS TYPE_SCHEMA, NULL                 AS TYPE_NAME, NULL                 AS SELF_REFERENCING_COL_NAME, NULL                 AS REF_GENERATION, SAMPLE_PERCENT, SAMPLE_ROWS FROM SYSJDBC.TABLES" : "SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, REMARKS, TYPE_CAT,  TYPE_SCHEMA, TYPE_NAME, SELF_REFERENCING_COL_NAME, REF_GENERATION, SAMPLE_PERCENT, SAMPLE_ROWS FROM SYSJDBC.TABLES";
        if (schemapattern != null) {
            s = s + " WHERE TABLE_SCHEM LIKE ? ESCAPE '\\' ";
            whereadded = true;
        }
        if (tablepattern != null) {
            if (whereadded) {
                s = s + " AND TABLE_NAME LIKE ? ESCAPE '\\' ";
            } else {
                s = s + " WHERE TABLE_NAME LIKE ? ESCAPE '\\'";
                whereadded = true;
            }
        }
        if (types != null && types.length > 0) {
            if (whereadded) {
                s = s + " AND (";
            } else {
                s = s + " WHERE (";
                whereadded = true;
            }
            for (int i = 0; i < types.length; ++i) {
                s = i != 0 ? s + " OR TABLE_TYPE = ? " : s + " TABLE_TYPE = ? ";
            }
            s = s + " )";
        }
        s = s + " ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME";
        PreparedStatement ps = this.internalPreparedStatement(s, "getTables");
        int pcount = 1;
        if (schemapattern != null) {
            ps.setString(pcount, schemapattern);
            ++pcount;
        }
        if (tablepattern != null) {
            ps.setString(pcount, tablepattern);
            ++pcount;
        }
        ParameterMetaData pmd = ps.getParameterMetaData();
        if (types != null) {
            for (int k = 0; k < types.length; ++k) {
                if (types[k].length() > pmd.getPrecision(pcount)) {
                    ps.setNull(pcount, 1);
                } else {
                    ps.setString(pcount, types[k]);
                }
                ++pcount;
            }
        }
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String stmt = "SELECT PKTABLE_CAT,PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYSJDBC.CROSSREFERENCES WHERE PKTABLE_NAME = ? AND FKTABLE_NAME = ? ";
        if (primarySchema != null) {
            stmt = stmt + "AND PKTABLE_SCHEM = ? ";
        }
        if (foreignSchema != null) {
            stmt = stmt + "AND FKTABLE_SCHEM = ? ";
        }
        stmt = stmt + "ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ";
        PreparedStatement ps = this.internalPreparedStatement(stmt, "getCrossReference");
        ps.setString(1, primaryTable);
        ps.setString(2, foreignTable);
        int index = 3;
        if (primarySchema != null) {
            ps.setString(index++, primarySchema);
        }
        if (foreignSchema != null) {
            ps.setString(index, foreignSchema);
        }
        return this.setFromMetaData(ps.executeQuery());
    }

    private PreparedStatement internalPreparedStatement(String cmd, String routine) throws SQLException {
        this.connection.tracer.println("<Internal Query routine=" + routine + " >\n" + cmd + "\n</Internal Query>\n");
        PreparedStatement result = this.connection.prepareStatement(cmd, 1005, 1007);
        try {
            ((ResultSetSapDB)((Object)result)).setFromMetaData(true);
        }
        catch (ClassCastException ccx) {
            // empty catch block
        }
        return result;
    }

    private ResultSet setFromMetaData(ResultSet rs) {
        try {
            ((ResultSetSapDB)rs).setFromMetaData(true);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return rs;
    }

    private void loadSystemInfo() {
        this.systeminfo = new Hashtable();
        ResultSet rs = null;
        try {
            rs = this.catalogUsesProcedures ? this.internalPreparedQuery("CALL SYSJDBC.GETSYSTEMINFO", "loadSystemInfo") : this.internalQuery("SELECT \"PROPERTY\", \"VALUE\" FROM SYSJDBC.SYSTEMINFO", "loadSystemInfo");
            while (rs.next()) {
                this.systeminfo.put(rs.getString(1), rs.getString(2));
            }
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.getIntProperty("MAXBINARYLITERALLENGTH");
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getIntProperty("MAXCATALOGNAMELENGTH");
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return this.getIntProperty("MAXCHARLITERALLENGTH");
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getIntProperty("MAXCOLUMNNAMELENGTH");
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getIntProperty("MAXCOLUMNSINGROUPBY");
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getIntProperty("MAXCOLUMNSININDEX");
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getIntProperty("MAXCOLUMNSINORDERBY");
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return this.getIntProperty("MAXCOLUMNSINSELECT");
    }

    public int getMaxColumnsInTable() throws SQLException {
        return this.getIntProperty("MAXCOLUMNSINTABLE");
    }

    private int getIntProperty(String property) throws SQLException {
        try {
            return Integer.parseInt((String)this.systeminfo.get(property));
        }
        catch (Exception ex) {
            throw SQLExceptionSapDB.generateSQLException("error.nometadata", (Object)property, (Object)ex.getMessage());
        }
    }

    public ResultSet getConstraints(String catalog, String schemapattern, String tablepattern) throws SQLException {
        boolean whereadded = false;
        String s = "SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, CONSTRAINT_NAME, CONSTRAINT_DEFINITION FROM SYSJDBC.CONSTRAINTS";
        if (schemapattern != null) {
            s = s + " WHERE TABLE_SCHEM LIKE ? ESCAPE '\\'";
            whereadded = true;
        }
        if (tablepattern != null) {
            if (whereadded) {
                s = s + " AND TABLE_NAME LIKE ? ESCAPE '\\'";
            } else {
                s = s + " WHERE TABLE_NAME LIKE ? ESCAPE '\\'";
                whereadded = true;
            }
        }
        PreparedStatement ps = this.internalPreparedStatement(s, "getConstraints");
        int pcount = 1;
        if (schemapattern != null) {
            ps.setString(pcount, schemapattern);
            ++pcount;
        }
        if (tablepattern != null) {
            ps.setString(pcount, tablepattern);
            ++pcount;
        }
        return this.setFromMetaData(ps.executeQuery());
    }

    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        PreparedStatement ps = this.internalPreparedStatement("SELECT FUNCTION_CAT,       FUNCTION_SCHEM,       FUNCTION_NAME,       COLUMN_NAME,       COLUMN_TYPE,       DATA_TYPE,       TYPE_NAME,       PRECISION,       length,       SCALE,       RADIX,       NULLABLE,       COMMENT AS REMARKS,       CHAR_OCTET_LENGTH,       ORDINAL_POSITION,       IS_NULLABLE,       SPECIFIC_NAME FROM SYSJDBC.FUNCTIONCOLUMNS  WHERE FUNCTION_SCHEM LIKE ? ESCAPE '\\'    AND FUNCTION_NAME  LIKE ? ESCAPE '\\'    AND COLUMN_NAME LIKE ? ESCAPE '\\'  ORDER BY FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME", "getFunctionColumns");
        ps.setString(1, schemaPattern == null ? "%" : schemaPattern);
        ps.setString(2, functionNamePattern == null ? "%" : functionNamePattern);
        ps.setString(3, columnNamePattern == null ? "%" : columnNamePattern);
        return this.setFromMetaData(ps.executeQuery());
    }

    public boolean isMultiVersionReadEnabled() throws SQLException {
        return ((String)this.systeminfo.get("USEMULTIVERSIONREADSUPPORT")).equals("YES");
    }
}

