/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ColumnInfo;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.FetchInfo;
import com.sap.dbtech.jdbc.ParameterMetaDataSapDB;
import com.sap.dbtech.jdbc.Parseinfo;
import com.sap.dbtech.jdbc.ParseinfoCache;
import com.sap.dbtech.jdbc.ResultSetMetaDataSapDB;
import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.jdbc.StatementSapDB;
import com.sap.dbtech.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.dbtech.jdbc.exceptions.UnicodeConversionException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.ABAPStreamDescriptor;
import com.sap.dbtech.jdbc.translators.ABAPStreamTranslator;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamPutval;
import com.sap.dbtech.jdbc.translators.AbstractProcedurePutval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.StreamInfo;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.Tracer;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class CallableStatementSapDB
extends StatementSapDB
implements CallableStatement,
SQLParamController {
    private Vector inputOMSStreams;
    private Vector outputOMSStreams;
    private Vector inputProcedureLongs;
    static final int maxParseAgainCnt = 10;
    Parseinfo parseinfo;
    boolean lastWasNull;
    DataPart replyMem;
    protected Object[] inputArgs;
    Vector inputLongs;
    Vector batchRows;
    short[] outPutTypes;
    byte[] outPutScale;
    FetchInfo fetchInfo;
    AbstractMap columnMap;
    private final String initialParamValue = "initParam";
    public static final int UNLIMITED_STREAM_LENGTH = -1;
    private static final PutvalComparator putvalComparator = new PutvalComparator();

    CallableStatementSapDB(ConnectionSapDB connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.constructor(sql);
    }

    public void addBatch() throws SQLException {
        if (this.batchItems == null) {
            this.batchItems = new Vector();
        }
        this.batchItems.addElement(this.inputArgs);
        Object[] nextRow = new Object[this.parseinfo.paramInfos.length];
        DBTechTranslator[] paraminfos = this.parseinfo.paramInfos;
        int paraminfos_length = paraminfos.length;
        for (int i = 0; i < paraminfos_length; ++i) {
            nextRow[i] = paraminfos[i].cloneObjectForBatch(this.inputArgs[i]);
        }
        this.inputArgs = nextRow;
    }

    public void addBatch(String sql) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.addbatch.preparedstatement");
    }

    private int calculateInputRecord() {
        int result = 0;
        for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
            DBTechTranslator currentInfo = this.parseinfo.paramInfos[i];
            if (!currentInfo.isInput()) continue;
            int currentFieldLen = currentInfo.getPhysicalLength();
            result = this.parseinfo.varDataInput ? (currentFieldLen < 250 ? ++result : (result += 3)) : ++result;
            result += currentFieldLen;
        }
        return result;
    }

    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.inputArgs.length; ++i) {
            this.inputArgs[i] = "initParam";
        }
    }

    private void constructor(String sql) throws SQLException {
        this.parseinfo = this.doParse(sql, false);
        this.isPoolable = false;
    }

    private Parseinfo doParse(String sql, boolean parseAgain) throws SQLException {
        if (sql == null) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.null");
        }
        Parseinfo result = null;
        ParseinfoCache cache = this.connection.parseCache;
        ColumnInfo[] columnNames = null;
        if (sql == null) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.null");
        }
        this.fetchInfo = null;
        if (parseAgain) {
            result = this.parseinfo;
            result.setMassParseid(null);
        } else if (cache != null) {
            result = cache.findParseinfo(sql);
        }
        if (result == null || parseAgain) {
            ReplyPacket replyPacket;
            try {
                this.setWithInfo = true;
                replyPacket = this.sendSQL(sql, this.resultSetType, this.resultSetConcurrency, parseAgain);
            }
            catch (SQLException exc) {
                if (exc.getErrorCode() != 700) {
                    throw exc;
                }
                if (this.statementType == 2) {
                    this.connection.close();
                    throw exc;
                }
                replyPacket = this.sendSQL(sql, this.resultSetType, this.resultSetConcurrency, parseAgain);
            }
            if (!parseAgain) {
                result = new Parseinfo(this.connection, sql, replyPacket.functionCode());
            }
            PartEnumeration enume = replyPacket.partEnumeration();
            DBTechTranslator[] shortInfos = null;
            while (enume.hasMoreElements()) {
                enume.nextElement();
                switch (enume.partKind()) {
                    case 10: {
                        int parseidPos = replyPacket.getPartDataPos();
                        result.setParseIdAndSession(replyPacket.getBytes(parseidPos, 12), replyPacket.getInt4(parseidPos));
                        break;
                    }
                    case 14: {
                        shortInfos = replyPacket.parseShortFields(this.connection, result.isDBProc, result.procParamInfos, false);
                        break;
                    }
                    case 32: {
                        result.varDataInput = true;
                        shortInfos = replyPacket.parseShortFields(this.connection, result.isDBProc, result.procParamInfos, true);
                        break;
                    }
                    case 13: {
                        result.setSelect(true);
                        int cursorLength = replyPacket.partLength();
                        if (cursorLength <= 0) break;
                        this.cursorName = replyPacket.getCursorName();
                        break;
                    }
                    case 19: {
                        result.setUpdateTableName(replyPacket.getTablename());
                        break;
                    }
                    case 2: {
                        columnNames = replyPacket.parseColumnNames(columnNames);
                        break;
                    }
                    case 36: {
                        columnNames = replyPacket.parseSchemaTableColumnNames(columnNames);
                        break;
                    }
                }
            }
            result.setShortInfosAndColumnNames(shortInfos, columnNames);
            if (cache != null && !parseAgain) {
                cache.addParseinfo(result);
            }
        }
        this.inputArgs = new Object[result.paramInfos.length];
        this.clearParameters();
        return result;
    }

    public boolean execute() throws SQLException {
        this.assertOpen();
        return this.execute(10);
    }

    private void reparse() throws SQLException {
        Object[] tmpArgs = this.inputArgs;
        this.doParse(this.parseinfo.sqlCmd, true);
        this.inputArgs = tmpArgs;
    }

    protected String getUpdTablename(String sqlCmd) {
        return this.parseinfo.updTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(int afterParseAgain) throws SQLException {
        int returnCode;
        int isQuery;
        block42: {
            ReplyPacket replyPacket;
            boolean isCommunicationLocked;
            block41: {
                if (this.connection == null) {
                    throw SQLExceptionSapDB.generateSQLException("error.internal.connectionnull");
                }
                isCommunicationLocked = false;
                if (this.parseinfo.isAlreadyExecuted()) {
                    this.replyMem = null;
                    this.closeResultSet(true);
                    if (this.connection == null) {
                        throw new NullPointerException();
                    }
                    this.reparse();
                    this.rowsAffected = 0;
                    return false;
                }
                if (!this.parseinfo.isValid()) {
                    this.reparse();
                }
                try {
                    this.canceled = false;
                    this.closeResultSet(true);
                    if (!this.parseinfo.isValid()) {
                        this.reparse();
                    }
                    this.replyMem = null;
                    this.outputOMSStreams = null;
                    RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
                    requestPacket.initExecute(this.parseinfo.getParseId(), this.connection.autocommit, this.resultSetType);
                    if (this.parseinfo.isSelect) {
                        requestPacket.addCursorPart(this.cursorName);
                    }
                    if (this.parseinfo.inputCount > 0 || this.parseinfo.hasStreams) {
                        DataPart dataPart = requestPacket.newDataPart(this.parseinfo.varDataInput);
                        if (this.parseinfo.inputCount > 0) {
                            dataPart.addRow(this.parseinfo.inputCount);
                            for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
                                if (this.parseinfo.paramInfos[i].isInput() && "initParam" == this.inputArgs[i]) {
                                    if (this.parseinfo.paramInfos[i].isStreamKind() && this.outPutTypes != null && this.outPutTypes[i + 1] != 0) {
                                        if (this.outputOMSStreams == null) {
                                            this.outputOMSStreams = new Vector();
                                        }
                                        ABAPStreamTranslator t = (ABAPStreamTranslator)this.parseinfo.paramInfos[i];
                                        AbstractABAPStreamGetval getval = t.createGetval();
                                        this.outputOMSStreams.add(getval);
                                        t.put(dataPart, getval);
                                        continue;
                                    }
                                    throw new SQLException(MessageTranslator.translate("error.missinginout", Integer.toString(i + 1)), "02000");
                                }
                                this.parseinfo.paramInfos[i].put(dataPart, this.inputArgs[i]);
                            }
                            this.inputProcedureLongs = null;
                            if (this.parseinfo.hasLongs) {
                                if (this.parseinfo.isDBProc) {
                                    this.handleProcedureStreamsForExecute(dataPart, this.inputArgs);
                                } else {
                                    this.handleStreamsForExecute(dataPart, this.inputArgs);
                                }
                            }
                            if (this.parseinfo.hasStreams) {
                                this.handleOMSStreamsForExecute(dataPart);
                            }
                        } else {
                            this.handleOMSStreamsForExecute(dataPart);
                        }
                        dataPart.close();
                    }
                    if (this.parseinfo.isSelect && this.parseinfo.columnInfos == null && this.parseinfo.functionCode != 248) {
                        try {
                            requestPacket.initDbsCommand("DESCRIBE ", false, false, 1003);
                        }
                        catch (UnicodeConversionException e) {
                            // empty catch block
                        }
                        requestPacket.addParseidPart(this.parseinfo.getParseId());
                    }
                    try {
                        if (!this.parseinfo.hasStreams && this.inputProcedureLongs == null) {
                            replyPacket = this.connection.execute(requestPacket, this, 1);
                        } else {
                            this.connection.m_communicationSemaphore.acquire();
                            isCommunicationLocked = true;
                            replyPacket = this.connection.execute(requestPacket, false, false, this, 3);
                        }
                    }
                    catch (SQLException dbExc) {
                        if (dbExc.getErrorCode() == -8 && afterParseAgain > 0) {
                            this.resetPutvals(this.inputLongs);
                            this.reparse();
                            this.connection.freeRequestPacket(requestPacket);
                            --afterParseAgain;
                            if (isCommunicationLocked) {
                                this.connection.m_communicationSemaphore.release();
                                isCommunicationLocked = false;
                            }
                            boolean bl = this.execute(afterParseAgain);
                            this.canceled = false;
                            if (isCommunicationLocked) {
                                this.connection.m_communicationSemaphore.release();
                            }
                            return bl;
                        }
                        throw dbExc;
                    }
                    if (!this.parseinfo.isSelect) break block41;
                }
                catch (SQLException timeout) {
                    if (timeout.getErrorCode() != 700 || this.connection.isInTransaction() || this.statementType == 2) {
                        throw timeout;
                    }
                    if (isCommunicationLocked) {
                        this.connection.m_communicationSemaphore.release();
                        isCommunicationLocked = false;
                    }
                    this.closeResultSet(true);
                    this.resetPutvals(this.inputLongs);
                    this.reparse();
                    boolean bl = this.execute(10);
                    return bl;
                }
                finally {
                    this.canceled = false;
                    if (isCommunicationLocked) {
                        this.connection.m_communicationSemaphore.release();
                    }
                }
                isQuery = this.parseResult(replyPacket, null, this.parseinfo.getColumnInfos(), this.parseinfo.columnNames);
                break block42;
            }
            if (this.inputProcedureLongs != null) {
                replyPacket = this.processProcedureStreams(replyPacket);
            } else if (this.parseinfo.hasStreams) {
                replyPacket = this.processOMSStreams(replyPacket);
            }
            if (isCommunicationLocked) {
                this.connection.m_communicationSemaphore.release();
                isCommunicationLocked = false;
            }
            isQuery = this.parseResult(replyPacket, null, this.parseinfo.getColumnInfos(), this.parseinfo.columnNames);
            returnCode = replyPacket.returnCode();
            replyPacket.firstSegment();
            this.replyMem = replyPacket.getDataPart();
            if (this.parseinfo.hasLongs && !this.parseinfo.isDBProc && returnCode == 0) {
                this.handleStreamsForPutval(replyPacket);
            }
        }
        returnCode = isQuery;
        return returnCode != 0;
    }

    public boolean execute(String sql) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.execute.preparedstatement");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        this.assertOpen();
        if (this.parseinfo != null && this.parseinfo.isSelect) {
            throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset"), new int[0]);
        }
        if (this.parseinfo != null && (this.parseinfo.functionCode == 34 || this.parseinfo.functionCode == 248)) {
            for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
                if (!this.parseinfo.paramInfos[i].isOutput()) continue;
                throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchprocout"), new int[0]);
            }
        }
        if (this.batchItems == null) {
            return new int[0];
        }
        Vector streamVec = null;
        boolean inTrans = this.connection.isInTransaction();
        Vector localBatchItems = this.batchItems;
        this.batchItems = null;
        try {
            this.canceled = false;
            int count = localBatchItems.size();
            ReplyPacket replyPacket = null;
            int inputCursor = 0;
            boolean noError = true;
            int recordSize = 0;
            int insertCountPartSize = RequestPacket.resultCountPartSize();
            int executeCount = -1;
            int[] result = new int[count];
            this.rowsAffected = -1;
            for (int i = 0; i < result.length; ++i) {
                result[i] = -2;
            }
            if (this.parseinfo.getMassParseid() == null) {
                this.parseMassCmd(false);
            }
            if (this.parseinfo.paramInfos.length > 0) {
                recordSize = this.calculateInputRecord();
            }
            while (inputCursor < count && noError) {
                streamVec = null;
                int firstRecordNo = inputCursor;
                RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
                requestPacket.initExecute(this.parseinfo.getMassParseid(), this.connection.autocommit, this.resultSetType);
                if (executeCount == -1) {
                    requestPacket.addUndefResultCount();
                } else {
                    requestPacket.addResultCount(executeCount);
                }
                requestPacket.addCursorPart(this.cursorName);
                if (this.parseinfo.paramInfos.length > 0) {
                    DataPart dataPart = requestPacket.newDataPart(this.parseinfo.varDataInput);
                    if (executeCount == -1) {
                        dataPart.setFirstPart();
                    }
                    do {
                        Object[] row = (Object[])localBatchItems.elementAt(inputCursor);
                        dataPart.addRow(this.parseinfo.inputCount);
                        for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
                            if (this.parseinfo.paramInfos[i].isInput() && "initParam" == row[i]) {
                                throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchmissingin", Integer.toString(inputCursor + 1), Integer.toString(i + 1)), "0200", this.makeBatchCountArray(result));
                            }
                            this.parseinfo.paramInfos[i].put(dataPart, row[i]);
                        }
                        if (this.parseinfo.hasLongs) {
                            this.handleStreamsForExecute(dataPart, row);
                            if (streamVec == null) {
                                streamVec = new Vector(this.inputLongs.size());
                            }
                            streamVec.addAll(this.inputLongs);
                        }
                        dataPart.moveRecordBase();
                    } while (++inputCursor < count && dataPart.hasRoomFor(recordSize, insertCountPartSize) && this.parseinfo.isMassCmd());
                    if (inputCursor == count) {
                        dataPart.setLastPart();
                    }
                    dataPart.closeArrayPart(inputCursor - firstRecordNo);
                } else {
                    ++inputCursor;
                }
                try {
                    replyPacket = this.connection.execute(requestPacket, this, 2);
                }
                catch (SQLException dbExc) {
                    if (dbExc.getErrorCode() == -8) {
                        int errorpos = ((SQLExceptionSapDB)dbExc).getErrorPos();
                        errorpos = errorpos < 2 ? 0 : --errorpos;
                        this.resetPutvals(streamVec);
                        this.parseMassCmd(true);
                        inputCursor = firstRecordNo + errorpos;
                        continue;
                    }
                    SQLExceptionSapDBInterface specific = (SQLExceptionSapDBInterface)((Object)dbExc);
                    if (!this.connection.getAutoCommit()) {
                        this.rowsAffected = this.rowsAffected > 0 ? (this.rowsAffected += specific.getErrorPos() - 1) : specific.getErrorPos() - 1;
                    }
                    throw new BatchUpdateExceptionSapDB(dbExc, new Integer(inputCursor + 1), this.makeBatchCountArray(result));
                }
                executeCount = replyPacket.resultCount(false);
                if (this.parseinfo.hasLongs) {
                    this.handleStreamsForPutval(replyPacket);
                }
                if (!this.parseinfo.isMassCmd() && executeCount != -1) {
                    result[inputCursor - 1] = executeCount;
                    if (this.rowsAffected > 0) {
                        this.rowsAffected += executeCount;
                        continue;
                    }
                    this.rowsAffected = executeCount;
                    continue;
                }
                this.rowsAffected = executeCount;
            }
            int[] nArray = result;
            return nArray;
        }
        catch (SQLException timeout) {
            if (timeout.getErrorCode() != 700 || inTrans || this.statementType == 2) {
                throw timeout;
            }
            this.batchItems = localBatchItems;
            this.resetPutvals(streamVec);
            int[] nArray = this.executeBatch();
            return nArray;
        }
        finally {
            this.canceled = false;
        }
    }

    private int[] makeBatchCountArray(int[] resultArr) {
        int[] erg;
        if (this.rowsAffected > 0) {
            erg = new int[this.rowsAffected];
            System.arraycopy(resultArr, 0, erg, 0, erg.length);
        } else {
            erg = new int[]{};
        }
        return erg;
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.parseinfo != null && !this.parseinfo.isSelect) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.rowcount");
        }
        this.execute();
        return this.currentResultSet;
    }

    public ResultSet executeQuery(String statement) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.executequery.preparedstatement");
    }

    public ResultSetSapDB executeQuerySap() throws SQLException {
        if (this.parseinfo != null && !this.parseinfo.isSelect) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.rowcount");
        }
        return (ResultSetSapDB)this.currentResultSet;
    }

    public int executeUpdate() throws SQLException {
        if (this.parseinfo != null && this.parseinfo.isSelect) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.resultset");
        }
        this.execute();
        if (this.hasRowCount) {
            return this.rowsAffected;
        }
        return 0;
    }

    public int executeUpdate(String statement) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.executeupdate.preparedstatement");
    }

    private DBTechTranslator findColInfo(int colIndex) throws SQLException {
        DBTechTranslator info;
        try {
            info = this.parseinfo.paramInfos[colIndex - 1];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw SQLExceptionSapDB.generateSQLException("error.colindex.notfound", (Object)Integer.toString(colIndex));
        }
        return info;
    }

    private DBTechTranslator findParamInfo(String paramName) throws SQLException {
        DBTechTranslator info;
        if (!this.parseinfo.isDBProc) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.noprocedure");
        }
        if (this.columnMap == null) {
            this.columnMap = this.parseinfo.getColumnMap();
        }
        if ((info = (DBTechTranslator)this.columnMap.get(paramName)) == null && (info = (DBTechTranslator)this.columnMap.get(paramName.toUpperCase())) != null) {
            this.columnMap.put(paramName, info);
        }
        if (info == null) {
            throw SQLExceptionSapDB.generateSQLException("error.invalidcolumnindex", (Object)paramName);
        }
        return info;
    }

    public Array getArray(int i) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.array.unsupported");
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getBigDecimal(this, this.getReplyData());
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getBigDecimal(scale, this, this.getReplyData());
    }

    public Blob getBlob(int i) throws SQLException {
        this.assertOpen();
        return this.findColInfo(i).getBlob(this, this.getReplyData(), this.getReplyData());
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getBoolean(this, this.getReplyData());
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getByte(this, this.getReplyData());
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getBytes(this, this.getReplyData());
    }

    public Clob getClob(int i) throws SQLException {
        this.assertOpen();
        return this.findColInfo(i).getClob(this, this.getReplyData(), this.getReplyData());
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getDate(this, this.getReplyData(), null);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getDate(this, this.getReplyData(), cal);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getDouble(this, this.getReplyData());
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getFloat(this, this.getReplyData());
    }

    Object getInputParameter(int parameterIndex) {
        return this.inputArgs[parameterIndex - 1];
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getInt(this, this.getReplyData());
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getLong(this, this.getReplyData());
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.fetchInfo == null) {
            if (this.parseinfo == null) {
                return null;
            }
            if (!this.parseinfo.isSelect && this.parseinfo.functionCode != 4 && this.parseinfo.functionCode != 248) {
                return null;
            }
            DBTechTranslator[] colinfos = this.parseinfo.getColumnInfos();
            if (colinfos != null) {
                return new ResultSetMetaDataSapDB(colinfos, "");
            }
            try {
                this.parseinfo.doDescribeParseId();
            }
            catch (Exception ex) {
                return null;
            }
            return new ResultSetMetaDataSapDB(this.getFetchInfo(this.cursorName, this.parseinfo.getColumnInfos(), this.parseinfo.columnNames).getColInfo(), "");
        }
        return new ResultSetMetaDataSapDB(this.fetchInfo.getColInfo(), "");
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.assertOpen();
        Object result = null;
        DBTechTranslator translator = this.findColInfo(parameterIndex);
        DataPart replymem = this.getReplyData();
        int typeCode = this.outPutTypes == null ? 0 : this.outPutTypes[parameterIndex];
        switch (typeCode) {
            case -7: {
                if (translator.isNull(this, replymem)) break;
                result = new Boolean(translator.getBoolean(this, replymem));
                break;
            }
            case -6: {
                if (translator.isNull(this, replymem)) break;
                result = new Byte(translator.getByte(this, replymem));
                break;
            }
            case 5: {
                if (translator.isNull(this, replymem)) break;
                result = new Short(translator.getShort(this, replymem));
                break;
            }
            case 4: {
                if (translator.isNull(this, replymem)) break;
                result = new Integer(translator.getInt(this, replymem));
                break;
            }
            case -5: {
                if (translator.isNull(this, replymem)) break;
                result = new Long(translator.getLong(this, replymem));
                break;
            }
            case 7: {
                if (translator.isNull(this, replymem)) break;
                result = new Float(translator.getFloat(this, replymem));
                break;
            }
            case 6: 
            case 8: {
                if (translator.isNull(this, replymem)) break;
                result = new Double(translator.getDouble(this, replymem));
                break;
            }
            case 2: 
            case 3: {
                byte scale = this.outPutScale[parameterIndex];
                if (scale == -1) {
                    result = translator.getBigDecimal(this, replymem);
                    break;
                }
                result = translator.getBigDecimal(scale, this, replymem);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                result = translator.getString(this, replymem);
                break;
            }
            case 91: {
                result = translator.getDate(this, replymem, null);
                break;
            }
            case 92: {
                result = translator.getTime(this, replymem, null);
                break;
            }
            case 93: {
                result = translator.getTimestamp(this, replymem, null);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                result = translator.getBytes(this, replymem);
                break;
            }
            case 2004: {
                result = translator.getBlob(this, replymem, replymem);
                break;
            }
            case 2005: {
                result = translator.getClob(this, replymem, replymem);
                break;
            }
            default: {
                result = translator.getObject(this, replymem);
            }
        }
        return result;
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"CallableStatement", (Object)"getObject");
    }

    public Ref getRef(int i) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.ref.unsupported");
    }

    public DataPart getReplyData() throws SQLException {
        if (this.replyMem == null && (this.outputOMSStreams == null || this.outputOMSStreams != null && this.outputOMSStreams.size() == 0)) {
            throw SQLExceptionSapDB.generateSQLException("error.nooutparamdata");
        }
        return this.replyMem;
    }

    public short getShort(int parameterIndex) throws SQLException {
        return this.findColInfo(parameterIndex).getShort(this, this.getReplyData());
    }

    public String getString(int parameterIndex) throws SQLException {
        return this.findColInfo(parameterIndex).getString(this, this.getReplyData());
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return this.findColInfo(parameterIndex).getTime(this, this.getReplyData(), null);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.findColInfo(parameterIndex).getTime(this, this.getReplyData(), cal);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.findColInfo(parameterIndex).getTimestamp(this, this.getReplyData(), null);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.findColInfo(parameterIndex).getTimestamp(this, this.getReplyData(), cal);
    }

    private void handleStreamsForExecute(DataPart dataPart, Object[] arguments) throws SQLException {
        Putval putval;
        int i;
        this.inputLongs = new Vector();
        for (i = 0; i < this.parseinfo.paramInfos.length; ++i) {
            Object inarg = arguments[i];
            if (inarg == null || !this.parseinfo.paramInfos[i].isLongKind()) continue;
            try {
                putval = (Putval)inarg;
                this.inputLongs.addElement(putval);
                continue;
            }
            catch (ClassCastException exc) {
                // empty catch block
            }
        }
        if (this.inputLongs.size() > 1) {
            Collections.sort(this.inputLongs, putvalComparator);
        }
        Enumeration putvals = this.inputLongs.elements();
        i = 0;
        while (putvals.hasMoreElements()) {
            putval = (Putval)putvals.nextElement();
            if (putval.atEnd() && (putval = (Putval)putval.cloneForBatch()).atEnd()) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.isatend");
            }
            putval.transferStream(dataPart, i);
            putval.setNeedsDescriptorUpdate();
            ++i;
        }
    }

    private void handleProcedureStreamsForExecute(DataPart dataPart, Object[] objects) throws SQLExceptionSapDB {
        this.inputProcedureLongs = new Vector();
        for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
            Object arg = this.inputArgs[i];
            if (arg == null) continue;
            try {
                AbstractProcedurePutval pv = (AbstractProcedurePutval)arg;
                this.inputProcedureLongs.addElement(pv);
                pv.updateIndex(this.inputProcedureLongs.size() - 1);
                continue;
            }
            catch (ClassCastException ignored) {
                // empty catch block
            }
        }
    }

    private void handleOMSStreamsForExecute(DataPart dataPart) {
        ABAPStreamDescriptor t;
        int k;
        this.inputOMSStreams = new Vector();
        for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
            Object inarg = this.inputArgs[i];
            if (inarg == null) continue;
            try {
                this.inputOMSStreams.addElement((AbstractABAPStreamPutval)this.inputArgs[i]);
                continue;
            }
            catch (ClassCastException exc) {
                // empty catch block
            }
        }
        int inputoms_size = this.inputOMSStreams.size();
        for (k = 0; k < inputoms_size; ++k) {
            t = (ABAPStreamDescriptor)this.inputOMSStreams.elementAt(k);
            t.updateIndex(k);
        }
        if (this.outputOMSStreams != null) {
            for (k = 0; k < this.outputOMSStreams.size(); ++k) {
                t = (ABAPStreamDescriptor)this.outputOMSStreams.elementAt(k);
                t.updateIndex(k);
            }
        }
    }

    private ReplyPacket processProcedureStreams(ReplyPacket packet) throws SQLException {
        ReplyPacket erg = null;
        try {
            while (packet.existsPart(25)) {
                StreamInfo[] streaminfos = packet.parseStreamInfos();
                StreamInfo info = streaminfos[0];
                int tabid = info.getTabId();
                if (tabid < 0 || tabid > this.inputProcedureLongs.size()) {
                    throw SQLExceptionSapDB.generateSQLException("error.unknown.procedurelong", (Object)Integer.toString(tabid));
                }
                AbstractProcedurePutval pv = (AbstractProcedurePutval)this.inputProcedureLongs.elementAt(tabid);
                RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
                DataPart dataPart = requestPacket.initStreamCommand(this.connection.autocommit);
                pv.transferStream(dataPart, info.getRowCount());
                dataPart.close();
                packet = this.connection.execute(requestPacket, false, false, this, 3);
            }
            erg = packet;
        }
        catch (SQLException sqlEx) {
            ReplyPacket tmppacket = this.connection.sendStreamErrorPacket(sqlEx);
            if (tmppacket == null) {
                throw sqlEx;
            }
            erg = tmppacket;
        }
        for (int k = 0; k < this.inputProcedureLongs.size(); ++k) {
            AbstractProcedurePutval pv = (AbstractProcedurePutval)this.inputProcedureLongs.elementAt(k);
            pv.closeStream();
        }
        return erg;
    }

    private ReplyPacket processOMSStreams(ReplyPacket replyPacket) throws SQLException {
        AbstractABAPStreamGetval gv;
        while (true) {
            int tabid;
            if (replyPacket.existsPart(25)) {
                tabid = replyPacket.parseABAPTabIDForInput();
                AbstractABAPStreamPutval pv = (AbstractABAPStreamPutval)this.inputOMSStreams.elementAt(tabid);
                if (pv.atEnd()) {
                    throw SQLExceptionSapDB.generateSQLException("error.stream.eof", (Object)Integer.toString(tabid));
                }
                RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
                DataPart dataPart = requestPacket.initStreamCommand(this.connection.autocommit);
                pv.transferStream(dataPart);
                dataPart.close();
                replyPacket = this.connection.execute(requestPacket, false, false, this, 3);
                continue;
            }
            if (!replyPacket.existsPart(26)) break;
            tabid = replyPacket.parseABAPTabIDForOutput();
            gv = (AbstractABAPStreamGetval)this.outputOMSStreams.elementAt(tabid);
            boolean eos = gv.addReplyData(replyPacket);
            RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
            DataPart datapart = requestPacket.initStreamCommand(this.connection.autocommit);
            if (eos) {
                datapart.fillWithOMSReturnCode(100);
            } else {
                datapart.fillWithOMSReturnCode(0);
            }
            datapart.close();
            replyPacket = this.connection.execute(requestPacket, false, false, this, 3);
        }
        if (this.outputOMSStreams != null) {
            for (int i = 0; i < this.outputOMSStreams.size(); ++i) {
                gv = (AbstractABAPStreamGetval)this.outputOMSStreams.elementAt(i);
                if (gv == null) continue;
                gv.coalesceReply();
            }
        }
        return replyPacket;
    }

    private void getChangedPutvalDescriptors(ReplyPacket replyPacket) {
        byte[][] descriptorArray = replyPacket.parseLongDescriptors();
        if (!replyPacket.existsPart(18)) {
            return;
        }
        for (int i = 0; i < descriptorArray.length; ++i) {
            byte[] descriptor = descriptorArray[i];
            StructuredBytes descriptorPointer = new StructuredBytes(descriptor);
            int valIndex = descriptorPointer.getInt2(28);
            Putval putval = (Putval)this.inputLongs.elementAt(valIndex);
            putval.setDescriptor(descriptor);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleStreamsForPutval(ReplyPacket replyPacket) throws SQLException {
        if (this.inputLongs == null || this.inputLongs.size() == 0) {
            return;
        }
        Putval lastStream = (Putval)this.inputLongs.lastElement();
        Putval lastGoodPutval = null;
        int firstOpenStream = 0;
        int count = this.inputLongs.size();
        boolean requiresTrailingPacket = false;
        int putvalshandled = 0;
        while (!lastStream.atEnd()) {
            this.getChangedPutvalDescriptors(replyPacket);
            putvalshandled = 0;
            RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
            DataPart dataPart = requestPacket.initPutval(this.connection.autocommit);
            for (int i = firstOpenStream; i < count && dataPart.hasRoomFor(41); ++i) {
                Putval putval = (Putval)this.inputLongs.elementAt(i);
                if (putval.atEnd() || !putval.isDescriptorUpdated()) {
                    ++firstOpenStream;
                    continue;
                }
                int descriptorPos = dataPart.getExtent();
                putval.putDescriptor(dataPart, descriptorPos);
                ++putvalshandled;
                lastGoodPutval = putval;
                dataPart.addArg(descriptorPos, 41);
                if (this.canceled) {
                    putval.markErrorStream();
                    ++firstOpenStream;
                    continue;
                }
                putval.transferStream(dataPart, i);
                if (!putval.atEnd()) continue;
                ++firstOpenStream;
            }
            if (putvalshandled == 0) {
                if (lastGoodPutval == null) return;
                try {
                    lastGoodPutval.markAsLast(dataPart);
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    requiresTrailingPacket = true;
                    lastStream = lastGoodPutval;
                }
            } else if (lastStream.atEnd() && !this.canceled) {
                try {
                    lastStream.markAsLast(dataPart);
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    requiresTrailingPacket = true;
                }
            }
            dataPart.close();
            replyPacket = this.connection.execute(requestPacket, this, 2);
            if (!requiresTrailingPacket || this.canceled) continue;
            requestPacket = this.connection.getRequestPacket(false);
            dataPart = requestPacket.initPutval(this.connection.autocommit);
            lastStream.markAsLast(dataPart);
            dataPart.close();
            this.connection.execute(requestPacket, this, 2);
        }
        if (!this.canceled) return;
        throw SQLExceptionSapDB.generateSQLException("error.statement.cancelled");
    }

    private void parseMassCmd(boolean parsegain) throws SQLException {
        RequestPacket requestPacket = this.connection.getRequestPacket(false);
        try {
            requestPacket.initParseCommand(this.parseinfo.sqlCmd, true, parsegain, this.resultSetType);
            this.packetEncodingUnicode = false;
        }
        catch (UnicodeConversionException e) {
            this.connection.freeRequestPacket(requestPacket);
            requestPacket = this.connection.getRequestPacket(true);
            this.packetEncodingUnicode = true;
            try {
                requestPacket.initParseCommand(this.parseinfo.sqlCmd, true, parsegain, this.resultSetType);
            }
            catch (UnicodeConversionException e1) {
                throw SQLExceptionSapDB.generateSQLException("error.unicodetoAscii", (Object)this.parseinfo.sqlCmd);
            }
        }
        requestPacket.setMassCommand();
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, 1);
        if (replyPacket.existsPart(10)) {
            this.parseinfo.setMassParseid(replyPacket.getBytes(replyPacket.getPartDataPos(), 12));
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, -1);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (this.outPutTypes == null) {
            this.outPutTypes = new short[this.parseinfo.paramInfos.length + 1];
            this.outPutScale = new byte[this.parseinfo.paramInfos.length + 1];
        }
        this.outPutTypes[parameterIndex] = (short)sqlType;
        this.outPutScale[parameterIndex] = (byte)scale;
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(paramIndex, sqlType, -1);
    }

    ReplyPacket sendCommand(RequestPacket requestPacket, String sqlCmd, int gcFlags, boolean parseAgain) throws SQLException, UnicodeConversionException {
        requestPacket.initParseCommand(sqlCmd, true, parseAgain, this.resultSetType);
        if (this.setWithInfo) {
            requestPacket.setWithInfo();
        }
        ReplyPacket replyPacket = this.connection.execute(requestPacket, false, true, this, gcFlags);
        return replyPacket;
    }

    public void setArray(int i, Array x) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.array.unsupported");
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transAsciiStreamForInput(x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBigDecimalForInput(x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBinaryStreamForInput(x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        Object arg;
        this.inputArgs[i - 1] = arg = this.findColInfo(i).transBlobForInput(x, this.connection);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBooleanForInput(x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transByteForInput(x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBytesForInput(x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        Object arg;
        this.inputArgs[i - 1] = arg = this.findColInfo(i).transClobForInput(x, this.connection);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Object arg;
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transDateForInput(x, cal);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transDoubleForInput(x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transFloatForInput(x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transIntForInput(x);
    }

    public void setLastWasNull(boolean wasNull) {
        this.lastWasNull = wasNull;
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transLongForInput(x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.inputArgs[parameterIndex - 1] = null;
    }

    public void setDefault(int parameterIndex) throws SQLException {
        this.inputArgs[parameterIndex - 1] = "DefaultValue";
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transObjectForInput(x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case 4: {
                if (x instanceof Number) {
                    Number n = (Number)x;
                    this.setInt(parameterIndex, n.intValue());
                    return;
                }
            }
            case -5: {
                if (!(x instanceof Number)) break;
                Number n = (Number)x;
                this.setLong(parameterIndex, n.longValue());
                return;
            }
        }
        this.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, x, scale);
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.ref.unsupported");
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transShortForInput(x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        Object arg;
        this.assertOpen();
        this.inputArgs[parameterIndex - 1] = x != null && this.connection.isSQLModeOracle && x.equalsIgnoreCase("") ? null : (arg = this.findColInfo(parameterIndex).transStringForInput(x));
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Object arg;
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transTimeForInput(x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Object arg;
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transTimestampForInput(x, cal);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transUnicodeStreamForInput(x);
    }

    public boolean wasNull() throws SQLException {
        return this.lastWasNull;
    }

    protected FetchInfo getFetchInfo(String cursorName, DBTechTranslator[] infos, ColumnInfo[] columnNames) throws SQLException {
        if (this.fetchInfo == null) {
            this.fetchInfo = new FetchInfo(this.connection, cursorName, infos, columnNames, this.packetEncodingUnicode);
        } else if (!this.fetchInfo.getCursorName().equals(cursorName)) {
            this.fetchInfo = new FetchInfo(this.connection, cursorName, infos, columnNames, this.packetEncodingUnicode);
        }
        return this.fetchInfo;
    }

    protected void updateFetchInfo(DBTechTranslator[] infos, ColumnInfo[] columnNames) throws SQLException {
        this.parseinfo.setMetaData(infos, columnNames);
    }

    public void close() throws SQLException {
        this.replyMem = null;
        if (this.connection != null && this.parseinfo != null && !this.parseinfo.cached) {
            this.connection.dropParseid(this.parseinfo.getParseId());
            this.parseinfo.setParseIdAndSession(null, -1);
            this.connection.dropParseid(this.parseinfo.getMassParseid());
            this.parseinfo.setMassParseid(null);
        }
        super.close();
    }

    protected void resetPutvals(Vector inpLongs) {
        if (inpLongs != null) {
            Enumeration putvals = inpLongs.elements();
            while (putvals.hasMoreElements()) {
                Putval putval = (Putval)putvals.nextElement();
                putval.reset();
            }
        }
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(parameterName, sqlType, -1);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.findParamInfo(parameterName).getColIndex() + 1, sqlType, scale);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterName, sqlType, -1);
    }

    public URL getURL(int parm1) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getURL", (Object)"CallableStatementSapDB");
    }

    public void setURL(String parm1, URL parm2) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setURL", (Object)"CallableStatementSapDB");
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.findParamInfo(parameterName).getColIndex() + 1, sqlType);
    }

    public void setDefault(String parameterName) throws SQLException {
        this.setDefault(this.findParamInfo(parameterName).getColIndex() + 1);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.findParamInfo(parameterName).getColIndex() + 1, x, length);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.findParamInfo(parameterName).getColIndex() + 1, x, length);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.findParamInfo(parameterName).getColIndex() + 1, x, targetSqlType, scale);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.findParamInfo(parameterName).getColIndex() + 1, x, targetSqlType);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.findParamInfo(parameterName).getColIndex() + 1, reader, length);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.findParamInfo(parameterName).getColIndex() + 1, x, cal);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.findParamInfo(parameterName).getColIndex() + 1, x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.findParamInfo(parameterName).getColIndex() + 1, x, cal);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.findParamInfo(parameterName).getColIndex() + 1, sqlType, typeName);
    }

    public String getString(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getString(this, this.getReplyData());
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getBoolean(this, this.getReplyData());
    }

    public byte getByte(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getByte(this, this.getReplyData());
    }

    public short getShort(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getShort(this, this.getReplyData());
    }

    public int getInt(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getInt(this, this.getReplyData());
    }

    public long getLong(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getLong(this, this.getReplyData());
    }

    public float getFloat(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getFloat(this, this.getReplyData());
    }

    public double getDouble(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getDouble(this, this.getReplyData());
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getBytes(this, this.getReplyData());
    }

    public Date getDate(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getDate(this, this.getReplyData(), null);
    }

    public Time getTime(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getTime(this, this.getReplyData(), null);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getTimestamp(this, this.getReplyData(), null);
    }

    public Object getObject(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getObject(this, this.getReplyData());
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getBigDecimal(this, this.getReplyData());
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"CallableStatement", (Object)"getObject");
    }

    public Ref getRef(String parameterName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.ref.unsupported");
    }

    public Blob getBlob(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getBlob(this, this.getReplyData(), this.getReplyData());
    }

    public Clob getClob(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getClob(this, this.getReplyData(), this.getReplyData());
    }

    public Array getArray(String parameterName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.array.unsupported");
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getDate(this, this.getReplyData(), cal);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getTime(this, this.getReplyData(), cal);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getTimestamp(this, this.getReplyData(), cal);
    }

    public URL getURL(String parm1) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.url.unsupported");
    }

    public void setURL(int parm1, URL parm2) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.url.unsupported");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ParameterMetaDataSapDB.createParameterMetaDataSapDB(this.parseinfo.getParamInfo());
    }

    public AbstractABAPStreamGetval getOMSGetval(int index) throws SQLException {
        if (this.outputOMSStreams == null) {
            return null;
        }
        for (int i = 0; i < this.outputOMSStreams.size(); ++i) {
            AbstractABAPStreamGetval t = (AbstractABAPStreamGetval)this.outputOMSStreams.elementAt(i);
            if (t == null || index != t.getColIndex()) continue;
            return t;
        }
        throw SQLExceptionSapDB.generateSQLException("error.colindex.notfound", (Object)Integer.toString(index));
    }

    boolean isParameterSet(int parameterIndex) {
        return "initParam" != this.inputArgs[parameterIndex - 1];
    }

    void unsetParameter(int parameterIndex) {
        this.inputArgs[parameterIndex - 1] = "initParam";
    }

    Object[] getInputArgs() {
        return this.inputArgs;
    }

    public String toString() {
        return super.toString() + "[ParseID " + Tracer.Hex2String(this.parseinfo.getActualParseid()) + "]";
    }

    public Parseinfo getParseinfo() {
        return this.parseinfo;
    }

    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.findColInfo(parameterIndex).getCharacterStream(this, this.getReplyData(), this.getReplyData());
    }

    public Reader getCharacterStream(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getCharacterStream(this, this.getReplyData(), this.getReplyData());
    }

    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getNCharacterStream", (Object)"CallableStatementSapDB");
    }

    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getNCharacterStream", (Object)"CallableStatementSapDB");
    }

    public NClob getNClob(int parameterIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getNClob", (Object)"CallableStatementSapDB");
    }

    public NClob getNClob(String parameterName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getNClob", (Object)"CallableStatementSapDB");
    }

    public String getNString(int parameterIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getNString", (Object)"CallableStatementSapDB");
    }

    public String getNString(String parameterName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getNString", (Object)"CallableStatementSapDB");
    }

    public RowId getRowId(int parameterIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getRowId", (Object)"CallableStatementSapDB");
    }

    public RowId getRowId(String parameterName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getRowId", (Object)"CallableStatementSapDB");
    }

    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getSQLXML", (Object)"CallableStatementSapDB");
    }

    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"getSQLXML", (Object)"CallableStatementSapDB");
    }

    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.setAsciiStream(this.findParamInfo(parameterName).getColIndex() + 1, x, -1);
    }

    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setAsciiStream(this.findParamInfo(parameterName).getColIndex() + 1, x, length);
    }

    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.setBinaryStream(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setBinaryStream(this.findParamInfo(parameterName).getColIndex() + 1, x, length);
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlob(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setBlob(this.findParamInfo(parameterName).getColIndex() + 1, inputStream);
    }

    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBlob(this.findParamInfo(parameterName).getColIndex() + 1, inputStream, length);
    }

    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setCharacterStream(this.findParamInfo(parameterName).getColIndex() + 1, reader);
    }

    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(this.findParamInfo(parameterName).getColIndex() + 1, reader, length);
    }

    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setClob(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(this.findParamInfo(parameterName).getColIndex() + 1, reader);
    }

    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.findParamInfo(parameterName).getColIndex() + 1, reader, length);
    }

    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNCharacterStream", (Object)"CallableStatementSapDB");
    }

    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNCharacterStream", (Object)"CallableStatementSapDB");
    }

    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNClob", (Object)"CallableStatementSapDB");
    }

    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNClob", (Object)"CallableStatementSapDB");
    }

    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNClob", (Object)"CallableStatementSapDB");
    }

    public void setNString(String parameterName, String value) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNString", (Object)"CallableStatementSapDB");
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setRowId", (Object)"CallableStatementSapDB");
    }

    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setSQLXML", (Object)"CallableStatementSapDB");
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transAsciiStreamForInput(x, -1L);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transAsciiStreamForInput(x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBinaryStreamForInput(x, -1L);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBinaryStreamForInput(x, length);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBinaryStreamForInput(inputStream, -1L);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBinaryStreamForInput(inputStream, length);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, -1L);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, length);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, -1L);
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, length);
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNCharacterStream", (Object)"CallableStatementSapDB");
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNCharacterStream", (Object)"CallableStatementSapDB");
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNClob", (Object)"CallableStatementSapDB");
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNClob", (Object)"CallableStatementSapDB");
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNClob", (Object)"CallableStatementSapDB");
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setNString", (Object)"CallableStatementSapDB");
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setRowId", (Object)"CallableStatementSapDB");
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", (Object)"setSQLXML", (Object)"CallableStatementSapDB");
    }

    private static class PutvalComparator
    implements Comparator {
        private PutvalComparator() {
        }

        public int compare(Object o1, Object o2) {
            Putval p1 = (Putval)o1;
            Putval p2 = (Putval)o2;
            int p1_bufpos = p1.getBufpos();
            int p2_bufpos = p2.getBufpos();
            return p1_bufpos - p2_bufpos;
        }

        public boolean equals(Object o) {
            return o == this;
        }
    }
}

